/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.DefaultAddressedEnvelope;
import io.netty.channel.epoll.AbstractEpollChannel;
import io.netty.channel.epoll.EpollDomainDatagramChannelConfig;
import io.netty.channel.epoll.EpollEventLoop;
import io.netty.channel.epoll.EpollRecvByteAllocatorHandle;
import io.netty.channel.epoll.LinuxSocket;
import io.netty.channel.epoll.Native;
import io.netty.channel.unix.DomainDatagramChannel;
import io.netty.channel.unix.DomainDatagramPacket;
import io.netty.channel.unix.DomainDatagramSocketAddress;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.channel.unix.IovArray;
import io.netty.channel.unix.PeerCredentials;
import io.netty.channel.unix.UnixChannelUtil;
import io.netty.util.CharsetUtil;
import io.netty.util.UncheckedBooleanSupplier;
import io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;

public final class EpollDomainDatagramChannel
extends AbstractEpollChannel
implements DomainDatagramChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(true, 16);
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(DomainDatagramPacket.class) + ", " + StringUtil.simpleClassName(AddressedEnvelope.class) + '<' + StringUtil.simpleClassName(ByteBuf.class) + ", " + StringUtil.simpleClassName(DomainSocketAddress.class) + ">, " + StringUtil.simpleClassName(ByteBuf.class) + ')';
    private volatile boolean connected;
    private volatile DomainSocketAddress local;
    private volatile DomainSocketAddress remote;
    private final EpollDomainDatagramChannelConfig config = new EpollDomainDatagramChannelConfig(this);

    public EpollDomainDatagramChannel() {
        this(LinuxSocket.newSocketDomainDgram(), false);
    }

    public EpollDomainDatagramChannel(int n) {
        this(new LinuxSocket(n), true);
    }

    private EpollDomainDatagramChannel(LinuxSocket linuxSocket, boolean bl) {
        super(null, linuxSocket, bl);
    }

    @Override
    public final EpollDomainDatagramChannelConfig config() {
        return this.config;
    }

    @Override
    protected final void doBind(SocketAddress socketAddress) {
        super.doBind(socketAddress);
        this.local = (DomainSocketAddress)socketAddress;
        this.active = true;
    }

    @Override
    protected final void doClose() {
        super.doClose();
        EpollDomainDatagramChannel epollDomainDatagramChannel = this;
        epollDomainDatagramChannel.active = false;
        epollDomainDatagramChannel.connected = false;
        this.local = null;
        this.remote = null;
    }

    @Override
    protected final boolean doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        if (super.doConnect(socketAddress, socketAddress2)) {
            if (socketAddress2 != null) {
                this.local = (DomainSocketAddress)socketAddress2;
            }
            this.remote = (DomainSocketAddress)socketAddress;
            this.connected = true;
            return true;
        }
        return false;
    }

    @Override
    protected final void doDisconnect() {
        this.doClose();
    }

    protected final void doWrite(ChannelOutboundBuffer channelOutboundBuffer) {
        Object object;
        int n = this.maxMessagesPerWrite();
        while (n > 0 && (object = channelOutboundBuffer.current()) != null) {
            try {
                boolean bl = false;
                for (int i = this.config().getWriteSpinCount(); i > 0; --i) {
                    if (!this.doWriteMessage(object)) continue;
                    bl = true;
                    break;
                }
                if (!bl) break;
                channelOutboundBuffer.remove();
                --n;
            }
            catch (IOException iOException) {
                --n;
                channelOutboundBuffer.remove((Throwable)iOException);
            }
        }
        if (channelOutboundBuffer.isEmpty()) {
            this.clearFlag(Native.EPOLLOUT);
            return;
        }
        this.setFlag(Native.EPOLLOUT);
    }

    private boolean doWriteMessage(Object object) {
        long l;
        DomainSocketAddress domainSocketAddress;
        if (object instanceof AddressedEnvelope) {
            AddressedEnvelope addressedEnvelope = (AddressedEnvelope)object;
            object = (ByteBuf)addressedEnvelope.content();
            domainSocketAddress = (DomainSocketAddress)addressedEnvelope.recipient();
        } else {
            object = (ByteBuf)object;
            domainSocketAddress = null;
        }
        int n = object.readableBytes();
        if (n == 0) {
            return true;
        }
        if (object.hasMemoryAddress()) {
            long l2 = object.memoryAddress();
            l = domainSocketAddress == null ? (long)this.socket.sendAddress(l2, object.readerIndex(), object.writerIndex()) : (long)this.socket.sendToAddressDomainSocket(l2, object.readerIndex(), object.writerIndex(), domainSocketAddress.path().getBytes(CharsetUtil.UTF_8));
        } else if (object.nioBufferCount() > 1) {
            IovArray iovArray = ((EpollEventLoop)this.eventLoop()).cleanIovArray();
            Object object2 = object;
            iovArray.add((ByteBuf)object2, object2.readerIndex(), object.readableBytes());
            int n2 = iovArray.count();
            assert (n2 != 0);
            l = domainSocketAddress == null ? this.socket.writevAddresses(iovArray.memoryAddress(0), n2) : (long)this.socket.sendToAddressesDomainSocket(iovArray.memoryAddress(0), n2, domainSocketAddress.path().getBytes(CharsetUtil.UTF_8));
        } else {
            Object object3 = object;
            ByteBuffer byteBuffer = object3.internalNioBuffer(object3.readerIndex(), object.readableBytes());
            if (domainSocketAddress == null) {
                ByteBuffer byteBuffer2 = byteBuffer;
                l = this.socket.send(byteBuffer2, byteBuffer2.position(), byteBuffer.limit());
            } else {
                ByteBuffer byteBuffer3 = byteBuffer;
                l = this.socket.sendToDomainSocket(byteBuffer3, byteBuffer3.position(), byteBuffer.limit(), domainSocketAddress.path().getBytes(CharsetUtil.UTF_8));
            }
        }
        return l > 0L;
    }

    protected final Object filterOutboundMessage(Object object) {
        AddressedEnvelope addressedEnvelope;
        if (object instanceof DomainDatagramPacket) {
            DomainDatagramPacket domainDatagramPacket = (DomainDatagramPacket)object;
            ByteBuf byteBuf = (ByteBuf)domainDatagramPacket.content();
            if (UnixChannelUtil.isBufferCopyNeededForWrite((ByteBuf)byteBuf)) {
                return new DomainDatagramPacket(this.newDirectBuffer(domainDatagramPacket, byteBuf), (DomainSocketAddress)domainDatagramPacket.recipient());
            }
            return object;
        }
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            if (UnixChannelUtil.isBufferCopyNeededForWrite((ByteBuf)byteBuf)) {
                return this.newDirectBuffer(byteBuf);
            }
            return byteBuf;
        }
        if (object instanceof AddressedEnvelope && (addressedEnvelope = (AddressedEnvelope)object).content() instanceof ByteBuf && (addressedEnvelope.recipient() == null || addressedEnvelope.recipient() instanceof DomainSocketAddress)) {
            ByteBuf byteBuf = (ByteBuf)addressedEnvelope.content();
            if (UnixChannelUtil.isBufferCopyNeededForWrite((ByteBuf)byteBuf)) {
                return new DefaultAddressedEnvelope((Object)this.newDirectBuffer(addressedEnvelope, byteBuf), (SocketAddress)((DomainSocketAddress)addressedEnvelope.recipient()));
            }
            return addressedEnvelope;
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName((Object)object) + EXPECTED_TYPES);
    }

    @Override
    public final boolean isActive() {
        return this.socket.isOpen() && (this.config.getActiveOnOpen() && this.isRegistered() || this.active);
    }

    public final boolean isConnected() {
        return this.connected;
    }

    public final DomainSocketAddress localAddress() {
        return (DomainSocketAddress)super.localAddress();
    }

    protected final DomainSocketAddress localAddress0() {
        return this.local;
    }

    @Override
    public final ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    protected final AbstractEpollChannel.AbstractEpollUnsafe newUnsafe() {
        return new EpollDomainDatagramChannelUnsafe();
    }

    public final PeerCredentials peerCredentials() {
        return this.socket.getPeerCredentials();
    }

    public final DomainSocketAddress remoteAddress() {
        return (DomainSocketAddress)super.remoteAddress();
    }

    protected final DomainSocketAddress remoteAddress0() {
        return this.remote;
    }

    final class EpollDomainDatagramChannelUnsafe
    extends AbstractEpollChannel.AbstractEpollUnsafe {
        EpollDomainDatagramChannelUnsafe() {
        }

        @Override
        final void epollInReady() {
            assert (EpollDomainDatagramChannel.this.eventLoop().inEventLoop());
            EpollDomainDatagramChannelConfig epollDomainDatagramChannelConfig = EpollDomainDatagramChannel.this.config();
            if (EpollDomainDatagramChannel.this.shouldBreakEpollInReady((ChannelConfig)epollDomainDatagramChannelConfig)) {
                this.clearEpollIn0();
                return;
            }
            EpollRecvByteAllocatorHandle epollRecvByteAllocatorHandle = this.recvBufAllocHandle();
            epollRecvByteAllocatorHandle.edgeTriggered(EpollDomainDatagramChannel.this.isFlagSet(Native.EPOLLET));
            ChannelPipeline channelPipeline = EpollDomainDatagramChannel.this.pipeline();
            ByteBufAllocator byteBufAllocator = epollDomainDatagramChannelConfig.getAllocator();
            epollRecvByteAllocatorHandle.reset((ChannelConfig)epollDomainDatagramChannelConfig);
            this.epollInBefore();
            Throwable throwable = null;
            try {
                ByteBuf byteBuf = null;
                try {
                    boolean bl = EpollDomainDatagramChannel.this.isConnected();
                    do {
                        DomainDatagramSocketAddress domainDatagramSocketAddress;
                        byteBuf = epollRecvByteAllocatorHandle.allocate(byteBufAllocator);
                        epollRecvByteAllocatorHandle.attemptedBytesRead(byteBuf.writableBytes());
                        if (bl) {
                            epollRecvByteAllocatorHandle.lastBytesRead(EpollDomainDatagramChannel.this.doReadBytes(byteBuf));
                            if (epollRecvByteAllocatorHandle.lastBytesRead() <= 0) {
                                byteBuf.release();
                                break;
                            }
                            domainDatagramSocketAddress = new DomainDatagramPacket(byteBuf, (DomainSocketAddress)this.localAddress(), (DomainSocketAddress)this.remoteAddress());
                        } else {
                            ByteBuffer byteBuffer;
                            if (byteBuf.hasMemoryAddress()) {
                                domainDatagramSocketAddress = EpollDomainDatagramChannel.this.socket.recvFromAddressDomainSocket(byteBuf.memoryAddress(), byteBuf.writerIndex(), byteBuf.capacity());
                            } else {
                                ByteBuf byteBuf2 = byteBuf;
                                ByteBuffer byteBuffer2 = byteBuffer = byteBuf2.internalNioBuffer(byteBuf2.writerIndex(), byteBuf.writableBytes());
                                domainDatagramSocketAddress = EpollDomainDatagramChannel.this.socket.recvFromDomainSocket(byteBuffer2, byteBuffer2.position(), byteBuffer.limit());
                            }
                            if (domainDatagramSocketAddress == null) {
                                epollRecvByteAllocatorHandle.lastBytesRead(-1);
                                byteBuf.release();
                                break;
                            }
                            byteBuffer = domainDatagramSocketAddress.localAddress();
                            if (byteBuffer == null) {
                                byteBuffer = (DomainSocketAddress)this.localAddress();
                            }
                            epollRecvByteAllocatorHandle.lastBytesRead(domainDatagramSocketAddress.receivedAmount());
                            ByteBuf byteBuf3 = byteBuf;
                            byteBuf3.writerIndex(byteBuf3.writerIndex() + epollRecvByteAllocatorHandle.lastBytesRead());
                            domainDatagramSocketAddress = new DomainDatagramPacket(byteBuf, (DomainSocketAddress)byteBuffer, (DomainSocketAddress)domainDatagramSocketAddress);
                        }
                        epollRecvByteAllocatorHandle.incMessagesRead(1);
                        this.readPending = false;
                        channelPipeline.fireChannelRead((Object)domainDatagramSocketAddress);
                        byteBuf = null;
                    } while (epollRecvByteAllocatorHandle.continueReading(UncheckedBooleanSupplier.TRUE_SUPPLIER));
                }
                catch (Throwable throwable2) {
                    if (byteBuf != null) {
                        byteBuf.release();
                    }
                    throwable = throwable2;
                }
                epollRecvByteAllocatorHandle.readComplete();
                channelPipeline.fireChannelReadComplete();
                if (throwable != null) {
                    channelPipeline.fireExceptionCaught(throwable);
                }
                return;
            }
            finally {
                this.epollInFinally((ChannelConfig)epollDomainDatagramChannelConfig);
            }
        }
    }
}

