/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32.COM;

import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.COM.COMException;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.COM.Unknown;
import com.sun.jna.platform.win32.COM.Wbemcli;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.Variant;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;

public class WbemcliUtil {
    public static final WbemcliUtil INSTANCE = new WbemcliUtil();
    public static final String DEFAULT_NAMESPACE = "ROOT\\CIMV2";

    public static boolean hasNamespace(String wmiResult) {
        String string = wmiResult;
        if (((String)((Object)wmiResult)).toUpperCase().startsWith("ROOT\\")) {
            string = ((String)((Object)wmiResult)).substring(5);
        }
        wmiResult = new WmiQuery<NamespaceProperty>("ROOT", "__NAMESPACE", NamespaceProperty.class);
        wmiResult = ((WmiQuery)((Object)wmiResult)).execute();
        for (int i = 0; i < wmiResult.getResultCount(); ++i) {
            if (!string.equalsIgnoreCase((String)wmiResult.getValue(NamespaceProperty.NAME, i))) continue;
            return true;
        }
        return false;
    }

    public static Wbemcli.IWbemServices connectServer(String object) {
        Object object2 = Wbemcli.IWbemLocator.create();
        if (object2 == null) {
            throw new COMException("Failed to create WbemLocator object.");
        }
        object = object2.ConnectServer((String)object, null, null, null, 0, null, null);
        object2.Release();
        object2 = Ole32.INSTANCE.CoSetProxyBlanket((Unknown)object, 10, 0, null, 3, 3, null, 0);
        if (COMUtils.FAILED((WinNT.HRESULT)((Object)object2))) {
            ((Unknown)object).Release();
            throw new COMException("Could not set proxy blanket.", (WinNT.HRESULT)((Object)object2));
        }
        return object;
    }

    public class WmiResult<T extends Enum<T>> {
        private Map<T, List<Object>> propertyMap;
        private Map<T, Integer> vtTypeMap;
        private Map<T, Integer> cimTypeMap;
        private int resultCount = 0;

        public WmiResult(Class<T> clazz) {
            this.propertyMap = new EnumMap<T, List<Object>>(clazz);
            this.vtTypeMap = new EnumMap<T, Integer>(clazz);
            this.cimTypeMap = new EnumMap<T, Integer>(clazz);
            for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
                this.propertyMap.put(enum_, new ArrayList());
                this.vtTypeMap.put(enum_, 1);
                this.cimTypeMap.put(enum_, 0);
            }
        }

        public Object getValue(T t, int n) {
            return this.propertyMap.get(t).get(n);
        }

        public int getVtType(T t) {
            return this.vtTypeMap.get(t);
        }

        public int getCIMType(T t) {
            return this.cimTypeMap.get(t);
        }

        private void add(int n, int n2, T t, Object object) {
            this.propertyMap.get(t).add(object);
            if (n != 1 && this.vtTypeMap.get(t).equals(1)) {
                this.vtTypeMap.put(t, n);
            }
            if (this.cimTypeMap.get(t).equals(0)) {
                this.cimTypeMap.put(t, n2);
            }
        }

        public int getResultCount() {
            return this.resultCount;
        }

        private void incrementResultCount() {
            ++this.resultCount;
        }
    }

    public static class WmiQuery<T extends Enum<T>> {
        private String nameSpace;
        private String wmiClassName;
        private Class<T> propertyEnum;

        public WmiQuery(String string, String string2, Class<T> clazz) {
            this.nameSpace = string;
            this.wmiClassName = string2;
            this.propertyEnum = clazz;
        }

        public WmiQuery(String string, Class<T> clazz) {
            this(WbemcliUtil.DEFAULT_NAMESPACE, string, clazz);
        }

        public Class<T> getPropertyEnum() {
            return this.propertyEnum;
        }

        public String getNameSpace() {
            return this.nameSpace;
        }

        public void setNameSpace(String string) {
            this.nameSpace = string;
        }

        public String getWmiClassName() {
            return this.wmiClassName;
        }

        public void setWmiClassName(String string) {
            this.wmiClassName = string;
        }

        public WmiResult<T> execute() {
            try {
                return this.execute(-1);
            }
            catch (TimeoutException timeoutException) {
                throw new COMException("Got a WMI timeout when infinite wait was specified. This should never happen.");
            }
        }

        public WmiResult<T> execute(int n) {
            if (((Enum[])this.getPropertyEnum().getEnumConstants()).length <= 0) {
                throw new IllegalArgumentException("The query's property enum has no values.");
            }
            Wbemcli.IWbemServices iWbemServices = WbemcliUtil.connectServer(this.getNameSpace());
            try {
                WmiResult<T> wmiResult;
                Wbemcli.IEnumWbemClassObject iEnumWbemClassObject = WmiQuery.selectProperties(iWbemServices, this);
                try {
                    wmiResult = WmiQuery.enumerateProperties(iEnumWbemClassObject, this.getPropertyEnum(), n);
                    iEnumWbemClassObject.Release();
                }
                catch (Throwable throwable) {
                    iEnumWbemClassObject.Release();
                    throw throwable;
                }
                return wmiResult;
            }
            finally {
                iWbemServices.Release();
            }
        }

        private static <T extends Enum<T>> Wbemcli.IEnumWbemClassObject selectProperties(Wbemcli.IWbemServices iWbemServices, WmiQuery<T> wmiQuery) {
            Enum[] enumArray = (Enum[])wmiQuery.getPropertyEnum().getEnumConstants();
            StringBuilder stringBuilder = new StringBuilder("SELECT ");
            stringBuilder.append(enumArray[0].name());
            for (int i = 1; i < enumArray.length; ++i) {
                stringBuilder.append(',').append(enumArray[i].name());
            }
            stringBuilder.append(" FROM ").append(wmiQuery.getWmiClassName());
            return iWbemServices.ExecQuery("WQL", stringBuilder.toString().replaceAll("\\\\", "\\\\\\\\"), 48, null);
        }

        private static <T extends Enum<T>> WmiResult<T> enumerateProperties(Wbemcli.IEnumWbemClassObject iEnumWbemClassObject, Class<T> clazz, int n) {
            WbemcliUtil wbemcliUtil = INSTANCE;
            wbemcliUtil.getClass();
            WmiResult<T> wmiResult = wbemcliUtil.new WmiResult<T>(clazz);
            Pointer[] pointerArray = new Pointer[1];
            IntByReference intByReference = new IntByReference(0);
            HashMap<Enum[], WString> hashMap = new HashMap<Enum[], WString>();
            Object object = (Enum[])clazz.getEnumConstants();
            int n2 = ((Enum[])object).length;
            for (int i = 0; i < n2; ++i) {
                Enum[] enumArray = object[i];
                hashMap.put(enumArray, new WString(enumArray.name()));
            }
            while (iEnumWbemClassObject.getPointer() != Pointer.NULL && (object = iEnumWbemClassObject.Next(n, pointerArray.length, pointerArray, intByReference)).intValue() != 1 && object.intValue() != 262149) {
                if (object.intValue() == 262148) {
                    throw new TimeoutException("No results after " + n + " ms.");
                }
                if (COMUtils.FAILED((WinNT.HRESULT)((Object)object))) {
                    throw new COMException("Failed to enumerate results.", (WinNT.HRESULT)((Object)object));
                }
                object = new Variant.VARIANT.ByReference();
                IntByReference intByReference2 = new IntByReference();
                Wbemcli.IWbemClassObject iWbemClassObject = new Wbemcli.IWbemClassObject(pointerArray[0]);
                for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
                    iWbemClassObject.Get((WString)hashMap.get(enum_), 0, (Variant.VARIANT.ByReference)((Object)object), intByReference2, null);
                    int n3 = ((Number)((Object)(((Variant.VARIANT)((Object)object)).getValue() == null ? Integer.valueOf(1) : ((Variant.VARIANT)((Object)object)).getVarType()))).intValue();
                    int n4 = intByReference2.getValue();
                    switch (n3) {
                        case 8: {
                            ((WmiResult)wmiResult).add(n3, n4, enum_, ((Variant.VARIANT)((Object)object)).stringValue());
                            break;
                        }
                        case 3: {
                            ((WmiResult)wmiResult).add(n3, n4, enum_, ((Variant.VARIANT)((Object)object)).intValue());
                            break;
                        }
                        case 17: {
                            ((WmiResult)wmiResult).add(n3, n4, enum_, ((Variant.VARIANT)((Object)object)).byteValue());
                            break;
                        }
                        case 2: {
                            ((WmiResult)wmiResult).add(n3, n4, enum_, ((Variant.VARIANT)((Object)object)).shortValue());
                            break;
                        }
                        case 11: {
                            ((WmiResult)wmiResult).add(n3, n4, enum_, ((Variant.VARIANT)((Object)object)).booleanValue());
                            break;
                        }
                        case 4: {
                            ((WmiResult)wmiResult).add(n3, n4, enum_, Float.valueOf(((Variant.VARIANT)((Object)object)).floatValue()));
                            break;
                        }
                        case 5: {
                            ((WmiResult)wmiResult).add(n3, n4, enum_, ((Variant.VARIANT)((Object)object)).doubleValue());
                            break;
                        }
                        case 0: 
                        case 1: {
                            ((WmiResult)wmiResult).add(n3, n4, enum_, null);
                            break;
                        }
                        default: {
                            if ((n3 & 0x2000) == 8192 || (n3 & 0xD) == 13 || (n3 & 9) == 9 || (n3 & 0x1000) == 4096) {
                                ((WmiResult)wmiResult).add(n3, n4, enum_, null);
                                break;
                            }
                            ((WmiResult)wmiResult).add(n3, n4, enum_, ((Variant.VARIANT)((Object)object)).getValue());
                        }
                    }
                    OleAuto.INSTANCE.VariantClear((Variant.VARIANT)((Object)object));
                }
                iWbemClassObject.Release();
                ((WmiResult)wmiResult).incrementResultCount();
            }
            return wmiResult;
        }
    }

    private static enum NamespaceProperty {
        NAME;

    }
}

