/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.roster;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.e.a.a;
import org.e.a.b.d;
import org.e.a.e;
import org.e.a.h;
import org.e.a.i;
import org.e.c.a.c;
import org.jivesoftware.smack.AsyncButOrdered;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.PresenceTypeFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.filter.ToMatchesFilter;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.PresenceBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.roster.PresenceEventListener;
import org.jivesoftware.smack.roster.RosterEntries;
import org.jivesoftware.smack.roster.RosterEntry;
import org.jivesoftware.smack.roster.RosterGroup;
import org.jivesoftware.smack.roster.RosterListener;
import org.jivesoftware.smack.roster.RosterLoadedListener;
import org.jivesoftware.smack.roster.RosterUtil;
import org.jivesoftware.smack.roster.SubscribeListener;
import org.jivesoftware.smack.roster.packet.RosterPacket;
import org.jivesoftware.smack.roster.rosterstore.RosterStore;
import org.jivesoftware.smack.util.ExceptionCallback;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.SuccessCallback;

public final class Roster
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(Roster.class.getName());
    private static final Map<XMPPConnection, Roster> INSTANCES;
    private static final StanzaFilter PRESENCE_PACKET_FILTER;
    private static final StanzaFilter OUTGOING_USER_UNAVAILABLE_PRESENCE;
    private static boolean rosterLoadedAtLoginDefault;
    private static SubscriptionMode defaultSubscriptionMode;
    public static final int INITIAL_DEFAULT_NON_ROSTER_PRESENCE_MAP_SIZE = 1024;
    private static int defaultNonRosterPresenceMapMaxSize;
    private RosterStore rosterStore;
    private final Map<String, RosterGroup> groups = new ConcurrentHashMap<String, RosterGroup>();
    private final Map<a, RosterEntry> entries = new ConcurrentHashMap<a, RosterEntry>();
    private final Set<RosterEntry> unfiledEntries = new CopyOnWriteArraySet<RosterEntry>();
    private final Set<RosterListener> rosterListeners = new LinkedHashSet<RosterListener>();
    private final Set<PresenceEventListener> presenceEventListeners = new CopyOnWriteArraySet<PresenceEventListener>();
    private final Map<a, Map<d, Presence>> presenceMap = new ConcurrentHashMap<a, Map<d, Presence>>();
    private final c<a, Map<d, Presence>> nonRosterPresenceMap = new c(defaultNonRosterPresenceMapMaxSize);
    private final Set<RosterLoadedListener> rosterLoadedListeners = new LinkedHashSet<RosterLoadedListener>();
    private final Object rosterListenersAndEntriesLock = new Object();
    private RosterState rosterState = RosterState.uninitialized;
    private final PresencePacketListener presencePacketListener = new PresencePacketListener();
    private boolean rosterLoadedAtLogin = rosterLoadedAtLoginDefault;
    private SubscriptionMode subscriptionMode = Roster.getDefaultSubscriptionMode();
    private final Set<SubscribeListener> subscribeListeners = new CopyOnWriteArraySet<SubscribeListener>();
    private SubscriptionMode previousSubscriptionMode;
    private final AsyncButOrdered<a> asyncButOrdered = new AsyncButOrdered();

    public static synchronized Roster getInstanceFor(XMPPConnection xMPPConnection) {
        Roster roster = INSTANCES.get(xMPPConnection);
        if (roster == null) {
            roster = new Roster(xMPPConnection);
            INSTANCES.put(xMPPConnection, roster);
        }
        return roster;
    }

    public static SubscriptionMode getDefaultSubscriptionMode() {
        return defaultSubscriptionMode;
    }

    public static void setDefaultSubscriptionMode(SubscriptionMode subscriptionMode) {
        defaultSubscriptionMode = subscriptionMode;
    }

    private Roster(final XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        xMPPConnection.registerIQRequestHandler((IQRequestHandler)new RosterPushListener());
        xMPPConnection.addSyncStanzaListener((StanzaListener)this.presencePacketListener, PRESENCE_PACKET_FILTER);
        xMPPConnection.addAsyncStanzaListener(new StanzaListener(){

            public void processStanza(Stanza stanza) {
                Presence.Type type;
                stanza = (Presence)stanza;
                i i2 = stanza.getFrom();
                Object object2 = null;
                switch (Roster.this.subscriptionMode) {
                    case manual: {
                        for (Object object2 : Roster.this.subscribeListeners) {
                            if ((object2 = object2.processSubscribe(i2, (Presence)stanza)) == null) continue;
                        }
                        if (object2 != null) break;
                        return;
                    }
                    case accept_all: {
                        object2 = SubscribeListener.SubscribeAnswer.Approve;
                        break;
                    }
                    case reject_all: {
                        object2 = SubscribeListener.SubscribeAnswer.Deny;
                    }
                }
                if (object2 == null) {
                    return;
                }
                switch (object2) {
                    case ApproveAndAlsoRequestIfRequired: {
                        object2 = i2.n();
                        RosterUtil.askForSubscriptionIfRequired(Roster.this, (a)object2);
                    }
                    case Approve: {
                        type = Presence.Type.subscribed;
                        break;
                    }
                    case Deny: {
                        type = Presence.Type.unsubscribed;
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                object2 = ((PresenceBuilder)xMPPConnection.getStanzaFactory().buildPresenceStanza().ofType(type).to(stanza.getFrom())).build();
                xMPPConnection.sendStanza((Stanza)object2);
            }
        }, (StanzaFilter)PresenceTypeFilter.SUBSCRIBE);
        xMPPConnection.addConnectionListener(new ConnectionListener(){

            public void authenticated(XMPPConnection xMPPConnection, boolean bl) {
                if (!Roster.this.isRosterLoadedAtLogin()) {
                    return;
                }
                if (bl) {
                    return;
                }
                Roster.this.setOfflinePresencesAndResetLoaded();
                try {
                    Roster.this.reload();
                    return;
                }
                catch (InterruptedException | SmackException throwable) {
                    LOGGER.log(Level.SEVERE, "Could not reload Roster", throwable);
                    return;
                }
            }

            public void connectionClosed() {
                Roster.this.setOfflinePresencesAndResetLoaded();
            }
        });
        xMPPConnection.addStanzaSendingListener(new StanzaListener(){

            public void processStanza(Stanza stanza) {
                Roster.this.setOfflinePresences();
            }
        }, OUTGOING_USER_UNAVAILABLE_PRESENCE);
        if (xMPPConnection.isAuthenticated()) {
            try {
                this.reloadAndWait();
                return;
            }
            catch (InterruptedException | SmackException throwable) {
                LOGGER.log(Level.SEVERE, "Could not reload Roster", throwable);
            }
        }
    }

    private Map<d, Presence> getPresencesInternal(a c2) {
        Object object = this.presenceMap.get(c2);
        if (object == null) {
            object = c2;
            c2 = this.nonRosterPresenceMap;
            object = (Map)c2.get(object);
        }
        return object;
    }

    private synchronized Map<d, Presence> getOrCreatePresencesInternal(a a2) {
        c c2 = this.getPresencesInternal(a2);
        if (c2 == null) {
            if (this.contains(a2)) {
                c2 = new ConcurrentHashMap<d, Presence>();
                this.presenceMap.put(a2, (Map<d, Presence>)c2);
            } else {
                c2 = new c(32);
                this.nonRosterPresenceMap.put((Object)a2, (Object)c2);
            }
        }
        return c2;
    }

    public final SubscriptionMode getSubscriptionMode() {
        return this.subscriptionMode;
    }

    public final void setSubscriptionMode(SubscriptionMode subscriptionMode) {
        this.subscriptionMode = subscriptionMode;
    }

    public final void reload() {
        XMPPConnection xMPPConnection = this.getAuthenticatedConnectionOrThrow();
        RosterPacket rosterPacket = new RosterPacket();
        if (this.rosterStore != null && this.isRosterVersioningSupported()) {
            rosterPacket.setVersion(this.rosterStore.getRosterVersion());
        }
        this.rosterState = RosterState.loading;
        xMPPConnection = xMPPConnection.sendIqRequestAsync((IQ)rosterPacket);
        xMPPConnection.onSuccess((SuccessCallback)new RosterResultListener()).onError((ExceptionCallback)new ExceptionCallback<Exception>(){

            public void processException(Exception exception) {
                Roster.this.rosterState = RosterState.uninitialized;
                Level level = exception instanceof SmackException.NotConnectedException ? Level.FINE : Level.SEVERE;
                LOGGER.log(level, "Exception reloading roster", exception);
                for (RosterLoadedListener rosterLoadedListener : Roster.this.rosterLoadedListeners) {
                    rosterLoadedListener.onRosterLoadingFailed(exception);
                }
            }
        });
    }

    public final void reloadAndWait() {
        this.reload();
        this.waitUntilLoaded();
    }

    public final boolean setRosterStore(RosterStore rosterStore) {
        this.rosterStore = rosterStore;
        try {
            this.reload();
        }
        catch (InterruptedException | SmackException.NotConnectedException | SmackException.NotLoggedInException throwable) {
            LOGGER.log(Level.FINER, "Could not reload roster", throwable);
            return false;
        }
        return true;
    }

    protected final boolean waitUntilLoaded() {
        long l;
        long l2 = System.currentTimeMillis();
        for (long j = this.connection().getReplyTimeout(); !this.isLoaded() && j > 0L; j -= l - l2) {
            Roster roster = this;
            synchronized (roster) {
                if (!this.isLoaded()) {
                    ((Object)((Object)this)).wait(j);
                }
            }
            l = System.currentTimeMillis();
            l2 = l;
        }
        return this.isLoaded();
    }

    public final boolean isLoaded() {
        return this.rosterState == RosterState.loaded;
    }

    public final boolean addRosterListener(RosterListener rosterListener) {
        Object object = this.rosterListenersAndEntriesLock;
        synchronized (object) {
            return this.rosterListeners.add(rosterListener);
        }
    }

    public final boolean removeRosterListener(RosterListener rosterListener) {
        Object object = this.rosterListenersAndEntriesLock;
        synchronized (object) {
            return this.rosterListeners.remove(rosterListener);
        }
    }

    public final boolean addRosterLoadedListener(RosterLoadedListener rosterLoadedListener) {
        RosterLoadedListener rosterLoadedListener2 = rosterLoadedListener;
        synchronized (rosterLoadedListener2) {
            return this.rosterLoadedListeners.add(rosterLoadedListener);
        }
    }

    public final boolean removeRosterLoadedListener(RosterLoadedListener rosterLoadedListener) {
        RosterLoadedListener rosterLoadedListener2 = rosterLoadedListener;
        synchronized (rosterLoadedListener2) {
            return this.rosterLoadedListeners.remove(rosterLoadedListener);
        }
    }

    public final boolean addPresenceEventListener(PresenceEventListener presenceEventListener) {
        return this.presenceEventListeners.add(presenceEventListener);
    }

    public final boolean removePresenceEventListener(PresenceEventListener presenceEventListener) {
        return this.presenceEventListeners.remove(presenceEventListener);
    }

    public final RosterGroup createGroup(String string) {
        Object object = this.connection();
        if (this.groups.containsKey(string)) {
            return this.groups.get(string);
        }
        object = new RosterGroup(string, (XMPPConnection)object);
        this.groups.put(string, (RosterGroup)((Object)object));
        return object;
    }

    @Deprecated
    public final void createEntry(a a2, String string, String[] stringArray) {
        this.createItemAndRequestSubscription(a2, string, stringArray);
    }

    public final void createItem(a object, String stringArray, String[] stringArray2) {
        XMPPConnection xMPPConnection = this.getAuthenticatedConnectionOrThrow();
        RosterPacket rosterPacket = new RosterPacket();
        rosterPacket.setType(IQ.Type.set);
        object = new RosterPacket.Item((a)object, (String)stringArray);
        if (stringArray2 != null) {
            stringArray = stringArray2;
            int n = stringArray2.length;
            for (int j = 0; j < n; ++j) {
                String string = stringArray[j];
                if (string == null || string.trim().length() <= 0) continue;
                ((RosterPacket.Item)object).addGroupName(string);
            }
        }
        rosterPacket.addRosterItem((RosterPacket.Item)object);
        xMPPConnection.createStanzaCollectorAndSend((IQ)rosterPacket).nextResultOrThrow();
    }

    public final void createItemAndRequestSubscription(a a2, String string, String[] stringArray) {
        this.createItem(a2, string, stringArray);
        this.sendSubscriptionRequest(a2);
    }

    public final void preApproveAndCreateEntry(a a2, String string, String[] stringArray) {
        this.preApprove(a2);
        this.createItemAndRequestSubscription(a2, string, stringArray);
    }

    public final void preApprove(a a2) {
        XMPPConnection xMPPConnection = this.connection();
        if (!this.isSubscriptionPreApprovalSupported()) {
            throw new SmackException.FeatureNotSupportedException("Pre-approving");
        }
        a2 = ((PresenceBuilder)xMPPConnection.getStanzaFactory().buildPresenceStanza().ofType(Presence.Type.subscribed).to((i)a2)).build();
        xMPPConnection.sendStanza((Stanza)a2);
    }

    public final boolean isSubscriptionPreApprovalSupported() {
        XMPPConnection xMPPConnection = this.getAuthenticatedConnectionOrThrow();
        return xMPPConnection.hasFeature("sub", "urn:xmpp:features:pre-approval");
    }

    public final void sendSubscriptionRequest(a a2) {
        XMPPConnection xMPPConnection = this.getAuthenticatedConnectionOrThrow();
        a2 = ((PresenceBuilder)xMPPConnection.getStanzaFactory().buildPresenceStanza().ofType(Presence.Type.subscribe).to((i)a2)).build();
        xMPPConnection.sendStanza((Stanza)a2);
    }

    public final boolean addSubscribeListener(SubscribeListener subscribeListener) {
        Objects.requireNonNull((Object)subscribeListener, (String)"SubscribeListener argument must not be null");
        if (this.subscriptionMode != SubscriptionMode.manual) {
            this.previousSubscriptionMode = this.subscriptionMode;
            this.subscriptionMode = SubscriptionMode.manual;
        }
        return this.subscribeListeners.add(subscribeListener);
    }

    public final boolean removeSubscribeListener(SubscribeListener subscribeListener) {
        boolean bl = this.subscribeListeners.remove(subscribeListener);
        if (bl && this.subscribeListeners.isEmpty()) {
            Roster roster = this;
            roster.setSubscriptionMode(roster.previousSubscriptionMode);
        }
        return bl;
    }

    public final void removeEntry(RosterEntry object) {
        XMPPConnection xMPPConnection = this.getAuthenticatedConnectionOrThrow();
        if (!this.entries.containsKey(object.getJid())) {
            return;
        }
        RosterPacket rosterPacket = new RosterPacket();
        rosterPacket.setType(IQ.Type.set);
        object = RosterEntry.toRosterItem(object);
        ((RosterPacket.Item)object).setItemType(RosterPacket.ItemType.remove);
        rosterPacket.addRosterItem((RosterPacket.Item)object);
        xMPPConnection.createStanzaCollectorAndSend((IQ)rosterPacket).nextResultOrThrow();
    }

    public final int getEntryCount() {
        return this.getEntries().size();
    }

    public final void getEntriesAndAddListener(RosterListener rosterListener, RosterEntries rosterEntries) {
        Objects.requireNonNull((Object)rosterListener, (String)"listener must not be null");
        Objects.requireNonNull((Object)rosterEntries, (String)"rosterEntries must not be null");
        Object object = this.rosterListenersAndEntriesLock;
        synchronized (object) {
            rosterEntries.rosterEntries(this.entries.values());
            this.addRosterListener(rosterListener);
            return;
        }
    }

    public final Set<RosterEntry> getEntries() {
        HashSet<RosterEntry> hashSet;
        Object object = this.rosterListenersAndEntriesLock;
        synchronized (object) {
            hashSet = new HashSet<RosterEntry>(this.entries.size());
            for (RosterEntry rosterEntry : this.entries.values()) {
                hashSet.add(rosterEntry);
            }
        }
        return hashSet;
    }

    public final int getUnfiledEntryCount() {
        return this.unfiledEntries.size();
    }

    public final Set<RosterEntry> getUnfiledEntries() {
        return Collections.unmodifiableSet(this.unfiledEntries);
    }

    public final RosterEntry getEntry(a a2) {
        if (a2 == null) {
            return null;
        }
        return this.entries.get(a2);
    }

    public final boolean contains(a a2) {
        return this.getEntry(a2) != null;
    }

    public final RosterGroup getGroup(String string) {
        return this.groups.get(string);
    }

    public final int getGroupCount() {
        return this.groups.size();
    }

    public final Collection<RosterGroup> getGroups() {
        return Collections.unmodifiableCollection(this.groups.values());
    }

    public final Presence getPresence(a a2) {
        Map<d, Presence> map = this.getPresencesInternal(a2);
        if (map == null) {
            Presence presence = Roster.synthesizeUnvailablePresence((i)a2);
            return presence;
        }
        Presence presence = null;
        Presence presence2 = null;
        for (Presence presence3 : map.values()) {
            Presence.Mode mode;
            if (!presence3.isAvailable()) {
                presence2 = presence3;
                continue;
            }
            if (presence == null || presence3.getPriority() > presence.getPriority()) {
                presence = presence3;
                continue;
            }
            if (presence3.getPriority() != presence.getPriority()) continue;
            Presence.Mode mode2 = presence3.getMode();
            if (mode2 == null) {
                mode2 = Presence.Mode.available;
            }
            if ((mode = presence.getMode()) == null) {
                mode = Presence.Mode.available;
            }
            if (mode2.compareTo((Enum)mode) >= 0) continue;
            presence = presence3;
        }
        if (presence == null) {
            if (presence2 != null) {
                return presence2;
            }
            presence = Roster.synthesizeUnvailablePresence((i)a2);
            return presence;
        }
        return presence;
    }

    public final Presence getPresenceResource(h h2) {
        Object object = h2.n();
        d d2 = h2.d();
        if ((object = this.getPresencesInternal((a)object)) == null) {
            object = Roster.synthesizeUnvailablePresence((i)h2);
            return object;
        }
        if ((object = (Presence)object.get(d2)) == null) {
            object = Roster.synthesizeUnvailablePresence((i)h2);
            return object;
        }
        return object;
    }

    public final List<Presence> getAllPresences(a object) {
        Object object2 = this.getPresencesInternal((a)object);
        if (object2 == null) {
            object2 = Roster.synthesizeUnvailablePresence((i)object);
            object = new ArrayList<Presence>(Arrays.asList(object2));
        } else {
            object = new ArrayList(object2.values().size());
            for (Presence presence : object2.values()) {
                object.add(presence);
            }
        }
        return object;
    }

    public final List<Presence> getAvailablePresences(a object) {
        object = this.getAllPresences((a)object);
        ArrayList<Presence> arrayList = new ArrayList<Presence>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            Presence presence = (Presence)object.next();
            if (!presence.isAvailable()) continue;
            arrayList.add(presence);
        }
        return arrayList;
    }

    public final List<Presence> getPresences(a object) {
        Map<d, Presence> map = this.getPresencesInternal((a)object);
        if (map == null) {
            Presence presence = Roster.synthesizeUnvailablePresence((i)object);
            object = Arrays.asList(presence);
        } else {
            ArrayList<Presence> arrayList = new ArrayList<Presence>();
            Presence presence = null;
            for (Presence presence2 : map.values()) {
                if (presence2.isAvailable()) {
                    arrayList.add(presence2);
                    continue;
                }
                presence = presence2;
            }
            if (!arrayList.isEmpty()) {
                object = arrayList;
            } else if (presence != null) {
                object = Arrays.asList(presence);
            } else {
                map = Roster.synthesizeUnvailablePresence((i)object);
                object = Arrays.asList(map);
            }
        }
        return object;
    }

    public final boolean isSubscribedToMyPresence(i object) {
        if (object == null) {
            return false;
        }
        object = object.n();
        if (this.connection().getXMPPServiceDomain().a((CharSequence)object)) {
            return true;
        }
        if ((object = this.getEntry((a)object)) == null) {
            return false;
        }
        return ((RosterEntry)((Object)object)).canSeeMyPresence();
    }

    public final boolean iAmSubscribedTo(i object) {
        if (object == null) {
            return false;
        }
        object = object.n();
        if ((object = this.getEntry((a)object)) == null) {
            return false;
        }
        return ((RosterEntry)((Object)object)).canSeeHisPresence();
    }

    public static void setRosterLoadedAtLoginDefault(boolean bl) {
        rosterLoadedAtLoginDefault = bl;
    }

    public final void setRosterLoadedAtLogin(boolean bl) {
        this.rosterLoadedAtLogin = bl;
    }

    public final boolean isRosterLoadedAtLogin() {
        return this.rosterLoadedAtLogin;
    }

    final RosterStore getRosterStore() {
        return this.rosterStore;
    }

    private void setOfflinePresences() {
        for (i i2 : this.presenceMap.keySet()) {
            Map<d, Presence> map = this.presenceMap.get(i2);
            if (map == null) continue;
            for (d d2 : map.keySet()) {
                PresenceBuilder presenceBuilder = StanzaBuilder.buildPresence().ofType(Presence.Type.unavailable);
                e e2 = i2.o();
                if (e2 == null) {
                    LOGGER.warning("Can not transform user JID to bare JID: '" + i2 + "'");
                    continue;
                }
                presenceBuilder.from((i)org.e.a.a.d.a((e)e2, (d)d2));
                try {
                    this.presencePacketListener.processStanza((Stanza)presenceBuilder.build());
                }
                catch (SmackException.NotConnectedException notConnectedException) {
                    throw new IllegalStateException("presencePacketListener should never throw a NotConnectedException when processStanza is called with a presence of type unavailable", notConnectedException);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }
    }

    private void setOfflinePresencesAndResetLoaded() {
        this.setOfflinePresences();
        this.rosterState = RosterState.uninitialized;
    }

    private void fireRosterChangedEvent(Collection<i> collection, Collection<i> collection2, Collection<i> collection3) {
        Object object = this.rosterListenersAndEntriesLock;
        synchronized (object) {
            for (RosterListener rosterListener : this.rosterListeners) {
                if (!collection.isEmpty()) {
                    rosterListener.entriesAdded(collection);
                }
                if (!collection2.isEmpty()) {
                    rosterListener.entriesUpdated(collection2);
                }
                if (collection3.isEmpty()) continue;
                rosterListener.entriesDeleted(collection3);
            }
            return;
        }
    }

    private void fireRosterPresenceEvent(Presence presence) {
        Object object = this.rosterListenersAndEntriesLock;
        synchronized (object) {
            for (RosterListener rosterListener : this.rosterListeners) {
                rosterListener.presenceChanged(presence);
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addUpdateEntry(Collection<i> object, Collection<i> iterator2, Collection<i> object22, RosterPacket.Item item, RosterEntry rosterEntry) {
        RosterEntry rosterEntry2;
        void var5_18;
        void var4_17;
        ArrayList<String> arrayList = this.rosterListenersAndEntriesLock;
        synchronized (arrayList) {
            rosterEntry2 = this.entries.put(var4_17.getJid(), (RosterEntry)var5_18);
        }
        if (rosterEntry2 == null) {
            arrayList = var4_17.getJid();
            object.add(arrayList);
            Roster.move((a)arrayList, this.nonRosterPresenceMap, this.presenceMap);
        } else {
            arrayList = RosterEntry.toRosterItem(rosterEntry2);
            if (!rosterEntry2.equalsDeep(var5_18) || !var4_17.getGroupNames().equals(((RosterPacket.Item)((Object)arrayList)).getGroupNames())) {
                iterator2.add((RosterGroup)var4_17.getJid());
                rosterEntry2.updateItem((RosterPacket.Item)var4_17);
            } else {
                void var3_8;
                var3_8.add(var4_17.getJid());
            }
        }
        if (var4_17.getGroupNames().isEmpty()) {
            this.unfiledEntries.add((RosterEntry)var5_18);
        } else {
            this.unfiledEntries.remove(var5_18);
        }
        arrayList = new ArrayList<String>();
        for (String string : var4_17.getGroupNames()) {
            void var3_12;
            arrayList.add(string);
            RosterGroup rosterGroup = this.getGroup(string);
            if (rosterGroup == null) {
                RosterGroup rosterGroup2 = this.createGroup(string);
                this.groups.put(string, rosterGroup2);
            }
            var3_12.addEntryLocal((RosterEntry)var5_18);
        }
        object = new ArrayList();
        for (RosterGroup rosterGroup : this.getGroups()) {
            object.add(rosterGroup.getName());
        }
        object.removeAll(arrayList);
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            object = this.getGroup(string);
            ((RosterGroup)((Object)object)).removeEntryLocal((RosterEntry)var5_18);
            if (((RosterGroup)((Object)object)).getEntryCount() != 0) continue;
            this.groups.remove(string);
        }
    }

    private void deleteEntry(Collection<i> object, RosterEntry rosterEntry) {
        a object22 = rosterEntry.getJid();
        this.entries.remove(object22);
        this.unfiledEntries.remove((Object)rosterEntry);
        Roster.move(object22, this.presenceMap, this.nonRosterPresenceMap);
        object.add((Map.Entry<String, RosterGroup>)object22);
        for (Map.Entry<String, RosterGroup> entry : this.groups.entrySet()) {
            RosterGroup rosterGroup = entry.getValue();
            rosterGroup.removeEntryLocal(rosterEntry);
            if (rosterGroup.getEntryCount() != 0) continue;
            this.groups.remove(entry.getKey());
        }
    }

    private void removeEmptyGroups() {
        for (RosterGroup rosterGroup : this.getGroups()) {
            if (rosterGroup.getEntryCount() != 0) continue;
            this.groups.remove(rosterGroup.getName());
        }
    }

    private static void move(a a2, Map<a, Map<d, Presence>> map, Map<a, Map<d, Presence>> map2) {
        if ((map = map.remove(a2)) != null && !map.isEmpty()) {
            map2.put(a2, map);
        }
    }

    private static boolean hasValidSubscriptionType(RosterPacket.Item item) {
        switch (item.getItemType()) {
            case none: 
            case from: 
            case to: 
            case both: {
                return true;
            }
        }
        return false;
    }

    private static Presence synthesizeUnvailablePresence(i i2) {
        return ((PresenceBuilder)StanzaBuilder.buildPresence().ofType(Presence.Type.unavailable).from(i2)).build();
    }

    public final boolean isRosterVersioningSupported() {
        return this.connection().hasFeature("ver", "urn:xmpp:features:rosterver");
    }

    public static void setDefaultNonRosterPresenceMapMaxSize(int n) {
        defaultNonRosterPresenceMapMaxSize = n;
    }

    public final void setNonRosterPresenceMapMaxSize(int n) {
        this.nonRosterPresenceMap.a(n);
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection xMPPConnection) {
                Roster.getInstanceFor(xMPPConnection);
            }
        });
        INSTANCES = new WeakHashMap<XMPPConnection, Roster>();
        PRESENCE_PACKET_FILTER = StanzaTypeFilter.PRESENCE;
        OUTGOING_USER_UNAVAILABLE_PRESENCE = new AndFilter(new StanzaFilter[]{PresenceTypeFilter.UNAVAILABLE, ToMatchesFilter.MATCH_NO_TO_SET});
        rosterLoadedAtLoginDefault = true;
        defaultSubscriptionMode = SubscriptionMode.reject_all;
        defaultNonRosterPresenceMapMaxSize = 1024;
    }

    private final class RosterPushListener
    extends AbstractIqRequestHandler {
        private RosterPushListener() {
            super("query", "jabber:iq:roster", IQ.Type.set, IQRequestHandler.Mode.sync);
        }

        public final IQ handleIQRequest(IQ object) {
            Object object2 = Roster.this.connection();
            RosterPacket rosterPacket = (RosterPacket)((Object)object);
            Object object3 = object2.getUser();
            if (object3 == null) {
                LOGGER.warning("Ignoring roster push " + object + " while " + object2 + " has no bound resource. This may be a server bug.");
                return null;
            }
            Object object4 = object3.b();
            Object object5 = rosterPacket.getFrom();
            if (object5 != null) {
                if (object5.a((CharSequence)object3)) {
                    LOGGER.warning("Received roster push from full JID. This behavior is since RFC 6121 not longer standard compliant. Please ask your server vendor to fix this and comply to RFC 6121 \u00a7 2.1.6. IQ roster push stanza: " + object);
                } else if (!object5.a((CharSequence)object4)) {
                    LOGGER.warning("Ignoring roster push with a non matching 'from' ourJid='" + object4 + "' from='" + object5 + "'");
                    return IQ.createErrorResponse((IQ)object, (StanzaError.Condition)StanzaError.Condition.service_unavailable);
                }
            }
            if ((object3 = rosterPacket.getRosterItems()).size() != 1) {
                LOGGER.warning("Ignoring roster push with not exactly one entry. size=" + object3.size());
                return IQ.createErrorResponse((IQ)object, (StanzaError.Condition)StanzaError.Condition.bad_request);
            }
            object = new ArrayList();
            object4 = new ArrayList();
            object5 = new ArrayList();
            ArrayList arrayList = new ArrayList();
            object3 = (RosterPacket.Item)object3.iterator().next();
            object2 = new RosterEntry((RosterPacket.Item)object3, Roster.this, (XMPPConnection)object2);
            String string = rosterPacket.getVersion();
            if (((RosterPacket.Item)object3).getItemType().equals((Object)RosterPacket.ItemType.remove)) {
                Roster.this.deleteEntry((Collection)object5, (RosterEntry)((Object)object2));
                if (Roster.this.rosterStore != null) {
                    Roster.this.rosterStore.removeEntry((i)((RosterEntry)((Object)object2)).getJid(), string);
                }
            } else if (Roster.hasValidSubscriptionType((RosterPacket.Item)object3)) {
                Roster.this.addUpdateEntry((Collection)object, (Collection)object4, arrayList, (RosterPacket.Item)object3, (RosterEntry)((Object)object2));
                if (Roster.this.rosterStore != null) {
                    Roster.this.rosterStore.addEntry((RosterPacket.Item)object3, string);
                }
            }
            Roster.this.removeEmptyGroups();
            Roster.this.fireRosterChangedEvent((Collection)object, (Collection)object4, (Collection)object5);
            return IQ.createResultIQ((IQ)rosterPacket);
        }
    }

    private class RosterResultListener
    implements SuccessCallback<IQ> {
        private RosterResultListener() {
        }

        public void onSuccess(IQ object) {
            Object object222;
            Iterator<RosterPacket.Item> iterator;
            XMPPConnection xMPPConnection = Roster.this.connection();
            LOGGER.log(Level.FINE, "RosterResultListener received {0}", object);
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            ArrayList arrayList3 = new ArrayList();
            ArrayList arrayList4 = new ArrayList();
            if (object instanceof RosterPacket) {
                RosterEntry rosterEntry2;
                object = (RosterPacket)((Object)object);
                iterator = new ArrayList();
                for (RosterPacket.Item object32 : ((RosterPacket)((Object)object)).getRosterItems()) {
                    if (!Roster.hasValidSubscriptionType(object32)) continue;
                    ((ArrayList)((Object)iterator)).add(object32);
                }
                object222 = ((ArrayList)((Object)iterator)).iterator();
                while (object222.hasNext()) {
                    RosterPacket.Item item = (RosterPacket.Item)object222.next();
                    rosterEntry2 = new RosterEntry(item, Roster.this, xMPPConnection);
                    Roster.this.addUpdateEntry(arrayList, arrayList2, arrayList4, item, rosterEntry2);
                }
                object222 = new HashSet<a>();
                for (RosterEntry rosterEntry2 : Roster.this.entries.values()) {
                    object222.add(rosterEntry2.getJid());
                }
                object222.removeAll(arrayList);
                object222.removeAll(arrayList2);
                object222.removeAll(arrayList4);
                Iterator iterator2 = object222.iterator();
                while (iterator2.hasNext()) {
                    rosterEntry2 = (i)iterator2.next();
                    Roster.this.deleteEntry(arrayList3, (RosterEntry)((Object)Roster.this.entries.get((Object)rosterEntry2)));
                }
                if (Roster.this.rosterStore != null) {
                    String string = ((RosterPacket)((Object)object)).getVersion();
                    Roster.this.rosterStore.resetEntries((Collection<RosterPacket.Item>)((Object)iterator), string);
                }
                Roster.this.removeEmptyGroups();
            } else {
                object = Roster.this.rosterStore.getEntries();
                if (object == null) {
                    Roster.this.rosterStore.resetStore();
                    try {
                        Roster.this.reload();
                        return;
                    }
                    catch (InterruptedException | SmackException.NotConnectedException | SmackException.NotLoggedInException throwable) {
                        LOGGER.log(Level.FINE, "Exception while trying to load the roster after the roster store was corrupted", throwable);
                        return;
                    }
                }
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    object222 = (RosterPacket.Item)iterator.next();
                    RosterEntry rosterEntry = new RosterEntry((RosterPacket.Item)object222, Roster.this, xMPPConnection);
                    Roster.this.addUpdateEntry(arrayList, arrayList2, arrayList4, object222, rosterEntry);
                }
            }
            Roster.this.rosterState = RosterState.loaded;
            object = Roster.this;
            synchronized (object) {
                ((Object)((Object)Roster.this)).notifyAll();
            }
            Roster.this.fireRosterChangedEvent(arrayList, arrayList2, arrayList3);
            try {
                object = Roster.this.rosterLoadedListeners;
                synchronized (object) {
                    for (Object object222 : Roster.this.rosterLoadedListeners) {
                        object222.onRosterLoaded(Roster.this);
                    }
                }
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, "RosterLoadedListener threw exception", exception);
            }
        }
    }

    private class PresencePacketListener
    implements StanzaListener {
        private PresencePacketListener() {
        }

        public void processStanza(Stanza stanza) {
            Presence presence;
            if (Roster.this.rosterState == RosterState.loading) {
                try {
                    Roster.this.waitUntilLoaded();
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.log(Level.INFO, "Presence listener was interrupted", interruptedException);
                }
            }
            final i i2 = stanza.getFrom();
            if (!Roster.this.isLoaded() && Roster.this.rosterLoadedAtLogin && (presence = Roster.this.connection()) != null && i2 != null && !i2.a((CharSequence)presence.getUser())) {
                LOGGER.warning("Roster not loaded while processing " + stanza);
            }
            presence = (Presence)stanza;
            if (i2 != null) {
                stanza = i2.n();
            } else {
                stanza = Roster.this.connection();
                if (stanza == null) {
                    LOGGER.finest("Connection was null while trying to handle exotic presence stanza: " + presence);
                    return;
                }
                if ((stanza = stanza.getUser()) == null) {
                    LOGGER.info("Connection had no local address in Roster's presence listener. Possibly we received a presence without from before being authenticated. Presence: " + presence);
                    return;
                }
                LOGGER.info("Exotic presence stanza without from received: " + presence);
                stanza = stanza.n();
            }
            Roster.this.asyncButOrdered.performAsyncButOrdered((Object)stanza, new Runnable((a)stanza){
                final /* synthetic */ a val$key;
                {
                    this.val$key = a2;
                }

                @Override
                public void run() {
                    Object object = d.a;
                    Object object2 = null;
                    h h2 = null;
                    if (i2 != null) {
                        object = i2.x();
                        if (object == null) {
                            object = d.a;
                            object2 = i2.n();
                        } else {
                            h2 = i2.t();
                            assert (h2 != null);
                        }
                    }
                    switch (presence.getType()) {
                        case available: {
                            object2 = Roster.this.getOrCreatePresencesInternal(this.val$key);
                            object2.remove(d.a);
                            object2.put(object, presence);
                            if (Roster.this.contains(this.val$key)) {
                                Roster.this.fireRosterPresenceEvent(presence);
                            }
                            for (PresenceEventListener presenceEventListener : Roster.this.presenceEventListeners) {
                                presenceEventListener.presenceAvailable(h2, presence);
                            }
                            return;
                        }
                        case unavailable: {
                            object2 = Roster.this.getOrCreatePresencesInternal(this.val$key);
                            if (i2.k()) {
                                object2.put(d.a, presence);
                            } else {
                                object2.put(object, presence);
                            }
                            if (Roster.this.contains(this.val$key)) {
                                Roster.this.fireRosterPresenceEvent(presence);
                            }
                            if (h2 != null) {
                                for (PresenceEventListener presenceEventListener : Roster.this.presenceEventListeners) {
                                    presenceEventListener.presenceUnavailable(h2, presence);
                                }
                                return;
                            }
                            LOGGER.fine("Unavailable presence from bare JID: " + presence);
                            return;
                        }
                        case error: {
                            if (i2 == null || !i2.g()) break;
                            object2 = Roster.this.getOrCreatePresencesInternal(this.val$key);
                            object2.clear();
                            object2.put(d.a, presence);
                            if (Roster.this.contains(this.val$key)) {
                                Roster.this.fireRosterPresenceEvent(presence);
                            }
                            for (PresenceEventListener presenceEventListener : Roster.this.presenceEventListeners) {
                                presenceEventListener.presenceError(i2, presence);
                            }
                            return;
                        }
                        case subscribed: {
                            for (PresenceEventListener presenceEventListener : Roster.this.presenceEventListeners) {
                                presenceEventListener.presenceSubscribed((a)object2, presence);
                            }
                            return;
                        }
                        case unsubscribed: {
                            for (PresenceEventListener presenceEventListener : Roster.this.presenceEventListeners) {
                                presenceEventListener.presenceUnsubscribed((a)object2, presence);
                            }
                            break;
                        }
                    }
                }
            });
        }
    }

    public static enum SubscriptionMode {
        accept_all,
        reject_all,
        manual;

    }

    private static enum RosterState {
        uninitialized,
        loading,
        loaded;

    }
}

