/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.roster.rosterstore;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.e.a.i;
import org.jivesoftware.smack.roster.packet.RosterPacket;
import org.jivesoftware.smack.roster.provider.RosterPacketProvider;
import org.jivesoftware.smack.roster.rosterstore.RosterStore;
import org.jivesoftware.smack.util.FileUtils;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.util.stringencoder.Base32;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public final class DirectoryRosterStore
implements RosterStore {
    private final File fileDir;
    private static final String ENTRY_PREFIX = "entry-";
    private static final String VERSION_FILE_NAME = "__version__";
    private static final String STORE_ID = "DEFAULT_ROSTER_STORE";
    private static final Logger LOGGER = Logger.getLogger(DirectoryRosterStore.class.getName());

    private static boolean rosterDirFilter(File object) {
        object = ((File)object).getName();
        return ((String)object).startsWith(ENTRY_PREFIX);
    }

    private DirectoryRosterStore(File file) {
        this.fileDir = file;
    }

    public static DirectoryRosterStore init(File object) {
        if (((DirectoryRosterStore)(object = new DirectoryRosterStore((File)object))).setRosterVersion("")) {
            return object;
        }
        return null;
    }

    public static DirectoryRosterStore open(File object) {
        String string = FileUtils.readFile((File)((DirectoryRosterStore)(object = new DirectoryRosterStore((File)object))).getVersionFile());
        if (string != null && string.startsWith("DEFAULT_ROSTER_STORE\n")) {
            return object;
        }
        return null;
    }

    private File getVersionFile() {
        return new File(this.fileDir, VERSION_FILE_NAME);
    }

    @Override
    public final List<RosterPacket.Item> getEntries() {
        ArrayList<RosterPacket.Item> arrayList = new ArrayList<RosterPacket.Item>();
        for (File file : this.fileDir.listFiles(DirectoryRosterStore::rosterDirFilter)) {
            RosterPacket.Item object = DirectoryRosterStore.readEntry(file);
            if (object == null) {
                return null;
            }
            arrayList.add(object);
        }
        return arrayList;
    }

    @Override
    public final RosterPacket.Item getEntry(i i2) {
        return DirectoryRosterStore.readEntry(this.getBareJidFile(i2));
    }

    @Override
    public final String getRosterVersion() {
        String[] stringArray = FileUtils.readFile((File)this.getVersionFile());
        if (stringArray == null) {
            return null;
        }
        if ((stringArray = stringArray.split("\n", 2)).length < 2) {
            return null;
        }
        return stringArray[1];
    }

    private boolean setRosterVersion(String string) {
        return FileUtils.writeFile((File)this.getVersionFile(), (CharSequence)("DEFAULT_ROSTER_STORE\n" + string));
    }

    @Override
    public final boolean addEntry(RosterPacket.Item item, String string) {
        return this.addEntryRaw(item) && this.setRosterVersion(string);
    }

    @Override
    public final boolean removeEntry(i i2, String string) {
        return this.getBareJidFile(i2).delete() && this.setRosterVersion(string);
    }

    @Override
    public final boolean resetEntries(Collection<RosterPacket.Item> collection, String string) {
        for (File file : this.fileDir.listFiles(DirectoryRosterStore::rosterDirFilter)) {
            file.delete();
        }
        for (RosterPacket.Item item : collection) {
            if (this.addEntryRaw(item)) continue;
            return false;
        }
        return this.setRosterVersion(string);
    }

    @Override
    public final void resetStore() {
        this.resetEntries(Collections.emptyList(), "");
    }

    private static RosterPacket.Item readEntry(File object) {
        FileReader fileReader;
        try {
            fileReader = new FileReader((File)object);
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOGGER.log(Level.FINE, "Roster entry file not found", fileNotFoundException);
            return null;
        }
        try {
            XmlPullParser xmlPullParser = PacketParserUtils.getParserFor((Reader)fileReader);
            RosterPacket.Item item = RosterPacketProvider.parseItem(xmlPullParser);
            ((Reader)fileReader).close();
            return item;
        }
        catch (IOException | IllegalArgumentException | XmlPullParserException throwable) {
            boolean bl = ((File)object).delete();
            object = "Exception while parsing roster entry.";
            if (bl) {
                object = (String)object + " File was deleted.";
            }
            LOGGER.log(Level.SEVERE, (String)object, throwable);
            return null;
        }
    }

    private boolean addEntryRaw(RosterPacket.Item item) {
        return FileUtils.writeFile((File)this.getBareJidFile((i)item.getJid()), (CharSequence)item.toXML());
    }

    private File getBareJidFile(i object) {
        object = Base32.encode((String)object.toString());
        return new File(this.fileDir, ENTRY_PREFIX + (String)object);
    }
}

