/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.util.InterruptSource;
import java.io.PrintStream;

public class SourcedInterruptedException
extends InterruptedException
implements ExceptionUtils.CustomStackTrace {
    final Throwable interruptSource;

    public static InterruptedException wrap(InterruptedException interruptedException) {
        return SourcedInterruptedException.wrap(interruptedException, InterruptSource.Util.currentThread());
    }

    public static InterruptedException wrap(InterruptedException interruptedException, InterruptSource interruptSource) {
        if (!(interruptedException instanceof SourcedInterruptedException) && interruptSource != null) {
            return new SourcedInterruptedException(interruptedException, interruptSource.getInterruptSource(true));
        }
        return interruptedException;
    }

    public SourcedInterruptedException(String string, InterruptedException interruptedException, Throwable throwable) {
        super(string);
        if (interruptedException != null) {
            this.initCause(interruptedException);
        }
        this.interruptSource = throwable;
    }

    public SourcedInterruptedException(InterruptedException interruptedException, Throwable throwable) {
        super(interruptedException.getMessage());
        this.initCause(interruptedException);
        this.interruptSource = throwable;
    }

    public final Throwable getInterruptSource() {
        return this.interruptSource;
    }

    @Override
    public InterruptedException getCause() {
        return (InterruptedException)super.getCause();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append(this.getClass().getSimpleName()).append(": ");
        if (this.interruptSource != null) {
            stringBuilder.append("[sourced]");
        } else {
            stringBuilder.append("[unknown]");
        }
        String string = this.getLocalizedMessage();
        if (string != null) {
            stringBuilder.append(" ").append(string);
        }
        return stringBuilder.toString();
    }

    @Override
    public final void printCauseStack(PrintStream printStream, String string, int n, int n2) {
        string = string + "[" + n + "]";
        printStream.println(string + " by " + this.getClass().getSimpleName() + ": " + this.getMessage() + " on thread " + Thread.currentThread().getName());
        ExceptionUtils.dumpStack(printStream, this.getStackTrace(), 0, n2);
        if (this.interruptSource != null) {
            ExceptionUtils.printCause(printStream, string, this.interruptSource, 0, 1, n2);
        }
    }

    @Override
    public final void printStackTrace(PrintStream printStream, int n, int n2) {
        printStream.println(this.getClass().getSimpleName() + ": " + this.getMessage() + " on thread " + Thread.currentThread().getName());
        ExceptionUtils.dumpStack(printStream, this.getStackTrace(), 0, n2);
        ExceptionUtils.printCause(printStream, "Caused", this.getCause(), 0, n, n2);
        if (this.interruptSource != null) {
            ExceptionUtils.printCause(printStream, "InterruptSource", this.interruptSource, 0, n, n2);
        }
    }
}

