/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.av;

import com.jogamp.common.av.AudioFormat;
import com.jogamp.common.av.AudioSink;
import java.nio.ByteBuffer;

public final class NullAudioSink
implements AudioSink {
    private volatile float playSpeed = 1.0f;
    private volatile boolean playRequested = false;
    private volatile int playingPTS = Integer.MIN_VALUE;
    private float volume = 1.0f;
    private AudioFormat chosenFormat = null;
    private boolean available = true;

    @Override
    public final boolean makeCurrent(boolean bl) {
        return true;
    }

    @Override
    public final boolean release(boolean bl) {
        return true;
    }

    @Override
    public final boolean isAvailable() {
        return this.available;
    }

    @Override
    public final float getPlaySpeed() {
        return this.playSpeed;
    }

    @Override
    public final boolean setPlaySpeed(float f) {
        if (Math.abs(1.0f - f) < 0.01f) {
            f = 1.0f;
        }
        this.playSpeed = f;
        return true;
    }

    @Override
    public final float getVolume() {
        return this.volume;
    }

    @Override
    public final boolean setVolume(float f) {
        this.volume = f;
        return true;
    }

    @Override
    public final int getSourceCount() {
        return -1;
    }

    @Override
    public final float getDefaultLatency() {
        return 0.0f;
    }

    @Override
    public final float getLatency() {
        return 0.0f;
    }

    @Override
    public final AudioFormat getNativeFormat() {
        return DefaultFormat;
    }

    @Override
    public final AudioFormat getPreferredFormat() {
        return DefaultFormat;
    }

    @Override
    public final void setChannelLimit(int n) {
    }

    @Override
    public final boolean isSupported(AudioFormat audioFormat) {
        return true;
    }

    @Override
    public final boolean init(AudioFormat audioFormat, int n, int n2, int n3, int n4) {
        this.chosenFormat = audioFormat;
        return true;
    }

    @Override
    public final AudioFormat getChosenFormat() {
        return this.chosenFormat;
    }

    @Override
    public final boolean isPlaying() {
        return this.playRequested;
    }

    @Override
    public final void play() {
        this.playRequested = true;
    }

    @Override
    public final void pause() {
        this.playRequested = false;
    }

    @Override
    public final void flush() {
    }

    @Override
    public final void destroy() {
        this.available = false;
        this.chosenFormat = null;
    }

    @Override
    public final int getEnqueuedFrameCount() {
        return 0;
    }

    @Override
    public final int getFrameCount() {
        return 0;
    }

    @Override
    public final int getQueuedFrameCount() {
        return 0;
    }

    @Override
    public final int getQueuedByteCount() {
        return 0;
    }

    @Override
    public final float getQueuedTime() {
        return 0.0f;
    }

    @Override
    public final float getAvgFrameDuration() {
        return 0.0f;
    }

    @Override
    public final int getPTS() {
        return this.playingPTS;
    }

    @Override
    public final int getFreeFrameCount() {
        return 1;
    }

    @Override
    public final AudioSink.AudioFrame enqueueData(int n, ByteBuffer byteBuffer, int n2) {
        if (!this.available || this.chosenFormat == null) {
            return null;
        }
        this.playingPTS = n;
        return null;
    }
}

