/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.ChannelPromise;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayDeque;
import java.util.Queue;

public final class ChannelFlushPromiseNotifier {
    private long writeCounter;
    private final Queue<FlushCheckpoint> flushCheckpoints = new ArrayDeque<FlushCheckpoint>();
    private final boolean tryNotify;

    public ChannelFlushPromiseNotifier(boolean bl) {
        this.tryNotify = bl;
    }

    public ChannelFlushPromiseNotifier() {
        this(false);
    }

    @Deprecated
    public final ChannelFlushPromiseNotifier add(ChannelPromise channelPromise, int n) {
        return this.add(channelPromise, (long)n);
    }

    public final ChannelFlushPromiseNotifier add(ChannelPromise object, long l) {
        ObjectUtil.checkNotNull((Object)object, (String)"promise");
        ObjectUtil.checkPositiveOrZero((long)l, (String)"pendingDataSize");
        long l2 = this.writeCounter + l;
        if (object instanceof FlushCheckpoint) {
            object = (FlushCheckpoint)object;
            object.flushCheckpoint(l2);
            this.flushCheckpoints.add((FlushCheckpoint)object);
        } else {
            this.flushCheckpoints.add(new DefaultFlushCheckpoint(l2, (ChannelPromise)object));
        }
        return this;
    }

    public final ChannelFlushPromiseNotifier increaseWriteCounter(long l) {
        ObjectUtil.checkPositiveOrZero((long)l, (String)"delta");
        this.writeCounter += l;
        return this;
    }

    public final long writeCounter() {
        return this.writeCounter;
    }

    public final ChannelFlushPromiseNotifier notifyPromises() {
        this.notifyPromises0(null);
        return this;
    }

    @Deprecated
    public final ChannelFlushPromiseNotifier notifyFlushFutures() {
        return this.notifyPromises();
    }

    public final ChannelFlushPromiseNotifier notifyPromises(Throwable throwable) {
        FlushCheckpoint flushCheckpoint;
        this.notifyPromises();
        while ((flushCheckpoint = this.flushCheckpoints.poll()) != null) {
            if (this.tryNotify) {
                flushCheckpoint.promise().tryFailure(throwable);
                continue;
            }
            flushCheckpoint.promise().setFailure(throwable);
        }
        return this;
    }

    @Deprecated
    public final ChannelFlushPromiseNotifier notifyFlushFutures(Throwable throwable) {
        return this.notifyPromises(throwable);
    }

    public final ChannelFlushPromiseNotifier notifyPromises(Throwable object, Throwable throwable) {
        this.notifyPromises0((Throwable)object);
        while ((object = this.flushCheckpoints.poll()) != null) {
            if (this.tryNotify) {
                object.promise().tryFailure(throwable);
                continue;
            }
            object.promise().setFailure(throwable);
        }
        return this;
    }

    @Deprecated
    public final ChannelFlushPromiseNotifier notifyFlushFutures(Throwable throwable, Throwable throwable2) {
        return this.notifyPromises(throwable, throwable2);
    }

    private void notifyPromises0(Throwable object) {
        if (this.flushCheckpoints.isEmpty()) {
            this.writeCounter = 0L;
            return;
        }
        long l = this.writeCounter;
        while (true) {
            FlushCheckpoint flushCheckpoint;
            if ((flushCheckpoint = this.flushCheckpoints.peek()) == null) {
                this.writeCounter = 0L;
                break;
            }
            if (flushCheckpoint.flushCheckpoint() > l) {
                if (l <= 0L || this.flushCheckpoints.size() != 1) break;
                this.writeCounter = 0L;
                FlushCheckpoint flushCheckpoint2 = flushCheckpoint;
                flushCheckpoint2.flushCheckpoint(flushCheckpoint2.flushCheckpoint() - l);
                break;
            }
            this.flushCheckpoints.remove();
            ChannelPromise channelPromise = flushCheckpoint.promise();
            if (object == null) {
                if (this.tryNotify) {
                    channelPromise.trySuccess();
                    continue;
                }
                channelPromise.setSuccess();
                continue;
            }
            if (this.tryNotify) {
                channelPromise.tryFailure((Throwable)object);
                continue;
            }
            channelPromise.setFailure((Throwable)object);
        }
        long l2 = this.writeCounter;
        if (l2 >= 0x8000000000L) {
            this.writeCounter = 0L;
            for (FlushCheckpoint flushCheckpoint : this.flushCheckpoints) {
                flushCheckpoint.flushCheckpoint(flushCheckpoint.flushCheckpoint() - l2);
            }
        }
    }

    private static class DefaultFlushCheckpoint
    implements FlushCheckpoint {
        private long checkpoint;
        private final ChannelPromise future;

        DefaultFlushCheckpoint(long l, ChannelPromise channelPromise) {
            this.checkpoint = l;
            this.future = channelPromise;
        }

        @Override
        public long flushCheckpoint() {
            return this.checkpoint;
        }

        @Override
        public void flushCheckpoint(long l) {
            this.checkpoint = l;
        }

        @Override
        public ChannelPromise promise() {
            return this.future;
        }
    }

    static interface FlushCheckpoint {
        public long flushCheckpoint();

        public void flushCheckpoint(long var1);

        public ChannelPromise promise();
    }
}

