/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements.jdbc;

import java.sql.DatabaseMetaData;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.exposed.sql.statements.api.IdentifierManagerApi;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0014R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\rR\u0014\u0010\u000e\u001a\u00020\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0014\u0010\u000f\u001a\u00020\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0014\u0010\u0011\u001a\u00020\u0012X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0094\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\nR\u0014\u0010\u001d\u001a\u00020\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\rR\u0014\u0010\u001f\u001a\u00020\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\r\u00a8\u0006\""}, d2={"Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcIdentifierManager;", "Lorg/jetbrains/exposed/sql/statements/api/IdentifierManagerApi;", "metadata", "Ljava/sql/DatabaseMetaData;", "(Ljava/sql/DatabaseMetaData;)V", "_keywords", "", "", "extraNameCharacters", "getExtraNameCharacters", "()Ljava/lang/String;", "isLowerCaseIdentifiers", "", "()Z", "isLowerCaseQuotedIdentifiers", "isUpperCaseIdentifiers", "isUpperCaseQuotedIdentifiers", "maxColumnNameLength", "", "getMaxColumnNameLength", "()I", "oracleVersion", "Lorg/jetbrains/exposed/sql/statements/api/IdentifierManagerApi$OracleVersion;", "getOracleVersion$annotations", "()V", "getOracleVersion", "()Lorg/jetbrains/exposed/sql/statements/api/IdentifierManagerApi$OracleVersion;", "quoteString", "getQuoteString", "supportsMixedIdentifiers", "getSupportsMixedIdentifiers", "supportsMixedQuotedIdentifiers", "getSupportsMixedQuotedIdentifiers", "dbKeywords", "exposed-jdbc"})
public final class JdbcIdentifierManager
extends IdentifierManagerApi {
    private final String quoteString;
    private final boolean isUpperCaseIdentifiers;
    private final boolean isUpperCaseQuotedIdentifiers;
    private final boolean isLowerCaseIdentifiers;
    private final boolean isLowerCaseQuotedIdentifiers;
    private final boolean supportsMixedIdentifiers;
    private final boolean supportsMixedQuotedIdentifiers;
    private final List<String> _keywords;
    private final String extraNameCharacters;
    private final IdentifierManagerApi.OracleVersion oracleVersion;
    private final int maxColumnNameLength;

    public JdbcIdentifierManager(DatabaseMetaData databaseMetaData) {
        Intrinsics.checkNotNullParameter((Object)databaseMetaData, (String)"");
        String string = databaseMetaData.getIdentifierQuoteString();
        Intrinsics.checkNotNull((Object)string);
        this.quoteString = ((Object)StringsKt.trim((CharSequence)string)).toString();
        this.isUpperCaseIdentifiers = databaseMetaData.storesUpperCaseIdentifiers();
        this.isUpperCaseQuotedIdentifiers = databaseMetaData.storesUpperCaseQuotedIdentifiers();
        this.isLowerCaseIdentifiers = databaseMetaData.storesLowerCaseIdentifiers();
        this.isLowerCaseQuotedIdentifiers = databaseMetaData.storesLowerCaseQuotedIdentifiers();
        this.supportsMixedIdentifiers = databaseMetaData.supportsMixedCaseIdentifiers();
        this.supportsMixedQuotedIdentifiers = databaseMetaData.supportsMixedCaseQuotedIdentifiers();
        String string2 = databaseMetaData.getSQLKeywords();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        char[] cArray = new char[1];
        char[] cArray2 = cArray;
        cArray[0] = 44;
        this._keywords = StringsKt.split$default((CharSequence)string2, (char[])cArray2, (boolean)false, (int)0, (int)6, null);
        String string3 = databaseMetaData.getExtraNameCharacters();
        Intrinsics.checkNotNull((Object)string3);
        this.extraNameCharacters = string3;
        this.oracleVersion = !Intrinsics.areEqual((Object)databaseMetaData.getDatabaseProductName(), (Object)"Oracle") ? IdentifierManagerApi.OracleVersion.NonOracle : (databaseMetaData.getDatabaseMajorVersion() <= 11 ? IdentifierManagerApi.OracleVersion.Oracle11g : (databaseMetaData.getDatabaseMajorVersion() == 12 && databaseMetaData.getDatabaseMinorVersion() == 1 ? IdentifierManagerApi.OracleVersion.Oracle12_1g : IdentifierManagerApi.OracleVersion.Oracle12plus));
        this.maxColumnNameLength = databaseMetaData.getMaxColumnNameLength();
    }

    public final String getQuoteString() {
        return this.quoteString;
    }

    protected final boolean isUpperCaseIdentifiers() {
        return this.isUpperCaseIdentifiers;
    }

    protected final boolean isUpperCaseQuotedIdentifiers() {
        return this.isUpperCaseQuotedIdentifiers;
    }

    protected final boolean isLowerCaseIdentifiers() {
        return this.isLowerCaseIdentifiers;
    }

    protected final boolean isLowerCaseQuotedIdentifiers() {
        return this.isLowerCaseQuotedIdentifiers;
    }

    protected final boolean getSupportsMixedIdentifiers() {
        return this.supportsMixedIdentifiers;
    }

    protected final boolean getSupportsMixedQuotedIdentifiers() {
        return this.supportsMixedQuotedIdentifiers;
    }

    protected final List<String> dbKeywords() {
        return this._keywords;
    }

    protected final String getExtraNameCharacters() {
        return this.extraNameCharacters;
    }

    protected final IdentifierManagerApi.OracleVersion getOracleVersion() {
        return this.oracleVersion;
    }

    protected static /* synthetic */ void getOracleVersion$annotations() {
    }

    protected final int getMaxColumnNameLength() {
        return this.maxColumnNameLength;
    }
}

