/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.input.pointer.util;

import androidx.compose.ui.input.pointer.util.DataPointAtTime;
import androidx.compose.ui.input.pointer.util.VelocityTrackerKt;
import androidx.compose.ui.input.pointer.util.VelocityTracker_notMobileKt;
import androidx.compose.ui.internal.InlineClassHelperKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001:\u0001\"B\u001d\b\u0000\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001aJ\u0006\u0010\u001d\u001a\u00020\u0016J \u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Landroidx/compose/ui/input/pointer/util/VelocityTracker1D;", "", "isDataDifferential", "", "strategy", "Landroidx/compose/ui/input/pointer/util/VelocityTracker1D$Strategy;", "<init>", "(ZLandroidx/compose/ui/input/pointer/util/VelocityTracker1D$Strategy;)V", "(Z)V", "()Z", "minSampleSize", "", "samples", "", "Landroidx/compose/ui/input/pointer/util/DataPointAtTime;", "[Landroidx/compose/ui/input/pointer/util/DataPointAtTime;", "index", "reusableDataPointsArray", "", "reusableTimeArray", "reusableVelocityCoefficients", "addDataPoint", "", "timeMillis", "", "dataPoint", "", "calculateVelocity", "maximumVelocity", "resetTracking", "calculateLeastSquaresVelocity", "dataPoints", "time", "sampleCount", "Strategy", "ui"})
public final class VelocityTracker1D {
    private final boolean isDataDifferential;
    private final Strategy strategy;
    private final int minSampleSize;
    private final DataPointAtTime[] samples;
    private int index;
    private final float[] reusableDataPointsArray;
    private final float[] reusableTimeArray;
    private final float[] reusableVelocityCoefficients;
    public static final int $stable = 8;

    public VelocityTracker1D(boolean bl, Strategy strategy) {
        int n;
        Intrinsics.checkNotNullParameter((Object)((Object)strategy), (String)"");
        this.isDataDifferential = bl;
        this.strategy = strategy;
        if (this.isDataDifferential && this.strategy.equals((Object)Strategy.Lsq2)) {
            throw new IllegalStateException("Lsq2 not (yet) supported for differential axes");
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.strategy.ordinal()]) {
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.minSampleSize = n;
        this.samples = new DataPointAtTime[20];
        this.reusableDataPointsArray = new float[20];
        this.reusableTimeArray = new float[20];
        this.reusableVelocityCoefficients = new float[3];
    }

    public /* synthetic */ VelocityTracker1D(boolean bl, Strategy strategy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            strategy = Strategy.Lsq2;
        }
        this(bl, strategy);
    }

    public final boolean isDataDifferential() {
        return this.isDataDifferential;
    }

    public VelocityTracker1D(boolean bl) {
        this(bl, Strategy.Impulse);
    }

    public final void addDataPoint(long l2, float f2) {
        this.index = (this.index + 1) % 20;
        VelocityTrackerKt.access$set(this.samples, this.index, l2, f2);
    }

    public final float calculateVelocity() {
        float[] fArray = this.reusableDataPointsArray;
        float[] fArray2 = this.reusableTimeArray;
        int n = 0;
        int n2 = this.index;
        DataPointAtTime dataPointAtTime = this.samples[n2];
        if (dataPointAtTime == null) {
            return 0.0f;
        }
        DataPointAtTime dataPointAtTime2 = dataPointAtTime;
        DataPointAtTime dataPointAtTime3 = dataPointAtTime;
        boolean bl = false;
        while (this.samples[n2] != null) {
            DataPointAtTime dataPointAtTime4;
            float f2 = dataPointAtTime2.getTime() - dataPointAtTime4.getTime();
            float f3 = Math.abs(dataPointAtTime4.getTime() - dataPointAtTime3.getTime());
            DataPointAtTime dataPointAtTime5 = dataPointAtTime3 = this.strategy == Strategy.Lsq2 || this.isDataDifferential ? dataPointAtTime4 : dataPointAtTime2;
            if (f3 > 40.0f) {
                bl = true;
                break;
            }
            if (f2 > 100.0f) break;
            fArray[n] = dataPointAtTime4.getDataPoint();
            fArray2[n] = -f2;
            n2 = (n2 == 0 ? 20 : n2) - 1;
            if (++n < 20) continue;
        }
        if (n >= this.minSampleSize && VelocityTracker_notMobileKt.shouldUseDataPoints(this, fArray, fArray2, n, bl)) {
            float f4;
            switch (WhenMappings.$EnumSwitchMapping$0[this.strategy.ordinal()]) {
                case 1: {
                    f4 = VelocityTrackerKt.access$calculateImpulseVelocity(fArray, fArray2, n, this.isDataDifferential);
                    break;
                }
                case 2: {
                    f4 = this.calculateLeastSquaresVelocity(fArray, fArray2, n);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return f4 * 1000.0f;
        }
        return 0.0f;
    }

    public final float calculateVelocity(float f2) {
        float f3;
        boolean bl = f2 > 0.0f;
        if (!bl) {
            InlineClassHelperKt.throwIllegalStateException("maximumVelocity should be a positive value. You specified=" + f2);
        }
        if ((f3 = this.calculateVelocity()) == 0.0f || Float.isNaN(f3)) {
            return 0.0f;
        }
        if (f3 > 0.0f) {
            return RangesKt.coerceAtMost((float)f3, (float)f2);
        }
        return RangesKt.coerceAtLeast((float)f3, (float)(-f2));
    }

    public final void resetTracking() {
        ArraysKt.fill$default((Object[])this.samples, null, (int)0, (int)0, (int)6, null);
        this.index = 0;
    }

    private final float calculateLeastSquaresVelocity(float[] fArray, float[] fArray2, int n) {
        float f2;
        try {
            f2 = VelocityTrackerKt.polyFitLeastSquares(fArray2, fArray, n, 2, this.reusableVelocityCoefficients)[1];
        }
        catch (IllegalArgumentException illegalArgumentException) {
            f2 = 0.0f;
        }
        return f2;
    }

    public VelocityTracker1D() {
        this(false, null, 3, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Landroidx/compose/ui/input/pointer/util/VelocityTracker1D$Strategy;", "", "<init>", "(Ljava/lang/String;I)V", "Lsq2", "Impulse", "ui"})
    public static final class Strategy
    extends Enum<Strategy> {
        public static final /* enum */ Strategy Lsq2 = new Strategy();
        public static final /* enum */ Strategy Impulse = new Strategy();
        private static final /* synthetic */ Strategy[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Strategy[] values() {
            return (Strategy[])$VALUES.clone();
        }

        public static Strategy valueOf(String string) {
            return Enum.valueOf(Strategy.class, string);
        }

        public static EnumEntries<Strategy> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ Strategy[] $values() {
            Strategy[] strategyArray = new Strategy[2];
            Strategy[] strategyArray2 = strategyArray;
            strategyArray[0] = Lsq2;
            strategyArray2[1] = Impulse;
            return strategyArray2;
        }

        static {
            $VALUES = Strategy.$values();
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Strategy.values().length];
            try {
                nArray[Strategy.Impulse.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Strategy.Lsq2.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

