/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.e.a.a.d;
import org.e.a.i;
import org.e.b.c;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.FlexibleStanzaTypeFilter;
import org.jivesoftware.smack.filter.OrFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.delay.DelayInformationManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverInfoBuilder;
import org.jivesoftware.smackx.pubsub.Affiliation;
import org.jivesoftware.smackx.pubsub.AffiliationsExtension;
import org.jivesoftware.smackx.pubsub.ConfigurationEvent;
import org.jivesoftware.smackx.pubsub.EmbeddedPacketExtension;
import org.jivesoftware.smackx.pubsub.EventElement;
import org.jivesoftware.smackx.pubsub.EventElementType;
import org.jivesoftware.smackx.pubsub.FormNode;
import org.jivesoftware.smackx.pubsub.FormNodeType;
import org.jivesoftware.smackx.pubsub.Item;
import org.jivesoftware.smackx.pubsub.ItemDeleteEvent;
import org.jivesoftware.smackx.pubsub.ItemPublishEvent;
import org.jivesoftware.smackx.pubsub.ItemsExtension;
import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.OptionsExtension;
import org.jivesoftware.smackx.pubsub.PubSubElementType;
import org.jivesoftware.smackx.pubsub.PubSubManager;
import org.jivesoftware.smackx.pubsub.RetractItem;
import org.jivesoftware.smackx.pubsub.SubscribeExtension;
import org.jivesoftware.smackx.pubsub.Subscription;
import org.jivesoftware.smackx.pubsub.SubscriptionsExtension;
import org.jivesoftware.smackx.pubsub.UnsubscribeExtension;
import org.jivesoftware.smackx.pubsub.form.ConfigureForm;
import org.jivesoftware.smackx.pubsub.form.FillableConfigureForm;
import org.jivesoftware.smackx.pubsub.form.FillableSubscribeForm;
import org.jivesoftware.smackx.pubsub.form.SubscribeForm;
import org.jivesoftware.smackx.pubsub.listener.ItemDeleteListener;
import org.jivesoftware.smackx.pubsub.listener.ItemEventListener;
import org.jivesoftware.smackx.pubsub.listener.NodeConfigListener;
import org.jivesoftware.smackx.pubsub.packet.PubSub;
import org.jivesoftware.smackx.pubsub.packet.PubSubNamespace;
import org.jivesoftware.smackx.pubsub.util.NodeUtils;
import org.jivesoftware.smackx.shim.packet.Header;
import org.jivesoftware.smackx.shim.packet.HeadersExtension;
import org.jivesoftware.smackx.xdata.form.FillableForm;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public abstract class Node {
    protected final PubSubManager pubSubManager;
    protected final String id;
    protected ConcurrentHashMap<ItemEventListener<Item>, StanzaListener> itemEventToListenerMap = new ConcurrentHashMap();
    protected ConcurrentHashMap<ItemDeleteListener, StanzaListener> itemDeleteToListenerMap = new ConcurrentHashMap();
    protected ConcurrentHashMap<NodeConfigListener, StanzaListener> configEventToListenerMap = new ConcurrentHashMap();

    Node(PubSubManager pubSubManager, String string) {
        this.pubSubManager = pubSubManager;
        this.id = string;
    }

    public String getId() {
        return this.id;
    }

    public ConfigureForm getNodeConfiguration() {
        PubSub pubSub = this.createPubsubPacket(IQ.Type.get, new NodeExtension(PubSubElementType.CONFIGURE_OWNER, this.getId()));
        pubSub = this.sendPubsubPacket(pubSub);
        return NodeUtils.getFormFromPacket((Stanza)pubSub, PubSubElementType.CONFIGURE_OWNER);
    }

    public void sendConfigurationForm(FillableConfigureForm object) {
        object = this.createPubsubPacket(IQ.Type.set, new FormNode(FormNodeType.CONFIGURE_OWNER, this.getId(), object.getDataFormToSubmit()));
        this.pubSubManager.getConnection().createStanzaCollectorAndSend((IQ)object).nextResultOrThrow();
    }

    public DiscoverInfo discoverInfo() {
        XMPPConnection xMPPConnection = this.pubSubManager.getConnection();
        DiscoverInfo discoverInfo = ((DiscoverInfoBuilder)DiscoverInfo.builder(xMPPConnection).to((i)this.pubSubManager.getServiceJid())).setNode(this.getId()).build();
        return (DiscoverInfo)xMPPConnection.createStanzaCollectorAndSend((IQ)discoverInfo).nextResultOrThrow();
    }

    public List<Subscription> getSubscriptions() {
        return this.getSubscriptions(null, null);
    }

    public List<Subscription> getSubscriptions(List<ExtensionElement> list, Collection<ExtensionElement> collection) {
        return this.getSubscriptions(SubscriptionsExtension.SubscriptionsNamespace.basic, list, collection);
    }

    public List<Subscription> getSubscriptionsAsOwner() {
        return this.getSubscriptionsAsOwner(null, null);
    }

    public List<Subscription> getSubscriptionsAsOwner(List<ExtensionElement> list, Collection<ExtensionElement> collection) {
        return this.getSubscriptions(SubscriptionsExtension.SubscriptionsNamespace.owner, list, collection);
    }

    private List<Subscription> getSubscriptions(SubscriptionsExtension.SubscriptionsNamespace enum_, List<ExtensionElement> object, Collection<ExtensionElement> collection) {
        ExtensionElement extensionElement;
        enum_ = ((SubscriptionsExtension.SubscriptionsNamespace)enum_).type;
        PubSub pubSub = this.createPubsubPacket(IQ.Type.get, new NodeExtension((PubSubElementType)enum_, this.getId()));
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                extensionElement = (ExtensionElement)object.next();
                pubSub.addExtension(extensionElement);
            }
        }
        object = this.sendPubsubPacket(pubSub);
        if (collection != null) {
            collection.addAll(object.getExtensions());
        }
        extensionElement = (SubscriptionsExtension)((PubSub)((Object)object)).getExtension((PubSubElementType)enum_);
        return extensionElement.getSubscriptions();
    }

    public PubSub modifySubscriptionsAsOwner(List<Subscription> object) {
        object = this.createPubsubPacket(IQ.Type.set, new SubscriptionsExtension(SubscriptionsExtension.SubscriptionsNamespace.owner, this.getId(), (List<Subscription>)object));
        return this.sendPubsubPacket((PubSub)((Object)object));
    }

    public List<Affiliation> getAffiliations() {
        return this.getAffiliations(null, null);
    }

    public List<Affiliation> getAffiliations(List<ExtensionElement> list, Collection<ExtensionElement> collection) {
        return this.getAffiliations(Affiliation.AffiliationNamespace.basic, list, collection);
    }

    public List<Affiliation> getAffiliationsAsOwner() {
        return this.getAffiliationsAsOwner(null, null);
    }

    public List<Affiliation> getAffiliationsAsOwner(List<ExtensionElement> list, Collection<ExtensionElement> collection) {
        return this.getAffiliations(Affiliation.AffiliationNamespace.owner, list, collection);
    }

    private List<Affiliation> getAffiliations(Affiliation.AffiliationNamespace enum_, List<ExtensionElement> object, Collection<ExtensionElement> collection) {
        ExtensionElement extensionElement;
        enum_ = ((Affiliation.AffiliationNamespace)enum_).type;
        PubSub pubSub = this.createPubsubPacket(IQ.Type.get, new NodeExtension((PubSubElementType)enum_, this.getId()));
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                extensionElement = (ExtensionElement)object.next();
                pubSub.addExtension(extensionElement);
            }
        }
        object = this.sendPubsubPacket(pubSub);
        if (collection != null) {
            collection.addAll(object.getExtensions());
        }
        extensionElement = (AffiliationsExtension)((PubSub)((Object)object)).getExtension((PubSubElementType)enum_);
        return extensionElement.getAffiliations();
    }

    public PubSub modifyAffiliationAsOwner(List<Affiliation> list) {
        for (Affiliation affiliation : list) {
            if (affiliation.getPubSubNamespace() == PubSubNamespace.owner) continue;
            throw new IllegalArgumentException("Must use Affiliation(BareJid, Type) affiliations");
        }
        Object object = this.createPubsubPacket(IQ.Type.set, new AffiliationsExtension(Affiliation.AffiliationNamespace.owner, list, this.getId()));
        return this.sendPubsubPacket((PubSub)((Object)object));
    }

    public Subscription subscribe(i object) {
        object = this.createPubsubPacket(IQ.Type.set, new SubscribeExtension((i)object, this.getId()));
        object = this.sendPubsubPacket((PubSub)((Object)object));
        return (Subscription)object.getExtension(PubSubElementType.SUBSCRIPTION);
    }

    @Deprecated
    public Subscription subscribe(String string) {
        try {
            string = d.a((String)string);
        }
        catch (c c2) {
            throw new IllegalArgumentException(c2);
        }
        return this.subscribe((i)string);
    }

    public Subscription subscribe(i object, FillableSubscribeForm object2) {
        object2 = ((FillableForm)object2).getDataFormToSubmit();
        object = this.createPubsubPacket(IQ.Type.set, new SubscribeExtension((i)object, this.getId()));
        object.addExtension((ExtensionElement)new FormNode(FormNodeType.OPTIONS, (DataForm)object2));
        object = this.sendPubsubPacket((PubSub)((Object)object));
        return (Subscription)object.getExtension(PubSubElementType.SUBSCRIPTION);
    }

    @Deprecated
    public Subscription subscribe(String string, FillableSubscribeForm fillableSubscribeForm) {
        try {
            string = d.a((String)string);
        }
        catch (c c2) {
            throw new IllegalArgumentException(c2);
        }
        return this.subscribe((i)string, fillableSubscribeForm);
    }

    public void unsubscribe(String string) {
        this.unsubscribe(string, null);
    }

    public void unsubscribe(String string, String string2) {
        Node node = this;
        node.sendPubsubPacket(node.createPubsubPacket(IQ.Type.set, new UnsubscribeExtension(string, this.getId(), string2)));
    }

    public SubscribeForm getSubscriptionOptions(String string) {
        return this.getSubscriptionOptions(string, null);
    }

    public SubscribeForm getSubscriptionOptions(String object, String string) {
        Node node = this;
        object = node.sendPubsubPacket(node.createPubsubPacket(IQ.Type.get, new OptionsExtension((String)object, this.getId(), string)));
        object = (FormNode)((PubSub)((Object)object)).getExtension(PubSubElementType.OPTIONS);
        return new SubscribeForm(((FormNode)object).getForm());
    }

    public void addItemEventListener(ItemEventListener itemEventListener) {
        ItemEventTranslator itemEventTranslator = new ItemEventTranslator(itemEventListener);
        this.itemEventToListenerMap.put(itemEventListener, itemEventTranslator);
        this.pubSubManager.getConnection().addSyncStanzaListener((StanzaListener)itemEventTranslator, (StanzaFilter)new EventContentFilter(EventElementType.items.toString(), "item"));
    }

    public void removeItemEventListener(ItemEventListener itemEventListener) {
        if ((itemEventListener = this.itemEventToListenerMap.remove(itemEventListener)) != null) {
            this.pubSubManager.getConnection().removeSyncStanzaListener((StanzaListener)itemEventListener);
        }
    }

    public void addConfigurationListener(NodeConfigListener nodeConfigListener) {
        NodeConfigTranslator nodeConfigTranslator = new NodeConfigTranslator(nodeConfigListener);
        this.configEventToListenerMap.put(nodeConfigListener, nodeConfigTranslator);
        this.pubSubManager.getConnection().addSyncStanzaListener((StanzaListener)nodeConfigTranslator, (StanzaFilter)new EventContentFilter(EventElementType.configuration.toString()));
    }

    public void removeConfigurationListener(NodeConfigListener nodeConfigListener) {
        if ((nodeConfigListener = this.configEventToListenerMap.remove(nodeConfigListener)) != null) {
            this.pubSubManager.getConnection().removeSyncStanzaListener((StanzaListener)nodeConfigListener);
        }
    }

    public void addItemDeleteListener(ItemDeleteListener object) {
        ItemDeleteTranslator itemDeleteTranslator = new ItemDeleteTranslator((ItemDeleteListener)object);
        this.itemDeleteToListenerMap.put((ItemDeleteListener)object, itemDeleteTranslator);
        object = new EventContentFilter(EventElementType.items.toString(), "retract");
        EventContentFilter eventContentFilter = new EventContentFilter(EventElementType.purge.toString());
        this.pubSubManager.getConnection().addSyncStanzaListener((StanzaListener)itemDeleteTranslator, (StanzaFilter)new OrFilter(new StanzaFilter[]{object, eventContentFilter}));
    }

    public void removeItemDeleteListener(ItemDeleteListener itemDeleteListener) {
        if ((itemDeleteListener = this.itemDeleteToListenerMap.remove(itemDeleteListener)) != null) {
            this.pubSubManager.getConnection().removeSyncStanzaListener((StanzaListener)itemDeleteListener);
        }
    }

    public String toString() {
        return super.toString() + " " + this.getClass().getName() + " id: " + this.id;
    }

    protected PubSub createPubsubPacket(IQ.Type type, NodeExtension nodeExtension) {
        return PubSub.createPubsubPacket((i)this.pubSubManager.getServiceJid(), type, nodeExtension);
    }

    protected PubSub sendPubsubPacket(PubSub pubSub) {
        return this.pubSubManager.sendPubsubPacket(pubSub);
    }

    private static List<String> getSubscriptionIds(Stanza object) {
        object = (HeadersExtension)object.getExtension(HeadersExtension.class);
        ArrayList<String> arrayList = null;
        if (object != null) {
            arrayList = new ArrayList<String>(((HeadersExtension)object).getHeaders().size());
            for (Header header : ((HeadersExtension)object).getHeaders()) {
                arrayList.add(header.getValue());
            }
        }
        return arrayList;
    }

    class EventContentFilter
    extends FlexibleStanzaTypeFilter<Message> {
        private final String firstElement;
        private final String secondElement;
        private final boolean allowEmpty;

        EventContentFilter(String string) {
            this(string, null);
        }

        EventContentFilter(String string, String string2) {
            this.firstElement = string;
            this.secondElement = string2;
            this.allowEmpty = this.firstElement.equals(EventElementType.items.toString()) && "item".equals(string2);
        }

        public boolean acceptSpecific(Message object) {
            if ((object = EventElement.from((Stanza)object)) == null) {
                return false;
            }
            if ((object = ((EventElement)object).getEvent()) == null) {
                return false;
            }
            if (((NodeExtension)object).getElementName().equals(this.firstElement)) {
                if (!((NodeExtension)object).getNode().equals(Node.this.getId())) {
                    return false;
                }
                if (this.secondElement == null) {
                    return true;
                }
                if (object instanceof EmbeddedPacketExtension) {
                    object = ((EmbeddedPacketExtension)object).getExtensions();
                    if (this.allowEmpty && object.isEmpty()) {
                        return true;
                    }
                    if (object.size() > 0 && ((ExtensionElement)object.get(0)).getElementName().equals(this.secondElement)) {
                        return true;
                    }
                }
            }
            return false;
        }
    }

    public static class NodeConfigTranslator
    implements StanzaListener {
        private final NodeConfigListener listener;

        public NodeConfigTranslator(NodeConfigListener nodeConfigListener) {
            this.listener = nodeConfigListener;
        }

        public void processStanza(Stanza object) {
            object = (EventElement)object.getExtensionElement("event", PubSubNamespace.event.getXmlns());
            object = (ConfigurationEvent)object.getEvent();
            this.listener.handleNodeConfiguration((ConfigurationEvent)object);
        }
    }

    public static class ItemDeleteTranslator
    implements StanzaListener {
        private final ItemDeleteListener listener;

        public ItemDeleteTranslator(ItemDeleteListener itemDeleteListener) {
            this.listener = itemDeleteListener;
        }

        public void processStanza(Stanza stanza) {
            EmbeddedPacketExtension embeddedPacketExtension = (EventElement)stanza.getExtensionElement("event", PubSubNamespace.event.getXmlns());
            List<ExtensionElement> list = ((EventElement)embeddedPacketExtension).getExtensions();
            if (list.get(0).getElementName().equals(PubSubElementType.PURGE_EVENT.getElementName())) {
                this.listener.handlePurge();
                return;
            }
            embeddedPacketExtension = (ItemsExtension)((EventElement)embeddedPacketExtension).getEvent();
            list = ((ItemsExtension)embeddedPacketExtension).getItems();
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (RetractItem retractItem : list) {
                arrayList.add(retractItem.getId());
            }
            list = new ItemDeleteEvent(((NodeExtension)((Object)embeddedPacketExtension)).getNode(), arrayList, Node.getSubscriptionIds(stanza));
            this.listener.handleDeletedItems((ItemDeleteEvent)((Object)list));
        }
    }

    public static class ItemEventTranslator
    implements StanzaListener {
        private final ItemEventListener listener;

        public ItemEventTranslator(ItemEventListener itemEventListener) {
            this.listener = itemEventListener;
        }

        public void processStanza(Stanza object) {
            EmbeddedPacketExtension embeddedPacketExtension = (EventElement)object.getExtensionElement("event", PubSubNamespace.event.getXmlns());
            embeddedPacketExtension = (ItemsExtension)((EventElement)embeddedPacketExtension).getEvent();
            object = new ItemPublishEvent<NamedElement>(((NodeExtension)((Object)embeddedPacketExtension)).getNode(), ((ItemsExtension)embeddedPacketExtension).getItems(), Node.getSubscriptionIds(object), DelayInformationManager.getDelayTimestamp(object));
            this.listener.handlePublishedItems(object);
        }
    }
}

