/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.components;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectAnnotationSource;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectKotlinClassKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.SignatureSerializer;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectClassUtilKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ClassLiteralValue;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;

final class ReflectClassStructure {
    public static final ReflectClassStructure INSTANCE = new ReflectClassStructure();

    private ReflectClassStructure() {
    }

    public final void loadClassAnnotations(Class<?> object, KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor) {
        Intrinsics.checkNotNullParameter(object, (String)"");
        Intrinsics.checkNotNullParameter((Object)annotationVisitor, (String)"");
        object = ArrayIteratorKt.iterator((Object[])((Class)object).getDeclaredAnnotations());
        while (object.hasNext()) {
            Annotation annotation = (Annotation)object.next();
            Intrinsics.checkNotNull((Object)annotation);
            this.processAnnotation(annotationVisitor, annotation);
        }
        annotationVisitor.visitEnd();
    }

    public final void visitMembers(Class<?> clazz, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        Intrinsics.checkNotNullParameter((Object)memberVisitor, (String)"");
        this.loadMethodAnnotations(clazz, memberVisitor);
        this.loadConstructorAnnotations(clazz, memberVisitor);
        this.loadFieldAnnotations(clazz, memberVisitor);
    }

    private final void loadMethodAnnotations(Class<?> object, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        object = ArrayIteratorKt.iterator((Object[])((Class)object).getDeclaredMethods());
        while (object.hasNext()) {
            KotlinJvmBinaryClass.MethodAnnotationVisitor methodAnnotationVisitor;
            Method method = (Method)object.next();
            Name name = Name.identifier(method.getName());
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
            Intrinsics.checkNotNull((Object)method);
            if (memberVisitor.visitMethod(name, SignatureSerializer.INSTANCE.methodDesc(method)) == null) continue;
            Annotation[][] annotationArray = ArrayIteratorKt.iterator((Object[])method.getDeclaredAnnotations());
            while (annotationArray.hasNext()) {
                Annotation annotation = (Annotation)annotationArray.next();
                KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor = methodAnnotationVisitor;
                Intrinsics.checkNotNull((Object)annotation);
                this.processAnnotation(annotationVisitor, annotation);
            }
            Annotation[][] annotationArray2 = method.getParameterAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)annotationArray2, (String)"");
            annotationArray = annotationArray2;
            int n = ((Object[])annotationArray).length;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                Object object2 = annotationArray[i];
                object2 = ArrayIteratorKt.iterator((Object[])object2);
                while (object2.hasNext()) {
                    KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor;
                    Annotation annotation = (Annotation)object2.next();
                    Class clazz = JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation));
                    ClassId classId = ReflectClassUtilKt.getClassId(clazz);
                    Intrinsics.checkNotNull((Object)annotation);
                    if (methodAnnotationVisitor.visitParameterAnnotation(n2, classId, new ReflectAnnotationSource(annotation)) == null) continue;
                    INSTANCE.processAnnotationArguments(annotationArgumentVisitor, annotation, clazz);
                }
            }
            methodAnnotationVisitor.visitEnd();
        }
    }

    private final void loadConstructorAnnotations(Class<?> object, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        object = ArrayIteratorKt.iterator((Object[])((Class)object).getDeclaredConstructors());
        while (object.hasNext()) {
            KotlinJvmBinaryClass.MethodAnnotationVisitor methodAnnotationVisitor;
            Annotation[][] annotationArray = (Annotation[][])object.next();
            Intrinsics.checkNotNull((Object)annotationArray);
            if (memberVisitor.visitMethod(SpecialNames.INIT, SignatureSerializer.INSTANCE.constructorDesc((Constructor<?>)annotationArray)) == null) continue;
            Annotation[][] annotationArray2 = ArrayIteratorKt.iterator((Object[])annotationArray.getDeclaredAnnotations());
            while (annotationArray2.hasNext()) {
                Annotation annotation = (Annotation)annotationArray2.next();
                KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor = methodAnnotationVisitor;
                Intrinsics.checkNotNull((Object)annotation);
                this.processAnnotation(annotationVisitor, annotation);
            }
            annotationArray2 = annotationArray.getParameterAnnotations();
            Intrinsics.checkNotNull((Object)annotationArray2);
            if (!(((Object[])annotationArray2).length == 0)) {
                int n = annotationArray.getParameterTypes().length - ((Object[])annotationArray2).length;
                annotationArray = annotationArray2;
                int n2 = ((Object[])annotationArray).length;
                for (int i = 0; i < n2; ++i) {
                    int n3 = i;
                    Object object2 = annotationArray[i];
                    object2 = ArrayIteratorKt.iterator((Object[])object2);
                    while (object2.hasNext()) {
                        Annotation annotation = (Annotation)object2.next();
                        Class clazz = JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation));
                        ClassId classId = ReflectClassUtilKt.getClassId(clazz);
                        Intrinsics.checkNotNull((Object)annotation);
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = methodAnnotationVisitor.visitParameterAnnotation(n3 + n, classId, new ReflectAnnotationSource(annotation));
                        if (annotationArgumentVisitor == null) continue;
                        INSTANCE.processAnnotationArguments(annotationArgumentVisitor, annotation, clazz);
                    }
                }
            }
            methodAnnotationVisitor.visitEnd();
        }
    }

    private final void loadFieldAnnotations(Class<?> object, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        object = ArrayIteratorKt.iterator((Object[])((Class)object).getDeclaredFields());
        while (object.hasNext()) {
            KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor;
            Object object2 = (Field)object.next();
            Name name = Name.identifier(((Field)object2).getName());
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
            Intrinsics.checkNotNull((Object)object2);
            if (memberVisitor.visitField(name, SignatureSerializer.INSTANCE.fieldDesc((Field)object2), null) == null) continue;
            object2 = ArrayIteratorKt.iterator((Object[])((Field)object2).getDeclaredAnnotations());
            while (object2.hasNext()) {
                Annotation annotation = (Annotation)object2.next();
                Intrinsics.checkNotNull((Object)annotation);
                this.processAnnotation(annotationVisitor, annotation);
            }
            annotationVisitor.visitEnd();
        }
    }

    private final void processAnnotation(KotlinJvmBinaryClass.AnnotationVisitor object, Annotation annotation) {
        Class clazz = JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation));
        KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = object.visitAnnotation(ReflectClassUtilKt.getClassId(clazz), new ReflectAnnotationSource(annotation));
        if (annotationArgumentVisitor != null) {
            object = annotationArgumentVisitor;
            INSTANCE.processAnnotationArguments((KotlinJvmBinaryClass.AnnotationArgumentVisitor)object, annotation, clazz);
            return;
        }
    }

    private final void processAnnotationArguments(KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor, Annotation annotation, Class<?> object) {
        object = ArrayIteratorKt.iterator((Object[])((Class)object).getDeclaredMethods());
        while (object.hasNext()) {
            Object object2;
            Method method = (Method)object.next();
            try {
                Object object3 = method.invoke((Object)annotation, new Object[0]);
                Intrinsics.checkNotNull((Object)object3);
                object2 = object3;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            Name name = Name.identifier(method.getName());
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
            this.processAnnotationArgumentValue(annotationArgumentVisitor, name, object2);
        }
        annotationArgumentVisitor.visitEnd();
    }

    private final ClassLiteralValue classLiteralValue(Class<?> object) {
        int n = 0;
        while (((Class)object).isArray()) {
            ++n;
            object = ((Class)object).getComponentType();
        }
        if (((Class)object).isPrimitive()) {
            if (Intrinsics.areEqual(object, Void.TYPE)) {
                return new ClassLiteralValue(ClassId.Companion.topLevel(StandardNames.FqNames.unit.toSafe()), n);
            }
            PrimitiveType primitiveType = JvmPrimitiveType.get(((Class)object).getName()).getPrimitiveType();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)primitiveType), (String)"");
            object = primitiveType;
            if (n > 0) {
                return new ClassLiteralValue(ClassId.Companion.topLevel(((PrimitiveType)((Object)object)).getArrayTypeFqName()), n - 1);
            }
            return new ClassLiteralValue(ClassId.Companion.topLevel(((PrimitiveType)((Object)object)).getTypeFqName()), n);
        }
        Object object2 = JavaToKotlinClassMap.INSTANCE.mapJavaToKotlin(((ClassId)(object = ReflectClassUtilKt.getClassId(object))).asSingleFqName());
        if (object2 == null) {
            object2 = object;
        }
        object = object2;
        return new ClassLiteralValue((ClassId)object, n);
    }

    private final void processAnnotationArgumentValue(KotlinJvmBinaryClass.AnnotationArgumentVisitor objectArray, Name objectArray2, Object object) {
        Class<?> clazz = object.getClass();
        if (Intrinsics.areEqual(clazz, Class.class)) {
            Intrinsics.checkNotNull((Object)object);
            objectArray.visitClassLiteral((Name)objectArray2, this.classLiteralValue((Class)object));
            return;
        }
        if (ReflectKotlinClassKt.access$getTYPES_ELIGIBLE_FOR_SIMPLE_VISIT$p().contains(clazz)) {
            objectArray.visit((Name)objectArray2, object);
            return;
        }
        if (ReflectClassUtilKt.isEnumClassOrSpecializedEnumEntryClass(clazz)) {
            clazz = clazz.isEnum() ? clazz : clazz.getEnclosingClass();
            Intrinsics.checkNotNull(clazz);
            ClassId classId = ReflectClassUtilKt.getClassId(clazz);
            Intrinsics.checkNotNull((Object)object);
            Name name = Name.identifier(((Enum)object).name());
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
            objectArray.visitEnum((Name)objectArray2, classId, name);
            return;
        }
        if (Annotation.class.isAssignableFrom(clazz)) {
            Class<?>[] classArray = clazz.getInterfaces();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"");
            Class clazz2 = (Class)ArraysKt.single((Object[])classArray);
            Intrinsics.checkNotNull((Object)clazz2);
            KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = objectArray.visitAnnotation((Name)objectArray2, ReflectClassUtilKt.getClassId(clazz2));
            if (annotationArgumentVisitor == null) {
                return;
            }
            clazz = annotationArgumentVisitor;
            Intrinsics.checkNotNull((Object)object);
            this.processAnnotationArguments((KotlinJvmBinaryClass.AnnotationArgumentVisitor)((Object)clazz), (Annotation)object, clazz2);
            return;
        }
        if (clazz.isArray()) {
            KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor annotationArrayArgumentVisitor = objectArray.visitArray((Name)objectArray2);
            if (annotationArrayArgumentVisitor == null) {
                return;
            }
            KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor annotationArrayArgumentVisitor2 = annotationArrayArgumentVisitor;
            if ((clazz = clazz.getComponentType()).isEnum()) {
                Intrinsics.checkNotNull(clazz);
                objectArray = ReflectClassUtilKt.getClassId(clazz);
                Intrinsics.checkNotNull((Object)object);
                for (Object object2 : (Object[])object) {
                    Intrinsics.checkNotNull((Object)object2);
                    Name name = Name.identifier(((Enum)object2).name());
                    Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
                    annotationArrayArgumentVisitor2.visitEnum((ClassId)objectArray, name);
                }
            } else if (Intrinsics.areEqual(clazz, Class.class)) {
                Intrinsics.checkNotNull((Object)object);
                for (Object object3 : (Object[])object) {
                    Intrinsics.checkNotNull((Object)object3);
                    annotationArrayArgumentVisitor2.visitClassLiteral(this.classLiteralValue((Class)object3));
                }
            } else if (Annotation.class.isAssignableFrom(clazz)) {
                Intrinsics.checkNotNull((Object)object);
                for (Object object4 : (Object[])object) {
                    KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor;
                    Intrinsics.checkNotNull((Object)clazz);
                    if (annotationArrayArgumentVisitor2.visitAnnotation(ReflectClassUtilKt.getClassId(clazz)) == null) continue;
                    Intrinsics.checkNotNull((Object)object4);
                    this.processAnnotationArguments(annotationArgumentVisitor, (Annotation)object4, clazz);
                }
            } else {
                Intrinsics.checkNotNull((Object)object);
                for (Object object5 : (Object[])object) {
                    annotationArrayArgumentVisitor2.visit(object5);
                }
            }
            annotationArrayArgumentVisitor2.visitEnd();
            return;
        }
        throw new UnsupportedOperationException("Unsupported annotation argument value (" + clazz + "): " + object);
    }
}

