/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.protobuf;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import kotlin.reflect.jvm.internal.impl.protobuf.CodedInputStream;
import kotlin.reflect.jvm.internal.impl.protobuf.Internal;
import kotlin.reflect.jvm.internal.impl.protobuf.LiteralByteString;
import kotlin.reflect.jvm.internal.impl.protobuf.RopeByteString;

public abstract class ByteString
implements Iterable<Byte> {
    public static final ByteString EMPTY = new LiteralByteString(new byte[0]);

    ByteString() {
    }

    public abstract ByteIterator iterator();

    public abstract int size();

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public static ByteString copyFrom(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return new LiteralByteString(byArray2);
    }

    public static ByteString copyFrom(byte[] byArray) {
        return ByteString.copyFrom(byArray, 0, byArray.length);
    }

    public static ByteString copyFromUtf8(String string) {
        try {
            return new LiteralByteString(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-8 not supported?", unsupportedEncodingException);
        }
    }

    public ByteString concat(ByteString byteString) {
        int n;
        int n2 = this.size();
        if ((long)n2 + (long)(n = byteString.size()) >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException(new StringBuilder(53).append("ByteString would be too long: ").append(n2).append("+").append(n).toString());
        }
        return RopeByteString.concatenate(this, byteString);
    }

    public static ByteString copyFrom(Iterable<ByteString> object) {
        ArrayList<ByteString> arrayList;
        if (!(object instanceof Collection)) {
            arrayList = new ArrayList<ByteString>();
            object = object.iterator();
            while (object.hasNext()) {
                ByteString byteString = (ByteString)object.next();
                arrayList.add(byteString);
            }
        } else {
            arrayList = (ArrayList<ByteString>)object;
        }
        object = arrayList.isEmpty() ? EMPTY : ByteString.balancedConcat(arrayList.iterator(), arrayList.size());
        return object;
    }

    private static ByteString balancedConcat(Iterator<ByteString> object, int n) {
        assert (n > 0);
        if (n == 1) {
            object = object.next();
        } else {
            int n2 = n >>> 1;
            ByteString byteString = ByteString.balancedConcat((Iterator<ByteString>)object, n2);
            object = ByteString.balancedConcat((Iterator<ByteString>)object, n - n2);
            object = byteString.concat((ByteString)object);
        }
        return object;
    }

    public void copyTo(byte[] byArray, int n, int n2, int n3) {
        if (n < 0) {
            throw new IndexOutOfBoundsException(new StringBuilder(30).append("Source offset < 0: ").append(n).toString());
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException(new StringBuilder(30).append("Target offset < 0: ").append(n2).toString());
        }
        if (n3 < 0) {
            throw new IndexOutOfBoundsException(new StringBuilder(23).append("Length < 0: ").append(n3).toString());
        }
        if (n + n3 > this.size()) {
            int n4 = n + n3;
            throw new IndexOutOfBoundsException(new StringBuilder(34).append("Source end offset < 0: ").append(n4).toString());
        }
        if (n2 + n3 > byArray.length) {
            int n5 = n2 + n3;
            throw new IndexOutOfBoundsException(new StringBuilder(34).append("Target end offset < 0: ").append(n5).toString());
        }
        if (n3 > 0) {
            this.copyToInternal(byArray, n, n2, n3);
        }
    }

    protected abstract void copyToInternal(byte[] var1, int var2, int var3, int var4);

    public byte[] toByteArray() {
        int n = this.size();
        if (n == 0) {
            return Internal.EMPTY_BYTE_ARRAY;
        }
        byte[] byArray = new byte[n];
        this.copyToInternal(byArray, 0, 0, n);
        return byArray;
    }

    void writeTo(OutputStream outputStream, int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException(new StringBuilder(30).append("Source offset < 0: ").append(n).toString());
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException(new StringBuilder(23).append("Length < 0: ").append(n2).toString());
        }
        if (n + n2 > this.size()) {
            int n3 = n + n2;
            throw new IndexOutOfBoundsException(new StringBuilder(39).append("Source end offset exceeded: ").append(n3).toString());
        }
        if (n2 > 0) {
            this.writeToInternal(outputStream, n, n2);
        }
    }

    abstract void writeToInternal(OutputStream var1, int var2, int var3);

    public abstract String toString(String var1);

    public String toStringUtf8() {
        try {
            return this.toString("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-8 not supported?", unsupportedEncodingException);
        }
    }

    public abstract boolean isValidUtf8();

    protected abstract int partialIsValidUtf8(int var1, int var2, int var3);

    public abstract CodedInputStream newCodedInput();

    public static Output newOutput() {
        return new Output(128);
    }

    protected abstract int getTreeDepth();

    protected abstract boolean isBalanced();

    protected abstract int peekCachedHashCode();

    protected abstract int partialHash(int var1, int var2, int var3);

    public String toString() {
        return String.format("<ByteString@%s size=%d>", Integer.toHexString(System.identityHashCode(this)), this.size());
    }

    public static final class Output
    extends OutputStream {
        private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
        private final int initialCapacity;
        private final ArrayList<ByteString> flushedBuffers;
        private int flushedBuffersTotalBytes;
        private byte[] buffer;
        private int bufferPos;

        Output(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Buffer size < 0");
            }
            this.initialCapacity = n;
            this.flushedBuffers = new ArrayList();
            this.buffer = new byte[n];
        }

        @Override
        public final synchronized void write(int n) {
            if (this.bufferPos == this.buffer.length) {
                this.flushFullBuffer(1);
            }
            this.buffer[this.bufferPos++] = (byte)n;
        }

        @Override
        public final synchronized void write(byte[] byArray, int n, int n2) {
            if (n2 <= this.buffer.length - this.bufferPos) {
                System.arraycopy(byArray, n, this.buffer, this.bufferPos, n2);
                this.bufferPos += n2;
                return;
            }
            int n3 = this.buffer.length - this.bufferPos;
            System.arraycopy(byArray, n, this.buffer, this.bufferPos, n3);
            this.flushFullBuffer(n2 -= n3);
            System.arraycopy(byArray, n += n3, this.buffer, 0, n2);
            this.bufferPos = n2;
        }

        public final synchronized ByteString toByteString() {
            this.flushLastBuffer();
            return ByteString.copyFrom(this.flushedBuffers);
        }

        private byte[] copyArray(byte[] byArray, int n) {
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, Math.min(byArray.length, n));
            return byArray2;
        }

        public final synchronized int size() {
            return this.flushedBuffersTotalBytes + this.bufferPos;
        }

        public final String toString() {
            return String.format("<ByteString.Output@%s size=%d>", Integer.toHexString(System.identityHashCode(this)), this.size());
        }

        private void flushFullBuffer(int n) {
            this.flushedBuffers.add(new LiteralByteString(this.buffer));
            this.flushedBuffersTotalBytes += this.buffer.length;
            n = Math.max(this.initialCapacity, Math.max(n, this.flushedBuffersTotalBytes >>> 1));
            this.buffer = new byte[n];
            this.bufferPos = 0;
        }

        private void flushLastBuffer() {
            if (this.bufferPos < this.buffer.length) {
                if (this.bufferPos > 0) {
                    Output output = this;
                    byte[] byArray = output.copyArray(output.buffer, this.bufferPos);
                    this.flushedBuffers.add(new LiteralByteString(byArray));
                }
            } else {
                this.flushedBuffers.add(new LiteralByteString(this.buffer));
                this.buffer = EMPTY_BYTE_ARRAY;
            }
            this.flushedBuffersTotalBytes += this.bufferPos;
            this.bufferPos = 0;
        }
    }

    public static interface ByteIterator
    extends Iterator<Byte> {
        public byte nextByte();
    }
}

