/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;

public final class EnumValue
extends ConstantValue<Pair<? extends ClassId, ? extends Name>> {
    private final ClassId enumClassId;
    private final Name enumEntryName;

    public EnumValue(ClassId classId, Name name) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"");
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        super(TuplesKt.to((Object)classId, (Object)name));
        this.enumClassId = classId;
        this.enumEntryName = name;
    }

    public final Name getEnumEntryName() {
        return this.enumEntryName;
    }

    @Override
    public final KotlinType getType(ModuleDescriptor declarationDescriptor) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        Annotated annotated = FindClassInModuleKt.findClassAcrossModuleDependencies(declarationDescriptor, this.enumClassId);
        if (annotated != null) {
            declarationDescriptor = annotated;
            stringArray = (String[])annotated;
            if ((annotated = DescriptorUtils.isEnumClass((DeclarationDescriptor)stringArray) ? declarationDescriptor : null) != null && (annotated = annotated.getDefaultType()) != null) {
                return (KotlinType)annotated;
            }
        }
        String[] stringArray2 = new String[2];
        stringArray = stringArray2;
        stringArray2[0] = this.enumClassId.toString();
        stringArray[1] = this.enumEntryName.toString();
        return ErrorUtils.createErrorType(ErrorTypeKind.ERROR_ENUM_TYPE, stringArray);
    }

    @Override
    public final String toString() {
        return "" + this.enumClassId.getShortClassName() + '.' + this.enumEntryName;
    }
}

