/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.scopes;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SimpleFunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Substitutable;
import kotlin.reflect.jvm.internal.impl.incremental.components.LookupLocation;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.CapturedTypeConstructorKt;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.DescriptorKindFilter;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.ResolutionScope;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.SubstitutingScope$$Lambda$0;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.SubstitutingScope$$Lambda$1;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitution;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.utils.CollectionsKt;

public final class SubstitutingScope
implements MemberScope {
    private final MemberScope workerScope;
    private final Lazy substitutor$delegate;
    private final TypeSubstitutor capturingSubstitutor;
    private Map<DeclarationDescriptor, DeclarationDescriptor> substitutedDescriptors;
    private final Lazy _allDescriptors$delegate;

    public SubstitutingScope(MemberScope object, TypeSubstitutor typeSubstitutor2) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeSubstitutor2, (String)"");
        this.workerScope = object;
        object = typeSubstitutor2;
        this.substitutor$delegate = LazyKt.lazy((Function0)new SubstitutingScope$$Lambda$0((TypeSubstitutor)object));
        TypeSubstitution typeSubstitution = typeSubstitutor2.getSubstitution();
        Intrinsics.checkNotNullExpressionValue((Object)typeSubstitution, (String)"");
        this.capturingSubstitutor = CapturedTypeConstructorKt.wrapWithCapturingSubstitution$default(typeSubstitution, false, 1, null).buildSubstitutor();
        object = this;
        this._allDescriptors$delegate = LazyKt.lazy((Function0)new SubstitutingScope$$Lambda$1((SubstitutingScope)object));
    }

    private final Collection<DeclarationDescriptor> get_allDescriptors() {
        Lazy lazy = this._allDescriptors$delegate;
        return (Collection)lazy.getValue();
    }

    private final <D extends DeclarationDescriptor> D substitute(D object) {
        DeclarationDescriptor declarationDescriptor;
        if (this.capturingSubstitutor.isEmpty()) {
            return object;
        }
        if (this.substitutedDescriptors == null) {
            this.substitutedDescriptors = new HashMap();
        }
        Map<DeclarationDescriptor, DeclarationDescriptor> map = this.substitutedDescriptors;
        Intrinsics.checkNotNull(map);
        Map<DeclarationDescriptor, DeclarationDescriptor> map2 = map;
        DeclarationDescriptor declarationDescriptor2 = map.get(object);
        if (declarationDescriptor2 == null) {
            if (object instanceof Substitutable) {
                declarationDescriptor2 = ((Substitutable)object).substitute(this.capturingSubstitutor);
                if (declarationDescriptor2 == null) {
                    object = "We expect that no conflict should happen while substitution is guaranteed to generate invariant projection, but " + object + " substitution fails";
                    throw new AssertionError(object);
                }
            } else {
                throw new IllegalStateException(("Unknown descriptor in scope: " + object).toString());
            }
            declarationDescriptor2 = declarationDescriptor2;
            map2.put((DeclarationDescriptor)object, declarationDescriptor2);
            declarationDescriptor = declarationDescriptor2;
        } else {
            declarationDescriptor = declarationDescriptor2;
        }
        object = declarationDescriptor;
        Intrinsics.checkNotNull((Object)declarationDescriptor);
        return object;
    }

    private final <D extends DeclarationDescriptor> Collection<D> substitute(Collection<? extends D> object) {
        if (this.capturingSubstitutor.isEmpty()) {
            return object;
        }
        if (object.isEmpty()) {
            return object;
        }
        LinkedHashSet<DeclarationDescriptor> linkedHashSet = CollectionsKt.newLinkedHashSetWithExpectedSize(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)object.next();
            declarationDescriptor = this.substitute(declarationDescriptor);
            linkedHashSet.add(declarationDescriptor);
        }
        return linkedHashSet;
    }

    @Override
    public final Collection<? extends PropertyDescriptor> getContributedVariables(Name name, LookupLocation lookupLocation) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        Intrinsics.checkNotNullParameter((Object)lookupLocation, (String)"");
        SubstitutingScope substitutingScope = this;
        return substitutingScope.substitute(substitutingScope.workerScope.getContributedVariables(name, lookupLocation));
    }

    @Override
    public final ClassifierDescriptor getContributedClassifier(Name object, LookupLocation lookupLocation) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)lookupLocation, (String)"");
        ClassifierDescriptor classifierDescriptor = this.workerScope.getContributedClassifier((Name)object, lookupLocation);
        if (classifierDescriptor != null) {
            object = classifierDescriptor;
            return (ClassifierDescriptor)this.substitute((DeclarationDescriptor)object);
        }
        return null;
    }

    @Override
    public final Collection<? extends SimpleFunctionDescriptor> getContributedFunctions(Name name, LookupLocation lookupLocation) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        Intrinsics.checkNotNullParameter((Object)lookupLocation, (String)"");
        SubstitutingScope substitutingScope = this;
        return substitutingScope.substitute(substitutingScope.workerScope.getContributedFunctions(name, lookupLocation));
    }

    @Override
    public final Collection<DeclarationDescriptor> getContributedDescriptors(DescriptorKindFilter descriptorKindFilter, Function1<? super Name, Boolean> function1) {
        Intrinsics.checkNotNullParameter((Object)descriptorKindFilter, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        return this.get_allDescriptors();
    }

    @Override
    public final Set<Name> getFunctionNames() {
        return this.workerScope.getFunctionNames();
    }

    @Override
    public final Set<Name> getVariableNames() {
        return this.workerScope.getVariableNames();
    }

    @Override
    public final Set<Name> getClassifierNames() {
        return this.workerScope.getClassifierNames();
    }

    @Override
    public final void recordLookup(Name name, LookupLocation lookupLocation) {
        MemberScope.DefaultImpls.recordLookup(this, name, lookupLocation);
    }

    private static final TypeSubstitutor substitutor_delegate$lambda$0(TypeSubstitutor typeSubstitutor2) {
        return typeSubstitutor2.getSubstitution().buildSubstitutor();
    }

    private static final Collection _allDescriptors_delegate$lambda$1(SubstitutingScope substitutingScope) {
        SubstitutingScope substitutingScope2 = substitutingScope;
        return substitutingScope2.substitute(ResolutionScope.DefaultImpls.getContributedDescriptors$default(substitutingScope2.workerScope, null, null, 3, null));
    }

    static /* synthetic */ TypeSubstitutor accessor$SubstitutingScope$lambda0(TypeSubstitutor typeSubstitutor2) {
        return SubstitutingScope.substitutor_delegate$lambda$0(typeSubstitutor2);
    }

    static /* synthetic */ Collection accessor$SubstitutingScope$lambda1(SubstitutingScope substitutingScope) {
        return SubstitutingScope._allDescriptors_delegate$lambda$1(substitutingScope);
    }
}

