/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.util.CharsetUtil;
import io.netty.util.internal.ThrowableUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.Provider;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;

final class BouncyCastlePemReader {
    private static final String BC_PROVIDER = "org.bouncycastle.jce.provider.BouncyCastleProvider";
    private static final String BC_FIPS_PROVIDER = "org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider";
    private static final String BC_PEMPARSER = "org.bouncycastle.openssl.PEMParser";
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(BouncyCastlePemReader.class);
    private static volatile Throwable unavailabilityCause;
    private static volatile Provider bcProvider;
    private static volatile boolean attemptedLoading;

    public static boolean hasAttemptedLoading() {
        return attemptedLoading;
    }

    public static boolean isAvailable() {
        if (!BouncyCastlePemReader.hasAttemptedLoading()) {
            BouncyCastlePemReader.tryLoading();
        }
        return unavailabilityCause == null;
    }

    public static Throwable unavailabilityCause() {
        return unavailabilityCause;
    }

    private static void tryLoading() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public final Void run() {
                try {
                    Class<?> clazz;
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    try {
                        clazz = Class.forName(BouncyCastlePemReader.BC_PROVIDER, true, classLoader);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        try {
                            clazz = Class.forName(BouncyCastlePemReader.BC_FIPS_PROVIDER, true, classLoader);
                        }
                        catch (ClassNotFoundException classNotFoundException2) {
                            ThrowableUtil.addSuppressed((Throwable)classNotFoundException, (Throwable)classNotFoundException2);
                            throw classNotFoundException;
                        }
                    }
                    Class.forName(BouncyCastlePemReader.BC_PEMPARSER, true, classLoader);
                    bcProvider = (Provider)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    logger.debug("Bouncy Castle provider available");
                    attemptedLoading = true;
                }
                catch (Throwable throwable) {
                    logger.debug("Cannot load Bouncy Castle provider", throwable);
                    unavailabilityCause = throwable;
                    attemptedLoading = true;
                }
                return null;
            }
        });
    }

    public static PrivateKey getPrivateKey(InputStream inputStream, String string) {
        if (!BouncyCastlePemReader.isAvailable()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Bouncy castle provider is unavailable.", BouncyCastlePemReader.unavailabilityCause());
            }
            return null;
        }
        try {
            inputStream = BouncyCastlePemReader.newParser(inputStream);
            return BouncyCastlePemReader.getPrivateKey((PEMParser)inputStream, string);
        }
        catch (Exception exception) {
            logger.debug("Unable to extract private key", (Throwable)exception);
            return null;
        }
    }

    public static PrivateKey getPrivateKey(File file, String string) {
        if (!BouncyCastlePemReader.isAvailable()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Bouncy castle provider is unavailable.", BouncyCastlePemReader.unavailabilityCause());
            }
            return null;
        }
        try {
            file = BouncyCastlePemReader.newParser(file);
            return BouncyCastlePemReader.getPrivateKey((PEMParser)file, string);
        }
        catch (Exception exception) {
            logger.debug("Unable to extract private key", (Throwable)exception);
            return null;
        }
    }

    private static JcaPEMKeyConverter newConverter() {
        return new JcaPEMKeyConverter().setProvider(bcProvider);
    }

    private static PrivateKey getPrivateKey(PEMParser pEMParser, String string) {
        try {
            JcaPEMKeyConverter jcaPEMKeyConverter = BouncyCastlePemReader.newConverter();
            PrivateKey privateKey = null;
            Object object = pEMParser.readObject();
            while (object != null && privateKey == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Parsed PEM object of type {} and assume key is {}encrypted", (Object)object.getClass().getName(), (Object)(string == null ? "not " : ""));
                }
                if (string == null) {
                    if (object instanceof PrivateKeyInfo) {
                        privateKey = jcaPEMKeyConverter.getPrivateKey((PrivateKeyInfo)object);
                    } else if (object instanceof PEMKeyPair) {
                        privateKey = jcaPEMKeyConverter.getKeyPair((PEMKeyPair)object).getPrivate();
                    } else {
                        logger.debug("Unable to handle PEM object of type {} as a non encrypted key", object.getClass());
                    }
                } else if (object instanceof PEMEncryptedKeyPair) {
                    privateKey = new JcePEMDecryptorProviderBuilder().setProvider(bcProvider).build(string.toCharArray());
                    privateKey = jcaPEMKeyConverter.getKeyPair(((PEMEncryptedKeyPair)object).decryptKeyPair((PEMDecryptorProvider)privateKey)).getPrivate();
                } else if (object instanceof PKCS8EncryptedPrivateKeyInfo) {
                    privateKey = new JceOpenSSLPKCS8DecryptorProviderBuilder().setProvider(bcProvider).build(string.toCharArray());
                    privateKey = jcaPEMKeyConverter.getPrivateKey(((PKCS8EncryptedPrivateKeyInfo)object).decryptPrivateKeyInfo((InputDecryptorProvider)privateKey));
                } else {
                    logger.debug("Unable to handle PEM object of type {} as a encrypted key", object.getClass());
                }
                if (privateKey != null) continue;
                object = pEMParser.readObject();
            }
            if (privateKey == null && logger.isDebugEnabled()) {
                logger.debug("No key found");
            }
            return privateKey;
        }
        finally {
            if (pEMParser != null) {
                try {
                    pEMParser.close();
                }
                catch (Exception exception) {
                    logger.debug("Failed closing pem parser", (Throwable)exception);
                }
            }
        }
    }

    private static PEMParser newParser(File file) {
        return new PEMParser((Reader)new FileReader(file));
    }

    private static PEMParser newParser(InputStream inputStream) {
        return new PEMParser((Reader)new InputStreamReader(inputStream, CharsetUtil.US_ASCII));
    }

    private BouncyCastlePemReader() {
    }
}

