/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.handler.ssl.DefaultOpenSslKeyMaterial;
import io.netty.handler.ssl.OpenSslKeyMaterial;
import io.netty.handler.ssl.OpenSslPrivateKey;
import io.netty.handler.ssl.PemEncoded;
import io.netty.handler.ssl.PemX509Certificate;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.netty.internal.tcnative.SSL;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLException;
import javax.net.ssl.X509KeyManager;

class OpenSslKeyMaterialProvider {
    private final X509KeyManager keyManager;
    private final String password;

    OpenSslKeyMaterialProvider(X509KeyManager x509KeyManager, String string) {
        this.keyManager = x509KeyManager;
        this.password = string;
    }

    static void validateKeyMaterialSupported(X509Certificate[] x509CertificateArray, PrivateKey privateKey, String string) {
        OpenSslKeyMaterialProvider.validateSupported(x509CertificateArray);
        OpenSslKeyMaterialProvider.validateSupported(privateKey, string);
    }

    private static void validateSupported(PrivateKey privateKey, String string) {
        long l;
        if (privateKey == null) {
            return;
        }
        long l2 = 0L;
        try {
            l2 = ReferenceCountedOpenSslContext.toBIO((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, privateKey);
            l = SSL.parsePrivateKey((long)l2, (String)string);
        }
        catch (Exception exception) {
            try {
                throw new SSLException("PrivateKey type not supported " + privateKey.getFormat(), exception);
            }
            catch (Throwable throwable) {
                SSL.freeBIO((long)l2);
                if (0L != 0L) {
                    SSL.freePrivateKey((long)0L);
                }
                throw throwable;
            }
        }
        SSL.freeBIO((long)l2);
        if (l != 0L) {
            SSL.freePrivateKey((long)l);
            return;
        }
    }

    private static void validateSupported(X509Certificate[] x509CertificateArray) {
        long l;
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            return;
        }
        long l2 = 0L;
        PemEncoded pemEncoded = null;
        try {
            pemEncoded = PemX509Certificate.toPEM((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, true, x509CertificateArray);
            l2 = ReferenceCountedOpenSslContext.toBIO((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, pemEncoded.retain());
            l = SSL.parseX509Chain((long)l2);
        }
        catch (Exception exception) {
            try {
                throw new SSLException("Certificate type not supported", exception);
            }
            catch (Throwable throwable) {
                SSL.freeBIO((long)l2);
                if (0L != 0L) {
                    SSL.freeX509Chain((long)0L);
                }
                if (pemEncoded != null) {
                    pemEncoded.release();
                }
                throw throwable;
            }
        }
        SSL.freeBIO((long)l2);
        if (l != 0L) {
            SSL.freeX509Chain((long)l);
        }
        if (pemEncoded != null) {
            pemEncoded.release();
            return;
        }
    }

    X509KeyManager keyManager() {
        return this.keyManager;
    }

    OpenSslKeyMaterial chooseKeyMaterial(ByteBufAllocator object, String object2) {
        X509Certificate[] x509CertificateArray = this.keyManager.getCertificateChain((String)object2);
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            return null;
        }
        object2 = this.keyManager.getPrivateKey((String)object2);
        PemEncoded pemEncoded = PemX509Certificate.toPEM(object, true, x509CertificateArray);
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        try {
            l = ReferenceCountedOpenSslContext.toBIO(object, pemEncoded.retain());
            l3 = SSL.parseX509Chain((long)l);
            if (object2 instanceof OpenSslPrivateKey) {
                object = ((OpenSslPrivateKey)object2).newKeyMaterial(l3, x509CertificateArray);
            } else {
                l2 = ReferenceCountedOpenSslContext.toBIO(object, (PrivateKey)object2);
                l4 = object2 == null ? 0L : SSL.parsePrivateKey((long)l2, (String)this.password);
                object = new DefaultOpenSslKeyMaterial(l3, l4, x509CertificateArray);
            }
            l3 = 0L;
            l4 = 0L;
        }
        catch (Throwable throwable) {
            SSL.freeBIO((long)l);
            SSL.freeBIO((long)l2);
            if (l3 != 0L) {
                SSL.freeX509Chain((long)l3);
            }
            if (l4 != 0L) {
                SSL.freePrivateKey((long)l4);
            }
            pemEncoded.release();
            throw throwable;
        }
        SSL.freeBIO((long)l);
        SSL.freeBIO((long)l2);
        if (0L != 0L) {
            SSL.freeX509Chain((long)0L);
        }
        if (0L != 0L) {
            SSL.freePrivateKey((long)0L);
        }
        pemEncoded.release();
        return object;
    }

    void destroy() {
    }
}

