/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelOutboundInvoker;
import io.netty.channel.ChannelPromise;
import io.netty.channel.unix.UnixChannel;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.UnsupportedMessageTypeException;
import io.netty.handler.ssl.ApplicationProtocolAccessor;
import io.netty.handler.ssl.AsyncRunnable;
import io.netty.handler.ssl.ConscryptAlpnSslEngine;
import io.netty.handler.ssl.NotSslRecordException;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.netty.handler.ssl.ResumptionController;
import io.netty.handler.ssl.SslCloseCompletionEvent;
import io.netty.handler.ssl.SslHandlerCoalescingBufferQueue;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.ssl.SslHandshakeTimeoutException;
import io.netty.handler.ssl.SslUtils;
import io.netty.handler.ssl.StacklessSSLHandshakeException;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseNotifier;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.ThrowableUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;

public class SslHandler
extends ByteToMessageDecoder
implements ChannelOutboundHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SslHandler.class);
    private static final Pattern IGNORABLE_CLASS_IN_STACK = Pattern.compile("^.*(?:Socket|Datagram|Sctp|Udt)Channel.*$");
    private static final Pattern IGNORABLE_ERROR_MESSAGE = Pattern.compile("^.*(?:connection.*(?:reset|closed|abort|broken)|broken.*pipe).*$", 2);
    private static final int STATE_SENT_FIRST_MESSAGE = 1;
    private static final int STATE_FLUSHED_BEFORE_HANDSHAKE = 2;
    private static final int STATE_READ_DURING_HANDSHAKE = 4;
    private static final int STATE_HANDSHAKE_STARTED = 8;
    private static final int STATE_NEEDS_FLUSH = 16;
    private static final int STATE_OUTBOUND_CLOSED = 32;
    private static final int STATE_CLOSE_NOTIFY = 64;
    private static final int STATE_PROCESS_TASK = 128;
    private static final int STATE_FIRE_CHANNEL_READ = 256;
    private static final int STATE_UNWRAP_REENTRY = 512;
    private static final int MAX_PLAINTEXT_LENGTH = 16384;
    private volatile ChannelHandlerContext ctx;
    private final SSLEngine engine;
    private final SslEngineType engineType;
    private final Executor delegatedTaskExecutor;
    private final boolean jdkCompatibilityMode;
    private final ByteBuffer[] singleBuffer = new ByteBuffer[1];
    private final boolean startTls;
    private final ResumptionController resumptionController;
    private final SslTasksRunner sslTaskRunnerForUnwrap = new SslTasksRunner(true);
    private final SslTasksRunner sslTaskRunner = new SslTasksRunner(false);
    private SslHandlerCoalescingBufferQueue pendingUnencryptedWrites;
    private Promise<Channel> handshakePromise = new LazyChannelPromise();
    private final LazyChannelPromise sslClosePromise = new LazyChannelPromise();
    private int packetLength;
    private short state;
    private volatile long handshakeTimeoutMillis = 10000L;
    private volatile long closeNotifyFlushTimeoutMillis = 3000L;
    private volatile long closeNotifyReadTimeoutMillis;
    volatile int wrapDataSize = 16384;

    public SslHandler(SSLEngine sSLEngine) {
        this(sSLEngine, false);
    }

    public SslHandler(SSLEngine sSLEngine, boolean bl) {
        this(sSLEngine, bl, (Executor)ImmediateExecutor.INSTANCE);
    }

    public SslHandler(SSLEngine sSLEngine, Executor executor) {
        this(sSLEngine, false, executor);
    }

    public SslHandler(SSLEngine sSLEngine, boolean bl, Executor executor) {
        this(sSLEngine, bl, executor, null);
    }

    SslHandler(SSLEngine sSLEngine, boolean bl, Executor executor, ResumptionController resumptionController) {
        this.engine = (SSLEngine)ObjectUtil.checkNotNull((Object)sSLEngine, (String)"engine");
        this.delegatedTaskExecutor = (Executor)ObjectUtil.checkNotNull((Object)executor, (String)"delegatedTaskExecutor");
        this.engineType = SslEngineType.forEngine(sSLEngine);
        this.startTls = bl;
        this.jdkCompatibilityMode = this.engineType.jdkCompatibilityMode(sSLEngine);
        SslHandler sslHandler = this;
        sslHandler.setCumulator(sslHandler.engineType.cumulator);
        this.resumptionController = resumptionController;
    }

    public long getHandshakeTimeoutMillis() {
        return this.handshakeTimeoutMillis;
    }

    public void setHandshakeTimeout(long l, TimeUnit timeUnit) {
        ObjectUtil.checkNotNull((Object)((Object)timeUnit), (String)"unit");
        this.setHandshakeTimeoutMillis(timeUnit.toMillis(l));
    }

    public void setHandshakeTimeoutMillis(long l) {
        this.handshakeTimeoutMillis = ObjectUtil.checkPositiveOrZero((long)l, (String)"handshakeTimeoutMillis");
    }

    public final void setWrapDataSize(int n) {
        this.wrapDataSize = n;
    }

    @Deprecated
    public long getCloseNotifyTimeoutMillis() {
        return this.getCloseNotifyFlushTimeoutMillis();
    }

    @Deprecated
    public void setCloseNotifyTimeout(long l, TimeUnit timeUnit) {
        this.setCloseNotifyFlushTimeout(l, timeUnit);
    }

    @Deprecated
    public void setCloseNotifyTimeoutMillis(long l) {
        this.setCloseNotifyFlushTimeoutMillis(l);
    }

    public final long getCloseNotifyFlushTimeoutMillis() {
        return this.closeNotifyFlushTimeoutMillis;
    }

    public final void setCloseNotifyFlushTimeout(long l, TimeUnit timeUnit) {
        this.setCloseNotifyFlushTimeoutMillis(timeUnit.toMillis(l));
    }

    public final void setCloseNotifyFlushTimeoutMillis(long l) {
        this.closeNotifyFlushTimeoutMillis = ObjectUtil.checkPositiveOrZero((long)l, (String)"closeNotifyFlushTimeoutMillis");
    }

    public final long getCloseNotifyReadTimeoutMillis() {
        return this.closeNotifyReadTimeoutMillis;
    }

    public final void setCloseNotifyReadTimeout(long l, TimeUnit timeUnit) {
        this.setCloseNotifyReadTimeoutMillis(timeUnit.toMillis(l));
    }

    public final void setCloseNotifyReadTimeoutMillis(long l) {
        this.closeNotifyReadTimeoutMillis = ObjectUtil.checkPositiveOrZero((long)l, (String)"closeNotifyReadTimeoutMillis");
    }

    public SSLEngine engine() {
        return this.engine;
    }

    public String applicationProtocol() {
        SSLEngine sSLEngine = this.engine();
        if (!(sSLEngine instanceof ApplicationProtocolAccessor)) {
            return null;
        }
        return ((ApplicationProtocolAccessor)((Object)sSLEngine)).getNegotiatedApplicationProtocol();
    }

    public Future<Channel> handshakeFuture() {
        return this.handshakePromise;
    }

    @Deprecated
    public ChannelFuture close() {
        return this.closeOutbound();
    }

    @Deprecated
    public ChannelFuture close(ChannelPromise channelPromise) {
        return this.closeOutbound(channelPromise);
    }

    public ChannelFuture closeOutbound() {
        SslHandler sslHandler = this;
        return sslHandler.closeOutbound(sslHandler.ctx.newPromise());
    }

    public ChannelFuture closeOutbound(final ChannelPromise channelPromise) {
        ChannelHandlerContext channelHandlerContext = this.ctx;
        if (channelHandlerContext.executor().inEventLoop()) {
            this.closeOutbound0(channelPromise);
        } else {
            channelHandlerContext.executor().execute(new Runnable(){

                @Override
                public void run() {
                    SslHandler.this.closeOutbound0(channelPromise);
                }
            });
        }
        return channelPromise;
    }

    private void closeOutbound0(ChannelPromise channelPromise) {
        this.setState(32);
        this.engine.closeOutbound();
        try {
            SslHandler sslHandler = this;
            sslHandler.flush(sslHandler.ctx, channelPromise);
            return;
        }
        catch (Exception exception) {
            if (!channelPromise.tryFailure((Throwable)exception)) {
                logger.warn("{} flush() raised a masked exception.", (Object)this.ctx.channel(), (Object)exception);
            }
            return;
        }
    }

    public Future<Channel> sslCloseFuture() {
        return this.sslClosePromise;
    }

    public void handlerRemoved0(ChannelHandlerContext channelHandlerContext) {
        try {
            if (this.pendingUnencryptedWrites != null && !this.pendingUnencryptedWrites.isEmpty()) {
                this.pendingUnencryptedWrites.releaseAndFailAll((ChannelOutboundInvoker)channelHandlerContext, (Throwable)new ChannelException("Pending write on removal of SslHandler"));
            }
            this.pendingUnencryptedWrites = null;
            SSLException sSLException = null;
            if (!this.handshakePromise.isDone() && this.handshakePromise.tryFailure((Throwable)(sSLException = new SSLHandshakeException("SslHandler removed before handshake completed")))) {
                channelHandlerContext.fireUserEventTriggered((Object)new SslHandshakeCompletionEvent(sSLException));
            }
            if (!this.sslClosePromise.isDone()) {
                if (sSLException == null) {
                    sSLException = new SSLException("SslHandler removed before SSLEngine was closed");
                }
                this.notifyClosePromise(sSLException);
            }
            return;
        }
        finally {
            ReferenceCountUtil.release((Object)this.engine);
        }
    }

    public void bind(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, ChannelPromise channelPromise) {
        channelHandlerContext.bind(socketAddress, channelPromise);
    }

    public void connect(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        channelHandlerContext.connect(socketAddress, socketAddress2, channelPromise);
    }

    public void deregister(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        channelHandlerContext.deregister(channelPromise);
    }

    public void disconnect(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        this.closeOutboundAndChannel(channelHandlerContext, channelPromise, true);
    }

    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        this.closeOutboundAndChannel(channelHandlerContext, channelPromise, false);
    }

    public void read(ChannelHandlerContext channelHandlerContext) {
        if (!this.handshakePromise.isDone()) {
            this.setState(4);
        }
        channelHandlerContext.read();
    }

    private static IllegalStateException newPendingWritesNullException() {
        return new IllegalStateException("pendingUnencryptedWrites is null, handlerRemoved0 called?");
    }

    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        if (!(object instanceof ByteBuf)) {
            channelHandlerContext = new UnsupportedMessageTypeException(object, new Class[]{ByteBuf.class});
            ReferenceCountUtil.safeRelease((Object)object);
            channelPromise.setFailure((Throwable)channelHandlerContext);
            return;
        }
        if (this.pendingUnencryptedWrites == null) {
            ReferenceCountUtil.safeRelease((Object)object);
            channelPromise.setFailure((Throwable)SslHandler.newPendingWritesNullException());
            return;
        }
        this.pendingUnencryptedWrites.add((ByteBuf)object, channelPromise);
    }

    public void flush(ChannelHandlerContext channelHandlerContext) {
        if (this.startTls && !this.isStateSet(1)) {
            this.setState(1);
            this.pendingUnencryptedWrites.writeAndRemoveAll(channelHandlerContext);
            this.forceFlush(channelHandlerContext);
            this.startHandshakeProcessing(true);
            return;
        }
        if (this.isStateSet(128)) {
            return;
        }
        try {
            this.wrapAndFlush(channelHandlerContext);
            return;
        }
        catch (Throwable throwable) {
            this.setHandshakeFailure(channelHandlerContext, throwable);
            PlatformDependent.throwException((Throwable)throwable);
            return;
        }
    }

    private void wrapAndFlush(ChannelHandlerContext channelHandlerContext) {
        if (this.pendingUnencryptedWrites.isEmpty()) {
            this.pendingUnencryptedWrites.add(Unpooled.EMPTY_BUFFER, channelHandlerContext.newPromise());
        }
        if (!this.handshakePromise.isDone()) {
            this.setState(2);
        }
        try {
            this.wrap(channelHandlerContext, false);
            return;
        }
        finally {
            this.forceFlush(channelHandlerContext);
        }
    }

    /*
     * Exception decompiling
     */
    private void wrap(ChannelHandlerContext var1_1, boolean var2_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 8[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean wrapNonAppData(final ChannelHandlerContext channelHandlerContext, boolean bl) {
        block22: {
            ByteBuf byteBuf = null;
            ByteBufAllocator byteBufAllocator = channelHandlerContext.alloc();
            try {
                while (!channelHandlerContext.isRemoved()) {
                    SSLEngineResult sSLEngineResult;
                    if (byteBuf == null) {
                        byteBuf = this.allocateOutNetBuf(channelHandlerContext, 2048, 1);
                    }
                    if ((sSLEngineResult = this.wrap(byteBufAllocator, this.engine, Unpooled.EMPTY_BUFFER, byteBuf)).bytesProduced() > 0) {
                        channelHandlerContext.write((Object)byteBuf).addListener((GenericFutureListener)new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture object) {
                                if ((object = object.cause()) != null) {
                                    SslHandler.this.setHandshakeFailureTransportFailure(channelHandlerContext, (Throwable)object);
                                }
                            }
                        });
                        if (bl) {
                            this.setState(16);
                        }
                        byteBuf = null;
                    }
                    SSLEngineResult.HandshakeStatus handshakeStatus = sSLEngineResult.getHandshakeStatus();
                    switch (handshakeStatus) {
                        case FINISHED: {
                            if (this.setHandshakeSuccess() && bl && !this.pendingUnencryptedWrites.isEmpty()) {
                                this.wrap(channelHandlerContext, true);
                            }
                            return false;
                        }
                        case NEED_TASK: {
                            if (this.runDelegatedTasks(bl)) break;
                            break block22;
                        }
                        case NEED_UNWRAP: {
                            if (!bl && this.unwrapNonAppData(channelHandlerContext) > 0) break;
                            return false;
                        }
                        case NEED_WRAP: {
                            break;
                        }
                        case NOT_HANDSHAKING: {
                            if (this.setHandshakeSuccess() && bl && !this.pendingUnencryptedWrites.isEmpty()) {
                                this.wrap(channelHandlerContext, true);
                            }
                            if (!bl) {
                                this.unwrapNonAppData(channelHandlerContext);
                            }
                            return true;
                        }
                        default: {
                            throw new IllegalStateException("Unknown handshake status: " + (Object)((Object)sSLEngineResult.getHandshakeStatus()));
                        }
                    }
                    if (!(sSLEngineResult.bytesProduced() == 0 && handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_TASK || sSLEngineResult.bytesConsumed() == 0 && sSLEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING)) {
                        continue;
                    }
                    break;
                }
            }
            finally {
                if (byteBuf != null) {
                    byteBuf.release();
                }
            }
        }
        return false;
    }

    private SSLEngineResult wrapMultiple(ByteBufAllocator byteBufAllocator, SSLEngine sSLEngine, ByteBuf byteBuf, ByteBuf byteBuf2) {
        SSLEngineResult sSLEngineResult = null;
        do {
            ByteBuf byteBuf3;
            int n;
            int n2;
            if (!byteBuf2.isWritable(n2 = this.engineType.calculateRequiredOutBufSpace(this, n = Math.min(16384, byteBuf.readableBytes()), byteBuf.nioBufferCount()))) {
                if (sSLEngineResult != null) break;
                byteBuf2.ensureWritable(n2);
            }
            if ((sSLEngineResult = this.wrap(byteBufAllocator, sSLEngine, byteBuf3 = byteBuf.readSlice(n), byteBuf2)).getStatus() == SSLEngineResult.Status.CLOSED) break;
            if (!byteBuf3.isReadable()) continue;
            ByteBuf byteBuf4 = byteBuf;
            byteBuf4.readerIndex(byteBuf4.readerIndex() - byteBuf3.readableBytes());
        } while (byteBuf.readableBytes() > 0);
        return sSLEngineResult;
    }

    private SSLEngineResult wrap(ByteBufAllocator object, SSLEngine sSLEngine, ByteBuf byteBuf, ByteBuf byteBuf2) {
        ByteBuf byteBuf3 = null;
        try {
            Object object2;
            int n = byteBuf.readerIndex();
            int n2 = byteBuf.readableBytes();
            if (byteBuf.isDirect() || !this.engineType.wantsDirectBuffer) {
                if (!(byteBuf instanceof CompositeByteBuf) && byteBuf.nioBufferCount() == 1) {
                    object = this.singleBuffer;
                    this.singleBuffer[0] = byteBuf.internalNioBuffer(n, n2);
                } else {
                    object = byteBuf.nioBuffers();
                }
            } else {
                byteBuf3 = object.directBuffer(n2);
                byteBuf3.writeBytes(byteBuf, n, n2);
                object = this.singleBuffer;
                ByteBuf byteBuf4 = byteBuf3;
                this.singleBuffer[0] = byteBuf4.internalNioBuffer(byteBuf4.readerIndex(), n2);
            }
            while (true) {
                ByteBuf byteBuf5 = byteBuf2;
                object2 = SslHandler.toByteBuffer(byteBuf5, byteBuf5.writerIndex(), byteBuf2.writableBytes());
                object2 = sSLEngine.wrap((ByteBuffer[])object, (ByteBuffer)object2);
                byteBuf.skipBytes(((SSLEngineResult)object2).bytesConsumed());
                ByteBuf byteBuf6 = byteBuf2;
                byteBuf6.writerIndex(byteBuf6.writerIndex() + ((SSLEngineResult)object2).bytesProduced());
                if (((SSLEngineResult)object2).getStatus() != SSLEngineResult.Status.BUFFER_OVERFLOW) break;
                byteBuf2.ensureWritable(sSLEngine.getSession().getPacketBufferSize());
            }
            object = object2;
            return object;
        }
        finally {
            this.singleBuffer[0] = null;
            if (byteBuf3 != null) {
                byteBuf3.release();
            }
        }
    }

    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        boolean bl = this.handshakePromise.cause() != null;
        ClosedChannelException closedChannelException = new ClosedChannelException();
        if (this.isStateSet(8) && !this.handshakePromise.isDone()) {
            ThrowableUtil.addSuppressed((Throwable)closedChannelException, (Throwable)StacklessSSLHandshakeException.newInstance("Connection closed while SSL/TLS handshake was in progress", SslHandler.class, "channelInactive"));
        }
        this.setHandshakeFailure(channelHandlerContext, closedChannelException, !this.isStateSet(32), this.isStateSet(8), false);
        this.notifyClosePromise(closedChannelException);
        try {
            super.channelInactive(channelHandlerContext);
            return;
        }
        catch (DecoderException decoderException) {
            if (!bl || !(decoderException.getCause() instanceof SSLException)) {
                throw decoderException;
            }
            return;
        }
    }

    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        if (this.ignoreException(throwable)) {
            if (logger.isDebugEnabled()) {
                logger.debug("{} Swallowing a harmless 'connection reset by peer / broken pipe' error that occurred while writing close_notify in response to the peer's close_notify", (Object)channelHandlerContext.channel(), (Object)throwable);
            }
            if (channelHandlerContext.channel().isActive()) {
                channelHandlerContext.close();
                return;
            }
        } else {
            channelHandlerContext.fireExceptionCaught(throwable);
        }
    }

    private boolean ignoreException(Throwable stackTraceElementArray) {
        if (!(stackTraceElementArray instanceof SSLException) && stackTraceElementArray instanceof IOException && this.sslClosePromise.isDone()) {
            String string = stackTraceElementArray.getMessage();
            if (string != null && IGNORABLE_ERROR_MESSAGE.matcher(string).matches()) {
                return true;
            }
            StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray.getStackTrace();
            stackTraceElementArray = stackTraceElementArray2;
            stackTraceElementArray = stackTraceElementArray2;
            int n = stackTraceElementArray2.length;
            for (int i = 0; i < n; ++i) {
                Class<?> clazz = stackTraceElementArray[i];
                String string2 = ((StackTraceElement)((Object)clazz)).getClassName();
                clazz = ((StackTraceElement)((Object)clazz)).getMethodName();
                if (string2.startsWith("io.netty.") || !"read".equals(clazz)) continue;
                if (IGNORABLE_CLASS_IN_STACK.matcher(string2).matches()) {
                    return true;
                }
                try {
                    clazz = PlatformDependent.getClassLoader(((Object)((Object)this)).getClass()).loadClass(string2);
                    if (SocketChannel.class.isAssignableFrom(clazz) || DatagramChannel.class.isAssignableFrom(clazz)) {
                        return true;
                    }
                    if (PlatformDependent.javaVersion() >= 7 && "com.sun.nio.sctp.SctpChannel".equals(clazz.getSuperclass().getName())) {
                        return true;
                    }
                    continue;
                }
                catch (Throwable throwable) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Unexpected exception while loading class {} classname {}", new Object[]{((Object)((Object)this)).getClass(), string2, throwable});
                }
            }
        }
        return false;
    }

    @Deprecated
    public static boolean isEncrypted(ByteBuf byteBuf) {
        return SslHandler.isEncrypted(byteBuf, false);
    }

    public static boolean isEncrypted(ByteBuf byteBuf, boolean bl) {
        if (byteBuf.readableBytes() < 5) {
            throw new IllegalArgumentException("buffer must have at least 5 readable bytes");
        }
        ByteBuf byteBuf2 = byteBuf;
        return SslUtils.getEncryptedPacketLength(byteBuf2, byteBuf2.readerIndex(), bl) != -2;
    }

    private void decodeJdkCompatible(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        int n;
        int n2 = this.packetLength;
        if (n2 > 0) {
            if (byteBuf.readableBytes() < n2) {
                return;
            }
        } else {
            n = byteBuf.readableBytes();
            if (n < 5) {
                return;
            }
            ByteBuf byteBuf2 = byteBuf;
            n2 = SslUtils.getEncryptedPacketLength(byteBuf2, byteBuf2.readerIndex(), true);
            if (n2 == -2) {
                NotSslRecordException notSslRecordException = new NotSslRecordException("not an SSL/TLS record: " + ByteBufUtil.hexDump((ByteBuf)byteBuf));
                ByteBuf byteBuf3 = byteBuf;
                byteBuf3.skipBytes(byteBuf3.readableBytes());
                this.setHandshakeFailure(channelHandlerContext, notSslRecordException);
                throw notSslRecordException;
            }
            if (n2 == -1) {
                return;
            }
            assert (n2 > 0);
            if (n2 > n) {
                this.packetLength = n2;
                return;
            }
        }
        this.packetLength = 0;
        try {
            n = this.unwrap(channelHandlerContext, byteBuf, n2);
            assert (n == n2 || this.engine.isInboundDone()) : "we feed the SSLEngine a packets worth of data: " + n2 + " but it only consumed: " + n;
            return;
        }
        catch (Throwable throwable) {
            this.handleUnwrapThrowable(channelHandlerContext, throwable);
            return;
        }
    }

    private void decodeNonJdkCompatible(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        try {
            ByteBuf byteBuf2 = byteBuf;
            this.unwrap(channelHandlerContext, byteBuf2, byteBuf2.readableBytes());
            return;
        }
        catch (Throwable throwable) {
            this.handleUnwrapThrowable(channelHandlerContext, throwable);
            return;
        }
    }

    private void handleUnwrapThrowable(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        try {
            if (this.handshakePromise.tryFailure(throwable)) {
                channelHandlerContext.fireUserEventTriggered((Object)new SslHandshakeCompletionEvent(throwable));
            }
            if (this.pendingUnencryptedWrites != null) {
                this.wrapAndFlush(channelHandlerContext);
            }
        }
        catch (SSLException sSLException) {
            logger.debug("SSLException during trying to call SSLEngine.wrap(...) because of an previous SSLException, ignoring...", (Throwable)sSLException);
        }
        finally {
            this.setHandshakeFailure(channelHandlerContext, throwable, true, false, true);
        }
        PlatformDependent.throwException((Throwable)throwable);
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        if (this.isStateSet(128)) {
            return;
        }
        if (this.jdkCompatibilityMode) {
            this.decodeJdkCompatible(channelHandlerContext, byteBuf);
            return;
        }
        this.decodeNonJdkCompatible(channelHandlerContext, byteBuf);
    }

    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        this.channelReadComplete0(channelHandlerContext);
    }

    private void channelReadComplete0(ChannelHandlerContext channelHandlerContext) {
        this.discardSomeReadBytes();
        this.flushIfNeeded(channelHandlerContext);
        this.readIfNeeded(channelHandlerContext);
        this.clearState(256);
        channelHandlerContext.fireChannelReadComplete();
    }

    private void readIfNeeded(ChannelHandlerContext channelHandlerContext) {
        if (!(channelHandlerContext.channel().config().isAutoRead() || this.isStateSet(256) && this.handshakePromise.isDone())) {
            channelHandlerContext.read();
        }
    }

    private void flushIfNeeded(ChannelHandlerContext channelHandlerContext) {
        if (this.isStateSet(16)) {
            this.forceFlush(channelHandlerContext);
        }
    }

    private int unwrapNonAppData(ChannelHandlerContext channelHandlerContext) {
        return this.unwrap(channelHandlerContext, Unpooled.EMPTY_BUFFER, 0);
    }

    /*
     * Unable to fully structure code
     */
    private int unwrap(ChannelHandlerContext var1_1, ByteBuf var2_2, int var3_4) {
        var4_5 = var3_4;
        var5_6 = false;
        var6_7 = false;
        var7_8 = false;
        var8_9 = this.allocate(var1_1, var3_4);
        try {
            do {
                block24: {
                    var9_11 = this.engineType.unwrap(this, var2_2, var3_4, var8_9);
                    var10_12 = var9_11.getStatus();
                    var11_13 = var9_11.getHandshakeStatus();
                    var12_14 = var9_11.bytesProduced();
                    var9_10 = var9_11.bytesConsumed();
                    var2_2.skipBytes(var9_10);
                    var3_4 -= var9_10;
                    if (var11_13 != SSLEngineResult.HandshakeStatus.FINISHED && var11_13 != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) break block24;
                    if (var8_9.isReadable() == false ? this.setHandshakeSuccess() != false : this.setHandshakeSuccessUnwrapMarkReentry() != false) ** GOTO lbl-1000
                    if (var11_13 == SSLEngineResult.HandshakeStatus.FINISHED || !this.pendingUnencryptedWrites.isEmpty()) lbl-1000:
                    // 2 sources

                    {
                        v0 = true;
                    } else {
                        v0 = false;
                    }
                    var5_6 |= v0;
                }
                if (var8_9.isReadable()) {
                    this.setState(256);
                    if (this.isStateSet(512)) {
                        var7_8 = true;
                        this.executeChannelRead(var1_1, var8_9);
                    } else {
                        var1_1.fireChannelRead((Object)var8_9);
                    }
                    var8_9 = null;
                }
                if (var10_12 == SSLEngineResult.Status.CLOSED) {
                    var6_7 = true;
                } else if (var10_12 == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    if (var8_9 != null) {
                        var8_9.release();
                    }
                    var8_9 = this.allocate(var1_1, this.engineType.calculatePendingData(this, (var13_15 = this.engine.getSession().getApplicationBufferSize()) < var12_14 ? var13_15 : var13_15 - var12_14));
                    continue;
                }
                if (var11_13 == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    v1 = this.runDelegatedTasks(true);
                    var13_15 = (int)v1;
                    if (!v1) {
                        var5_6 = false;
                        break;
                    }
                } else if (var11_13 == SSLEngineResult.HandshakeStatus.NEED_WRAP && this.wrapNonAppData(var1_1, true) && var3_4 == 0) break;
                if (var10_12 == SSLEngineResult.Status.BUFFER_UNDERFLOW || var11_13 != SSLEngineResult.HandshakeStatus.NEED_TASK && (var9_10 == 0 && var12_14 == 0 || var3_4 == 0 && var11_13 == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING)) {
                    if (var11_13 != SSLEngineResult.HandshakeStatus.NEED_UNWRAP) break;
                    this.readIfNeeded(var1_1);
                    break;
                }
                if (var8_9 != null) continue;
                var8_9 = this.allocate(var1_1, var3_4);
            } while (!var1_1.isRemoved());
            if (this.isStateSet(2) && this.handshakePromise.isDone()) {
                this.clearState(2);
                var5_6 = true;
            }
            if (var5_6) {
                this.wrap(var1_1, true);
            }
        }
        finally {
            if (var8_9 != null) {
                var8_9.release();
            }
            if (var6_7) {
                if (var7_8) {
                    this.executeNotifyClosePromise(var1_1);
                } else {
                    this.notifyClosePromise(null);
                }
            }
        }
        return var4_5 - var3_4;
    }

    private boolean setHandshakeSuccessUnwrapMarkReentry() {
        boolean bl = !this.isStateSet(512);
        if (bl) {
            this.setState(512);
        }
        try {
            boolean bl2 = this.setHandshakeSuccess();
            return bl2;
        }
        finally {
            if (bl) {
                this.clearState(512);
            }
        }
    }

    private void executeNotifyClosePromise(ChannelHandlerContext channelHandlerContext) {
        try {
            channelHandlerContext.executor().execute(new Runnable(){

                @Override
                public void run() {
                    SslHandler.this.notifyClosePromise(null);
                }
            });
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            this.notifyClosePromise(rejectedExecutionException);
            return;
        }
    }

    private void executeChannelRead(final ChannelHandlerContext channelHandlerContext, final ByteBuf byteBuf) {
        try {
            channelHandlerContext.executor().execute(new Runnable(){

                @Override
                public void run() {
                    channelHandlerContext.fireChannelRead((Object)byteBuf);
                }
            });
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            byteBuf.release();
            throw rejectedExecutionException;
        }
    }

    private static ByteBuffer toByteBuffer(ByteBuf byteBuf, int n, int n2) {
        if (byteBuf.nioBufferCount() == 1) {
            return byteBuf.internalNioBuffer(n, n2);
        }
        return byteBuf.nioBuffer(n, n2);
    }

    private static boolean inEventLoop(Executor executor) {
        return executor instanceof EventExecutor && ((EventExecutor)executor).inEventLoop();
    }

    /*
     * Unable to fully structure code
     */
    private boolean runDelegatedTasks(boolean var1_1) {
        block9: {
            if (this.delegatedTaskExecutor != ImmediateExecutor.INSTANCE && !SslHandler.inEventLoop(this.delegatedTaskExecutor)) break block9;
            while (true) lbl-1000:
            // 6 sources

            {
                if ((var2_4 = this.engine.getDelegatedTask()) == null) {
                    return true;
                }
                this.setState(128);
                if (var2_4 instanceof AsyncRunnable) {
                    var3_5 = false;
                    try {
                        var2_4 = (AsyncRunnable)var2_4;
                        var4_6 = new AsyncTaskCompletionHandler(var1_1);
                        var2_4.run(var4_6);
                        var3_5 = var4_6.resumeLater();
                        if (!var3_5) ** GOTO lbl-1000
                        return false;
                    }
                    finally {
                        if (var3_5) ** GOTO lbl-1000
                        this.clearState(128);
                    }
                    continue;
                }
                try {
                    var2_4.run();
                }
                finally {
                    this.clearState(128);
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
        }
        this.executeDelegatedTask(var1_1);
        return false;
    }

    private SslTasksRunner getTaskRunner(boolean bl) {
        if (bl) {
            return this.sslTaskRunnerForUnwrap;
        }
        return this.sslTaskRunner;
    }

    private void executeDelegatedTask(boolean bl) {
        SslHandler sslHandler = this;
        sslHandler.executeDelegatedTask(sslHandler.getTaskRunner(bl));
    }

    private void executeDelegatedTask(SslTasksRunner sslTasksRunner) {
        this.setState(128);
        try {
            this.delegatedTaskExecutor.execute(sslTasksRunner);
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            this.clearState(128);
            throw rejectedExecutionException;
        }
    }

    private boolean setHandshakeSuccess() {
        boolean bl;
        Object object = this.engine.getSession();
        if (this.resumptionController != null && !this.handshakePromise.isDone()) {
            try {
                if (this.resumptionController.validateResumeIfNeeded(this.engine) && logger.isDebugEnabled()) {
                    logger.debug("{} Resumed and reauthenticated session", (Object)this.ctx.channel());
                }
            }
            catch (CertificateException certificateException) {
                object = new SSLHandshakeException(certificateException.getMessage());
                ((Throwable)object).initCause(certificateException);
                throw object;
            }
        }
        if (bl = !this.handshakePromise.isDone() && this.handshakePromise.trySuccess((Object)this.ctx.channel())) {
            if (logger.isDebugEnabled()) {
                logger.debug("{} HANDSHAKEN: protocol:{} cipher suite:{}", new Object[]{this.ctx.channel(), object.getProtocol(), object.getCipherSuite()});
            }
            this.ctx.fireUserEventTriggered((Object)SslHandshakeCompletionEvent.SUCCESS);
        }
        if (this.isStateSet(4)) {
            this.clearState(4);
            if (!this.ctx.channel().config().isAutoRead()) {
                this.ctx.read();
            }
        }
        return bl;
    }

    private void setHandshakeFailure(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        this.setHandshakeFailure(channelHandlerContext, throwable, true, true, false);
    }

    private void setHandshakeFailure(ChannelHandlerContext channelHandlerContext, Throwable throwable, boolean bl, boolean bl2, boolean bl3) {
        try {
            block7: {
                this.setState(32);
                this.engine.closeOutbound();
                if (bl) {
                    try {
                        this.engine.closeInbound();
                    }
                    catch (SSLException sSLException) {
                        String string;
                        if (!logger.isDebugEnabled() || (string = sSLException.getMessage()) != null && (string.contains("possible truncation attack") || string.contains("closing inbound before receiving peer's close_notify"))) break block7;
                        logger.debug("{} SSLEngine.closeInbound() raised an exception.", (Object)channelHandlerContext.channel(), (Object)sSLException);
                    }
                }
            }
            if (this.handshakePromise.tryFailure(throwable) || bl3) {
                SslUtils.handleHandshakeFailure(channelHandlerContext, throwable, bl2);
            }
            return;
        }
        finally {
            this.releaseAndFailAll(channelHandlerContext, throwable);
        }
    }

    private void setHandshakeFailureTransportFailure(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        try {
            throwable = new SSLException("failure when writing TLS control frames", throwable);
            this.releaseAndFailAll(channelHandlerContext, throwable);
            if (this.handshakePromise.tryFailure(throwable)) {
                channelHandlerContext.fireUserEventTriggered((Object)new SslHandshakeCompletionEvent(throwable));
            }
            return;
        }
        finally {
            channelHandlerContext.close();
        }
    }

    private void releaseAndFailAll(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        if (this.resumptionController != null && (!this.engine.getSession().isValid() || throwable instanceof SSLHandshakeException)) {
            this.resumptionController.remove(this.engine());
        }
        if (this.pendingUnencryptedWrites != null) {
            this.pendingUnencryptedWrites.releaseAndFailAll((ChannelOutboundInvoker)channelHandlerContext, throwable);
        }
    }

    private void notifyClosePromise(Throwable throwable) {
        if (throwable == null) {
            if (this.sslClosePromise.trySuccess(this.ctx.channel())) {
                this.ctx.fireUserEventTriggered((Object)SslCloseCompletionEvent.SUCCESS);
                return;
            }
        } else if (this.sslClosePromise.tryFailure(throwable)) {
            this.ctx.fireUserEventTriggered((Object)new SslCloseCompletionEvent(throwable));
        }
    }

    private void closeOutboundAndChannel(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise, boolean bl) {
        block6: {
            this.setState(32);
            this.engine.closeOutbound();
            if (!channelHandlerContext.channel().isActive()) {
                if (bl) {
                    channelHandlerContext.disconnect(channelPromise);
                    return;
                }
                channelHandlerContext.close(channelPromise);
                return;
            }
            ChannelPromise channelPromise2 = channelHandlerContext.newPromise();
            try {
                this.flush(channelHandlerContext, channelPromise2);
                if (this.isStateSet(64)) break block6;
                this.setState(64);
                this.safeClose(channelHandlerContext, (ChannelFuture)channelPromise2, (ChannelPromise)PromiseNotifier.cascade((boolean)false, (Future)channelHandlerContext.newPromise(), (Promise)channelPromise));
                return;
            }
            catch (Throwable throwable) {
                if (!this.isStateSet(64)) {
                    this.setState(64);
                    this.safeClose(channelHandlerContext, (ChannelFuture)channelPromise2, (ChannelPromise)PromiseNotifier.cascade((boolean)false, (Future)channelHandlerContext.newPromise(), (Promise)channelPromise));
                } else {
                    this.sslClosePromise.addListener((GenericFutureListener)new FutureListener<Channel>(channelPromise){
                        final /* synthetic */ ChannelPromise val$promise;
                        {
                            this.val$promise = channelPromise;
                        }

                        public void operationComplete(Future<Channel> future) {
                            this.val$promise.setSuccess();
                        }
                    });
                }
                throw throwable;
            }
        }
        this.sslClosePromise.addListener((GenericFutureListener)new /* invalid duplicate definition of identical inner class */);
    }

    private void flush(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        if (this.pendingUnencryptedWrites != null) {
            this.pendingUnencryptedWrites.add(Unpooled.EMPTY_BUFFER, channelPromise);
        } else {
            channelPromise.setFailure((Throwable)SslHandler.newPendingWritesNullException());
        }
        this.flush(channelHandlerContext);
    }

    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
        channelHandlerContext = channelHandlerContext.channel();
        this.pendingUnencryptedWrites = new SslHandlerCoalescingBufferQueue((Channel)channelHandlerContext, 16, this.engineType.wantsDirectBuffer){

            @Override
            protected int wrapDataSize() {
                return SslHandler.this.wrapDataSize;
            }
        };
        this.setOpensslEngineSocketFd((Channel)channelHandlerContext);
        boolean bl = Boolean.TRUE.equals(channelHandlerContext.config().getOption(ChannelOption.TCP_FASTOPEN_CONNECT));
        boolean bl2 = channelHandlerContext.isActive();
        if (bl2 || bl) {
            this.startHandshakeProcessing(bl2);
            if (bl && ((channelHandlerContext = channelHandlerContext.unsafe().outboundBuffer()) == null || channelHandlerContext.totalPendingWriteBytes() > 0L)) {
                this.setState(16);
            }
        }
    }

    private void startHandshakeProcessing(boolean bl) {
        if (!this.isStateSet(8)) {
            this.setState(8);
            if (this.engine.getUseClientMode()) {
                this.handshake(bl);
            }
            this.applyHandshakeTimeout();
            return;
        }
        if (this.isStateSet(16)) {
            SslHandler sslHandler = this;
            sslHandler.forceFlush(sslHandler.ctx);
        }
    }

    public Future<Channel> renegotiate() {
        ChannelHandlerContext channelHandlerContext = this.ctx;
        if (channelHandlerContext == null) {
            throw new IllegalStateException();
        }
        return this.renegotiate((Promise<Channel>)channelHandlerContext.executor().newPromise());
    }

    public Future<Channel> renegotiate(final Promise<Channel> promise) {
        ObjectUtil.checkNotNull(promise, (String)"promise");
        ChannelHandlerContext channelHandlerContext = this.ctx;
        if (channelHandlerContext == null) {
            throw new IllegalStateException();
        }
        if (!(channelHandlerContext = channelHandlerContext.executor()).inEventLoop()) {
            channelHandlerContext.execute(new Runnable(){

                @Override
                public void run() {
                    SslHandler.this.renegotiateOnEventLoop((Promise<Channel>)promise);
                }
            });
            return promise;
        }
        this.renegotiateOnEventLoop(promise);
        return promise;
    }

    private void renegotiateOnEventLoop(Promise<Channel> promise) {
        Promise<Channel> promise2 = this.handshakePromise;
        if (!promise2.isDone()) {
            PromiseNotifier.cascade(promise2, promise);
            return;
        }
        this.handshakePromise = promise;
        this.handshake(true);
        this.applyHandshakeTimeout();
    }

    private void handshake(boolean bl) {
        block8: {
            if (this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                return;
            }
            if (this.handshakePromise.isDone()) {
                return;
            }
            ChannelHandlerContext channelHandlerContext = this.ctx;
            try {
                this.engine.beginHandshake();
                this.wrapNonAppData(channelHandlerContext, false);
                if (bl) {
                    this.forceFlush(channelHandlerContext);
                    return;
                }
            }
            catch (Throwable throwable) {
                try {
                    this.setHandshakeFailure(channelHandlerContext, throwable);
                    return;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (!bl) break block8;
                    this.forceFlush(channelHandlerContext);
                }
            }
        }
    }

    private void applyHandshakeTimeout() {
        final Promise<Channel> promise = this.handshakePromise;
        final long l = this.handshakeTimeoutMillis;
        if (l <= 0L || promise.isDone()) {
            return;
        }
        ScheduledFuture scheduledFuture = this.ctx.executor().schedule(new Runnable(){

            @Override
            public void run() {
                if (promise.isDone()) {
                    return;
                }
                SslHandshakeTimeoutException sslHandshakeTimeoutException = new SslHandshakeTimeoutException("handshake timed out after " + l + "ms");
                try {
                    if (promise.tryFailure((Throwable)sslHandshakeTimeoutException)) {
                        SslUtils.handleHandshakeFailure(SslHandler.this.ctx, sslHandshakeTimeoutException, true);
                    }
                    return;
                }
                finally {
                    SslHandler.this.releaseAndFailAll(SslHandler.this.ctx, sslHandshakeTimeoutException);
                }
            }
        }, l, TimeUnit.MILLISECONDS);
        promise.addListener((GenericFutureListener)new FutureListener<Channel>((Future)scheduledFuture){
            final /* synthetic */ Future val$timeoutFuture;
            {
                this.val$timeoutFuture = future;
            }

            public void operationComplete(Future<Channel> future) {
                this.val$timeoutFuture.cancel(false);
            }
        });
    }

    private void forceFlush(ChannelHandlerContext channelHandlerContext) {
        this.clearState(16);
        channelHandlerContext.flush();
    }

    private void setOpensslEngineSocketFd(Channel channel) {
        if (channel instanceof UnixChannel && this.engine instanceof ReferenceCountedOpenSslEngine) {
            ((ReferenceCountedOpenSslEngine)this.engine).bioSetFd(((UnixChannel)channel).fd().intValue());
        }
    }

    public void channelActive(ChannelHandlerContext channelHandlerContext) {
        this.setOpensslEngineSocketFd(channelHandlerContext.channel());
        if (!this.startTls) {
            this.startHandshakeProcessing(true);
        }
        channelHandlerContext.fireChannelActive();
    }

    private void safeClose(final ChannelHandlerContext channelHandlerContext, final ChannelFuture channelFuture, final ChannelPromise channelPromise) {
        long l;
        if (!channelHandlerContext.channel().isActive()) {
            channelHandlerContext.close(channelPromise);
            return;
        }
        ScheduledFuture scheduledFuture = !channelFuture.isDone() ? ((l = this.closeNotifyFlushTimeoutMillis) > 0L ? channelHandlerContext.executor().schedule(new Runnable(){

            @Override
            public void run() {
                if (!channelFuture.isDone()) {
                    logger.warn("{} Last write attempt timed out; force-closing the connection.", (Object)channelHandlerContext.channel());
                    SslHandler.addCloseListener(channelHandlerContext.close(channelHandlerContext.newPromise()), channelPromise);
                }
            }
        }, l, TimeUnit.MILLISECONDS) : null) : null;
        channelFuture.addListener((GenericFutureListener)new ChannelFutureListener((Future)scheduledFuture, channelHandlerContext, channelPromise){
            final /* synthetic */ Future val$timeoutFuture;
            final /* synthetic */ ChannelHandlerContext val$ctx;
            final /* synthetic */ ChannelPromise val$promise;
            {
                this.val$timeoutFuture = future;
                this.val$ctx = channelHandlerContext;
                this.val$promise = channelPromise;
            }

            public void operationComplete(ChannelFuture object) {
                long l;
                if (this.val$timeoutFuture != null) {
                    this.val$timeoutFuture.cancel(false);
                }
                if ((l = SslHandler.this.closeNotifyReadTimeoutMillis) <= 0L) {
                    SslHandler.addCloseListener(this.val$ctx.close(this.val$ctx.newPromise()), this.val$promise);
                    return;
                }
                object = !SslHandler.this.sslClosePromise.isDone() ? this.val$ctx.executor().schedule(new Runnable(){

                    @Override
                    public void run() {
                        if (!SslHandler.this.sslClosePromise.isDone()) {
                            logger.debug("{} did not receive close_notify in {}ms; force-closing the connection.", (Object)val$ctx.channel(), (Object)l);
                            SslHandler.addCloseListener(val$ctx.close(val$ctx.newPromise()), val$promise);
                        }
                    }
                }, l, TimeUnit.MILLISECONDS) : null;
                SslHandler.this.sslClosePromise.addListener((GenericFutureListener)new FutureListener<Channel>((Future)object){
                    final /* synthetic */ Future val$closeNotifyReadTimeoutFuture;
                    {
                        this.val$closeNotifyReadTimeoutFuture = future;
                    }

                    public void operationComplete(Future<Channel> future) {
                        if (this.val$closeNotifyReadTimeoutFuture != null) {
                            this.val$closeNotifyReadTimeoutFuture.cancel(false);
                        }
                        SslHandler.addCloseListener(val$ctx.close(val$ctx.newPromise()), val$promise);
                    }
                });
            }
        });
    }

    private static void addCloseListener(ChannelFuture channelFuture, ChannelPromise channelPromise) {
        PromiseNotifier.cascade((boolean)false, (Future)channelFuture, (Promise)channelPromise);
    }

    private ByteBuf allocate(ChannelHandlerContext channelHandlerContext, int n) {
        channelHandlerContext = channelHandlerContext.alloc();
        if (this.engineType.wantsDirectBuffer) {
            return channelHandlerContext.directBuffer(n);
        }
        return channelHandlerContext.buffer(n);
    }

    private ByteBuf allocateOutNetBuf(ChannelHandlerContext channelHandlerContext, int n, int n2) {
        return this.engineType.allocateWrapBuffer(this, channelHandlerContext.alloc(), n, n2);
    }

    private boolean isStateSet(int n) {
        return (this.state & n) == n;
    }

    private void setState(int n) {
        this.state = (short)(this.state | n);
    }

    private void clearState(int n) {
        this.state = (short)(this.state & ~n);
    }

    private final class LazyChannelPromise
    extends DefaultPromise<Channel> {
        private LazyChannelPromise() {
        }

        protected final EventExecutor executor() {
            if (SslHandler.this.ctx == null) {
                throw new IllegalStateException();
            }
            return SslHandler.this.ctx.executor();
        }

        protected final void checkDeadLock() {
            if (SslHandler.this.ctx == null) {
                return;
            }
            super.checkDeadLock();
        }
    }

    private final class SslTasksRunner
    implements Runnable {
        private final boolean inUnwrap;
        private final Runnable runCompleteTask = new Runnable(){

            @Override
            public void run() {
                SslTasksRunner.this.runComplete();
            }
        };

        SslTasksRunner(boolean bl) {
            this.inUnwrap = bl;
        }

        private void taskError(Throwable throwable) {
            if (this.inUnwrap) {
                try {
                    SslHandler.this.handleUnwrapThrowable(SslHandler.this.ctx, throwable);
                    return;
                }
                catch (Throwable throwable2) {
                    this.safeExceptionCaught(throwable2);
                    return;
                }
            }
            SslHandler.this.setHandshakeFailure(SslHandler.this.ctx, throwable);
            SslHandler.this.forceFlush(SslHandler.this.ctx);
        }

        private void safeExceptionCaught(Throwable throwable) {
            try {
                SslHandler.this.exceptionCaught(SslHandler.this.ctx, this.wrapIfNeeded(throwable));
                return;
            }
            catch (Throwable throwable2) {
                SslHandler.this.ctx.fireExceptionCaught(throwable2);
                return;
            }
        }

        private Throwable wrapIfNeeded(Throwable throwable) {
            if (!this.inUnwrap) {
                return throwable;
            }
            if (throwable instanceof DecoderException) {
                return throwable;
            }
            return new DecoderException(throwable);
        }

        private void tryDecodeAgain() {
            try {
                SslHandler.this.channelRead(SslHandler.this.ctx, Unpooled.EMPTY_BUFFER);
                return;
            }
            catch (Throwable throwable) {
                this.safeExceptionCaught(throwable);
                return;
            }
            finally {
                SslHandler.this.channelReadComplete0(SslHandler.this.ctx);
            }
        }

        private void resumeOnEventExecutor() {
            assert (SslHandler.this.ctx.executor().inEventLoop());
            SslHandler.this.clearState(128);
            try {
                SSLEngineResult.HandshakeStatus handshakeStatus = SslHandler.this.engine.getHandshakeStatus();
                switch (handshakeStatus) {
                    case NEED_TASK: {
                        SslHandler.this.executeDelegatedTask(this);
                        break;
                    }
                    case FINISHED: 
                    case NOT_HANDSHAKING: {
                        SslHandler.this.setHandshakeSuccess();
                        try {
                            SslHandler.this.wrap(SslHandler.this.ctx, this.inUnwrap);
                        }
                        catch (Throwable throwable) {
                            this.taskError(throwable);
                            return;
                        }
                        if (this.inUnwrap) {
                            SslHandler.this.unwrapNonAppData(SslHandler.this.ctx);
                        }
                        SslHandler.this.forceFlush(SslHandler.this.ctx);
                        this.tryDecodeAgain();
                        break;
                    }
                    case NEED_UNWRAP: {
                        try {
                            SslHandler.this.unwrapNonAppData(SslHandler.this.ctx);
                        }
                        catch (SSLException sSLException) {
                            SslHandler.this.handleUnwrapThrowable(SslHandler.this.ctx, sSLException);
                            return;
                        }
                        this.tryDecodeAgain();
                        break;
                    }
                    case NEED_WRAP: {
                        try {
                            if (!SslHandler.this.wrapNonAppData(SslHandler.this.ctx, false) && this.inUnwrap) {
                                SslHandler.this.unwrapNonAppData(SslHandler.this.ctx);
                            }
                            SslHandler.this.forceFlush(SslHandler.this.ctx);
                        }
                        catch (Throwable throwable) {
                            this.taskError(throwable);
                            return;
                        }
                        this.tryDecodeAgain();
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            catch (Throwable throwable) {
                this.safeExceptionCaught(throwable);
            }
        }

        final void runComplete() {
            EventExecutor eventExecutor = SslHandler.this.ctx.executor();
            eventExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    SslTasksRunner.this.resumeOnEventExecutor();
                }
            });
        }

        @Override
        public final void run() {
            try {
                Runnable runnable = SslHandler.this.engine.getDelegatedTask();
                if (runnable == null) {
                    return;
                }
                if (!(runnable instanceof AsyncRunnable)) {
                    runnable.run();
                    this.runComplete();
                    return;
                }
                runnable = (AsyncRunnable)runnable;
                runnable.run(this.runCompleteTask);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }

        private void handleException(final Throwable throwable) {
            EventExecutor eventExecutor = SslHandler.this.ctx.executor();
            if (eventExecutor.inEventLoop()) {
                SslHandler.this.clearState(128);
                this.safeExceptionCaught(throwable);
                return;
            }
            try {
                eventExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        SslHandler.this.clearState(128);
                        SslTasksRunner.this.safeExceptionCaught(throwable);
                    }
                });
                return;
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                SslHandler.this.clearState(128);
                SslHandler.this.ctx.fireExceptionCaught(throwable);
                return;
            }
        }
    }

    private final class AsyncTaskCompletionHandler
    implements Runnable {
        private final boolean inUnwrap;
        boolean didRun;
        boolean resumeLater;

        AsyncTaskCompletionHandler(boolean bl) {
            this.inUnwrap = bl;
        }

        @Override
        public final void run() {
            this.didRun = true;
            if (this.resumeLater) {
                SslHandler.this.getTaskRunner(this.inUnwrap).runComplete();
            }
        }

        final boolean resumeLater() {
            if (!this.didRun) {
                this.resumeLater = true;
                return true;
            }
            return false;
        }
    }

    private static enum SslEngineType {
        TCNATIVE(true, ByteToMessageDecoder.COMPOSITE_CUMULATOR){

            @Override
            final SSLEngineResult unwrap(SslHandler sslHandler, ByteBuf object, int n, ByteBuf byteBuf) {
                int n2 = object.nioBufferCount();
                int n3 = byteBuf.writerIndex();
                if (n2 > 1) {
                    ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = (ReferenceCountedOpenSslEngine)sslHandler.engine;
                    try {
                        ((SslHandler)sslHandler).singleBuffer[0] = SslHandler.toByteBuffer(byteBuf, n3, byteBuf.writableBytes());
                        Object object2 = object;
                        object = referenceCountedOpenSslEngine.unwrap(object2.nioBuffers(object2.readerIndex(), n), sslHandler.singleBuffer);
                    }
                    finally {
                        ((SslHandler)sslHandler).singleBuffer[0] = null;
                    }
                } else {
                    ByteBuf byteBuf2 = object;
                    object = sslHandler.engine.unwrap(SslHandler.toByteBuffer(byteBuf2, byteBuf2.readerIndex(), n), SslHandler.toByteBuffer(byteBuf, n3, byteBuf.writableBytes()));
                }
                byteBuf.writerIndex(n3 + ((SSLEngineResult)object).bytesProduced());
                return object;
            }

            @Override
            final ByteBuf allocateWrapBuffer(SslHandler sslHandler, ByteBufAllocator byteBufAllocator, int n, int n2) {
                return byteBufAllocator.directBuffer(((ReferenceCountedOpenSslEngine)sslHandler.engine).calculateOutNetBufSize(n, n2));
            }

            @Override
            final int calculateRequiredOutBufSpace(SslHandler sslHandler, int n, int n2) {
                return ((ReferenceCountedOpenSslEngine)sslHandler.engine).calculateMaxLengthForWrap(n, n2);
            }

            @Override
            final int calculatePendingData(SslHandler sslHandler, int n) {
                int n2 = ((ReferenceCountedOpenSslEngine)sslHandler.engine).sslPending();
                if (n2 > 0) {
                    return n2;
                }
                return n;
            }

            @Override
            final boolean jdkCompatibilityMode(SSLEngine sSLEngine) {
                return ((ReferenceCountedOpenSslEngine)sSLEngine).jdkCompatibilityMode;
            }
        }
        ,
        CONSCRYPT(true, ByteToMessageDecoder.COMPOSITE_CUMULATOR){

            @Override
            final SSLEngineResult unwrap(SslHandler sslHandler, ByteBuf object, int n, ByteBuf byteBuf) {
                int n2 = object.nioBufferCount();
                int n3 = byteBuf.writerIndex();
                if (n2 > 1) {
                    try {
                        ((SslHandler)sslHandler).singleBuffer[0] = SslHandler.toByteBuffer(byteBuf, n3, byteBuf.writableBytes());
                        ByteBuf byteBuf2 = object;
                        object = ((ConscryptAlpnSslEngine)sslHandler.engine).unwrap(byteBuf2.nioBuffers(byteBuf2.readerIndex(), n), sslHandler.singleBuffer);
                    }
                    finally {
                        ((SslHandler)sslHandler).singleBuffer[0] = null;
                    }
                } else {
                    ByteBuf byteBuf3 = object;
                    object = sslHandler.engine.unwrap(SslHandler.toByteBuffer(byteBuf3, byteBuf3.readerIndex(), n), SslHandler.toByteBuffer(byteBuf, n3, byteBuf.writableBytes()));
                }
                byteBuf.writerIndex(n3 + ((SSLEngineResult)object).bytesProduced());
                return object;
            }

            @Override
            final ByteBuf allocateWrapBuffer(SslHandler sslHandler, ByteBufAllocator byteBufAllocator, int n, int n2) {
                return byteBufAllocator.directBuffer(((ConscryptAlpnSslEngine)sslHandler.engine).calculateOutNetBufSize(n, n2));
            }

            @Override
            final int calculateRequiredOutBufSpace(SslHandler sslHandler, int n, int n2) {
                return ((ConscryptAlpnSslEngine)sslHandler.engine).calculateRequiredOutBufSpace(n, n2);
            }

            @Override
            final int calculatePendingData(SslHandler sslHandler, int n) {
                return n;
            }

            @Override
            final boolean jdkCompatibilityMode(SSLEngine sSLEngine) {
                return true;
            }
        }
        ,
        JDK(false, ByteToMessageDecoder.MERGE_CUMULATOR){

            @Override
            final SSLEngineResult unwrap(SslHandler object, ByteBuf object2, int n, ByteBuf byteBuf) {
                int n2;
                int n3 = byteBuf.writerIndex();
                ByteBuf byteBuf2 = object2;
                object2 = SslHandler.toByteBuffer(byteBuf2, byteBuf2.readerIndex(), n);
                n = ((Buffer)object2).position();
                object = ((SslHandler)((Object)object)).engine.unwrap((ByteBuffer)object2, SslHandler.toByteBuffer(byteBuf, n3, byteBuf.writableBytes()));
                byteBuf.writerIndex(n3 + ((SSLEngineResult)object).bytesProduced());
                if (((SSLEngineResult)object).bytesConsumed() == 0 && (n2 = ((Buffer)object2).position() - n) != ((SSLEngineResult)object).bytesConsumed()) {
                    return new SSLEngineResult(((SSLEngineResult)object).getStatus(), ((SSLEngineResult)object).getHandshakeStatus(), n2, ((SSLEngineResult)object).bytesProduced());
                }
                return object;
            }

            @Override
            final ByteBuf allocateWrapBuffer(SslHandler sslHandler, ByteBufAllocator byteBufAllocator, int n, int n2) {
                return byteBufAllocator.heapBuffer(Math.max(n, sslHandler.engine.getSession().getPacketBufferSize()));
            }

            @Override
            final int calculateRequiredOutBufSpace(SslHandler sslHandler, int n, int n2) {
                return sslHandler.engine.getSession().getPacketBufferSize();
            }

            @Override
            final int calculatePendingData(SslHandler sslHandler, int n) {
                return n;
            }

            @Override
            final boolean jdkCompatibilityMode(SSLEngine sSLEngine) {
                return true;
            }
        };

        final boolean wantsDirectBuffer;
        final ByteToMessageDecoder.Cumulator cumulator;

        static SslEngineType forEngine(SSLEngine sSLEngine) {
            if (sSLEngine instanceof ReferenceCountedOpenSslEngine) {
                return TCNATIVE;
            }
            if (sSLEngine instanceof ConscryptAlpnSslEngine) {
                return CONSCRYPT;
            }
            return JDK;
        }

        private SslEngineType(boolean bl, ByteToMessageDecoder.Cumulator cumulator) {
            this.wantsDirectBuffer = bl;
            this.cumulator = cumulator;
        }

        abstract SSLEngineResult unwrap(SslHandler var1, ByteBuf var2, int var3, ByteBuf var4);

        abstract int calculatePendingData(SslHandler var1, int var2);

        abstract boolean jdkCompatibilityMode(SSLEngine var1);

        abstract ByteBuf allocateWrapBuffer(SslHandler var1, ByteBufAllocator var2, int var3, int var4);

        abstract int calculateRequiredOutBufSpace(SslHandler var1, int var2, int var3);
    }
}

