/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.timeout;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import java.util.concurrent.TimeUnit;

public class IdleStateHandler
extends ChannelDuplexHandler {
    private static final long MIN_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(1L);
    private final ChannelFutureListener writeListener = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture channelFuture) {
            IdleStateHandler.this.lastWriteTime = IdleStateHandler.this.ticksInNanos();
            IdleStateHandler.this.firstWriterIdleEvent = (IdleStateHandler.this.firstAllIdleEvent = true);
        }
    };
    private final boolean observeOutput;
    private final long readerIdleTimeNanos;
    private final long writerIdleTimeNanos;
    private final long allIdleTimeNanos;
    private Future<?> readerIdleTimeout;
    private long lastReadTime;
    private boolean firstReaderIdleEvent = true;
    private Future<?> writerIdleTimeout;
    private long lastWriteTime;
    private boolean firstWriterIdleEvent = true;
    private Future<?> allIdleTimeout;
    private boolean firstAllIdleEvent = true;
    private byte state;
    private static final byte ST_INITIALIZED = 1;
    private static final byte ST_DESTROYED = 2;
    private boolean reading;
    private long lastChangeCheckTimeStamp;
    private int lastMessageHashCode;
    private long lastPendingWriteBytes;
    private long lastFlushProgress;

    public IdleStateHandler(int n, int n2, int n3) {
        this(n, n2, n3, TimeUnit.SECONDS);
    }

    public IdleStateHandler(long l, long l2, long l3, TimeUnit timeUnit) {
        this(false, l, l2, l3, timeUnit);
    }

    public IdleStateHandler(boolean bl, long l, long l2, long l3, TimeUnit timeUnit) {
        ObjectUtil.checkNotNull((Object)((Object)timeUnit), (String)"unit");
        this.observeOutput = bl;
        this.readerIdleTimeNanos = l <= 0L ? 0L : Math.max(timeUnit.toNanos(l), MIN_TIMEOUT_NANOS);
        this.writerIdleTimeNanos = l2 <= 0L ? 0L : Math.max(timeUnit.toNanos(l2), MIN_TIMEOUT_NANOS);
        if (l3 <= 0L) {
            this.allIdleTimeNanos = 0L;
            return;
        }
        this.allIdleTimeNanos = Math.max(timeUnit.toNanos(l3), MIN_TIMEOUT_NANOS);
    }

    public long getReaderIdleTimeInMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.readerIdleTimeNanos);
    }

    public long getWriterIdleTimeInMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.writerIdleTimeNanos);
    }

    public long getAllIdleTimeInMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.allIdleTimeNanos);
    }

    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        if (channelHandlerContext.channel().isActive() && channelHandlerContext.channel().isRegistered()) {
            this.initialize(channelHandlerContext);
        }
    }

    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        this.destroy();
    }

    public void channelRegistered(ChannelHandlerContext channelHandlerContext) {
        if (channelHandlerContext.channel().isActive()) {
            this.initialize(channelHandlerContext);
        }
        super.channelRegistered(channelHandlerContext);
    }

    public void channelActive(ChannelHandlerContext channelHandlerContext) {
        this.initialize(channelHandlerContext);
        super.channelActive(channelHandlerContext);
    }

    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        this.destroy();
        super.channelInactive(channelHandlerContext);
    }

    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        if (this.readerIdleTimeNanos > 0L || this.allIdleTimeNanos > 0L) {
            this.reading = true;
            IdleStateHandler idleStateHandler = this;
            idleStateHandler.firstAllIdleEvent = true;
            idleStateHandler.firstReaderIdleEvent = true;
        }
        channelHandlerContext.fireChannelRead(object);
    }

    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        if ((this.readerIdleTimeNanos > 0L || this.allIdleTimeNanos > 0L) && this.reading) {
            this.lastReadTime = this.ticksInNanos();
            this.reading = false;
        }
        channelHandlerContext.fireChannelReadComplete();
    }

    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        if (this.writerIdleTimeNanos > 0L || this.allIdleTimeNanos > 0L) {
            channelHandlerContext.write(object, channelPromise.unvoid()).addListener((GenericFutureListener)this.writeListener);
            return;
        }
        channelHandlerContext.write(object, channelPromise);
    }

    public void resetReadTimeout() {
        if (this.readerIdleTimeNanos > 0L || this.allIdleTimeNanos > 0L) {
            this.lastReadTime = this.ticksInNanos();
            this.reading = false;
        }
    }

    public void resetWriteTimeout() {
        if (this.writerIdleTimeNanos > 0L || this.allIdleTimeNanos > 0L) {
            this.lastWriteTime = this.ticksInNanos();
        }
    }

    private void initialize(ChannelHandlerContext channelHandlerContext) {
        switch (this.state) {
            case 1: 
            case 2: {
                return;
            }
        }
        this.state = 1;
        this.initOutputChanged(channelHandlerContext);
        IdleStateHandler idleStateHandler = this;
        idleStateHandler.lastReadTime = idleStateHandler.lastWriteTime = this.ticksInNanos();
        if (this.readerIdleTimeNanos > 0L) {
            this.readerIdleTimeout = this.schedule(channelHandlerContext, new ReaderIdleTimeoutTask(channelHandlerContext), this.readerIdleTimeNanos, TimeUnit.NANOSECONDS);
        }
        if (this.writerIdleTimeNanos > 0L) {
            this.writerIdleTimeout = this.schedule(channelHandlerContext, new WriterIdleTimeoutTask(channelHandlerContext), this.writerIdleTimeNanos, TimeUnit.NANOSECONDS);
        }
        if (this.allIdleTimeNanos > 0L) {
            this.allIdleTimeout = this.schedule(channelHandlerContext, new AllIdleTimeoutTask(channelHandlerContext), this.allIdleTimeNanos, TimeUnit.NANOSECONDS);
        }
    }

    long ticksInNanos() {
        return System.nanoTime();
    }

    Future<?> schedule(ChannelHandlerContext channelHandlerContext, Runnable runnable, long l, TimeUnit timeUnit) {
        return channelHandlerContext.executor().schedule(runnable, l, timeUnit);
    }

    private void destroy() {
        this.state = (byte)2;
        if (this.readerIdleTimeout != null) {
            this.readerIdleTimeout.cancel(false);
            this.readerIdleTimeout = null;
        }
        if (this.writerIdleTimeout != null) {
            this.writerIdleTimeout.cancel(false);
            this.writerIdleTimeout = null;
        }
        if (this.allIdleTimeout != null) {
            this.allIdleTimeout.cancel(false);
            this.allIdleTimeout = null;
        }
    }

    protected void channelIdle(ChannelHandlerContext channelHandlerContext, IdleStateEvent idleStateEvent) {
        channelHandlerContext.fireUserEventTriggered((Object)idleStateEvent);
    }

    protected IdleStateEvent newIdleStateEvent(IdleState idleState, boolean bl) {
        switch (idleState) {
            case ALL_IDLE: {
                if (bl) {
                    return IdleStateEvent.FIRST_ALL_IDLE_STATE_EVENT;
                }
                return IdleStateEvent.ALL_IDLE_STATE_EVENT;
            }
            case READER_IDLE: {
                if (bl) {
                    return IdleStateEvent.FIRST_READER_IDLE_STATE_EVENT;
                }
                return IdleStateEvent.READER_IDLE_STATE_EVENT;
            }
            case WRITER_IDLE: {
                if (bl) {
                    return IdleStateEvent.FIRST_WRITER_IDLE_STATE_EVENT;
                }
                return IdleStateEvent.WRITER_IDLE_STATE_EVENT;
            }
        }
        throw new IllegalArgumentException("Unhandled: state=" + (Object)((Object)idleState) + ", first=" + bl);
    }

    private void initOutputChanged(ChannelHandlerContext channelHandlerContext) {
        if (this.observeOutput) {
            channelHandlerContext = channelHandlerContext.channel();
            channelHandlerContext = channelHandlerContext.unsafe();
            if ((channelHandlerContext = channelHandlerContext.outboundBuffer()) != null) {
                this.lastMessageHashCode = System.identityHashCode(channelHandlerContext.current());
                this.lastPendingWriteBytes = channelHandlerContext.totalPendingWriteBytes();
                this.lastFlushProgress = channelHandlerContext.currentProgress();
            }
        }
    }

    private boolean hasOutputChanged(ChannelHandlerContext channelHandlerContext, boolean bl) {
        if (this.observeOutput) {
            if (this.lastChangeCheckTimeStamp != this.lastWriteTime) {
                this.lastChangeCheckTimeStamp = this.lastWriteTime;
                if (!bl) {
                    return true;
                }
            }
            channelHandlerContext = channelHandlerContext.channel();
            channelHandlerContext = channelHandlerContext.unsafe();
            if ((channelHandlerContext = channelHandlerContext.outboundBuffer()) != null) {
                long l;
                int n = System.identityHashCode(channelHandlerContext.current());
                long l2 = channelHandlerContext.totalPendingWriteBytes();
                if (n != this.lastMessageHashCode || l2 != this.lastPendingWriteBytes) {
                    this.lastMessageHashCode = n;
                    this.lastPendingWriteBytes = l2;
                    if (!bl) {
                        return true;
                    }
                }
                if ((l = channelHandlerContext.currentProgress()) != this.lastFlushProgress) {
                    this.lastFlushProgress = l;
                    return !bl;
                }
            }
        }
        return false;
    }

    private final class AllIdleTimeoutTask
    extends AbstractIdleTask {
        AllIdleTimeoutTask(ChannelHandlerContext channelHandlerContext) {
            super(channelHandlerContext);
        }

        @Override
        protected final void run(ChannelHandlerContext channelHandlerContext) {
            long l = IdleStateHandler.this.allIdleTimeNanos;
            if (!IdleStateHandler.this.reading) {
                l -= IdleStateHandler.this.ticksInNanos() - Math.max(IdleStateHandler.this.lastReadTime, IdleStateHandler.this.lastWriteTime);
            }
            if (l <= 0L) {
                AllIdleTimeoutTask allIdleTimeoutTask = this;
                IdleStateHandler.this.allIdleTimeout = IdleStateHandler.this.schedule(channelHandlerContext, allIdleTimeoutTask, allIdleTimeoutTask.IdleStateHandler.this.allIdleTimeNanos, TimeUnit.NANOSECONDS);
                boolean bl = IdleStateHandler.this.firstAllIdleEvent;
                IdleStateHandler.this.firstAllIdleEvent = false;
                try {
                    if (IdleStateHandler.this.hasOutputChanged(channelHandlerContext, bl)) {
                        return;
                    }
                    IdleStateEvent idleStateEvent = IdleStateHandler.this.newIdleStateEvent(IdleState.ALL_IDLE, bl);
                    IdleStateHandler.this.channelIdle(channelHandlerContext, idleStateEvent);
                }
                catch (Throwable throwable) {
                    channelHandlerContext.fireExceptionCaught(throwable);
                    return;
                }
            } else {
                IdleStateHandler.this.allIdleTimeout = IdleStateHandler.this.schedule(channelHandlerContext, this, l, TimeUnit.NANOSECONDS);
            }
        }
    }

    private final class WriterIdleTimeoutTask
    extends AbstractIdleTask {
        WriterIdleTimeoutTask(ChannelHandlerContext channelHandlerContext) {
            super(channelHandlerContext);
        }

        @Override
        protected final void run(ChannelHandlerContext channelHandlerContext) {
            long l = IdleStateHandler.this.lastWriteTime;
            long l2 = IdleStateHandler.this.writerIdleTimeNanos - (IdleStateHandler.this.ticksInNanos() - l);
            if (l2 <= 0L) {
                WriterIdleTimeoutTask writerIdleTimeoutTask = this;
                IdleStateHandler.this.writerIdleTimeout = IdleStateHandler.this.schedule(channelHandlerContext, writerIdleTimeoutTask, writerIdleTimeoutTask.IdleStateHandler.this.writerIdleTimeNanos, TimeUnit.NANOSECONDS);
                boolean bl = IdleStateHandler.this.firstWriterIdleEvent;
                IdleStateHandler.this.firstWriterIdleEvent = false;
                try {
                    if (IdleStateHandler.this.hasOutputChanged(channelHandlerContext, bl)) {
                        return;
                    }
                    IdleStateEvent idleStateEvent = IdleStateHandler.this.newIdleStateEvent(IdleState.WRITER_IDLE, bl);
                    IdleStateHandler.this.channelIdle(channelHandlerContext, idleStateEvent);
                }
                catch (Throwable throwable) {
                    channelHandlerContext.fireExceptionCaught(throwable);
                    return;
                }
            } else {
                IdleStateHandler.this.writerIdleTimeout = IdleStateHandler.this.schedule(channelHandlerContext, this, l2, TimeUnit.NANOSECONDS);
            }
        }
    }

    private final class ReaderIdleTimeoutTask
    extends AbstractIdleTask {
        ReaderIdleTimeoutTask(ChannelHandlerContext channelHandlerContext) {
            super(channelHandlerContext);
        }

        @Override
        protected final void run(ChannelHandlerContext channelHandlerContext) {
            long l = IdleStateHandler.this.readerIdleTimeNanos;
            if (!IdleStateHandler.this.reading) {
                l -= IdleStateHandler.this.ticksInNanos() - IdleStateHandler.this.lastReadTime;
            }
            if (l <= 0L) {
                ReaderIdleTimeoutTask readerIdleTimeoutTask = this;
                IdleStateHandler.this.readerIdleTimeout = IdleStateHandler.this.schedule(channelHandlerContext, readerIdleTimeoutTask, readerIdleTimeoutTask.IdleStateHandler.this.readerIdleTimeNanos, TimeUnit.NANOSECONDS);
                boolean bl = IdleStateHandler.this.firstReaderIdleEvent;
                IdleStateHandler.this.firstReaderIdleEvent = false;
                try {
                    IdleStateEvent idleStateEvent = IdleStateHandler.this.newIdleStateEvent(IdleState.READER_IDLE, bl);
                    IdleStateHandler.this.channelIdle(channelHandlerContext, idleStateEvent);
                }
                catch (Throwable throwable) {
                    channelHandlerContext.fireExceptionCaught(throwable);
                    return;
                }
            } else {
                IdleStateHandler.this.readerIdleTimeout = IdleStateHandler.this.schedule(channelHandlerContext, this, l, TimeUnit.NANOSECONDS);
            }
        }
    }

    private static abstract class AbstractIdleTask
    implements Runnable {
        private final ChannelHandlerContext ctx;

        AbstractIdleTask(ChannelHandlerContext channelHandlerContext) {
            this.ctx = channelHandlerContext;
        }

        @Override
        public void run() {
            if (!this.ctx.channel().isOpen()) {
                return;
            }
            AbstractIdleTask abstractIdleTask = this;
            abstractIdleTask.run(abstractIdleTask.ctx);
        }

        protected abstract void run(ChannelHandlerContext var1);
    }
}

