/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.unix;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.unix.FileDescriptor;
import io.netty.util.internal.ObjectUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public abstract class SocketWritableByteChannel
implements WritableByteChannel {
    protected final FileDescriptor fd;

    protected SocketWritableByteChannel(FileDescriptor fileDescriptor) {
        this.fd = (FileDescriptor)ObjectUtil.checkNotNull((Object)fileDescriptor, (String)"fd");
    }

    protected int write(ByteBuffer byteBuffer, int n, int n2) {
        return this.fd.write(byteBuffer, n, n2);
    }

    @Override
    public final int write(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        if (byteBuffer.isDirect()) {
            n2 = this.write(byteBuffer, n, byteBuffer.limit());
        } else {
            n2 -= n;
            ByteBuf byteBuf = null;
            try {
                Object object;
                if (n2 == 0) {
                    byteBuf = Unpooled.EMPTY_BUFFER;
                } else {
                    object = this.alloc();
                    if (object.isDirectBufferPooled()) {
                        byteBuf = object.directBuffer(n2);
                    } else {
                        byteBuf = ByteBufUtil.threadLocalDirectBuffer();
                        if (byteBuf == null) {
                            byteBuf = Unpooled.directBuffer((int)n2);
                        }
                    }
                }
                byteBuf.writeBytes(byteBuffer.duplicate());
                ByteBuf byteBuf2 = byteBuf;
                Object object2 = object = byteBuf2.internalNioBuffer(byteBuf2.readerIndex(), n2);
                n2 = this.write((ByteBuffer)object2, ((Buffer)object2).position(), ((Buffer)object).limit());
            }
            finally {
                if (byteBuf != null) {
                    byteBuf.release();
                }
            }
        }
        if (n2 > 0) {
            byteBuffer.position(n + n2);
        }
        return n2;
    }

    @Override
    public final boolean isOpen() {
        return this.fd.isOpen();
    }

    @Override
    public final void close() {
        this.fd.close();
    }

    protected abstract ByteBufAllocator alloc();
}

