/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.e.a.b.d;
import org.e.a.e;
import org.h.b.a;
import org.h.b.b;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.Smack;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.datatypes.UInt16;
import org.jivesoftware.smack.debugger.SmackDebuggerFactory;
import org.jivesoftware.smack.internal.SmackTlsContext;
import org.jivesoftware.smack.packet.id.StandardStanzaIdSource;
import org.jivesoftware.smack.packet.id.StanzaIdSource;
import org.jivesoftware.smack.packet.id.StanzaIdSourceFactory;
import org.jivesoftware.smack.proxy.ProxyInfo;
import org.jivesoftware.smack.util.CloseableUtil;
import org.jivesoftware.smack.util.CollectionUtil;
import org.jivesoftware.smack.util.DNSUtil;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.SslContextFactory;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.TLSUtils;
import org.jivesoftware.smack.util.dns.SmackDaneVerifier;

public abstract class ConnectionConfiguration {
    private static final Logger LOGGER;
    protected final org.e.a.b xmppServiceDomain;
    protected final a xmppServiceDomainDnsName;
    protected final InetAddress hostAddress;
    protected final a host;
    protected final UInt16 port;
    private final CallbackHandler callbackHandler;
    private final SmackDebuggerFactory debuggerFactory;
    private final SocketFactory socketFactory;
    private final CharSequence username;
    private final String password;
    private final d resource;
    private final Locale language;
    private final e authzid;
    private final boolean sendPresence;
    private final SecurityMode securityMode;
    final SmackTlsContext smackTlsContext;
    private final DnssecMode dnssecMode;
    private final String[] enabledSSLProtocols;
    private final String[] enabledSSLCiphers;
    private final HostnameVerifier hostnameVerifier;
    protected final ProxyInfo proxy;
    protected final boolean allowNullOrEmptyUsername;
    private final Set<String> enabledSaslMechanisms;
    private final boolean compressionEnabled;
    private final StanzaIdSourceFactory stanzaIdSourceFactory;

    protected ConnectionConfiguration(Builder<?, ?> builder) {
        a a2;
        try {
            this.smackTlsContext = ConnectionConfiguration.getSmackTlsContext(((Builder)builder).dnssecMode, ((Builder)builder).sslContextFactory, ((Builder)builder).customX509TrustManager, ((Builder)builder).keyManagers, ((Builder)builder).sslContextSecureRandom, ((Builder)builder).keystoreType, ((Builder)builder).keystorePath, ((Builder)builder).callbackHandler, ((Builder)builder).pkcs11Library);
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | UnrecoverableKeyException | CertificateException | UnsupportedCallbackException exception) {
            throw new IllegalArgumentException(exception);
        }
        this.authzid = ((Builder)builder).authzid;
        this.username = ((Builder)builder).username;
        this.password = ((Builder)builder).password;
        this.callbackHandler = ((Builder)builder).callbackHandler;
        this.resource = ((Builder)builder).resource;
        this.language = ((Builder)builder).language;
        this.xmppServiceDomain = ((Builder)builder).xmppServiceDomain;
        if (this.xmppServiceDomain == null) {
            throw new IllegalArgumentException("Must define the XMPP domain");
        }
        try {
            a2 = a.a((org.e.a.b)this.xmppServiceDomain);
        }
        catch (b b2) {
            LOGGER.log(Level.INFO, "Could not transform XMPP service domain '" + this.xmppServiceDomain + "' to a DNS name. TLS X.509 certificate validiation may not be possible.", b2);
            a2 = null;
        }
        this.xmppServiceDomainDnsName = a2;
        this.hostAddress = ((Builder)builder).hostAddress;
        this.host = ((Builder)builder).host;
        this.port = ((Builder)builder).port;
        this.proxy = ((Builder)builder).proxy;
        this.socketFactory = ((Builder)builder).socketFactory;
        this.dnssecMode = ((Builder)builder).dnssecMode;
        this.securityMode = ((Builder)builder).securityMode;
        this.enabledSSLProtocols = ((Builder)builder).enabledSSLProtocols;
        this.enabledSSLCiphers = ((Builder)builder).enabledSSLCiphers;
        this.hostnameVerifier = ((Builder)builder).hostnameVerifier;
        this.sendPresence = ((Builder)builder).sendPresence;
        this.debuggerFactory = ((Builder)builder).debuggerFactory;
        this.allowNullOrEmptyUsername = ((Builder)builder).allowEmptyOrNullUsername;
        this.enabledSaslMechanisms = ((Builder)builder).enabledSaslMechanisms;
        this.compressionEnabled = ((Builder)builder).compressionEnabled;
        this.stanzaIdSourceFactory = ((Builder)builder).stanzaIdSourceFactory;
        assert (this.enabledSaslMechanisms == null || !this.enabledSaslMechanisms.isEmpty());
    }

    private static SmackTlsContext getSmackTlsContext(DnssecMode object, SslContextFactory object2, X509TrustManager x509TrustManager, KeyManager[] keyManagerArray, SecureRandom secureRandom, String object3, String string, CallbackHandler callbackHandler, String string2) {
        object2 = object2 != null ? object2.createSslContext() : SSLContext.getInstance("TLS");
        if (keyManagerArray == null) {
            keyManagerArray = Builder.getKeyManagersFrom((String)object3, string, callbackHandler, string2);
        }
        object3 = null;
        if (object == DnssecMode.needsDnssecAndDane) {
            object = DNSUtil.getDaneProvider();
            if (object == null) {
                throw new UnsupportedOperationException("DANE enabled but no SmackDaneProvider configured");
            }
            object3 = object.newInstance();
            if (object3 == null) {
                throw new IllegalStateException("DANE requested but DANE provider did not return a DANE verifier");
            }
            object3.init((SSLContext)object2, keyManagerArray, x509TrustManager, secureRandom);
        } else {
            object = x509TrustManager != null ? new TrustManager[]{x509TrustManager} : null;
            ((SSLContext)object2).init(keyManagerArray, (TrustManager[])object, secureRandom);
        }
        return new SmackTlsContext((SSLContext)object2, (SmackDaneVerifier)object3);
    }

    public String getHostString() {
        if (this.hostAddress != null) {
            return this.hostAddress.toString();
        }
        if (this.host != null) {
            return this.host.toString();
        }
        return this.xmppServiceDomain.toString();
    }

    public a getHost() {
        return this.host;
    }

    public InetAddress getHostAddress() {
        return this.hostAddress;
    }

    public UInt16 getPort() {
        return this.port;
    }

    @Deprecated
    public org.e.a.b getServiceName() {
        return this.xmppServiceDomain;
    }

    public org.e.a.b getXMPPServiceDomain() {
        return this.xmppServiceDomain;
    }

    public a getXmppServiceDomainAsDnsNameIfPossible() {
        return this.xmppServiceDomainDnsName;
    }

    public SecurityMode getSecurityMode() {
        return this.securityMode;
    }

    public DnssecMode getDnssecMode() {
        return this.dnssecMode;
    }

    public String[] getEnabledSSLProtocols() {
        return this.enabledSSLProtocols;
    }

    public String[] getEnabledSSLCiphers() {
        return this.enabledSSLCiphers;
    }

    public HostnameVerifier getHostnameVerifier() {
        if (this.hostnameVerifier != null) {
            return this.hostnameVerifier;
        }
        return SmackConfiguration.getDefaultHostnameVerifier();
    }

    public SmackDebuggerFactory getDebuggerFactory() {
        return this.debuggerFactory;
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public ProxyInfo getProxyInfo() {
        return this.proxy;
    }

    public CharSequence getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public d getResource() {
        return this.resource;
    }

    public Locale getLanguage() {
        return this.language;
    }

    public String getXmlLang() {
        if (this.language != null) {
            return this.language.toString().replace("_", "-");
        }
        return null;
    }

    public e getAuthzid() {
        return this.authzid;
    }

    public boolean isSendPresence() {
        return this.sendPresence;
    }

    public boolean isCompressionEnabled() {
        return this.compressionEnabled;
    }

    public boolean isEnabledSaslMechanism(String string) {
        if (this.enabledSaslMechanisms == null) {
            return !SASLAuthentication.getBlacklistedSASLMechanisms().contains(string);
        }
        return this.enabledSaslMechanisms.contains(string);
    }

    public Set<String> getEnabledSaslMechanisms() {
        if (this.enabledSaslMechanisms == null) {
            return null;
        }
        return Collections.unmodifiableSet(this.enabledSaslMechanisms);
    }

    StanzaIdSource constructStanzaIdSource() {
        return this.stanzaIdSourceFactory.constructStanzaIdSource();
    }

    static {
        Smack.ensureInitialized();
        LOGGER = Logger.getLogger(ConnectionConfiguration.class.getName());
    }

    public static abstract class Builder<B extends Builder<B, C>, C extends ConnectionConfiguration> {
        private SecurityMode securityMode = SecurityMode.required;
        private DnssecMode dnssecMode = DnssecMode.disabled;
        private KeyManager[] keyManagers;
        private SecureRandom sslContextSecureRandom;
        private String keystorePath;
        private String keystoreType;
        private String pkcs11Library = "pkcs11.config";
        private SslContextFactory sslContextFactory;
        private String[] enabledSSLProtocols;
        private String[] enabledSSLCiphers;
        private HostnameVerifier hostnameVerifier;
        private e authzid;
        private CharSequence username;
        private String password;
        private d resource;
        private Locale language = Locale.getDefault();
        private boolean sendPresence = true;
        private ProxyInfo proxy;
        private CallbackHandler callbackHandler;
        private SmackDebuggerFactory debuggerFactory;
        private SocketFactory socketFactory;
        private org.e.a.b xmppServiceDomain;
        private InetAddress hostAddress;
        private a host;
        private UInt16 port = UInt16.from(5222);
        private boolean allowEmptyOrNullUsername = false;
        private boolean saslMechanismsSealed;
        private Set<String> enabledSaslMechanisms;
        private X509TrustManager customX509TrustManager;
        private boolean compressionEnabled = false;
        private StanzaIdSourceFactory stanzaIdSourceFactory = new StandardStanzaIdSource.Factory();

        protected Builder() {
            if (SmackConfiguration.DEBUG) {
                this.enableDefaultDebugger();
            }
        }

        public B setXmppAddressAndPassword(CharSequence charSequence, String string) {
            return this.setXmppAddressAndPassword(org.e.a.a.d.b((CharSequence)charSequence), string);
        }

        public B setXmppAddressAndPassword(e e2, String string) {
            this.setUsernameAndPassword((CharSequence)e2.a(), string);
            return this.setXmppDomain(e2.v());
        }

        public B setUsernameAndPassword(CharSequence charSequence, String string) {
            this.username = charSequence;
            this.password = string;
            return this.getThis();
        }

        @Deprecated
        public B setServiceName(org.e.a.b b2) {
            return this.setXmppDomain(b2);
        }

        public B setXmppDomain(org.e.a.b b2) {
            this.xmppServiceDomain = b2;
            return this.getThis();
        }

        public B setXmppDomain(String string) {
            this.xmppServiceDomain = org.e.a.a.d.f((String)string);
            return this.getThis();
        }

        public B setResource(d d2) {
            this.resource = d2;
            return this.getThis();
        }

        public B setLanguage(Locale locale) {
            this.language = locale;
            return this.getThis();
        }

        public B setResource(CharSequence charSequence) {
            Objects.requireNonNull(charSequence, "resource must not be null");
            return this.setResource(d.b((String)charSequence.toString()));
        }

        public B setHostAddress(InetAddress inetAddress) {
            this.hostAddress = inetAddress;
            return this.getThis();
        }

        public B setHost(CharSequence object) {
            if (org.h.e.a.c((String)(object = object.toString()))) {
                try {
                    object = InetAddress.getByName((String)object);
                }
                catch (UnknownHostException unknownHostException) {
                    throw new AssertionError((Object)unknownHostException);
                }
                this.setHostAddress((InetAddress)object);
            } else {
                object = a.a((String)object);
                this.setHost((a)object);
            }
            return this.getThis();
        }

        public B setHost(a a2) {
            this.host = a2;
            return this.getThis();
        }

        @Deprecated
        public B setHostAddressByNameOrIp(CharSequence charSequence) {
            return this.setHost(charSequence);
        }

        public B setPort(int n) {
            if (n < 0 || n > 65535) {
                throw new IllegalArgumentException("Port must be a 16-bit unsigned integer (i.e. between 0-65535. Port was: " + n);
            }
            UInt16 uInt16 = UInt16.from(n);
            return this.setPort(uInt16);
        }

        public B setPort(UInt16 uInt16) {
            this.port = Objects.requireNonNull(uInt16);
            return this.getThis();
        }

        @Deprecated
        public B setCallbackHandler(CallbackHandler callbackHandler) {
            this.callbackHandler = callbackHandler;
            return this.getThis();
        }

        public B setDnssecMode(DnssecMode dnssecMode) {
            this.dnssecMode = Objects.requireNonNull(dnssecMode, "DNSSEC mode must not be null");
            return this.getThis();
        }

        public B setCustomX509TrustManager(X509TrustManager x509TrustManager) {
            this.customX509TrustManager = x509TrustManager;
            return this.getThis();
        }

        public B setSecurityMode(SecurityMode securityMode) {
            this.securityMode = securityMode;
            return this.getThis();
        }

        public B setKeyManagers(KeyManager[] keyManagerArray) {
            this.keyManagers = keyManagerArray;
            return this.getThis();
        }

        public B setKeyManager(KeyManager keyManagerArray) {
            keyManagerArray = new KeyManager[]{keyManagerArray};
            return this.setKeyManagers(keyManagerArray);
        }

        public B setSslContextSecureRandom(SecureRandom secureRandom) {
            this.sslContextSecureRandom = secureRandom;
            return this.getThis();
        }

        @Deprecated
        public B setKeystorePath(String string) {
            this.keystorePath = string;
            return this.getThis();
        }

        @Deprecated
        public B setKeystoreType(String string) {
            this.keystoreType = string;
            return this.getThis();
        }

        @Deprecated
        public B setPKCS11Library(String string) {
            this.pkcs11Library = string;
            return this.getThis();
        }

        @Deprecated
        public B setCustomSSLContext(SSLContext sSLContext) {
            return this.setSslContextFactory(() -> sSLContext);
        }

        public B setSslContextFactory(SslContextFactory sslContextFactory) {
            this.sslContextFactory = Objects.requireNonNull(sslContextFactory, "The provided SslContextFactory must not be null");
            return this.getThis();
        }

        public B setEnabledSSLProtocols(String[] stringArray) {
            this.enabledSSLProtocols = stringArray;
            return this.getThis();
        }

        public B setEnabledSSLCiphers(String[] stringArray) {
            this.enabledSSLCiphers = stringArray;
            return this.getThis();
        }

        public B setHostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
            return this.getThis();
        }

        public B setSendPresence(boolean bl) {
            this.sendPresence = bl;
            return this.getThis();
        }

        public B enableDefaultDebugger() {
            this.debuggerFactory = SmackConfiguration.getDefaultSmackDebuggerFactory();
            assert (this.debuggerFactory != null);
            return this.getThis();
        }

        public B setDebuggerFactory(SmackDebuggerFactory smackDebuggerFactory) {
            this.debuggerFactory = smackDebuggerFactory;
            return this.getThis();
        }

        public B setSocketFactory(SocketFactory socketFactory) {
            this.socketFactory = socketFactory;
            return this.getThis();
        }

        public B setProxyInfo(ProxyInfo proxyInfo) {
            this.proxy = proxyInfo;
            return this.getThis();
        }

        public B allowEmptyOrNullUsernames() {
            this.allowEmptyOrNullUsername = true;
            return this.getThis();
        }

        public B performSaslAnonymousAuthentication() {
            if (!SASLAuthentication.isSaslMechanismRegistered("ANONYMOUS")) {
                throw new IllegalArgumentException("SASL ANONYMOUS is not registered");
            }
            this.throwIfEnabledSaslMechanismsSet();
            this.allowEmptyOrNullUsernames();
            this.addEnabledSaslMechanism("ANONYMOUS");
            this.saslMechanismsSealed = true;
            return this.getThis();
        }

        public B performSaslExternalAuthentication(SSLContext sSLContext) {
            if (!SASLAuthentication.isSaslMechanismRegistered("EXTERNAL")) {
                throw new IllegalArgumentException("SASL EXTERNAL is not registered");
            }
            this.setCustomSSLContext(sSLContext);
            this.throwIfEnabledSaslMechanismsSet();
            this.allowEmptyOrNullUsernames();
            this.setSecurityMode(SecurityMode.required);
            this.addEnabledSaslMechanism("EXTERNAL");
            this.saslMechanismsSealed = true;
            return this.getThis();
        }

        private void throwIfEnabledSaslMechanismsSet() {
            if (this.enabledSaslMechanisms != null) {
                throw new IllegalStateException("Enabled SASL mechanisms found");
            }
        }

        public B addEnabledSaslMechanism(String string) {
            return this.addEnabledSaslMechanism(Arrays.asList(StringUtils.requireNotNullNorEmpty(string, "saslMechanism must not be null nor empty")));
        }

        public B addEnabledSaslMechanism(Collection<String> collection) {
            if (this.saslMechanismsSealed) {
                throw new IllegalStateException("The enabled SASL mechanisms are sealed, you can not add new ones");
            }
            CollectionUtil.requireNotEmpty(collection, "saslMechanisms");
            Set<String> set = SASLAuthentication.getBlacklistedSASLMechanisms();
            for (String string : collection) {
                if (!SASLAuthentication.isSaslMechanismRegistered(string)) {
                    throw new IllegalArgumentException("SASL " + string + " is not available. Consider registering it with Smack");
                }
                if (!set.contains(string)) continue;
                throw new IllegalArgumentException("SALS " + string + " is blacklisted.");
            }
            if (this.enabledSaslMechanisms == null) {
                this.enabledSaslMechanisms = new HashSet<String>(collection.size());
            }
            this.enabledSaslMechanisms.addAll(collection);
            return this.getThis();
        }

        public B setAuthzid(e e2) {
            this.authzid = e2;
            return this.getThis();
        }

        public B setCompressionEnabled(boolean bl) {
            this.compressionEnabled = bl;
            return this.getThis();
        }

        public B setStanzaIdSourceFactory(StanzaIdSourceFactory stanzaIdSourceFactory) {
            this.stanzaIdSourceFactory = Objects.requireNonNull(stanzaIdSourceFactory);
            return this.getThis();
        }

        public abstract C build();

        protected abstract B getThis();

        public static KeyManager[] getKeyManagersFrom(String object, String object2, CallbackHandler callbackHandler, String string) {
            KeyManager[] keyManagerArray = null;
            KeyStore keyStore = null;
            PasswordCallback passwordCallback = null;
            if ("PKCS11".equals(object)) {
                object = Class.forName("sun.security.pkcs11.SunPKCS11").getConstructor(InputStream.class);
                object2 = "name = SmartCard\nlibrary = " + string;
                object2 = new ByteArrayInputStream(((String)object2).getBytes(StandardCharsets.UTF_8));
                object = (Provider)((Constructor)object).newInstance(object2);
                Security.addProvider((Provider)object);
                keyStore = KeyStore.getInstance("PKCS11", (Provider)object);
                passwordCallback = new PasswordCallback("PKCS11 Password: ", false);
                callbackHandler.handle(new Callback[]{passwordCallback});
                keyStore.load(null, passwordCallback.getPassword());
            } else if ("Apple".equals(object)) {
                keyStore = KeyStore.getInstance("KeychainStore", "Apple");
                keyStore.load(null, null);
            } else if (object != null) {
                keyStore = KeyStore.getInstance((String)object);
                if (callbackHandler != null && StringUtils.isNotEmpty((CharSequence)object2)) {
                    passwordCallback = new PasswordCallback("Keystore Password: ", false);
                    callbackHandler.handle(new Callback[]{passwordCallback});
                    keyStore.load(new FileInputStream((String)object2), passwordCallback.getPassword());
                } else {
                    object = TLSUtils.getDefaultTruststoreStreamIfPossible();
                    try {
                        object2 = "changeit".toCharArray();
                        try {
                            keyStore.load((InputStream)object, (char[])object2);
                        }
                        finally {
                            CloseableUtil.maybeClose((Closeable)object);
                        }
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.FINE, "KeyStore load() threw, attempting 'jks' fallback", iOException);
                        keyStore = KeyStore.getInstance("jks");
                        object = TLSUtils.getDefaultTruststoreStreamIfPossible();
                        try {
                            keyStore.load((InputStream)object, null);
                        }
                        finally {
                            CloseableUtil.maybeClose((Closeable)object);
                        }
                    }
                }
            }
            if (keyStore != null && (object2 = KeyManagerFactory.getInstance((String)(object = KeyManagerFactory.getDefaultAlgorithm()))) != null) {
                if (passwordCallback == null) {
                    ((KeyManagerFactory)object2).init(keyStore, null);
                } else {
                    ((KeyManagerFactory)object2).init(keyStore, passwordCallback.getPassword());
                    passwordCallback.clearPassword();
                }
                keyManagerArray = ((KeyManagerFactory)object2).getKeyManagers();
            }
            return keyManagerArray;
        }
    }

    public static enum DnssecMode {
        disabled,
        needsDnssec,
        needsDnssecAndDane;

    }

    public static enum SecurityMode {
        required,
        ifpossible,
        disabled;

    }
}

