/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import org.h.a.b;
import org.h.e.a;
import org.jivesoftware.smack.util.Objects;

public abstract class InternetAddress
implements CharSequence {
    protected final String originalString;

    protected InternetAddress(String string) {
        this.originalString = Objects.requireNonNull(string, "The 'originalString' argument must not be null");
    }

    public abstract InetAddress asInetAddress();

    @Override
    public String toString() {
        return this.originalString;
    }

    @Override
    public int length() {
        return this.originalString.length();
    }

    @Override
    public char charAt(int n) {
        return this.originalString.charAt(n);
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return this.originalString.subSequence(n, n2);
    }

    public String getRaw() {
        return this.originalString;
    }

    public static InternetAddress fromIgnoringZoneId(String string) {
        return InternetAddress.from(string, true);
    }

    public static InternetAddress from(String string) {
        return InternetAddress.from(string, false);
    }

    private static InternetAddress from(String string, boolean n) {
        InternetAddress internetAddress;
        String string2 = string;
        if (n && (n = string.indexOf(37)) > 1) {
            string = string.substring(0, n);
        }
        if (a.a((CharSequence)string)) {
            internetAddress = new Ipv4(string, string2);
        } else if (a.b((CharSequence)string)) {
            internetAddress = new Ipv6(string, string2);
        } else if (string.contains(".")) {
            try {
                internetAddress = org.h.b.a.a((String)string);
                internetAddress = new DomainName(string, (org.h.b.a)internetAddress);
            }
            catch (org.h.b.b b2) {
                internetAddress = new InvalidDomainName(string, b2);
            }
        } else {
            internetAddress = b.a((String)string);
            internetAddress = new DomainNameLabel(string, (b)internetAddress);
        }
        return internetAddress;
    }

    public static InternetAddress from(InetAddress inetAddress) {
        if (inetAddress instanceof Inet4Address) {
            return new Ipv4(inetAddress.getHostAddress(), (Inet4Address)inetAddress);
        }
        if (inetAddress instanceof Inet6Address) {
            return new Ipv6(inetAddress.getHostAddress(), (Inet6Address)inetAddress);
        }
        throw new IllegalArgumentException("Unknown type " + inetAddress.getClass() + " of " + inetAddress);
    }

    public static final class InvalidDomainName
    extends NonNumericInternetAddress {
        private final org.h.b.b invalidDnsNameException;

        private InvalidDomainName(String string, org.h.b.b b2) {
            super(string);
            this.invalidDnsNameException = b2;
        }

        public final org.h.b.b getInvalidDnsNameException() {
            return this.invalidDnsNameException;
        }
    }

    public static final class DomainNameLabel
    extends NonNumericInternetAddress {
        private final b dnsLabel;

        private DomainNameLabel(String string, b b2) {
            super(string);
            this.dnsLabel = b2;
        }

        public final b getDnsLabel() {
            return this.dnsLabel;
        }
    }

    public static final class DomainName
    extends NonNumericInternetAddress {
        private final org.h.b.a dnsName;

        private DomainName(String string, org.h.b.a a2) {
            super(string);
            this.dnsName = a2;
        }

        public final org.h.b.a getDnsName() {
            return this.dnsName;
        }
    }

    private static class NonNumericInternetAddress
    extends InternetAddress {
        private boolean attemptedToResolveInetAddress;
        private InetAddress inetAddress;

        protected NonNumericInternetAddress(String string) {
            super(string);
        }

        @Override
        public InetAddress asInetAddress() {
            if (this.inetAddress != null || this.attemptedToResolveInetAddress) {
                return this.inetAddress;
            }
            this.attemptedToResolveInetAddress = true;
            this.inetAddress = InetAddress.getByName(this.originalString);
            return this.inetAddress;
        }
    }

    public static final class Ipv6
    extends InetAddressInternetAddress {
        private Inet6Address inet6Address;

        private Ipv6(String string, String string2) {
            this(string, string2, a.b((String)string));
        }

        private Ipv6(String string, Inet6Address inet6Address) {
            String string2 = string;
            this(string2, string2, inet6Address);
        }

        private Ipv6(String string, String string2, Inet6Address inet6Address) {
            super(string, string2, inet6Address);
            this.inet6Address = inet6Address;
        }

        public final Inet6Address getInet6Address() {
            return this.inet6Address;
        }
    }

    public static final class Ipv4
    extends InetAddressInternetAddress {
        private final Inet4Address inet4Address;

        private Ipv4(String string, String string2) {
            this(string, string2, a.a((String)string));
        }

        private Ipv4(String string, Inet4Address inet4Address) {
            String string2 = string;
            this(string2, string2, inet4Address);
        }

        private Ipv4(String string, String string2, Inet4Address inet4Address) {
            super(string, string2, inet4Address);
            this.inet4Address = inet4Address;
        }

        public final Inet4Address getInet4Address() {
            return this.inet4Address;
        }
    }

    private static class InetAddressInternetAddress
    extends InternetAddress {
        private final InetAddress inetAddress;
        private final String raw;

        protected InetAddressInternetAddress(String string, String string2, InetAddress inetAddress) {
            super(string);
            this.raw = string2;
            this.inetAddress = inetAddress;
        }

        @Override
        public InetAddress asInetAddress() {
            return this.inetAddress;
        }

        @Override
        public final String getRaw() {
            return this.raw;
        }
    }
}

