/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509TrustManager;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.util.StringUtils;

public class TLSUtils {
    private static final Logger LOGGER = Logger.getLogger(TLSUtils.class.getName());
    public static final String SSL = "SSL";
    public static final String TLS = "TLS";
    public static final String PROTO_SSL3 = "SSLv3";
    public static final String PROTO_TLSV1 = "TLSv1";
    public static final String PROTO_TLSV1_1 = "TLSv1.1";
    public static final String PROTO_TLSV1_2 = "TLSv1.2";
    public static final String PROTO_TLSV1_3 = "TLSv1.3";
    private static final File DEFAULT_TRUSTSTORE_PATH;
    private static final int JKS_MAGIC = -17957139;
    private static final int JKS_VERSION_1 = 1;
    private static final int JKS_VERSION_2 = 2;

    public static <B extends ConnectionConfiguration.Builder<B, ?>> B setEnabledTlsProtocolsToRecommended(B b2) {
        b2.setEnabledSSLProtocols(new String[]{PROTO_TLSV1_3, PROTO_TLSV1_2});
        return b2;
    }

    @Deprecated
    public static <B extends ConnectionConfiguration.Builder<B, ?>> B setTLSOnly(B b2) {
        b2.setEnabledSSLProtocols(new String[]{PROTO_TLSV1_2, PROTO_TLSV1_1, PROTO_TLSV1});
        return b2;
    }

    @Deprecated
    public static <B extends ConnectionConfiguration.Builder<B, ?>> B setSSLv3AndTLSOnly(B b2) {
        b2.setEnabledSSLProtocols(new String[]{PROTO_TLSV1_2, PROTO_TLSV1_1, PROTO_TLSV1, PROTO_SSL3});
        return b2;
    }

    public static <B extends ConnectionConfiguration.Builder<B, ?>> B acceptAllCertificates(B b2) {
        b2.setCustomX509TrustManager(new AcceptAllTrustManager());
        return b2;
    }

    public static <B extends ConnectionConfiguration.Builder<B, ?>> B disableHostnameVerificationForTlsCertificates(B b2) {
        b2.setHostnameVerifier((string, sSLSession) -> true);
        return b2;
    }

    public static void setEnabledProtocolsAndCiphers(SSLSocket sSLSocket, String[] stringArray, String[] stringArray2) {
        HashSet<String> hashSet;
        HashSet<String> hashSet2;
        if (stringArray != null) {
            stringArray = new HashSet<String>(Arrays.asList(stringArray));
            hashSet2 = new HashSet<String>(Arrays.asList(sSLSocket.getSupportedProtocols()));
            hashSet = new HashSet<String>(hashSet2);
            hashSet.retainAll((Collection<?>)stringArray);
            if (hashSet.isEmpty()) {
                throw new SmackException.SecurityNotPossibleException("Request to enable SSL/TLS protocols '" + StringUtils.collectionToString((Collection<? extends Object>)stringArray) + "', but only '" + StringUtils.collectionToString(hashSet2) + "' are supported.");
            }
            stringArray = new String[hashSet.size()];
            stringArray = hashSet.toArray(stringArray);
            sSLSocket.setEnabledProtocols(stringArray);
        }
        if (stringArray2 != null) {
            stringArray = new HashSet<String>(Arrays.asList(stringArray2));
            hashSet2 = new HashSet<String>(Arrays.asList(sSLSocket.getEnabledCipherSuites()));
            hashSet = new HashSet<String>(hashSet2);
            hashSet.retainAll((Collection<?>)stringArray);
            if (hashSet.isEmpty()) {
                throw new SmackException.SecurityNotPossibleException("Request to enable SSL/TLS ciphers '" + StringUtils.collectionToString((Collection<? extends Object>)stringArray) + "', but only '" + StringUtils.collectionToString(hashSet2) + "' are supported.");
            }
            stringArray2 = new String[hashSet.size()];
            stringArray2 = hashSet.toArray(stringArray2);
            sSLSocket.setEnabledCipherSuites(stringArray2);
        }
    }

    public static byte[] getChannelBindingTlsServerEndPoint(SSLSession object) {
        object = object.getPeerCertificates();
        object = object[0];
        String string = ((Certificate)object).getPublicKey().getAlgorithm();
        switch (string) {
            case "MD5": 
            case "SHA-1": {
                string = "SHA-256";
                break;
            }
        }
        Object object2 = MessageDigest.getInstance(string);
        byte[] byArray = ((Certificate)object).getEncoded();
        ((MessageDigest)object2).update(byArray);
        return ((MessageDigest)object2).digest();
    }

    public static FileInputStream getDefaultTruststoreStreamIfPossible() {
        try {
            return new FileInputStream(DEFAULT_TRUSTSTORE_PATH);
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOGGER.log(Level.WARNING, "Could not open default truststore at " + DEFAULT_TRUSTSTORE_PATH, fileNotFoundException);
            return null;
        }
    }

    public static DefaultTrustStoreType getDefaultTruststoreType() {
        try (FileInputStream fileInputStream = TLSUtils.getDefaultTruststoreStreamIfPossible();){
            if (fileInputStream == null) {
                DefaultTrustStoreType defaultTrustStoreType = DefaultTrustStoreType.no_default;
                return defaultTrustStoreType;
            }
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            if (n == -17957139 && (n2 == 1 || n2 == 2)) {
                DefaultTrustStoreType defaultTrustStoreType = DefaultTrustStoreType.jks;
                return defaultTrustStoreType;
            }
        }
        return DefaultTrustStoreType.unknown;
    }

    public static void setDefaultTrustStoreTypeToJksIfRequired() {
        DefaultTrustStoreType defaultTrustStoreType;
        try {
            defaultTrustStoreType = TLSUtils.getDefaultTruststoreType();
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "Could not set keystore type to jks if required", iOException);
            return;
        }
        if (defaultTrustStoreType == DefaultTrustStoreType.jks) {
            System.setProperty("javax.net.ssl.trustStoreType", "JKS");
        }
    }

    static {
        String string = System.getProperty("java.home");
        string = string + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts";
        DEFAULT_TRUSTSTORE_PATH = new File(string);
    }

    static enum DefaultTrustStoreType {
        jks,
        unknown,
        no_default;

    }

    public static class AcceptAllTrustManager
    implements X509TrustManager {
        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

