/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.util.ArrayList;
import java.util.Collection;
import org.jivesoftware.smack.util.Function;
import org.jivesoftware.smack.util.StringUtils;

public class ToStringUtil {
    public static Builder builderFor(Class<?> clazz) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(clazz.getSimpleName()).append('(');
        return new Builder(stringBuilder);
    }

    public static final class Builder {
        private final StringBuilder sb;

        private Builder(StringBuilder stringBuilder) {
            this.sb = stringBuilder;
        }

        public final Builder addValue(String string, Object object) {
            if (object == null) {
                return this;
            }
            if (this.sb.charAt(this.sb.length() - 1) != '(') {
                this.sb.append(' ');
            }
            this.sb.append(string).append("='").append(object).append('\'');
            return this;
        }

        public final <V> Builder add(String object, Collection<? extends V> object2, Function<?, V> function) {
            if (object2.isEmpty()) {
                return this;
            }
            this.sb.append(' ').append((String)object).append('[');
            object = new ArrayList(object2.size());
            object2 = object2.iterator();
            while (object2.hasNext()) {
                Object object3 = object2.next();
                object3 = function.apply(object3).toString();
                object.add(object3);
            }
            StringUtils.appendTo((Collection<? extends Object>)object, ", ", this.sb);
            this.sb.append(']');
            return this;
        }

        public final String build() {
            this.sb.append(')');
            return this.sb.toString();
        }
    }
}

