/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteOrder;
import java.util.List;

public class WebSocket08FrameEncoder
extends MessageToMessageEncoder<WebSocketFrame>
implements WebSocketFrameEncoder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocket08FrameEncoder.class);
    private static final byte OPCODE_CONT = 0;
    private static final byte OPCODE_TEXT = 1;
    private static final byte OPCODE_BINARY = 2;
    private static final byte OPCODE_CLOSE = 8;
    private static final byte OPCODE_PING = 9;
    private static final byte OPCODE_PONG = 10;
    private static final int GATHERING_WRITE_THRESHOLD = 1024;
    private final boolean maskPayload;

    public WebSocket08FrameEncoder(boolean bl) {
        this.maskPayload = bl;
    }

    protected void encode(ChannelHandlerContext channelHandlerContext, WebSocketFrame webSocketFrame, List<Object> list) {
        block32: {
            int n;
            ByteBuf byteBuf = webSocketFrame.content();
            if (webSocketFrame instanceof TextWebSocketFrame) {
                n = 1;
            } else if (webSocketFrame instanceof PingWebSocketFrame) {
                n = 9;
            } else if (webSocketFrame instanceof PongWebSocketFrame) {
                n = 10;
            } else if (webSocketFrame instanceof CloseWebSocketFrame) {
                n = 8;
            } else if (webSocketFrame instanceof BinaryWebSocketFrame) {
                n = 2;
            } else if (webSocketFrame instanceof ContinuationWebSocketFrame) {
                n = 0;
            } else {
                throw new UnsupportedOperationException("Cannot encode frame of type: " + ((Object)((Object)webSocketFrame)).getClass().getName());
            }
            int n2 = byteBuf.readableBytes();
            if (logger.isTraceEnabled()) {
                logger.trace("Encoding WebSocket Frame opCode={} length={}", (Object)((byte)n), (Object)n2);
            }
            int n3 = 0;
            if (webSocketFrame.isFinalFragment()) {
                n3 = 128;
            }
            n3 |= webSocketFrame.rsv() % 8 << 4;
            n3 |= n % 128;
            if (n == 9 && n2 > 125) {
                throw new TooLongFrameException("invalid payload for PING (payload length must be <= 125, was " + n2);
            }
            webSocketFrame = null;
            try {
                int n4 = n = this.maskPayload ? 4 : 0;
                if (n2 <= 125) {
                    n = n + 2 + n2;
                    webSocketFrame = channelHandlerContext.alloc().buffer(n);
                    webSocketFrame.writeByte(n3);
                    byte by = this.maskPayload ? (byte)(0x80 | (byte)n2) : (byte)n2;
                    webSocketFrame.writeByte(by);
                } else if (n2 <= 65535) {
                    n += 4;
                    if (this.maskPayload || n2 <= 1024) {
                        n += n2;
                    }
                    webSocketFrame = channelHandlerContext.alloc().buffer(n);
                    webSocketFrame.writeByte(n3);
                    webSocketFrame.writeByte(this.maskPayload ? 254 : 126);
                    webSocketFrame.writeByte(n2 >>> 8 & 0xFF);
                    webSocketFrame.writeByte(n2 & 0xFF);
                } else {
                    n += 10;
                    if (this.maskPayload) {
                        n += n2;
                    }
                    webSocketFrame = channelHandlerContext.alloc().buffer(n);
                    webSocketFrame.writeByte(n3);
                    webSocketFrame.writeByte(this.maskPayload ? 255 : 127);
                    webSocketFrame.writeLong(n2);
                }
                if (this.maskPayload) {
                    n = PlatformDependent.threadLocalRandom().nextInt(Integer.MAX_VALUE);
                    webSocketFrame.writeInt(n);
                    if (byteBuf.isReadable()) {
                        ByteOrder byteOrder = byteBuf.order();
                        ByteOrder byteOrder2 = webSocketFrame.order();
                        n3 = byteBuf.readerIndex();
                        int n5 = byteBuf.writerIndex();
                        if (byteOrder == byteOrder2) {
                            long l = (long)n & 0xFFFFFFFFL;
                            l |= l << 32;
                            if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                                l = Long.reverseBytes(l);
                            }
                            int n6 = n5 - 7;
                            while (n3 < n6) {
                                webSocketFrame.writeLong(byteBuf.getLong(n3) ^ l);
                                n3 += 8;
                            }
                            if (n3 < n5 - 3) {
                                webSocketFrame.writeInt(byteBuf.getInt(n3) ^ (int)l);
                                n3 += 4;
                            }
                        }
                        int n7 = 0;
                        while (n3 < n5) {
                            byte by = byteBuf.getByte(n3);
                            webSocketFrame.writeByte(by ^ WebSocketUtil.byteAtIndex(n, n7++ & 3));
                            ++n3;
                        }
                    }
                    list.add((Object)webSocketFrame);
                    break block32;
                }
                if (webSocketFrame.writableBytes() >= byteBuf.readableBytes()) {
                    webSocketFrame.writeBytes(byteBuf);
                    list.add((Object)webSocketFrame);
                    break block32;
                }
                list.add((Object)webSocketFrame);
                list.add(byteBuf.retain());
                return;
            }
            catch (Throwable throwable) {
                if (webSocketFrame != null) {
                    webSocketFrame.release();
                }
                throw throwable;
            }
        }
    }
}

