/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.handler.codec.DateFormatter;
import io.netty.handler.codec.ValueConverter;
import io.netty.util.AsciiString;
import io.netty.util.internal.PlatformDependent;
import java.text.ParseException;
import java.util.Date;

public class CharSequenceValueConverter
implements ValueConverter<CharSequence> {
    public static final CharSequenceValueConverter INSTANCE = new CharSequenceValueConverter();
    private static final AsciiString TRUE_ASCII = new AsciiString((CharSequence)"true");

    @Override
    public CharSequence convertObject(Object object) {
        if (object instanceof CharSequence) {
            return (CharSequence)object;
        }
        return object.toString();
    }

    @Override
    public CharSequence convertInt(int n) {
        return String.valueOf(n);
    }

    @Override
    public CharSequence convertLong(long l) {
        return String.valueOf(l);
    }

    @Override
    public CharSequence convertDouble(double d) {
        return String.valueOf(d);
    }

    @Override
    public CharSequence convertChar(char c) {
        return String.valueOf(c);
    }

    @Override
    public CharSequence convertBoolean(boolean bl) {
        return String.valueOf(bl);
    }

    @Override
    public CharSequence convertFloat(float f) {
        return String.valueOf(f);
    }

    @Override
    public boolean convertToBoolean(CharSequence charSequence) {
        return AsciiString.contentEqualsIgnoreCase((CharSequence)charSequence, (CharSequence)TRUE_ASCII);
    }

    @Override
    public CharSequence convertByte(byte by) {
        return String.valueOf(by);
    }

    @Override
    public byte convertToByte(CharSequence charSequence) {
        if (charSequence instanceof AsciiString && charSequence.length() == 1) {
            return ((AsciiString)charSequence).byteAt(0);
        }
        return Byte.parseByte(charSequence.toString());
    }

    @Override
    public char convertToChar(CharSequence charSequence) {
        return charSequence.charAt(0);
    }

    @Override
    public CharSequence convertShort(short s) {
        return String.valueOf(s);
    }

    @Override
    public short convertToShort(CharSequence charSequence) {
        if (charSequence instanceof AsciiString) {
            return ((AsciiString)charSequence).parseShort();
        }
        return Short.parseShort(charSequence.toString());
    }

    @Override
    public int convertToInt(CharSequence charSequence) {
        if (charSequence instanceof AsciiString) {
            return ((AsciiString)charSequence).parseInt();
        }
        return Integer.parseInt(charSequence.toString());
    }

    @Override
    public long convertToLong(CharSequence charSequence) {
        if (charSequence instanceof AsciiString) {
            return ((AsciiString)charSequence).parseLong();
        }
        return Long.parseLong(charSequence.toString());
    }

    @Override
    public CharSequence convertTimeMillis(long l) {
        return DateFormatter.format(new Date(l));
    }

    @Override
    public long convertToTimeMillis(CharSequence charSequence) {
        Date date = DateFormatter.parseHttpDate(charSequence);
        if (date == null) {
            PlatformDependent.throwException((Throwable)new ParseException("header can't be parsed into a Date: " + charSequence, 0));
            return 0L;
        }
        return date.getTime();
    }

    @Override
    public float convertToFloat(CharSequence charSequence) {
        if (charSequence instanceof AsciiString) {
            return ((AsciiString)charSequence).parseFloat();
        }
        return Float.parseFloat(charSequence.toString());
    }

    @Override
    public double convertToDouble(CharSequence charSequence) {
        if (charSequence instanceof AsciiString) {
            return ((AsciiString)charSequence).parseDouble();
        }
        return Double.parseDouble(charSequence.toString());
    }
}

