/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.codec.compression.ByteBufChecksum;
import io.netty.handler.codec.compression.FastLz;
import java.util.zip.Adler32;
import java.util.zip.Checksum;

public class FastLzFrameEncoder
extends MessageToByteEncoder<ByteBuf> {
    private final int level;
    private final ByteBufChecksum checksum;

    public FastLzFrameEncoder() {
        this(0, null);
    }

    public FastLzFrameEncoder(int n) {
        this(n, null);
    }

    public FastLzFrameEncoder(boolean bl) {
        this(0, bl ? new Adler32() : null);
    }

    public FastLzFrameEncoder(int n, Checksum checksum) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException(String.format("level: %d (expected: %d or %d or %d)", n, 0, 1, 2));
        }
        this.level = n;
        this.checksum = checksum == null ? null : ByteBufChecksum.wrapChecksum(checksum);
    }

    @Override
    protected void encode(ChannelHandlerContext object, ByteBuf byteBuf, ByteBuf byteBuf2) {
        object = this.checksum;
        while (byteBuf.isReadable()) {
            int n;
            int n2;
            int n3 = byteBuf.readerIndex();
            int n4 = Math.min(byteBuf.readableBytes(), 65535);
            int n5 = byteBuf2.writerIndex();
            byteBuf2.setMedium(n5, 4607066);
            int n6 = n5 + 4 + (object != null ? 4 : 0);
            if (n4 < 32) {
                n2 = 0;
                byteBuf2.ensureWritable(n6 + 2 + n4);
                n = n6 + 2;
                if (object != null) {
                    object.reset();
                    ((ByteBufChecksum)object).update(byteBuf, n3, n4);
                    byteBuf2.setInt(n5 + 4, (int)object.getValue());
                }
                byteBuf2.setBytes(n, byteBuf, n3, n4);
                n3 = n4;
            } else {
                if (object != null) {
                    object.reset();
                    ((ByteBufChecksum)object).update(byteBuf, n3, n4);
                    byteBuf2.setInt(n5 + 4, (int)object.getValue());
                }
                n = FastLz.calculateOutputBufferLength(n4);
                byteBuf2.ensureWritable(n6 + 4 + n);
                n2 = n6 + 4;
                ByteBuf byteBuf3 = byteBuf;
                n = FastLz.compress(byteBuf3, byteBuf3.readerIndex(), n4, byteBuf2, n2, this.level);
                if (n < n4) {
                    n2 = 1;
                    n3 = n;
                    byteBuf2.setShort(n6, n3);
                    n6 += 2;
                } else {
                    n2 = 0;
                    byteBuf2.setBytes(n6 + 2, byteBuf, n3, n4);
                    n3 = n4;
                }
            }
            byteBuf2.setShort(n6, n4);
            byteBuf2.setByte(n5 + 3, n2 | (object != null ? 16 : 0));
            byteBuf2.writerIndex(n6 + 2 + n3);
            byteBuf.skipBytes(n4);
        }
        return;
    }
}

