/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.skiko.LibraryLoadException;
import org.jetbrains.skiko.OS;
import org.jetbrains.skiko.OsArch_jvmKt;
import org.jetbrains.skiko.Setup;
import org.jetbrains.skiko.SkikoProperties;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0006\u0010\t\u001a\u00020\bJ\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J \u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/skiko/Library;", "", "()V", "copyDir", "Ljava/io/File;", "loaded", "Ljava/util/concurrent/atomic/AtomicBoolean;", "findAndLoad", "", "load", "loadLibraryOrCopy", "library", "unpackIfNeeded", "dest", "resourceName", "", "deleteOnExit", "", "skiko"})
public final class Library {
    public static final Library INSTANCE = new Library();
    private static File copyDir;
    private static AtomicBoolean loaded;

    private Library() {
    }

    private final void loadLibraryOrCopy(File copyOptionArray) {
        try {
            System.load(copyOptionArray.getAbsolutePath());
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Serializable serializable = unsatisfiedLinkError;
            String string = unsatisfiedLinkError.getMessage();
            boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"already loaded in another classloader", (boolean)false, (int)2, null) : false;
            if (bl) {
                copyDir = Files.createTempDirectory("skiko", new FileAttribute[0]).toFile();
                Intrinsics.checkNotNull((Object)copyDir);
                String string2 = copyOptionArray.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
                serializable = FilesKt.resolve((File)copyDir, (String)string2);
                Path path = copyOptionArray.toPath();
                CopyOption[] copyOptionArray2 = new CopyOption[1];
                copyOptionArray = copyOptionArray2;
                copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
                Files.copy(path, ((File)serializable).toPath(), copyOptionArray);
                ((File)serializable).deleteOnExit();
                System.load(((File)serializable).getAbsolutePath());
                return;
            }
            throw serializable;
        }
    }

    private final File unpackIfNeeded(File file, String copyOptionArray, boolean bl) {
        File file2;
        block5: {
            file2 = new File(file, (String)copyOptionArray);
            if (file2.exists()) break block5;
            file = File.createTempFile("skiko", "", file);
            if (bl) {
                file2.deleteOnExit();
            }
            copyOptionArray = Library.class.getResourceAsStream("/" + (String)copyOptionArray);
            Throwable throwable = null;
            try {
                CopyOption[] copyOptionArray2 = copyOptionArray;
                CopyOption[] copyOptionArray3 = copyOptionArray2;
                CopyOption[] copyOptionArray4 = new CopyOption[1];
                copyOptionArray3 = copyOptionArray4;
                copyOptionArray4[0] = StandardCopyOption.REPLACE_EXISTING;
                Files.copy((InputStream)copyOptionArray2, file.toPath(), copyOptionArray3);
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    CloseableKt.closeFinally((Closeable)copyOptionArray, (Throwable)throwable);
                    throw throwable4;
                }
            }
            CloseableKt.closeFinally((Closeable)copyOptionArray, null);
            CopyOption[] copyOptionArray5 = new CopyOption[1];
            copyOptionArray = copyOptionArray5;
            copyOptionArray5[0] = StandardCopyOption.ATOMIC_MOVE;
            Files.move(file.toPath(), file2.toPath(), copyOptionArray);
        }
        return file2;
    }

    public final synchronized void load() {
        if (!loaded.compareAndSet(false, true)) {
            return;
        }
        this.findAndLoad();
        Setup.init$default(Setup.INSTANCE, false, false, false, false, false, 31, null);
        try {
            org.jetbrains.skia.impl.Library.Companion._nAfterLoad();
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            return;
        }
    }

    private final void findAndLoad() {
        Object object;
        String string;
        String string2 = "skiko-" + OsArch_jvmKt.getHostId();
        string2 = System.mapLibraryName(string2);
        String string3 = string = OsArch_jvmKt.getHostOs().isWindows() ? "icudtl.dat" : null;
        if (OsArch_jvmKt.getHostOs() == OS.Android) {
            System.loadLibrary("skiko-" + OsArch_jvmKt.getHostId());
            return;
        }
        Object object2 = SkikoProperties.INSTANCE.getLibraryPath();
        if (object2 != null) {
            object2 = new File(new File((String)object2), string2);
            this.loadLibraryOrCopy((File)object2);
            if (string != null && copyDir != null) {
                File file = copyDir;
                Intrinsics.checkNotNull((Object)file);
                this.unpackIfNeeded(file, string, true);
            }
            return;
        }
        object2 = new File(System.getProperty("java.home"), OsArch_jvmKt.getHostOs().isWindows() ? "bin" : "lib");
        Intrinsics.checkNotNull((Object)string2);
        Serializable serializable = FilesKt.resolve((File)object2, (String)string2);
        if (serializable.exists()) {
            String string4 = string;
            if (!(string4 != null ? !FilesKt.resolve((File)object2, (String)(object = string4)).exists() : false)) {
                this.loadLibraryOrCopy((File)serializable);
                return;
            }
        }
        if ((object = Library.class.getResourceAsStream("/" + string2 + ".sha256")) == null) {
            throw new LibraryLoadException("Cannot find " + string2 + ".sha256, proper native dependency missing.");
        }
        object2 = object;
        object2 = (Closeable)object2;
        serializable = null;
        try {
            object = (InputStream)object2;
            Charset charset = Charsets.UTF_8;
            object = new InputStreamReader((InputStream)object, charset);
            object = new BufferedReader((Reader)object, 8192).readLine();
        }
        catch (Throwable throwable) {
            try {
                object = throwable;
                serializable = throwable;
                throw object;
            }
            catch (Throwable throwable2) {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)serializable);
                throw throwable2;
            }
        }
        CloseableKt.closeFinally((Closeable)object2, null);
        object2 = new File(new File(SkikoProperties.INSTANCE.getDataPath()), (String)object);
        ((File)object2).mkdirs();
        serializable = this.unpackIfNeeded((File)object2, string2, false);
        this.loadLibraryOrCopy((File)serializable);
        if (string != null) {
            if (copyDir != null) {
                File file = copyDir;
                Intrinsics.checkNotNull((Object)file);
                this.unpackIfNeeded(file, string, true);
                return;
            }
            this.unpackIfNeeded((File)object2, string, false);
        }
    }

    static {
        loaded = new AtomicBoolean(false);
    }
}

