/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections;

import java.util.Arrays;
import java.util.Iterator;
import java.util.RandomAccess;
import kotlin.Metadata;
import kotlin.collections.AbstractCollection;
import kotlin.collections.AbstractIterator;
import kotlin.collections.AbstractList;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.RingBuffer;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010(\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00060\u0003j\u0002`\u0004B\u001f\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bB\u0011\b\u0016\u0012\u0006\u0010\f\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\rJ\u0016\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\tH\u0096\u0002\u00a2\u0006\u0002\u0010\u0016J\u0006\u0010\u0017\u001a\u00020\u0018J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0096\u0002J'\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0006\"\u0004\b\u0001\u0010\u00012\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0006H\u0014\u00a2\u0006\u0002\u0010\u001dJ\u0015\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006H\u0014\u00a2\u0006\u0002\u0010\u001eJ\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010 \u001a\u00020\tJ\u0013\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00028\u0000\u00a2\u0006\u0002\u0010$J\u000e\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\tJ\u0015\u0010'\u001a\u00020\t*\u00020\t2\u0006\u0010&\u001a\u00020\tH\u0082\bR\u0018\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006("}, d2={"Lkotlin/collections/RingBuffer;", "T", "Lkotlin/collections/AbstractList;", "Ljava/util/RandomAccess;", "Lkotlin/collections/RandomAccess;", "buffer", "", "", "filledSize", "", "<init>", "([Ljava/lang/Object;I)V", "capacity", "(I)V", "[Ljava/lang/Object;", "startIndex", "value", "size", "getSize", "()I", "get", "index", "(I)Ljava/lang/Object;", "isFull", "", "iterator", "", "toArray", "array", "([Ljava/lang/Object;)[Ljava/lang/Object;", "()[Ljava/lang/Object;", "expanded", "maxCapacity", "add", "", "element", "(Ljava/lang/Object;)V", "removeFirst", "n", "forward", "kotlin-stdlib"})
final class RingBuffer<T>
extends AbstractList<T>
implements RandomAccess {
    private final Object[] buffer;
    private final int capacity;
    private int startIndex;
    private int size;

    public RingBuffer(Object[] object, int n) {
        Intrinsics.checkNotNullParameter(object, "");
        this.buffer = object;
        if (!(n >= 0)) {
            object = "ring buffer filled size should not be negative but it is " + n;
            throw new IllegalArgumentException(object.toString());
        }
        if (!(n <= this.buffer.length)) {
            object = "ring buffer filled size: " + n + " cannot be larger than the buffer size: " + this.buffer.length;
            throw new IllegalArgumentException(object.toString());
        }
        this.capacity = this.buffer.length;
        this.size = n;
    }

    public RingBuffer(int n) {
        this(new Object[n], 0);
    }

    @Override
    public final int getSize() {
        return this.size;
    }

    @Override
    public final T get(int n) {
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(n, this.size());
        RingBuffer ringBuffer = this;
        int n2 = this.startIndex;
        return (T)this.buffer[(n2 + n) % ringBuffer.capacity];
    }

    public final boolean isFull() {
        return this.size() == this.capacity;
    }

    @Override
    public final Iterator<T> iterator() {
        return new AbstractIterator<T>(this){
            private int count;
            private int index;
            final /* synthetic */ RingBuffer<T> this$0;
            {
                this.this$0 = ringBuffer;
                this.count = ringBuffer.size();
                this.index = RingBuffer.access$getStartIndex$p(ringBuffer);
            }

            protected final void computeNext() {
                if (this.count == 0) {
                    this.done();
                    return;
                }
                iterator.1 v0 = this;
                v0.setNext(RingBuffer.access$getBuffer$p(v0.this$0)[this.index]);
                RingBuffer<T> ringBuffer = this.this$0;
                int n = this.index;
                this.index = (n + 1) % RingBuffer.access$getCapacity$p(ringBuffer);
                int n2 = this.count;
                this.count = n2 + -1;
            }
        };
    }

    @Override
    public final <T> T[] toArray(T[] TArray) {
        int n;
        T[] TArray2;
        Intrinsics.checkNotNullParameter(TArray, "");
        if (TArray.length < this.size()) {
            T[] TArray3 = Arrays.copyOf(TArray, this.size());
            TArray2 = TArray3;
            Intrinsics.checkNotNullExpressionValue(TArray3, "");
        } else {
            TArray2 = TArray;
        }
        TArray = TArray2;
        int n2 = this.size();
        int n3 = 0;
        for (n = this.startIndex; n3 < n2 && n < this.capacity; ++n3, ++n) {
            TArray[n3] = this.buffer[n];
        }
        n = 0;
        while (n3 < n2) {
            TArray[n3] = this.buffer[n];
            ++n3;
            ++n;
        }
        return CollectionsKt.terminateCollectionToArray(n2, TArray);
    }

    @Override
    public final Object[] toArray() {
        RingBuffer ringBuffer = this;
        return ((AbstractCollection)ringBuffer).toArray(new Object[ringBuffer.size()]);
    }

    public final RingBuffer<T> expanded(int n) {
        Object[] objectArray;
        n = RangesKt.coerceAtMost(this.capacity + (this.capacity >> 1) + 1, n);
        if (this.startIndex == 0) {
            Object[] objectArray2 = Arrays.copyOf(this.buffer, n);
            objectArray = objectArray2;
            Intrinsics.checkNotNullExpressionValue(objectArray2, "");
        } else {
            objectArray = ((AbstractCollection)this).toArray(new Object[n]);
        }
        Object[] objectArray3 = objectArray;
        return new RingBuffer<T>(objectArray3, this.size());
    }

    public final void add(T t) {
        if (this.isFull()) {
            throw new IllegalStateException("ring buffer is full");
        }
        RingBuffer ringBuffer = this;
        int n = this.startIndex;
        int n2 = this.size();
        this.buffer[(n + n2) % ((RingBuffer)ringBuffer).capacity] = t;
        int n3 = this.size();
        this.size = n3 + 1;
    }

    public final void removeFirst(int n) {
        if (!(n >= 0)) {
            String string = "n shouldn't be negative but it is " + n;
            throw new IllegalArgumentException(string.toString());
        }
        if (!(n <= this.size())) {
            String string = "n shouldn't be greater than the buffer size: n = " + n + ", size = " + this.size();
            throw new IllegalArgumentException(string.toString());
        }
        if (n > 0) {
            int n2 = this.startIndex;
            RingBuffer ringBuffer = this;
            int n3 = (n2 + n) % ringBuffer.capacity;
            if (n2 > n3) {
                ArraysKt.fill(this.buffer, null, n2, this.capacity);
                ArraysKt.fill(this.buffer, null, 0, n3);
            } else {
                ArraysKt.fill(this.buffer, null, n2, n3);
            }
            this.startIndex = n3;
            this.size = this.size() - n;
        }
    }

    private final int forward(int n, int n2) {
        return (n + n2) % this.capacity;
    }

    public static final /* synthetic */ int access$getStartIndex$p(RingBuffer ringBuffer) {
        return ringBuffer.startIndex;
    }

    public static final /* synthetic */ Object[] access$getBuffer$p(RingBuffer ringBuffer) {
        return ringBuffer.buffer;
    }
}

