/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text;

import androidx.compose.foundation.text.TextAutoSize;
import androidx.compose.foundation.text.modifiers.TextAutoSizeLayoutScope;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.style.TextOverflow;
import androidx.compose.ui.unit.TextUnit;
import androidx.compose.ui.unit.TextUnitKt;
import androidx.compose.ui.unit.TextUnitType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J#\u0010\t\u001a\u00020\u0003*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0013H\u0002J\f\u0010\u0014\u001a\u00020\u0012*\u00020\u0013H\u0002J\f\u0010\u0015\u001a\u00020\u0012*\u00020\u0013H\u0002J\u0013\u0010\u0016\u001a\u00020\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0010\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u0010\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0010\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u001b"}, d2={"Landroidx/compose/foundation/text/AutoSizeStepBased;", "Landroidx/compose/foundation/text/TextAutoSize;", "minFontSize", "Landroidx/compose/ui/unit/TextUnit;", "maxFontSize", "stepSize", "<init>", "(JJJLkotlin/jvm/internal/DefaultConstructorMarker;)V", "J", "getFontSize", "Landroidx/compose/foundation/text/modifiers/TextAutoSizeLayoutScope;", "constraints", "Landroidx/compose/ui/unit/Constraints;", "text", "Landroidx/compose/ui/text/AnnotatedString;", "getFontSize-Ci0_558", "(Landroidx/compose/foundation/text/modifiers/TextAutoSizeLayoutScope;JLandroidx/compose/ui/text/AnnotatedString;)J", "didOverflow", "", "Landroidx/compose/ui/text/TextLayoutResult;", "didOverflowBounds", "didOverflowByEllipsize", "equals", "other", "", "hashCode", "", "foundation"})
final class AutoSizeStepBased
implements TextAutoSize {
    private long minFontSize;
    private final long maxFontSize;
    private final long stepSize;

    private AutoSizeStepBased(long l2, long l3, long l4) {
        long l5;
        long l6;
        this.minFontSize = l2;
        this.maxFontSize = l3;
        this.stepSize = l4;
        if (TextUnit.equals-impl0((long)this.minFontSize, (long)TextUnit.Companion.getUnspecified-XSAIIZE())) {
            throw new IllegalArgumentException("AutoSize.StepBased: TextUnit.Unspecified is not a valid value for minFontSize. Try using other values e.g. 10.sp");
        }
        if (TextUnit.equals-impl0((long)this.maxFontSize, (long)TextUnit.Companion.getUnspecified-XSAIIZE())) {
            throw new IllegalArgumentException("AutoSize.StepBased: TextUnit.Unspecified is not a valid value for maxFontSize. Try using other values e.g. 100.sp");
        }
        if (TextUnit.equals-impl0((long)this.stepSize, (long)TextUnit.Companion.getUnspecified-XSAIIZE())) {
            throw new IllegalArgumentException("AutoSize.StepBased: TextUnit.Unspecified is not a valid value for stepSize. Try using other values e.g. 0.25.sp");
        }
        if (TextUnitType.equals-impl0((long)TextUnit.getType-UIouoOA((long)this.minFontSize), (long)TextUnit.getType-UIouoOA((long)this.maxFontSize))) {
            l6 = this.minFontSize;
            l5 = this.maxFontSize;
            TextUnitKt.checkArithmetic-NB67dxo((long)l6, (long)l5);
            if (Float.compare(TextUnit.getValue-impl((long)l6), TextUnit.getValue-impl((long)l5)) > 0) {
                this.minFontSize = this.maxFontSize;
            }
        }
        if (TextUnitType.equals-impl0((long)TextUnit.getType-UIouoOA((long)this.stepSize), (long)TextUnitType.Companion.getSp-UIouoOA())) {
            l6 = this.stepSize;
            l5 = TextUnitKt.getSp((float)1.0E-4f);
            TextUnitKt.checkArithmetic-NB67dxo((long)l6, (long)l5);
            if (Float.compare(TextUnit.getValue-impl((long)l6), TextUnit.getValue-impl((long)l5)) < 0) {
                throw new IllegalArgumentException("AutoSize.StepBased: stepSize must be greater than or equal to 0.0001f.sp");
            }
        }
        if (TextUnit.getValue-impl((long)this.minFontSize) < 0.0f) {
            throw new IllegalArgumentException("AutoSize.StepBased: minFontSize must not be negative");
        }
        if (TextUnit.getValue-impl((long)this.maxFontSize) < 0.0f) {
            throw new IllegalArgumentException("AutoSize.StepBased: maxFontSize must not be negative");
        }
    }

    @Override
    public final long getFontSize-Ci0_558(TextAutoSizeLayoutScope textAutoSizeLayoutScope, long l2, AnnotatedString annotatedString) {
        float f2;
        TextLayoutResult textLayoutResult;
        Intrinsics.checkNotNullParameter((Object)textAutoSizeLayoutScope, (String)"");
        Intrinsics.checkNotNullParameter((Object)annotatedString, (String)"");
        float f3 = textAutoSizeLayoutScope.toPx--R2X_6o(this.stepSize);
        float f4 = textAutoSizeLayoutScope.toPx--R2X_6o(this.minFontSize);
        float f5 = textAutoSizeLayoutScope.toPx--R2X_6o(this.maxFontSize);
        float f6 = f4;
        float f7 = f5;
        float f8 = (f4 + f5) / 2.0f;
        while (f7 - f6 >= f3) {
            textLayoutResult = textAutoSizeLayoutScope.performLayout-5ZSfY2I(l2, annotatedString, textAutoSizeLayoutScope.toSp-kPz2Gy4(f8));
            if (this.didOverflow(textLayoutResult)) {
                f7 = f8;
            } else {
                f6 = f8;
            }
            f8 = (f6 + f7) / 2.0f;
        }
        f8 = (float)Math.floor((f6 - f4) / f3) * f3 + f4;
        if (f2 + f3 <= f5 && !this.didOverflow(textLayoutResult = textAutoSizeLayoutScope.performLayout-5ZSfY2I(l2, annotatedString, textAutoSizeLayoutScope.toSp-kPz2Gy4(f8 + f3)))) {
            f8 += f3;
        }
        return textAutoSizeLayoutScope.toSp-kPz2Gy4(f8);
    }

    private final boolean didOverflow(TextLayoutResult textLayoutResult) {
        int n2 = textLayoutResult.getLayoutInput().getOverflow-gIe3tQ8();
        if (TextOverflow.equals-impl0((int)n2, (int)TextOverflow.Companion.getClip-gIe3tQ8()) || TextOverflow.equals-impl0((int)n2, (int)TextOverflow.Companion.getVisible-gIe3tQ8())) {
            return this.didOverflowBounds(textLayoutResult);
        }
        if (TextOverflow.equals-impl0((int)n2, (int)TextOverflow.Companion.getStartEllipsis-gIe3tQ8()) || TextOverflow.equals-impl0((int)n2, (int)TextOverflow.Companion.getMiddleEllipsis-gIe3tQ8()) || TextOverflow.equals-impl0((int)n2, (int)TextOverflow.Companion.getEllipsis-gIe3tQ8())) {
            return this.didOverflowByEllipsize(textLayoutResult);
        }
        throw new IllegalArgumentException("TextOverflow type " + TextOverflow.toString-impl((int)textLayoutResult.getLayoutInput().getOverflow-gIe3tQ8()) + " is not supported.");
    }

    private final boolean didOverflowBounds(TextLayoutResult textLayoutResult) {
        return textLayoutResult.getDidOverflowWidth() || textLayoutResult.getDidOverflowHeight();
    }

    private final boolean didOverflowByEllipsize(TextLayoutResult textLayoutResult) {
        switch (textLayoutResult.getLineCount()) {
            case 0: {
                return false;
            }
            case 1: {
                return textLayoutResult.isLineEllipsized(0);
            }
        }
        int n2 = textLayoutResult.getLayoutInput().getOverflow-gIe3tQ8();
        if (TextOverflow.equals-impl0((int)n2, (int)TextOverflow.Companion.getStartEllipsis-gIe3tQ8()) || TextOverflow.equals-impl0((int)n2, (int)TextOverflow.Companion.getMiddleEllipsis-gIe3tQ8())) {
            return this.didOverflowBounds(textLayoutResult);
        }
        if (TextOverflow.equals-impl0((int)n2, (int)TextOverflow.Companion.getEllipsis-gIe3tQ8())) {
            TextLayoutResult textLayoutResult2 = textLayoutResult;
            return textLayoutResult2.isLineEllipsized(textLayoutResult2.getLineCount() - 1);
        }
        return false;
    }

    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof AutoSizeStepBased)) {
            return false;
        }
        if (!TextUnit.equals-impl0((long)((AutoSizeStepBased)object).minFontSize, (long)this.minFontSize)) {
            return false;
        }
        if (!TextUnit.equals-impl0((long)((AutoSizeStepBased)object).maxFontSize, (long)this.maxFontSize)) {
            return false;
        }
        return TextUnit.equals-impl0((long)((AutoSizeStepBased)object).stepSize, (long)this.stepSize);
    }

    @Override
    public final int hashCode() {
        int n2 = TextUnit.hashCode-impl((long)this.minFontSize);
        n2 = n2 * 31 + TextUnit.hashCode-impl((long)this.maxFontSize);
        n2 = n2 * 31 + TextUnit.hashCode-impl((long)this.stepSize);
        return n2;
    }

    public /* synthetic */ AutoSizeStepBased(long l2, long l3, long l4, DefaultConstructorMarker defaultConstructorMarker) {
        this(l2, l3, l4);
    }
}

