/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text;

import androidx.compose.foundation.internal.InlineClassHelperKt;
import androidx.compose.foundation.text.ValidatingOffsetMapping;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.input.OffsetMapping;
import androidx.compose.ui.text.input.TransformedText;
import androidx.compose.ui.text.input.VisualTransformation;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\u001a\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u001e\u0010\t\u001a\u00020\n*\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fH\u0001\u001a \u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0002\u001a \u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0002\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0014"}, d2={"ValidatingEmptyOffsetMappingIdentity", "Landroidx/compose/ui/text/input/OffsetMapping;", "getValidatingEmptyOffsetMappingIdentity", "()Landroidx/compose/ui/text/input/OffsetMapping;", "filterWithValidation", "Landroidx/compose/ui/text/input/TransformedText;", "Landroidx/compose/ui/text/input/VisualTransformation;", "text", "Landroidx/compose/ui/text/AnnotatedString;", "throwIfNotValidTransform", "", "originalLength", "", "limit", "validateTransformedToOriginal", "originalOffset", "offset", "validateOriginalToTransformed", "transformedOffset", "transformedLength", "foundation"})
public final class ValidatingOffsetMappingKt {
    private static final OffsetMapping ValidatingEmptyOffsetMappingIdentity = new ValidatingOffsetMapping(OffsetMapping.Companion.getIdentity(), 0, 0);

    public static final OffsetMapping getValidatingEmptyOffsetMappingIdentity() {
        return ValidatingEmptyOffsetMappingIdentity;
    }

    public static final TransformedText filterWithValidation(VisualTransformation visualTransformation, AnnotatedString annotatedString) {
        Intrinsics.checkNotNullParameter((Object)visualTransformation, (String)"");
        Intrinsics.checkNotNullParameter((Object)annotatedString, (String)"");
        visualTransformation = visualTransformation.filter(annotatedString);
        ValidatingOffsetMappingKt.throwIfNotValidTransform$default((TransformedText)visualTransformation, annotatedString.length(), 0, 2, null);
        return new TransformedText(visualTransformation.getText(), (OffsetMapping)new ValidatingOffsetMapping(visualTransformation.getOffsetMapping(), annotatedString.length(), visualTransformation.getText().length()));
    }

    public static final void throwIfNotValidTransform(TransformedText transformedText, int n2, int n3) {
        int n4;
        int n5;
        Intrinsics.checkNotNullParameter((Object)transformedText, (String)"");
        int n6 = transformedText.getText().length();
        int n7 = Math.min(n2, n3);
        for (n5 = 0; n5 < n7; ++n5) {
            n4 = transformedText.getOffsetMapping().originalToTransformed(n5);
            ValidatingOffsetMappingKt.validateOriginalToTransformed(n4, n6, n5);
        }
        n5 = transformedText.getOffsetMapping().originalToTransformed(n2);
        ValidatingOffsetMappingKt.validateOriginalToTransformed(n5, n6, n2);
        n4 = Math.min(n6, n3);
        for (n7 = 0; n7 < n4; ++n7) {
            n3 = transformedText.getOffsetMapping().transformedToOriginal(n7);
            ValidatingOffsetMappingKt.validateTransformedToOriginal(n3, n2, n7);
        }
        n7 = transformedText.getOffsetMapping().transformedToOriginal(n6);
        ValidatingOffsetMappingKt.validateTransformedToOriginal(n7, n2, n6);
    }

    public static /* synthetic */ void throwIfNotValidTransform$default(TransformedText transformedText, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n3 = 100;
        }
        ValidatingOffsetMappingKt.throwIfNotValidTransform(transformedText, n2, n3);
    }

    private static final void validateTransformedToOriginal(int n2, int n3, int n4) {
        boolean bl;
        boolean bl2 = n2 >= 0 ? n2 <= n3 : (bl = false);
        if (!bl2) {
            InlineClassHelperKt.throwIllegalStateException("OffsetMapping.transformedToOriginal returned invalid mapping: " + n4 + " -> " + n2 + " is not in range of original text [0, " + n3 + "]");
        }
    }

    private static final void validateOriginalToTransformed(int n2, int n3, int n4) {
        boolean bl;
        boolean bl2 = n2 >= 0 ? n2 <= n3 : (bl = false);
        if (!bl2) {
            InlineClassHelperKt.throwIllegalStateException("OffsetMapping.originalToTransformed returned invalid mapping: " + n4 + " -> " + n2 + " is not in range of transformed text [0, " + n3 + "]");
        }
    }

    public static final /* synthetic */ void access$validateOriginalToTransformed(int n2, int n3, int n4) {
        ValidatingOffsetMappingKt.validateOriginalToTransformed(n2, n3, n4);
    }

    public static final /* synthetic */ void access$validateTransformedToOriginal(int n2, int n3, int n4) {
        ValidatingOffsetMappingKt.validateTransformedToOriginal(n2, n3, n4);
    }
}

