/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.input.internal.selection;

import androidx.compose.foundation.text.StringHelpersKt;
import androidx.compose.foundation.text.StringHelpers_skikoKt;
import androidx.compose.foundation.text.input.TextFieldCharSequence;
import androidx.compose.foundation.text.input.internal.SelectionWedgeAffinity;
import androidx.compose.foundation.text.input.internal.TransformedTextFieldState;
import androidx.compose.foundation.text.input.internal.WedgeAffinity;
import androidx.compose.foundation.text.input.internal.selection.CursorAndWedgeAffinity;
import androidx.compose.foundation.text.input.internal.selection.TextFieldPreparedSelectionState;
import androidx.compose.foundation.text.input.internal.selection.TextPreparedSelectionKt;
import androidx.compose.runtime.snapshots.Snapshot;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.style.ResolvedTextDirection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b#\b\u0001\u0018\u0000 Y2\u00020\u0001:\u0001YB1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ,\u0010%\u001a\u00020\u00002\b\b\u0002\u0010&\u001a\u00020\u00072\u0017\u0010'\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020)0(\u00a2\u0006\u0002\b*H\u0082\bJ\u0006\u0010+\u001a\u00020\u0000J\u0006\u0010,\u001a\u00020\u0000J\u0006\u0010-\u001a\u00020\u0000J\u0006\u0010.\u001a\u00020\u0000J\u001f\u0010/\u001a\u00020\u00002\u0017\u00100\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020)0(\u00a2\u0006\u0002\b*J\u001f\u00101\u001a\u00020\u00002\u0017\u00100\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020)0(\u00a2\u0006\u0002\b*J\u0006\u00102\u001a\u000203J\u0006\u00104\u001a\u000203J!\u00105\u001a\u00020\u00002\b\b\u0002\u0010&\u001a\u00020\u00072\f\u00106\u001a\b\u0012\u0004\u0012\u00020307H\u0082\bJ\u0006\u00108\u001a\u00020\u0000J\u0006\u00109\u001a\u00020\u0000J\u0006\u0010:\u001a\u00020\u0000J\u0006\u0010;\u001a\u00020\u0000J\u0006\u0010<\u001a\u00020\u0000J\u0006\u0010=\u001a\u00020\u0000J\u0006\u0010>\u001a\u00020\u0000J\u0006\u0010?\u001a\u00020\u0000J\u0006\u0010@\u001a\u00020\u0000J\u0006\u0010A\u001a\u00020\u0000J\u0006\u0010B\u001a\u00020\u0000J\u0006\u0010C\u001a\u00020\u0000J\u0006\u0010D\u001a\u00020\u0000J\u0006\u0010E\u001a\u00020\u0000J\u0006\u0010F\u001a\u00020\u0000J\u0006\u0010G\u001a\u00020\u0000J\u0006\u0010H\u001a\u00020\u0000J\u0006\u0010I\u001a\u00020\u0000J\u0006\u0010J\u001a\u00020\u0000J\u0006\u0010K\u001a\u00020\u0000J\u0006\u0010L\u001a\u00020\u0000J\b\u0010M\u001a\u00020\u0007H\u0002J\u0017\u0010N\u001a\u000203*\u00020\u00052\b\b\u0002\u0010O\u001a\u000203H\u0082\u0010J\u0017\u0010P\u001a\u000203*\u00020\u00052\b\b\u0002\u0010O\u001a\u000203H\u0082\u0010J\u0016\u0010Q\u001a\u000203*\u00020\u00052\b\b\u0002\u0010O\u001a\u000203H\u0002J\u0016\u0010R\u001a\u000203*\u00020\u00052\b\b\u0002\u0010O\u001a\u000203H\u0002J\u0014\u0010S\u001a\u000203*\u00020\u00052\u0006\u0010T\u001a\u000203H\u0002J\u0010\u0010U\u001a\u0002032\u0006\u0010V\u001a\u000203H\u0002J\u0010\u0010W\u001a\u0002032\u0006\u0010X\u001a\u000203H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001c\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Landroidx/compose/foundation/text/input/internal/selection/SelectionMovementDeletionContext;", "", "state", "Landroidx/compose/foundation/text/input/internal/TransformedTextFieldState;", "textLayoutResult", "Landroidx/compose/ui/text/TextLayoutResult;", "isFromSoftKeyboard", "", "visibleTextLayoutHeight", "", "textPreparedSelectionState", "Landroidx/compose/foundation/text/input/internal/selection/TextFieldPreparedSelectionState;", "<init>", "(Landroidx/compose/foundation/text/input/internal/TransformedTextFieldState;Landroidx/compose/ui/text/TextLayoutResult;ZFLandroidx/compose/foundation/text/input/internal/selection/TextFieldPreparedSelectionState;)V", "initialValue", "Landroidx/compose/foundation/text/input/TextFieldCharSequence;", "getInitialValue", "()Landroidx/compose/foundation/text/input/TextFieldCharSequence;", "initialWedgeAffinity", "Landroidx/compose/foundation/text/input/internal/SelectionWedgeAffinity;", "getInitialWedgeAffinity", "()Landroidx/compose/foundation/text/input/internal/SelectionWedgeAffinity;", "selection", "Landroidx/compose/ui/text/TextRange;", "getSelection-d9O1mEE", "()J", "setSelection-5zc-tL8", "(J)V", "J", "wedgeAffinity", "Landroidx/compose/foundation/text/input/internal/WedgeAffinity;", "getWedgeAffinity", "()Landroidx/compose/foundation/text/input/internal/WedgeAffinity;", "setWedgeAffinity", "(Landroidx/compose/foundation/text/input/internal/WedgeAffinity;)V", "text", "", "applyIfNotEmpty", "resetCachedX", "block", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "selectAll", "deselect", "moveCursorLeftByChar", "moveCursorRightByChar", "collapseLeftOr", "or", "collapseRightOr", "getPrecedingCharacterIndex", "", "getNextCharacterIndex", "moveCursorTo", "proposedCursorMovement", "Lkotlin/Function0;", "moveCursorPrevByCodePointOrEmoji", "moveCursorPrevByChar", "moveCursorNextByChar", "moveCursorToHome", "moveCursorToEnd", "moveCursorLeftByWord", "moveCursorRightByWord", "moveCursorNextByWord", "moveCursorPrevByWord", "moveCursorPrevByParagraph", "moveCursorNextByParagraph", "moveCursorUpByLine", "moveCursorDownByLine", "moveCursorToLineLeftSide", "moveCursorToLineRightSide", "moveCursorToLineStart", "moveCursorToLineEnd", "moveCursorUpByPage", "moveCursorDownByPage", "selectMovement", "deleteMovement", "isLtr", "getNextWordOffsetForLayout", "currentOffset", "getPrevWordOffsetForLayout", "getLineStartByOffsetForLayout", "getLineEndByOffsetForLayout", "jumpByLinesOffset", "linesAmount", "jumpByPagesOffset", "pagesAmount", "charOffset", "offset", "Companion", "foundation"})
public final class SelectionMovementDeletionContext {
    public static final Companion Companion = new Companion(null);
    private final TransformedTextFieldState state;
    private final TextLayoutResult textLayoutResult;
    private final boolean isFromSoftKeyboard;
    private final float visibleTextLayoutHeight;
    private final TextFieldPreparedSelectionState textPreparedSelectionState;
    private final TextFieldCharSequence initialValue;
    private final SelectionWedgeAffinity initialWedgeAffinity;
    private long selection;
    private WedgeAffinity wedgeAffinity;
    private final String text;
    public static final int $stable = 8;
    public static final int NoCharacterFound = -1;

    public SelectionMovementDeletionContext(TransformedTextFieldState transformedTextFieldState, TextLayoutResult textLayoutResult, boolean bl, float f2, TextFieldPreparedSelectionState textFieldPreparedSelectionState) {
        Intrinsics.checkNotNullParameter((Object)transformedTextFieldState, (String)"");
        Intrinsics.checkNotNullParameter((Object)textFieldPreparedSelectionState, (String)"");
        this.state = transformedTextFieldState;
        this.textLayoutResult = textLayoutResult;
        this.isFromSoftKeyboard = bl;
        this.visibleTextLayoutHeight = f2;
        this.textPreparedSelectionState = textFieldPreparedSelectionState;
        transformedTextFieldState = Snapshot.Companion;
        textLayoutResult = transformedTextFieldState.getCurrentThreadSnapshot();
        Function1 function1 = textLayoutResult != null ? textLayoutResult.getReadObserver() : null;
        Snapshot snapshot = transformedTextFieldState.makeCurrentNonObservable((Snapshot)textLayoutResult);
        try {
            this.initialValue = this.state.getVisualText();
            this.initialWedgeAffinity = this.state.getSelectionWedgeAffinity();
        }
        finally {
            transformedTextFieldState.restoreNonObservable((Snapshot)textLayoutResult, snapshot, function1);
        }
        this.selection = this.initialValue.getSelection-d9O1mEE();
        this.text = ((Object)this.initialValue.getText()).toString();
    }

    public final TextFieldCharSequence getInitialValue() {
        return this.initialValue;
    }

    public final SelectionWedgeAffinity getInitialWedgeAffinity() {
        return this.initialWedgeAffinity;
    }

    public final long getSelection-d9O1mEE() {
        return this.selection;
    }

    public final void setSelection-5zc-tL8(long l2) {
        this.selection = l2;
    }

    public final WedgeAffinity getWedgeAffinity() {
        return this.wedgeAffinity;
    }

    public final void setWedgeAffinity(WedgeAffinity wedgeAffinity) {
        this.wedgeAffinity = wedgeAffinity;
    }

    private final SelectionMovementDeletionContext applyIfNotEmpty(boolean bl, Function1<? super SelectionMovementDeletionContext, Unit> function1) {
        if (bl) {
            this.textPreparedSelectionState.resetCachedX();
        }
        if (((CharSequence)this.text).length() > 0) {
            function1.invoke((Object)this);
        }
        return this;
    }

    static /* synthetic */ SelectionMovementDeletionContext applyIfNotEmpty$default(SelectionMovementDeletionContext selectionMovementDeletionContext, boolean bl, Function1 function1, int n2, Object object) {
        if ((n2 & 1) != 0) {
            bl = true;
        }
        if (bl) {
            selectionMovementDeletionContext.textPreparedSelectionState.resetCachedX();
        }
        if (((CharSequence)selectionMovementDeletionContext.text).length() > 0) {
            function1.invoke((Object)selectionMovementDeletionContext);
        }
        return selectionMovementDeletionContext;
    }

    public final SelectionMovementDeletionContext selectAll() {
        this.textPreparedSelectionState.resetCachedX();
        if (((CharSequence)this.text).length() > 0) {
            SelectionMovementDeletionContext selectionMovementDeletionContext = this;
            this.selection = TextRangeKt.TextRange((int)0, (int)selectionMovementDeletionContext.text.length());
        }
        return this;
    }

    public final SelectionMovementDeletionContext deselect() {
        this.textPreparedSelectionState.resetCachedX();
        if (((CharSequence)this.text).length() > 0) {
            SelectionMovementDeletionContext selectionMovementDeletionContext = this;
            this.selection = TextRangeKt.TextRange((int)TextRange.getEnd-impl((long)selectionMovementDeletionContext.selection));
        }
        return this;
    }

    public final SelectionMovementDeletionContext moveCursorLeftByChar() {
        if (this.isLtr()) {
            return this.moveCursorPrevByChar();
        }
        return this.moveCursorNextByChar();
    }

    public final SelectionMovementDeletionContext moveCursorRightByChar() {
        if (this.isLtr()) {
            return this.moveCursorNextByChar();
        }
        return this.moveCursorPrevByChar();
    }

    public final SelectionMovementDeletionContext collapseLeftOr(Function1<? super SelectionMovementDeletionContext, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"");
        this.textPreparedSelectionState.resetCachedX();
        if (((CharSequence)this.text).length() > 0) {
            SelectionMovementDeletionContext selectionMovementDeletionContext = this;
            if (TextRange.getCollapsed-impl((long)selectionMovementDeletionContext.selection)) {
                function1.invoke((Object)selectionMovementDeletionContext);
            } else {
                selectionMovementDeletionContext.selection = selectionMovementDeletionContext.isLtr() ? TextRangeKt.TextRange((int)TextRange.getMin-impl((long)selectionMovementDeletionContext.selection)) : TextRangeKt.TextRange((int)TextRange.getMax-impl((long)selectionMovementDeletionContext.selection));
            }
        }
        return this;
    }

    public final SelectionMovementDeletionContext collapseRightOr(Function1<? super SelectionMovementDeletionContext, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"");
        this.textPreparedSelectionState.resetCachedX();
        if (((CharSequence)this.text).length() > 0) {
            SelectionMovementDeletionContext selectionMovementDeletionContext = this;
            if (TextRange.getCollapsed-impl((long)selectionMovementDeletionContext.selection)) {
                function1.invoke((Object)selectionMovementDeletionContext);
            } else {
                selectionMovementDeletionContext.selection = selectionMovementDeletionContext.isLtr() ? TextRangeKt.TextRange((int)TextRange.getMax-impl((long)selectionMovementDeletionContext.selection)) : TextRangeKt.TextRange((int)TextRange.getMin-impl((long)selectionMovementDeletionContext.selection));
            }
        }
        return this;
    }

    public final int getPrecedingCharacterIndex() {
        return StringHelpers_skikoKt.findPrecedingBreak(this.text, TextRange.getEnd-impl((long)this.selection));
    }

    public final int getNextCharacterIndex() {
        return StringHelpers_skikoKt.findFollowingBreak(this.text, TextRange.getEnd-impl((long)this.selection));
    }

    private final SelectionMovementDeletionContext moveCursorTo(boolean bl, Function0<Integer> function0) {
        SelectionMovementDeletionContext selectionMovementDeletionContext = this;
        if (bl) {
            selectionMovementDeletionContext.textPreparedSelectionState.resetCachedX();
        }
        if (((CharSequence)selectionMovementDeletionContext.text).length() > 0) {
            SelectionMovementDeletionContext selectionMovementDeletionContext2 = selectionMovementDeletionContext;
            int n2 = TextRange.getEnd-impl((long)selectionMovementDeletionContext2.getSelection-d9O1mEE());
            long l2 = TextPreparedSelectionKt.calculateNextCursorPositionAndWedgeAffinity(((Number)function0.invoke()).intValue(), n2, selectionMovementDeletionContext2.state);
            int n3 = CursorAndWedgeAffinity.component1-impl(l2);
            WedgeAffinity wedgeAffinity = CursorAndWedgeAffinity.component2-impl(l2);
            if (n3 != n2 || !TextRange.getCollapsed-impl((long)selectionMovementDeletionContext2.getSelection-d9O1mEE())) {
                selectionMovementDeletionContext2.setSelection-5zc-tL8(TextRangeKt.TextRange((int)n3));
            }
            if (wedgeAffinity != null) {
                selectionMovementDeletionContext2.setWedgeAffinity(wedgeAffinity);
            }
        }
        return selectionMovementDeletionContext;
    }

    static /* synthetic */ SelectionMovementDeletionContext moveCursorTo$default(SelectionMovementDeletionContext object, boolean n2, Function0 function0, int n3, Object object2) {
        if ((n3 & 1) != 0) {
            n2 = 1;
        }
        object2 = object;
        if (n2 != 0) {
            ((SelectionMovementDeletionContext)object2).textPreparedSelectionState.resetCachedX();
        }
        if (((CharSequence)((SelectionMovementDeletionContext)object2).text).length() > 0) {
            object = object2;
            n2 = TextRange.getEnd-impl((long)((SelectionMovementDeletionContext)object).getSelection-d9O1mEE());
            long l2 = TextPreparedSelectionKt.calculateNextCursorPositionAndWedgeAffinity(((Number)function0.invoke()).intValue(), n2, ((SelectionMovementDeletionContext)object).state);
            int n4 = CursorAndWedgeAffinity.component1-impl(l2);
            WedgeAffinity wedgeAffinity = CursorAndWedgeAffinity.component2-impl(l2);
            if (n4 != n2 || !TextRange.getCollapsed-impl((long)((SelectionMovementDeletionContext)object).getSelection-d9O1mEE())) {
                ((SelectionMovementDeletionContext)object).setSelection-5zc-tL8(TextRangeKt.TextRange((int)n4));
            }
            if (wedgeAffinity != null) {
                ((SelectionMovementDeletionContext)object).setWedgeAffinity(wedgeAffinity);
            }
        }
        return object2;
    }

    public final SelectionMovementDeletionContext moveCursorPrevByCodePointOrEmoji() {
        SelectionMovementDeletionContext selectionMovementDeletionContext = this;
        selectionMovementDeletionContext.textPreparedSelectionState.resetCachedX();
        if (((CharSequence)selectionMovementDeletionContext.text).length() > 0) {
            SelectionMovementDeletionContext selectionMovementDeletionContext2 = selectionMovementDeletionContext;
            int n2 = TextRange.getEnd-impl((long)selectionMovementDeletionContext2.getSelection-d9O1mEE());
            long l2 = TextPreparedSelectionKt.calculateNextCursorPositionAndWedgeAffinity(StringHelpers_skikoKt.findCodePointOrEmojiStartBefore(this.text, TextRange.getEnd-impl((long)this.selection), -1), n2, selectionMovementDeletionContext2.state);
            int n3 = CursorAndWedgeAffinity.component1-impl(l2);
            WedgeAffinity wedgeAffinity = CursorAndWedgeAffinity.component2-impl(l2);
            if (n3 != n2 || !TextRange.getCollapsed-impl((long)selectionMovementDeletionContext2.getSelection-d9O1mEE())) {
                selectionMovementDeletionContext2.setSelection-5zc-tL8(TextRangeKt.TextRange((int)n3));
            }
            if (wedgeAffinity != null) {
                selectionMovementDeletionContext2.setWedgeAffinity(wedgeAffinity);
            }
        }
        return selectionMovementDeletionContext;
    }

    public final SelectionMovementDeletionContext moveCursorPrevByChar() {
        SelectionMovementDeletionContext selectionMovementDeletionContext = this;
        selectionMovementDeletionContext.textPreparedSelectionState.resetCachedX();
        if (((CharSequence)selectionMovementDeletionContext.text).length() > 0) {
            SelectionMovementDeletionContext selectionMovementDeletionContext2 = selectionMovementDeletionContext;
            int n2 = TextRange.getEnd-impl((long)selectionMovementDeletionContext2.getSelection-d9O1mEE());
            long l2 = TextPreparedSelectionKt.calculateNextCursorPositionAndWedgeAffinity(StringHelpers_skikoKt.findPrecedingBreak(this.text, TextRange.getEnd-impl((long)this.selection)), n2, selectionMovementDeletionContext2.state);
            int n3 = CursorAndWedgeAffinity.component1-impl(l2);
            WedgeAffinity wedgeAffinity = CursorAndWedgeAffinity.component2-impl(l2);
            if (n3 != n2 || !TextRange.getCollapsed-impl((long)selectionMovementDeletionContext2.getSelection-d9O1mEE())) {
                selectionMovementDeletionContext2.setSelection-5zc-tL8(TextRangeKt.TextRange((int)n3));
            }
            if (wedgeAffinity != null) {
                selectionMovementDeletionContext2.setWedgeAffinity(wedgeAffinity);
            }
        }
        return selectionMovementDeletionContext;
    }

    public final SelectionMovementDeletionContext moveCursorNextByChar() {
        SelectionMovementDeletionContext selectionMovementDeletionContext = this;
        selectionMovementDeletionContext.textPreparedSelectionState.resetCachedX();
        if (((CharSequence)selectionMovementDeletionContext.text).length() > 0) {
            SelectionMovementDeletionContext selectionMovementDeletionContext2 = selectionMovementDeletionContext;
            int n2 = TextRange.getEnd-impl((long)selectionMovementDeletionContext2.getSelection-d9O1mEE());
            long l2 = TextPreparedSelectionKt.calculateNextCursorPositionAndWedgeAffinity(StringHelpers_skikoKt.findFollowingBreak(this.text, TextRange.getEnd-impl((long)this.selection)), n2, selectionMovementDeletionContext2.state);
            int n3 = CursorAndWedgeAffinity.component1-impl(l2);
            WedgeAffinity wedgeAffinity = CursorAndWedgeAffinity.component2-impl(l2);
            if (n3 != n2 || !TextRange.getCollapsed-impl((long)selectionMovementDeletionContext2.getSelection-d9O1mEE())) {
                selectionMovementDeletionContext2.setSelection-5zc-tL8(TextRangeKt.TextRange((int)n3));
            }
            if (wedgeAffinity != null) {
                selectionMovementDeletionContext2.setWedgeAffinity(wedgeAffinity);
            }
        }
        return selectionMovementDeletionContext;
    }

    public final SelectionMovementDeletionContext moveCursorToHome() {
        SelectionMovementDeletionContext selectionMovementDeletionContext = this;
        selectionMovementDeletionContext.textPreparedSelectionState.resetCachedX();
        if (((CharSequence)selectionMovementDeletionContext.text).length() > 0) {
            SelectionMovementDeletionContext selectionMovementDeletionContext2 = selectionMovementDeletionContext;
            int n2 = TextRange.getEnd-impl((long)selectionMovementDeletionContext2.getSelection-d9O1mEE());
            long l2 = TextPreparedSelectionKt.calculateNextCursorPositionAndWedgeAffinity(0, n2, selectionMovementDeletionContext2.state);
            int n3 = CursorAndWedgeAffinity.component1-impl(l2);
            WedgeAffinity wedgeAffinity = CursorAndWedgeAffinity.component2-impl(l2);
            if (n3 != n2 || !TextRange.getCollapsed-impl((long)selectionMovementDeletionContext2.getSelection-d9O1mEE())) {
                selectionMovementDeletionContext2.setSelection-5zc-tL8(TextRangeKt.TextRange((int)n3));
            }
            if (wedgeAffinity != null) {
                selectionMovementDeletionContext2.setWedgeAffinity(wedgeAffinity);
            }
        }
        return selectionMovementDeletionContext;
    }

    public final SelectionMovementDeletionContext moveCursorToEnd() {
        SelectionMovementDeletionContext selectionMovementDeletionContext = this;
        selectionMovementDeletionContext.textPreparedSelectionState.resetCachedX();
        if (((CharSequence)selectionMovementDeletionContext.text).length() > 0) {
            SelectionMovementDeletionContext selectionMovementDeletionContext2 = selectionMovementDeletionContext;
            int n2 = TextRange.getEnd-impl((long)selectionMovementDeletionContext2.getSelection-d9O1mEE());
            long l2 = TextPreparedSelectionKt.calculateNextCursorPositionAndWedgeAffinity(this.text.length(), n2, selectionMovementDeletionContext2.state);
            int n3 = CursorAndWedgeAffinity.component1-impl(l2);
            WedgeAffinity wedgeAffinity = CursorAndWedgeAffinity.component2-impl(l2);
            if (n3 != n2 || !TextRange.getCollapsed-impl((long)selectionMovementDeletionContext2.getSelection-d9O1mEE())) {
                selectionMovementDeletionContext2.setSelection-5zc-tL8(TextRangeKt.TextRange((int)n3));
            }
            if (wedgeAffinity != null) {
                selectionMovementDeletionContext2.setWedgeAffinity(wedgeAffinity);
            }
        }
        return selectionMovementDeletionContext;
    }

    public final SelectionMovementDeletionContext moveCursorLeftByWord() {
        if (this.isLtr()) {
            return this.moveCursorPrevByWord();
        }
        return this.moveCursorNextByWord();
    }

    public final SelectionMovementDeletionContext moveCursorRightByWord() {
        if (this.isLtr()) {
            return this.moveCursorNextByWord();
        }
        return this.moveCursorPrevByWord();
    }

    public final SelectionMovementDeletionContext moveCursorNextByWord() {
        SelectionMovementDeletionContext selectionMovementDeletionContext = this;
        selectionMovementDeletionContext.textPreparedSelectionState.resetCachedX();
        if (((CharSequence)selectionMovementDeletionContext.text).length() > 0) {
            SelectionMovementDeletionContext selectionMovementDeletionContext2 = selectionMovementDeletionContext;
            int n2 = TextRange.getEnd-impl((long)selectionMovementDeletionContext2.getSelection-d9O1mEE());
            TextLayoutResult textLayoutResult = this.textLayoutResult;
            long l2 = TextPreparedSelectionKt.calculateNextCursorPositionAndWedgeAffinity(textLayoutResult != null ? SelectionMovementDeletionContext.getNextWordOffsetForLayout$default(this, textLayoutResult, 0, 1, null) : this.text.length(), n2, selectionMovementDeletionContext2.state);
            int n3 = CursorAndWedgeAffinity.component1-impl(l2);
            WedgeAffinity wedgeAffinity = CursorAndWedgeAffinity.component2-impl(l2);
            if (n3 != n2 || !TextRange.getCollapsed-impl((long)selectionMovementDeletionContext2.getSelection-d9O1mEE())) {
                selectionMovementDeletionContext2.setSelection-5zc-tL8(TextRangeKt.TextRange((int)n3));
            }
            if (wedgeAffinity != null) {
                selectionMovementDeletionContext2.setWedgeAffinity(wedgeAffinity);
            }
        }
        return selectionMovementDeletionContext;
    }

    public final SelectionMovementDeletionContext moveCursorPrevByWord() {
        SelectionMovementDeletionContext selectionMovementDeletionContext = this;
        selectionMovementDeletionContext.textPreparedSelectionState.resetCachedX();
        if (((CharSequence)selectionMovementDeletionContext.text).length() > 0) {
            SelectionMovementDeletionContext selectionMovementDeletionContext2 = selectionMovementDeletionContext;
            int n2 = TextRange.getEnd-impl((long)selectionMovementDeletionContext2.getSelection-d9O1mEE());
            TextLayoutResult textLayoutResult = this.textLayoutResult;
            long l2 = TextPreparedSelectionKt.calculateNextCursorPositionAndWedgeAffinity(textLayoutResult != null ? SelectionMovementDeletionContext.getPrevWordOffsetForLayout$default(this, textLayoutResult, 0, 1, null) : 0, n2, selectionMovementDeletionContext2.state);
            int n3 = CursorAndWedgeAffinity.component1-impl(l2);
            WedgeAffinity wedgeAffinity = CursorAndWedgeAffinity.component2-impl(l2);
            if (n3 != n2 || !TextRange.getCollapsed-impl((long)selectionMovementDeletionContext2.getSelection-d9O1mEE())) {
                selectionMovementDeletionContext2.setSelection-5zc-tL8(TextRangeKt.TextRange((int)n3));
            }
            if (wedgeAffinity != null) {
                selectionMovementDeletionContext2.setWedgeAffinity(wedgeAffinity);
            }
        }
        return selectionMovementDeletionContext;
    }

    public final SelectionMovementDeletionContext moveCursorPrevByParagraph() {
        SelectionMovementDeletionContext selectionMovementDeletionContext = this;
        selectionMovementDeletionContext.textPreparedSelectionState.resetCachedX();
        if (((CharSequence)selectionMovementDeletionContext.text).length() > 0) {
            SelectionMovementDeletionContext selectionMovementDeletionContext2 = selectionMovementDeletionContext;
            int n2 = TextRange.getEnd-impl((long)selectionMovementDeletionContext2.getSelection-d9O1mEE());
            int n3 = StringHelpersKt.findParagraphStart(this.text, TextRange.getMin-impl((long)this.selection));
            if (n3 == TextRange.getMin-impl((long)this.selection) && n3 != 0) {
                n3 = StringHelpersKt.findParagraphStart(this.text, n3 - 1);
            }
            long l2 = TextPreparedSelectionKt.calculateNextCursorPositionAndWedgeAffinity(n3, n2, selectionMovementDeletionContext2.state);
            n3 = CursorAndWedgeAffinity.component1-impl(l2);
            WedgeAffinity wedgeAffinity = CursorAndWedgeAffinity.component2-impl(l2);
            if (n3 != n2 || !TextRange.getCollapsed-impl((long)selectionMovementDeletionContext2.getSelection-d9O1mEE())) {
                selectionMovementDeletionContext2.setSelection-5zc-tL8(TextRangeKt.TextRange((int)n3));
            }
            if (wedgeAffinity != null) {
                selectionMovementDeletionContext2.setWedgeAffinity(wedgeAffinity);
            }
        }
        return selectionMovementDeletionContext;
    }

    public final SelectionMovementDeletionContext moveCursorNextByParagraph() {
        SelectionMovementDeletionContext selectionMovementDeletionContext = this;
        selectionMovementDeletionContext.textPreparedSelectionState.resetCachedX();
        if (((CharSequence)selectionMovementDeletionContext.text).length() > 0) {
            SelectionMovementDeletionContext selectionMovementDeletionContext2 = selectionMovementDeletionContext;
            int n2 = TextRange.getEnd-impl((long)selectionMovementDeletionContext2.getSelection-d9O1mEE());
            int n3 = StringHelpersKt.findParagraphEnd(this.text, TextRange.getMax-impl((long)this.selection));
            if (n3 == TextRange.getMax-impl((long)this.selection) && n3 != this.text.length()) {
                n3 = StringHelpersKt.findParagraphEnd(this.text, n3 + 1);
            }
            long l2 = TextPreparedSelectionKt.calculateNextCursorPositionAndWedgeAffinity(n3, n2, selectionMovementDeletionContext2.state);
            n3 = CursorAndWedgeAffinity.component1-impl(l2);
            WedgeAffinity wedgeAffinity = CursorAndWedgeAffinity.component2-impl(l2);
            if (n3 != n2 || !TextRange.getCollapsed-impl((long)selectionMovementDeletionContext2.getSelection-d9O1mEE())) {
                selectionMovementDeletionContext2.setSelection-5zc-tL8(TextRangeKt.TextRange((int)n3));
            }
            if (wedgeAffinity != null) {
                selectionMovementDeletionContext2.setWedgeAffinity(wedgeAffinity);
            }
        }
        return selectionMovementDeletionContext;
    }

    public final SelectionMovementDeletionContext moveCursorUpByLine() {
        boolean bl;
        TextLayoutResult textLayoutResult = this.textLayoutResult;
        int n2 = textLayoutResult != null ? this.jumpByLinesOffset(textLayoutResult, -1) : Integer.MIN_VALUE;
        SelectionMovementDeletionContext selectionMovementDeletionContext = this;
        boolean bl2 = bl = n2 == Integer.MIN_VALUE;
        if (bl) {
            selectionMovementDeletionContext.textPreparedSelectionState.resetCachedX();
        }
        if (((CharSequence)selectionMovementDeletionContext.text).length() > 0) {
            SelectionMovementDeletionContext selectionMovementDeletionContext2 = selectionMovementDeletionContext;
            int n3 = TextRange.getEnd-impl((long)selectionMovementDeletionContext2.getSelection-d9O1mEE());
            long l2 = TextPreparedSelectionKt.calculateNextCursorPositionAndWedgeAffinity(RangesKt.coerceAtLeast((int)n2, (int)0), n3, selectionMovementDeletionContext2.state);
            n2 = CursorAndWedgeAffinity.component1-impl(l2);
            WedgeAffinity wedgeAffinity = CursorAndWedgeAffinity.component2-impl(l2);
            if (n2 != n3 || !TextRange.getCollapsed-impl((long)selectionMovementDeletionContext2.getSelection-d9O1mEE())) {
                selectionMovementDeletionContext2.setSelection-5zc-tL8(TextRangeKt.TextRange((int)n2));
            }
            if (wedgeAffinity != null) {
                selectionMovementDeletionContext2.setWedgeAffinity(wedgeAffinity);
            }
        }
        return selectionMovementDeletionContext;
    }

    public final SelectionMovementDeletionContext moveCursorDownByLine() {
        boolean bl;
        TextLayoutResult textLayoutResult = this.textLayoutResult;
        int n2 = textLayoutResult != null ? this.jumpByLinesOffset(textLayoutResult, 1) : Integer.MAX_VALUE;
        SelectionMovementDeletionContext selectionMovementDeletionContext = this;
        boolean bl2 = bl = n2 == Integer.MAX_VALUE;
        if (bl) {
            selectionMovementDeletionContext.textPreparedSelectionState.resetCachedX();
        }
        if (((CharSequence)selectionMovementDeletionContext.text).length() > 0) {
            SelectionMovementDeletionContext selectionMovementDeletionContext2 = selectionMovementDeletionContext;
            int n3 = TextRange.getEnd-impl((long)selectionMovementDeletionContext2.getSelection-d9O1mEE());
            long l2 = TextPreparedSelectionKt.calculateNextCursorPositionAndWedgeAffinity(RangesKt.coerceAtMost((int)n2, (int)this.text.length()), n3, selectionMovementDeletionContext2.state);
            n2 = CursorAndWedgeAffinity.component1-impl(l2);
            WedgeAffinity wedgeAffinity = CursorAndWedgeAffinity.component2-impl(l2);
            if (n2 != n3 || !TextRange.getCollapsed-impl((long)selectionMovementDeletionContext2.getSelection-d9O1mEE())) {
                selectionMovementDeletionContext2.setSelection-5zc-tL8(TextRangeKt.TextRange((int)n2));
            }
            if (wedgeAffinity != null) {
                selectionMovementDeletionContext2.setWedgeAffinity(wedgeAffinity);
            }
        }
        return selectionMovementDeletionContext;
    }

    public final SelectionMovementDeletionContext moveCursorToLineLeftSide() {
        if (this.isLtr()) {
            return this.moveCursorToLineStart();
        }
        return this.moveCursorToLineEnd();
    }

    public final SelectionMovementDeletionContext moveCursorToLineRightSide() {
        if (this.isLtr()) {
            return this.moveCursorToLineEnd();
        }
        return this.moveCursorToLineStart();
    }

    public final SelectionMovementDeletionContext moveCursorToLineStart() {
        SelectionMovementDeletionContext selectionMovementDeletionContext = this;
        selectionMovementDeletionContext.textPreparedSelectionState.resetCachedX();
        if (((CharSequence)selectionMovementDeletionContext.text).length() > 0) {
            SelectionMovementDeletionContext selectionMovementDeletionContext2 = selectionMovementDeletionContext;
            int n2 = TextRange.getEnd-impl((long)selectionMovementDeletionContext2.getSelection-d9O1mEE());
            TextLayoutResult textLayoutResult = this.textLayoutResult;
            long l2 = TextPreparedSelectionKt.calculateNextCursorPositionAndWedgeAffinity(textLayoutResult != null ? SelectionMovementDeletionContext.getLineStartByOffsetForLayout$default(this, textLayoutResult, 0, 1, null) : 0, n2, selectionMovementDeletionContext2.state);
            int n3 = CursorAndWedgeAffinity.component1-impl(l2);
            WedgeAffinity wedgeAffinity = CursorAndWedgeAffinity.component2-impl(l2);
            if (n3 != n2 || !TextRange.getCollapsed-impl((long)selectionMovementDeletionContext2.getSelection-d9O1mEE())) {
                selectionMovementDeletionContext2.setSelection-5zc-tL8(TextRangeKt.TextRange((int)n3));
            }
            if (wedgeAffinity != null) {
                selectionMovementDeletionContext2.setWedgeAffinity(wedgeAffinity);
            }
        }
        return selectionMovementDeletionContext;
    }

    public final SelectionMovementDeletionContext moveCursorToLineEnd() {
        SelectionMovementDeletionContext selectionMovementDeletionContext = this;
        selectionMovementDeletionContext.textPreparedSelectionState.resetCachedX();
        if (((CharSequence)selectionMovementDeletionContext.text).length() > 0) {
            SelectionMovementDeletionContext selectionMovementDeletionContext2 = selectionMovementDeletionContext;
            int n2 = TextRange.getEnd-impl((long)selectionMovementDeletionContext2.getSelection-d9O1mEE());
            TextLayoutResult textLayoutResult = this.textLayoutResult;
            long l2 = TextPreparedSelectionKt.calculateNextCursorPositionAndWedgeAffinity(textLayoutResult != null ? SelectionMovementDeletionContext.getLineEndByOffsetForLayout$default(this, textLayoutResult, 0, 1, null) : this.text.length(), n2, selectionMovementDeletionContext2.state);
            int n3 = CursorAndWedgeAffinity.component1-impl(l2);
            WedgeAffinity wedgeAffinity = CursorAndWedgeAffinity.component2-impl(l2);
            if (n3 != n2 || !TextRange.getCollapsed-impl((long)selectionMovementDeletionContext2.getSelection-d9O1mEE())) {
                selectionMovementDeletionContext2.setSelection-5zc-tL8(TextRangeKt.TextRange((int)n3));
            }
            if (wedgeAffinity != null) {
                selectionMovementDeletionContext2.setWedgeAffinity(wedgeAffinity);
            }
        }
        return selectionMovementDeletionContext;
    }

    public final SelectionMovementDeletionContext moveCursorUpByPage() {
        SelectionMovementDeletionContext selectionMovementDeletionContext;
        SelectionMovementDeletionContext selectionMovementDeletionContext2 = this;
        selectionMovementDeletionContext2 = selectionMovementDeletionContext2;
        if (((CharSequence)selectionMovementDeletionContext.text).length() > 0) {
            SelectionMovementDeletionContext selectionMovementDeletionContext3 = selectionMovementDeletionContext2;
            int n2 = TextRange.getEnd-impl((long)selectionMovementDeletionContext3.getSelection-d9O1mEE());
            long l2 = TextPreparedSelectionKt.calculateNextCursorPositionAndWedgeAffinity(this.jumpByPagesOffset(-1), n2, selectionMovementDeletionContext3.state);
            int n3 = CursorAndWedgeAffinity.component1-impl(l2);
            WedgeAffinity wedgeAffinity = CursorAndWedgeAffinity.component2-impl(l2);
            if (n3 != n2 || !TextRange.getCollapsed-impl((long)selectionMovementDeletionContext3.getSelection-d9O1mEE())) {
                selectionMovementDeletionContext3.setSelection-5zc-tL8(TextRangeKt.TextRange((int)n3));
            }
            if (wedgeAffinity != null) {
                selectionMovementDeletionContext3.setWedgeAffinity(wedgeAffinity);
            }
        }
        return selectionMovementDeletionContext2;
    }

    public final SelectionMovementDeletionContext moveCursorDownByPage() {
        SelectionMovementDeletionContext selectionMovementDeletionContext;
        SelectionMovementDeletionContext selectionMovementDeletionContext2 = this;
        selectionMovementDeletionContext2 = selectionMovementDeletionContext2;
        if (((CharSequence)selectionMovementDeletionContext.text).length() > 0) {
            SelectionMovementDeletionContext selectionMovementDeletionContext3 = selectionMovementDeletionContext2;
            int n2 = TextRange.getEnd-impl((long)selectionMovementDeletionContext3.getSelection-d9O1mEE());
            long l2 = TextPreparedSelectionKt.calculateNextCursorPositionAndWedgeAffinity(this.jumpByPagesOffset(1), n2, selectionMovementDeletionContext3.state);
            int n3 = CursorAndWedgeAffinity.component1-impl(l2);
            WedgeAffinity wedgeAffinity = CursorAndWedgeAffinity.component2-impl(l2);
            if (n3 != n2 || !TextRange.getCollapsed-impl((long)selectionMovementDeletionContext3.getSelection-d9O1mEE())) {
                selectionMovementDeletionContext3.setSelection-5zc-tL8(TextRangeKt.TextRange((int)n3));
            }
            if (wedgeAffinity != null) {
                selectionMovementDeletionContext3.setWedgeAffinity(wedgeAffinity);
            }
        }
        return selectionMovementDeletionContext2;
    }

    public final SelectionMovementDeletionContext selectMovement() {
        SelectionMovementDeletionContext selectionMovementDeletionContext = this;
        if (((CharSequence)selectionMovementDeletionContext.text).length() > 0) {
            SelectionMovementDeletionContext selectionMovementDeletionContext2 = selectionMovementDeletionContext;
            selectionMovementDeletionContext.selection = TextRangeKt.TextRange((int)TextRange.getStart-impl((long)selectionMovementDeletionContext2.initialValue.getSelection-d9O1mEE()), (int)TextRange.getEnd-impl((long)selectionMovementDeletionContext2.selection));
        }
        return selectionMovementDeletionContext;
    }

    public final SelectionMovementDeletionContext deleteMovement() {
        SelectionMovementDeletionContext selectionMovementDeletionContext = this;
        if (((CharSequence)selectionMovementDeletionContext.text).length() > 0) {
            SelectionMovementDeletionContext selectionMovementDeletionContext2 = selectionMovementDeletionContext;
            if (!TextRange.getCollapsed-impl((long)selectionMovementDeletionContext2.initialValue.getSelection-d9O1mEE())) {
                selectionMovementDeletionContext2.state.deleteSelectedText();
            } else {
                TransformedTextFieldState.replaceText-M8tDOmk$default(selectionMovementDeletionContext2.state, "", TextRangeKt.TextRange((int)TextRange.getStart-impl((long)selectionMovementDeletionContext2.initialValue.getSelection-d9O1mEE()), (int)TextRange.getEnd-impl((long)selectionMovementDeletionContext2.selection)), null, !selectionMovementDeletionContext2.isFromSoftKeyboard, 4, null);
            }
            selectionMovementDeletionContext2.selection = selectionMovementDeletionContext2.state.getVisualText().getSelection-d9O1mEE();
            selectionMovementDeletionContext2.wedgeAffinity = WedgeAffinity.Start;
        }
        return selectionMovementDeletionContext;
    }

    private final boolean isLtr() {
        TextLayoutResult textLayoutResult = this.textLayoutResult;
        if (textLayoutResult == null || (textLayoutResult = textLayoutResult.getParagraphDirection(TextRange.getEnd-impl((long)this.selection))) == null) {
            return true;
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        return textLayoutResult == ResolvedTextDirection.Ltr;
    }

    private final int getNextWordOffsetForLayout(TextLayoutResult textLayoutResult, int n2) {
        long l2;
        SelectionMovementDeletionContext selectionMovementDeletionContext = this;
        while (true) {
            if (n2 >= selectionMovementDeletionContext.initialValue.length()) {
                return selectionMovementDeletionContext.initialValue.length();
            }
            l2 = textLayoutResult.getWordBoundary--jx7JFs(selectionMovementDeletionContext.charOffset(n2));
            if (TextRange.getEnd-impl((long)l2) > n2) break;
            ++n2;
        }
        return TextRange.getEnd-impl((long)l2);
    }

    static /* synthetic */ int getNextWordOffsetForLayout$default(SelectionMovementDeletionContext selectionMovementDeletionContext, TextLayoutResult textLayoutResult, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n2 = TextRange.getEnd-impl((long)selectionMovementDeletionContext.selection);
        }
        return selectionMovementDeletionContext.getNextWordOffsetForLayout(textLayoutResult, n2);
    }

    private final int getPrevWordOffsetForLayout(TextLayoutResult textLayoutResult, int n2) {
        long l2;
        SelectionMovementDeletionContext selectionMovementDeletionContext = this;
        while (true) {
            if (n2 <= 0) {
                return 0;
            }
            l2 = textLayoutResult.getWordBoundary--jx7JFs(selectionMovementDeletionContext.charOffset(n2));
            if (TextRange.getStart-impl((long)l2) < n2) break;
            --n2;
        }
        return TextRange.getStart-impl((long)l2);
    }

    static /* synthetic */ int getPrevWordOffsetForLayout$default(SelectionMovementDeletionContext selectionMovementDeletionContext, TextLayoutResult textLayoutResult, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n2 = TextRange.getEnd-impl((long)selectionMovementDeletionContext.selection);
        }
        return selectionMovementDeletionContext.getPrevWordOffsetForLayout(textLayoutResult, n2);
    }

    private final int getLineStartByOffsetForLayout(TextLayoutResult textLayoutResult, int n2) {
        n2 = textLayoutResult.getLineForOffset(n2);
        return textLayoutResult.getLineStart(n2);
    }

    static /* synthetic */ int getLineStartByOffsetForLayout$default(SelectionMovementDeletionContext selectionMovementDeletionContext, TextLayoutResult textLayoutResult, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n2 = TextRange.getMin-impl((long)selectionMovementDeletionContext.selection);
        }
        return selectionMovementDeletionContext.getLineStartByOffsetForLayout(textLayoutResult, n2);
    }

    private final int getLineEndByOffsetForLayout(TextLayoutResult textLayoutResult, int n2) {
        n2 = textLayoutResult.getLineForOffset(n2);
        return textLayoutResult.getLineEnd(n2, true);
    }

    static /* synthetic */ int getLineEndByOffsetForLayout$default(SelectionMovementDeletionContext selectionMovementDeletionContext, TextLayoutResult textLayoutResult, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n2 = TextRange.getMax-impl((long)selectionMovementDeletionContext.selection);
        }
        return selectionMovementDeletionContext.getLineEndByOffsetForLayout(textLayoutResult, n2);
    }

    private final int jumpByLinesOffset(TextLayoutResult textLayoutResult, int n2) {
        int n3 = TextRange.getEnd-impl((long)this.selection);
        if (Float.isNaN(this.textPreparedSelectionState.getCachedX())) {
            this.textPreparedSelectionState.setCachedX(textLayoutResult.getCursorRect(n3).getLeft());
        }
        if ((n2 = textLayoutResult.getLineForOffset(n3) + n2) < 0) {
            return Integer.MIN_VALUE;
        }
        if (n2 >= textLayoutResult.getLineCount()) {
            return Integer.MAX_VALUE;
        }
        float f2 = textLayoutResult.getLineBottom(n2) - 1.0f;
        float f3 = this.textPreparedSelectionState.getCachedX();
        if (this.isLtr() && f3 >= textLayoutResult.getLineRight(n2) || !this.isLtr() && f3 <= textLayoutResult.getLineLeft(n2)) {
            return textLayoutResult.getLineEnd(n2, true);
        }
        float f4 = f3;
        long l2 = Float.floatToRawIntBits(f4);
        long l3 = Float.floatToRawIntBits(f2);
        return textLayoutResult.getOffsetForPosition-k-4lQ0M(Offset.constructor-impl((long)(l2 << 32 | l3 & 0xFFFFFFFFL)));
    }

    private final int jumpByPagesOffset(int n2) {
        int n3 = TextRange.getEnd-impl((long)this.initialValue.getSelection-d9O1mEE());
        if (this.textLayoutResult == null || Float.isNaN(this.visibleTextLayoutHeight)) {
            return n3;
        }
        Rect rect = this.textLayoutResult.getCursorRect(n3);
        Rect rect2 = rect.translate(0.0f, this.visibleTextLayoutHeight * (float)n2);
        int n4 = this.textLayoutResult.getLineForVerticalPosition(rect2.getTop());
        float f2 = this.textLayoutResult.getLineBottom(n4);
        if (Math.abs(rect2.getTop() - f2) > Math.abs(rect2.getBottom() - f2)) {
            return this.textLayoutResult.getOffsetForPosition-k-4lQ0M(rect2.getTopLeft-F1C5BW0());
        }
        return this.textLayoutResult.getOffsetForPosition-k-4lQ0M(rect2.getBottomLeft-F1C5BW0());
    }

    private final int charOffset(int n2) {
        return RangesKt.coerceAtMost((int)n2, (int)(this.text.length() - 1));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/compose/foundation/text/input/internal/selection/SelectionMovementDeletionContext$Companion;", "", "<init>", "()V", "NoCharacterFound", "", "foundation"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

