/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.PolymorphicSerializerKt;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractEncoder;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.internal.AbstractPolymorphicSerializer;
import kotlinx.serialization.json.ClassDiscriminatorMode;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonConfiguration;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementSerializer;
import kotlinx.serialization.json.JsonEncoder;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.internal.Composer;
import kotlinx.serialization.json.internal.ComposerForUnquotedLiterals;
import kotlinx.serialization.json.internal.ComposerForUnsignedNumbers;
import kotlinx.serialization.json.internal.ComposersKt;
import kotlinx.serialization.json.internal.InternalJsonWriter;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.JsonNamesMapKt;
import kotlinx.serialization.json.internal.PolymorphicKt;
import kotlinx.serialization.json.internal.StreamingJsonEncoderKt;
import kotlinx.serialization.json.internal.WriteMode;
import kotlinx.serialization.json.internal.WriteModeKt;
import kotlinx.serialization.modules.SerializersModule;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0010\u0010\t\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fB1\b\u0010\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\u000fJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J)\u0010'\u001a\u00020\u001f\"\u0004\b\u0000\u0010(2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H(0*2\u0006\u0010+\u001a\u0002H(H\u0016\u00a2\u0006\u0002\u0010,J\u0018\u0010-\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020\u001cH\u0002J\u0010\u00100\u001a\u0002012\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u00102\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u00103\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J?\u00104\u001a\u00020\u001f\"\b\b\u0000\u0010(*\u0002052\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H(0*2\b\u0010+\u001a\u0004\u0018\u0001H(H\u0016\u00a2\u0006\u0002\u00106J\u0010\u00107\u001a\u0002082\u0006\u0010#\u001a\u00020$H\u0016JR\u00109\u001a\u0002H(\"\n\b\u0000\u0010(\u0018\u0001*\u00020\u000426\u0010:\u001a2\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b<\u0012\b\b=\u0012\u0004\b\b(>\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b<\u0012\b\b=\u0012\u0004\b\b(\u0019\u0012\u0004\u0012\u0002H(0;H\u0082\b\u00a2\u0006\u0002\u0010?J\b\u0010@\u001a\u00020\u001fH\u0016J\u0010\u0010A\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020\u001aH\u0016J\u0010\u0010B\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020CH\u0016J\u0010\u0010D\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020&H\u0016J\u0010\u0010G\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020HH\u0016J\u0010\u0010I\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020JH\u0016J\u0010\u0010K\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020LH\u0016J\u0010\u0010M\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020NH\u0016J\u0010\u0010O\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020\u001cH\u0016J\u0018\u0010P\u001a\u00020\u001f2\u0006\u0010Q\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lkotlinx/serialization/json/internal/StreamingJsonEncoder;", "Lkotlinx/serialization/json/JsonEncoder;", "Lkotlinx/serialization/encoding/AbstractEncoder;", "composer", "Lkotlinx/serialization/json/internal/Composer;", "json", "Lkotlinx/serialization/json/Json;", "mode", "Lkotlinx/serialization/json/internal/WriteMode;", "modeReuseCache", "", "<init>", "(Lkotlinx/serialization/json/internal/Composer;Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/internal/WriteMode;[Lkotlinx/serialization/json/JsonEncoder;)V", "output", "Lkotlinx/serialization/json/internal/InternalJsonWriter;", "(Lkotlinx/serialization/json/internal/InternalJsonWriter;Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/internal/WriteMode;[Lkotlinx/serialization/json/JsonEncoder;)V", "getJson", "()Lkotlinx/serialization/json/Json;", "[Lkotlinx/serialization/json/JsonEncoder;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "configuration", "Lkotlinx/serialization/json/JsonConfiguration;", "forceQuoting", "", "polymorphicDiscriminator", "", "polymorphicSerialName", "encodeJsonElement", "", "element", "Lkotlinx/serialization/json/JsonElement;", "shouldEncodeElementDefault", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "index", "", "encodeSerializableValue", "T", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "value", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "encodeTypeInfo", "discriminator", "serialName", "beginStructure", "Lkotlinx/serialization/encoding/CompositeEncoder;", "endStructure", "encodeElement", "encodeNullableSerializableElement", "", "(Lkotlinx/serialization/descriptors/SerialDescriptor;ILkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "encodeInline", "Lkotlinx/serialization/encoding/Encoder;", "composerAs", "composerCreator", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "writer", "(Lkotlin/jvm/functions/Function2;)Lkotlinx/serialization/json/internal/Composer;", "encodeNull", "encodeBoolean", "encodeByte", "", "encodeShort", "", "encodeInt", "encodeLong", "", "encodeFloat", "", "encodeDouble", "", "encodeChar", "", "encodeString", "encodeEnum", "enumDescriptor", "kotlinx-serialization-json"})
public final class StreamingJsonEncoder
extends AbstractEncoder
implements JsonEncoder {
    private final Composer composer;
    private final Json json;
    private final WriteMode mode;
    private final JsonEncoder[] modeReuseCache;
    private final SerializersModule serializersModule;
    private final JsonConfiguration configuration;
    private boolean forceQuoting;
    private String polymorphicDiscriminator;
    private String polymorphicSerialName;

    public StreamingJsonEncoder(Composer composer, Json json, WriteMode writeMode, JsonEncoder[] jsonEncoderArray) {
        Intrinsics.checkNotNullParameter((Object)composer, (String)"");
        Intrinsics.checkNotNullParameter((Object)json, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)writeMode), (String)"");
        this.composer = composer;
        this.json = json;
        this.mode = writeMode;
        this.modeReuseCache = jsonEncoderArray;
        this.serializersModule = this.getJson().getSerializersModule();
        this.configuration = this.getJson().getConfiguration();
        int n = this.mode.ordinal();
        if (this.modeReuseCache != null && (this.modeReuseCache[n] != null || this.modeReuseCache[n] != this)) {
            this.modeReuseCache[n] = this;
        }
    }

    @Override
    public final Json getJson() {
        return this.json;
    }

    public StreamingJsonEncoder(InternalJsonWriter internalJsonWriter, Json json, WriteMode writeMode, JsonEncoder[] jsonEncoderArray) {
        Intrinsics.checkNotNullParameter((Object)internalJsonWriter, (String)"");
        Intrinsics.checkNotNullParameter((Object)json, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)writeMode), (String)"");
        Intrinsics.checkNotNullParameter((Object)jsonEncoderArray, (String)"");
        this(ComposersKt.Composer(internalJsonWriter, json), json, writeMode, jsonEncoderArray);
    }

    public final SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    @Override
    public final void encodeJsonElement(JsonElement jsonElement) {
        Intrinsics.checkNotNullParameter((Object)jsonElement, (String)"");
        if (this.polymorphicDiscriminator != null && !(jsonElement instanceof JsonObject)) {
            PolymorphicKt.throwJsonElementPolymorphicException(this.polymorphicSerialName, jsonElement);
            throw new KotlinNothingValueException();
        }
        this.encodeSerializableValue((SerializationStrategy)JsonElementSerializer.INSTANCE, jsonElement);
    }

    public final boolean shouldEncodeElementDefault(SerialDescriptor serialDescriptor, int n) {
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        return this.configuration.getEncodeDefaults();
    }

    public final <T> void encodeSerializableValue(SerializationStrategy<? super T> serializationStrategy, T t) {
        SerializationStrategy serializationStrategy2;
        String string;
        boolean bl;
        Intrinsics.checkNotNullParameter(serializationStrategy, (String)"");
        JsonEncoder jsonEncoder = this;
        if (jsonEncoder.getJson().getConfiguration().getUseArrayPolymorphism()) {
            serializationStrategy.serialize((Encoder)jsonEncoder, t);
            return;
        }
        boolean bl2 = serializationStrategy instanceof AbstractPolymorphicSerializer;
        if (bl2) {
            bl = jsonEncoder.getJson().getConfiguration().getClassDiscriminatorMode() != ClassDiscriminatorMode.NONE;
        } else {
            switch (PolymorphicKt.WhenMappings.$EnumSwitchMapping$0[jsonEncoder.getJson().getConfiguration().getClassDiscriminatorMode().ordinal()]) {
                case 1: 
                case 2: {
                    bl = false;
                    break;
                }
                case 3: {
                    SerialKind serialKind = serializationStrategy.getDescriptor().getKind();
                    if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.CLASS.INSTANCE) || Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.OBJECT.INSTANCE)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        boolean bl3 = bl;
        String string2 = string = bl ? PolymorphicKt.classDiscriminator(serializationStrategy.getDescriptor(), jsonEncoder.getJson()) : null;
        if (bl2) {
            AbstractPolymorphicSerializer abstractPolymorphicSerializer = (AbstractPolymorphicSerializer)serializationStrategy;
            if (t == null) {
                String string3 = "Value for serializer " + ((AbstractPolymorphicSerializer)serializationStrategy).getDescriptor() + " should always be non-null. Please report issue to the kotlinx.serialization tracker.";
                throw new IllegalArgumentException(string3.toString());
            }
            SerializationStrategy serializationStrategy3 = PolymorphicSerializerKt.findPolymorphicSerializer((AbstractPolymorphicSerializer)abstractPolymorphicSerializer, (Encoder)jsonEncoder, t);
            if (string != null) {
                PolymorphicKt.access$validateIfSealed(serializationStrategy, serializationStrategy3, string);
                PolymorphicKt.checkKind(serializationStrategy3.getDescriptor().getKind());
            }
            Intrinsics.checkNotNull((Object)serializationStrategy3);
            serializationStrategy2 = serializationStrategy3;
        } else {
            serializationStrategy2 = serializationStrategy = serializationStrategy;
        }
        if (string != null) {
            String string4;
            String string5 = serializationStrategy.getDescriptor().getSerialName();
            this.polymorphicDiscriminator = string4 = string;
            this.polymorphicSerialName = string5;
        }
        serializationStrategy.serialize((Encoder)jsonEncoder, t);
    }

    private final void encodeTypeInfo(String string, String string2) {
        this.composer.nextItem();
        this.encodeString(string);
        this.composer.print(':');
        this.composer.space();
        this.encodeString(string2);
    }

    public final CompositeEncoder beginStructure(SerialDescriptor serialDescriptor) {
        String string;
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        WriteMode writeMode = WriteModeKt.switchMode(this.getJson(), serialDescriptor);
        if (writeMode.begin != '\u0000') {
            this.composer.print(writeMode.begin);
            this.composer.indent();
        }
        if ((string = this.polymorphicDiscriminator) != null) {
            String string2 = this.polymorphicSerialName;
            if (string2 == null) {
                string2 = serialDescriptor.getSerialName();
            }
            this.encodeTypeInfo(string, string2);
            this.polymorphicDiscriminator = null;
            this.polymorphicSerialName = null;
        }
        if (this.mode == writeMode) {
            return this;
        }
        Object object = this.modeReuseCache;
        if (this.modeReuseCache != null && (object = object[writeMode.ordinal()]) != null) {
            return (CompositeEncoder)object;
        }
        return new StreamingJsonEncoder(this.composer, this.getJson(), writeMode, this.modeReuseCache);
    }

    public final void endStructure(SerialDescriptor serialDescriptor) {
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        if (this.mode.end != '\u0000') {
            this.composer.unIndent();
            this.composer.nextItemIfNotFirst();
            this.composer.print(this.mode.end);
        }
    }

    public final boolean encodeElement(SerialDescriptor serialDescriptor, int n) {
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        switch (WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
            case 1: {
                if (!this.composer.getWritingFirst()) {
                    this.composer.print(',');
                }
                this.composer.nextItem();
                break;
            }
            case 2: {
                if (!this.composer.getWritingFirst()) {
                    boolean bl;
                    if (n % 2 == 0) {
                        this.composer.print(',');
                        this.composer.nextItem();
                        bl = true;
                    } else {
                        this.composer.print(':');
                        this.composer.space();
                        bl = false;
                    }
                    this.forceQuoting = bl;
                    break;
                }
                this.forceQuoting = true;
                this.composer.nextItem();
                break;
            }
            case 3: {
                if (n == 0) {
                    this.forceQuoting = true;
                }
                if (n != 1) break;
                this.composer.print(',');
                this.composer.space();
                this.forceQuoting = false;
                break;
            }
            default: {
                if (!this.composer.getWritingFirst()) {
                    this.composer.print(',');
                }
                this.composer.nextItem();
                this.encodeString(JsonNamesMapKt.getJsonElementName(serialDescriptor, this.getJson(), n));
                this.composer.print(':');
                this.composer.space();
            }
        }
        return true;
    }

    public final <T> void encodeNullableSerializableElement(SerialDescriptor serialDescriptor, int n, SerializationStrategy<? super T> serializationStrategy, T t) {
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        Intrinsics.checkNotNullParameter(serializationStrategy, (String)"");
        if (t != null || this.configuration.getExplicitNulls()) {
            super.encodeNullableSerializableElement(serialDescriptor, n, serializationStrategy, t);
        }
    }

    public final Encoder encodeInline(SerialDescriptor object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        if (StreamingJsonEncoderKt.isUnsignedNumber(object)) {
            Composer composer;
            Object object2 = this;
            if (((StreamingJsonEncoder)object2).composer instanceof ComposerForUnsignedNumbers) {
                composer = ((StreamingJsonEncoder)object2).composer;
            } else {
                boolean bl = ((StreamingJsonEncoder)object2).forceQuoting;
                object2 = ((StreamingJsonEncoder)object2).composer.writer;
                composer = new ComposerForUnsignedNumbers((InternalJsonWriter)object2, bl);
            }
            object = this.mode;
            object2 = this.getJson();
            Composer composer2 = composer;
            return new StreamingJsonEncoder(composer2, (Json)object2, (WriteMode)((Object)object), null);
        }
        if (StreamingJsonEncoderKt.isUnquotedLiteral(object)) {
            Composer composer;
            Object object3 = this;
            if (((StreamingJsonEncoder)object3).composer instanceof ComposerForUnquotedLiterals) {
                composer = ((StreamingJsonEncoder)object3).composer;
            } else {
                boolean bl = ((StreamingJsonEncoder)object3).forceQuoting;
                object3 = ((StreamingJsonEncoder)object3).composer.writer;
                composer = new ComposerForUnquotedLiterals((InternalJsonWriter)object3, bl);
            }
            object = this.mode;
            object3 = this.getJson();
            Composer composer3 = composer;
            return new StreamingJsonEncoder(composer3, (Json)object3, (WriteMode)((Object)object), null);
        }
        if (this.polymorphicDiscriminator != null) {
            StreamingJsonEncoder streamingJsonEncoder;
            StreamingJsonEncoder streamingJsonEncoder2 = streamingJsonEncoder = this;
            streamingJsonEncoder.polymorphicSerialName = object.getSerialName();
            return streamingJsonEncoder;
        }
        return super.encodeInline(object);
    }

    private final /* synthetic */ <T extends Composer> T composerAs(Function2<? super InternalJsonWriter, ? super Boolean, ? extends T> function2) {
        Intrinsics.reifiedOperationMarker((int)3, (String)"T");
        if (this.composer instanceof Composer) {
            return (T)this.composer;
        }
        return (T)((Composer)function2.invoke((Object)this.composer.writer, (Object)this.forceQuoting));
    }

    public final void encodeNull() {
        this.composer.print("null");
    }

    public final void encodeBoolean(boolean bl) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(bl));
            return;
        }
        this.composer.print(bl);
    }

    public final void encodeByte(byte by) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(by));
            return;
        }
        this.composer.print(by);
    }

    public final void encodeShort(short s) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(s));
            return;
        }
        this.composer.print(s);
    }

    public final void encodeInt(int n) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(n));
            return;
        }
        this.composer.print(n);
    }

    public final void encodeLong(long l) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(l));
            return;
        }
        this.composer.print(l);
    }

    public final void encodeFloat(float f) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(f));
        } else {
            this.composer.print(f);
        }
        if (!this.configuration.getAllowSpecialFloatingPointValues() && !(!Float.isInfinite(f) && !Float.isNaN(f))) {
            throw JsonExceptionsKt.InvalidFloatingPointEncoded(Float.valueOf(f), this.composer.writer.toString());
        }
    }

    public final void encodeDouble(double d) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(d));
        } else {
            this.composer.print(d);
        }
        if (!this.configuration.getAllowSpecialFloatingPointValues() && !(!Double.isInfinite(d) && !Double.isNaN(d))) {
            throw JsonExceptionsKt.InvalidFloatingPointEncoded(d, this.composer.writer.toString());
        }
    }

    public final void encodeChar(char c) {
        this.encodeString(String.valueOf(c));
    }

    public final void encodeString(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        this.composer.printQuoted(string);
    }

    public final void encodeEnum(SerialDescriptor serialDescriptor, int n) {
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        this.encodeString(serialDescriptor.getElementName(n));
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WriteMode.values().length];
            try {
                nArray[WriteMode.LIST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[WriteMode.MAP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[WriteMode.POLY_OBJ.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

