/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.SwappedByteBuf;
import io.netty.buffer.UnpooledDirectByteBuf;
import io.netty.buffer.UnsafeByteBufUtil;
import io.netty.buffer.UnsafeDirectSwappedByteBuf;
import io.netty.util.internal.PlatformDependent;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class UnpooledUnsafeDirectByteBuf
extends UnpooledDirectByteBuf {
    long memoryAddress;

    public UnpooledUnsafeDirectByteBuf(ByteBufAllocator byteBufAllocator, int n, int n2) {
        super(byteBufAllocator, n, n2);
    }

    protected UnpooledUnsafeDirectByteBuf(ByteBufAllocator byteBufAllocator, ByteBuffer byteBuffer, int n) {
        super(byteBufAllocator, byteBuffer, n, false, true);
    }

    UnpooledUnsafeDirectByteBuf(ByteBufAllocator byteBufAllocator, ByteBuffer byteBuffer, int n, boolean bl) {
        super(byteBufAllocator, byteBuffer, n, bl, false);
    }

    @Override
    final void setByteBuffer(ByteBuffer byteBuffer, boolean bl) {
        super.setByteBuffer(byteBuffer, bl);
        this.memoryAddress = PlatformDependent.directBufferAddress((ByteBuffer)byteBuffer);
    }

    @Override
    public boolean hasMemoryAddress() {
        return true;
    }

    @Override
    public long memoryAddress() {
        this.ensureAccessible();
        return this.memoryAddress;
    }

    @Override
    public byte getByte(int n) {
        this.checkIndex(n);
        return this._getByte(n);
    }

    @Override
    protected byte _getByte(int n) {
        return UnsafeByteBufUtil.getByte(this.addr(n));
    }

    @Override
    public short getShort(int n) {
        this.checkIndex(n, 2);
        return this._getShort(n);
    }

    @Override
    protected short _getShort(int n) {
        return UnsafeByteBufUtil.getShort(this.addr(n));
    }

    @Override
    protected short _getShortLE(int n) {
        return UnsafeByteBufUtil.getShortLE(this.addr(n));
    }

    @Override
    public int getUnsignedMedium(int n) {
        this.checkIndex(n, 3);
        return this._getUnsignedMedium(n);
    }

    @Override
    protected int _getUnsignedMedium(int n) {
        return UnsafeByteBufUtil.getUnsignedMedium(this.addr(n));
    }

    @Override
    protected int _getUnsignedMediumLE(int n) {
        return UnsafeByteBufUtil.getUnsignedMediumLE(this.addr(n));
    }

    @Override
    public int getInt(int n) {
        this.checkIndex(n, 4);
        return this._getInt(n);
    }

    @Override
    protected int _getInt(int n) {
        return UnsafeByteBufUtil.getInt(this.addr(n));
    }

    @Override
    protected int _getIntLE(int n) {
        return UnsafeByteBufUtil.getIntLE(this.addr(n));
    }

    @Override
    public long getLong(int n) {
        this.checkIndex(n, 8);
        return this._getLong(n);
    }

    @Override
    protected long _getLong(int n) {
        return UnsafeByteBufUtil.getLong(this.addr(n));
    }

    @Override
    protected long _getLongLE(int n) {
        return UnsafeByteBufUtil.getLongLE(this.addr(n));
    }

    @Override
    public ByteBuf getBytes(int n, ByteBuf byteBuf, int n2, int n3) {
        UnpooledUnsafeDirectByteBuf unpooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.getBytes((AbstractByteBuf)unpooledUnsafeDirectByteBuf, unpooledUnsafeDirectByteBuf.addr(n), n, byteBuf, n2, n3);
        return this;
    }

    @Override
    void getBytes(int n, byte[] byArray, int n2, int n3, boolean bl) {
        UnpooledUnsafeDirectByteBuf unpooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.getBytes((AbstractByteBuf)unpooledUnsafeDirectByteBuf, unpooledUnsafeDirectByteBuf.addr(n), n, byArray, n2, n3);
    }

    @Override
    void getBytes(int n, ByteBuffer byteBuffer, boolean bl) {
        UnpooledUnsafeDirectByteBuf unpooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.getBytes(unpooledUnsafeDirectByteBuf, unpooledUnsafeDirectByteBuf.addr(n), n, byteBuffer);
    }

    @Override
    public ByteBuf setByte(int n, int n2) {
        this.checkIndex(n);
        this._setByte(n, n2);
        return this;
    }

    @Override
    protected void _setByte(int n, int n2) {
        UnsafeByteBufUtil.setByte(this.addr(n), n2);
    }

    @Override
    public ByteBuf setShort(int n, int n2) {
        this.checkIndex(n, 2);
        this._setShort(n, n2);
        return this;
    }

    @Override
    protected void _setShort(int n, int n2) {
        UnsafeByteBufUtil.setShort(this.addr(n), n2);
    }

    @Override
    protected void _setShortLE(int n, int n2) {
        UnsafeByteBufUtil.setShortLE(this.addr(n), n2);
    }

    @Override
    public ByteBuf setMedium(int n, int n2) {
        this.checkIndex(n, 3);
        this._setMedium(n, n2);
        return this;
    }

    @Override
    protected void _setMedium(int n, int n2) {
        UnsafeByteBufUtil.setMedium(this.addr(n), n2);
    }

    @Override
    protected void _setMediumLE(int n, int n2) {
        UnsafeByteBufUtil.setMediumLE(this.addr(n), n2);
    }

    @Override
    public ByteBuf setInt(int n, int n2) {
        this.checkIndex(n, 4);
        this._setInt(n, n2);
        return this;
    }

    @Override
    protected void _setInt(int n, int n2) {
        UnsafeByteBufUtil.setInt(this.addr(n), n2);
    }

    @Override
    protected void _setIntLE(int n, int n2) {
        UnsafeByteBufUtil.setIntLE(this.addr(n), n2);
    }

    @Override
    public ByteBuf setLong(int n, long l) {
        this.checkIndex(n, 8);
        this._setLong(n, l);
        return this;
    }

    @Override
    protected void _setLong(int n, long l) {
        UnsafeByteBufUtil.setLong(this.addr(n), l);
    }

    @Override
    protected void _setLongLE(int n, long l) {
        UnsafeByteBufUtil.setLongLE(this.addr(n), l);
    }

    @Override
    public ByteBuf setBytes(int n, ByteBuf byteBuf, int n2, int n3) {
        UnpooledUnsafeDirectByteBuf unpooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.setBytes((AbstractByteBuf)unpooledUnsafeDirectByteBuf, unpooledUnsafeDirectByteBuf.addr(n), n, byteBuf, n2, n3);
        return this;
    }

    @Override
    public ByteBuf setBytes(int n, byte[] byArray, int n2, int n3) {
        UnpooledUnsafeDirectByteBuf unpooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.setBytes((AbstractByteBuf)unpooledUnsafeDirectByteBuf, unpooledUnsafeDirectByteBuf.addr(n), n, byArray, n2, n3);
        return this;
    }

    @Override
    public ByteBuf setBytes(int n, ByteBuffer byteBuffer) {
        UnpooledUnsafeDirectByteBuf unpooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.setBytes(unpooledUnsafeDirectByteBuf, unpooledUnsafeDirectByteBuf.addr(n), n, byteBuffer);
        return this;
    }

    @Override
    void getBytes(int n, OutputStream outputStream, int n2, boolean bl) {
        UnpooledUnsafeDirectByteBuf unpooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.getBytes(unpooledUnsafeDirectByteBuf, unpooledUnsafeDirectByteBuf.addr(n), n, outputStream, n2);
    }

    @Override
    public int setBytes(int n, InputStream inputStream, int n2) {
        UnpooledUnsafeDirectByteBuf unpooledUnsafeDirectByteBuf = this;
        return UnsafeByteBufUtil.setBytes(unpooledUnsafeDirectByteBuf, unpooledUnsafeDirectByteBuf.addr(n), n, inputStream, n2);
    }

    @Override
    public ByteBuf copy(int n, int n2) {
        UnpooledUnsafeDirectByteBuf unpooledUnsafeDirectByteBuf = this;
        return UnsafeByteBufUtil.copy(unpooledUnsafeDirectByteBuf, unpooledUnsafeDirectByteBuf.addr(n), n, n2);
    }

    final long addr(int n) {
        return this.memoryAddress + (long)n;
    }

    @Override
    protected SwappedByteBuf newSwappedByteBuf() {
        if (PlatformDependent.isUnaligned()) {
            return new UnsafeDirectSwappedByteBuf(this);
        }
        return super.newSwappedByteBuf();
    }

    @Override
    public ByteBuf setZero(int n, int n2) {
        this.checkIndex(n, n2);
        UnsafeByteBufUtil.setZero(this.addr(n), n2);
        return this;
    }

    @Override
    public ByteBuf writeZero(int n) {
        ((ByteBuf)this).ensureWritable(n);
        int n2 = this.writerIndex;
        UnsafeByteBufUtil.setZero(this.addr(n2), n);
        this.writerIndex = n2 + n;
        return this;
    }
}

