/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import io.ktor.network.tls.CertificateAndKey;
import io.ktor.network.tls.NoPrivateKeyException;
import io.ktor.network.tls.TLSConfigBuilder;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0019\u0010\u0003\u001a\u00020\u0002*\u00020\u00002\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a'\u0010\n\u001a\u00020\u0002*\u00020\u00002\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000b\u001a1\u0010\u0014\u001a\u00020\u0002*\u00020\u00002\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a\u000f\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lio/ktor/network/tls/TLSConfigBuilder;", "other", "", "takeFrom", "(Lio/ktor/network/tls/TLSConfigBuilder;Lio/ktor/network/tls/TLSConfigBuilder;)V", "", "Ljava/security/cert/X509Certificate;", "chain", "Ljava/security/PrivateKey;", "key", "addCertificateChain", "(Lio/ktor/network/tls/TLSConfigBuilder;[Ljava/security/cert/X509Certificate;Ljava/security/PrivateKey;)V", "Ljava/security/KeyStore;", "store", "", "password", "", "alias", "addKeyStoreNullablePassword", "(Lio/ktor/network/tls/TLSConfigBuilder;Ljava/security/KeyStore;[CLjava/lang/String;)V", "addKeyStore", "Ljavax/net/ssl/X509TrustManager;", "findTrustManager", "()Ljavax/net/ssl/X509TrustManager;", "ktor-network-tls"})
public final class TLSConfigBuilderKt {
    public static final void takeFrom(TLSConfigBuilder tLSConfigBuilder, TLSConfigBuilder tLSConfigBuilder2) {
        Intrinsics.checkNotNullParameter((Object)tLSConfigBuilder, (String)"");
        Intrinsics.checkNotNullParameter((Object)tLSConfigBuilder2, (String)"");
        CollectionsKt.addAll((Collection)tLSConfigBuilder.getCertificates(), (Iterable)tLSConfigBuilder2.getCertificates());
        tLSConfigBuilder.setRandom(tLSConfigBuilder2.getRandom());
        tLSConfigBuilder.setCipherSuites(tLSConfigBuilder2.getCipherSuites());
        tLSConfigBuilder.setServerName(tLSConfigBuilder2.getServerName());
        tLSConfigBuilder.setTrustManager(tLSConfigBuilder2.getTrustManager());
    }

    public static final void addCertificateChain(TLSConfigBuilder tLSConfigBuilder, X509Certificate[] x509CertificateArray, PrivateKey privateKey) {
        Intrinsics.checkNotNullParameter((Object)tLSConfigBuilder, (String)"");
        Intrinsics.checkNotNullParameter((Object)x509CertificateArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"");
        ((Collection)tLSConfigBuilder.getCertificates()).add(new CertificateAndKey(x509CertificateArray, privateKey));
    }

    public static final void addKeyStoreNullablePassword(TLSConfigBuilder tLSConfigBuilder, KeyStore keyStore, char[] object, String object2) {
        Iterator iterator;
        Object object3;
        block12: {
            block11: {
                Object[] objectArray;
                Intrinsics.checkNotNullParameter((Object)tLSConfigBuilder, (String)"");
                Intrinsics.checkNotNullParameter((Object)keyStore, (String)"");
                String string = KeyManagerFactory.getDefaultAlgorithm();
                Intrinsics.checkNotNull((Object)string);
                String object5 = string;
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(string);
                Intrinsics.checkNotNull((Object)keyManagerFactory);
                KeyManagerFactory keyManagerFactory2 = keyManagerFactory;
                keyManagerFactory.init(keyStore, (char[])object);
                KeyManager[] keyManagerArray = keyManagerFactory2.getKeyManagers();
                Intrinsics.checkNotNullExpressionValue((Object)keyManagerArray, (String)"");
                Object[] objectArray2 = objectArray = (Object[])keyManagerArray;
                object3 = new ArrayList();
                for (Object object4 : objectArray2) {
                    if (!(object4 instanceof X509KeyManager)) continue;
                    object3.add(object4);
                }
                object = (List)object3;
                iterator = object2;
                if (iterator == null) break block11;
                object3 = iterator;
                if ((iterator = CollectionsKt.listOf((Object)iterator)) != null) break block12;
            }
            Enumeration<String> enumeration = keyStore.aliases();
            Intrinsics.checkNotNull(enumeration);
            ArrayList<String> arrayList = Collections.list(enumeration);
            Intrinsics.checkNotNullExpressionValue(arrayList, (String)"");
            iterator = arrayList;
        }
        Iterator iterator2 = iterator;
        object2 = iterator.iterator();
        block1: while (object2.hasNext()) {
            boolean bl;
            String string;
            block10: {
                boolean bl2;
                string = (String)object2.next();
                object3 = keyStore.getCertificateChain(string);
                if (object3 == null) {
                    String string2 = "Fail to get the certificate chain for this alias: " + string;
                    throw new IllegalStateException(string2.toString());
                }
                Certificate[] certificateArray = object3;
                int n2 = certificateArray.length;
                for (int i = 0; i < n2; ++i) {
                    Certificate certificate;
                    Certificate certificate2 = certificate = certificateArray[i];
                    if (certificate instanceof X509Certificate) continue;
                    bl = false;
                    break block10;
                }
                bl = bl2 = true;
            }
            if (!bl) {
                String string3 = "Fail to add key store " + keyStore + ". Only X509 certificate format supported.";
                throw new IllegalStateException(string3.toString());
            }
            Iterator iterator3 = object.iterator();
            while (iterator3.hasNext()) {
                Collection collection;
                Object object4;
                X509KeyManager x509KeyManager = (X509KeyManager)iterator3.next();
                if (x509KeyManager.getPrivateKey(string) == null) continue;
                Certificate[] certificateArray = object3;
                Certificate[] certificateArray2 = object3;
                object3 = new ArrayList(certificateArray.length);
                int n3 = certificateArray2.length;
                for (int i = 0; i < n3; ++i) {
                    Certificate certificate;
                    Certificate certificate3 = certificate = certificateArray2[i];
                    Object object5 = object3;
                    Intrinsics.checkNotNull((Object)certificate3);
                    object5.add((X509Certificate)certificate3);
                }
                List list = (List)object3;
                Collection collection2 = collection = (Collection)list;
                TLSConfigBuilderKt.addCertificateChain(tLSConfigBuilder, collection.toArray(new X509Certificate[0]), (PrivateKey)object4);
                continue block1;
            }
            throw new NoPrivateKeyException(string, keyStore);
        }
    }

    public static /* synthetic */ void addKeyStoreNullablePassword$default(TLSConfigBuilder tLSConfigBuilder, KeyStore keyStore, char[] cArray, String string, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string = null;
        }
        TLSConfigBuilderKt.addKeyStoreNullablePassword(tLSConfigBuilder, keyStore, cArray, string);
    }

    private static final X509TrustManager findTrustManager() {
        TrustManager[] trustManagerArray = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        Intrinsics.checkNotNull((Object)trustManagerArray);
        TrustManager[] trustManagerArray2 = trustManagerArray;
        trustManagerArray.init((KeyStore)null);
        TrustManager[] trustManagerArray3 = trustManagerArray2.getTrustManagers();
        Intrinsics.checkNotNull((Object)trustManagerArray3);
        trustManagerArray2 = trustManagerArray3;
        trustManagerArray2 = trustManagerArray3;
        trustManagerArray2 = trustManagerArray3;
        Collection collection = new ArrayList();
        for (TrustManager trustManager : trustManagerArray2) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            collection.add(trustManager);
        }
        return (X509TrustManager)CollectionsKt.first((List)((List)collection));
    }

    public static final /* synthetic */ X509TrustManager access$findTrustManager() {
        return TLSConfigBuilderKt.findTrustManager();
    }
}

