/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.awt;

import dorkbox.systemTray.Checkbox;
import dorkbox.systemTray.Entry;
import dorkbox.systemTray.Menu;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.Separator;
import dorkbox.systemTray.Status;
import dorkbox.systemTray.peer.MenuPeer;
import dorkbox.systemTray.ui.awt.AwtMenuItem;
import dorkbox.systemTray.ui.awt.AwtMenuItemCheckbox;
import dorkbox.systemTray.ui.awt.AwtMenuItemSeparator;
import dorkbox.systemTray.ui.awt.AwtMenuItemStatus;
import dorkbox.util.SwingUtil;
import java.awt.MenuShortcut;
import java.awt.PopupMenu;

class AwtMenu
implements MenuPeer {
    volatile java.awt.Menu _native;
    private final AwtMenu parent;

    AwtMenu(AwtMenu awtMenu) {
        this.parent = awtMenu;
        if (awtMenu == null) {
            this._native = new PopupMenu();
        } else {
            this._native = new java.awt.Menu();
            awtMenu._native.add(this._native);
        }
        this._native.addNotify();
    }

    @Override
    public void add(Menu menu, Entry entry, int n) {
        SwingUtil.INSTANCE.invokeAndWaitQuietly(() -> {
            if (entry instanceof Menu) {
                AwtMenu awtMenu = new AwtMenu(this);
                Menu menu2 = menu;
                ((Menu)entry).bind(awtMenu, menu2, menu2.getImageResizeUtil());
                return;
            }
            if (entry instanceof Separator) {
                AwtMenuItemSeparator awtMenuItemSeparator = new AwtMenuItemSeparator(this);
                Menu menu3 = menu;
                entry.bind(awtMenuItemSeparator, menu3, menu3.getImageResizeUtil());
                return;
            }
            if (entry instanceof Checkbox) {
                AwtMenuItemCheckbox awtMenuItemCheckbox = new AwtMenuItemCheckbox(this);
                Menu menu4 = menu;
                ((Checkbox)entry).bind(awtMenuItemCheckbox, menu4, menu4.getImageResizeUtil());
                return;
            }
            if (entry instanceof Status) {
                AwtMenuItemStatus awtMenuItemStatus = new AwtMenuItemStatus(this);
                Menu menu5 = menu;
                ((Status)entry).bind(awtMenuItemStatus, menu5, menu5.getImageResizeUtil());
                return;
            }
            if (entry instanceof MenuItem) {
                AwtMenuItem awtMenuItem = new AwtMenuItem(this);
                Menu menu6 = menu;
                ((MenuItem)entry).bind(awtMenuItem, menu6, menu6.getImageResizeUtil());
            }
        });
    }

    @Override
    public void setImage(MenuItem menuItem) {
    }

    @Override
    public void setEnabled(MenuItem menuItem) {
        SwingUtil.INSTANCE.invokeLater(() -> this._native.setEnabled(menuItem.getEnabled()));
    }

    @Override
    public void setText(MenuItem menuItem) {
        SwingUtil.INSTANCE.invokeLater(() -> this._native.setLabel(menuItem.getText()));
    }

    @Override
    public void setCallback(MenuItem menuItem) {
    }

    @Override
    public void setShortcut(MenuItem menuItem) {
        int n = SwingUtil.INSTANCE.getVirtualKey(menuItem.getShortcut());
        SwingUtil.INSTANCE.invokeLater(() -> this._native.setShortcut(new MenuShortcut(n)));
    }

    @Override
    public void setTooltip(MenuItem menuItem) {
    }

    @Override
    public void remove() {
        SwingUtil.INSTANCE.invokeLater(() -> {
            this._native.removeAll();
            this._native.deleteShortcut();
            this._native.setEnabled(false);
            if (this.parent != null) {
                this.parent._native.remove(this._native);
            }
            this._native.removeNotify();
        });
    }

    @Override
    public boolean hasParent() {
        return this.parent != null;
    }
}

