/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.osx;

import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.peer.MenuItemPeer;
import dorkbox.systemTray.ui.osx.AwtOsxMenu;
import dorkbox.systemTray.util.AwtAccessor;
import dorkbox.systemTray.util.EventDispatch;
import dorkbox.util.SwingUtil;
import java.awt.Image;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ImageIcon;

class AwtOsxMenuItem
implements MenuItemPeer {
    private final AwtOsxMenu parent;
    private final java.awt.MenuItem _native = new java.awt.MenuItem();
    private volatile ActionListener callback;
    private final Object peerObj;

    AwtOsxMenuItem(AwtOsxMenu awtOsxMenu) {
        this.parent = awtOsxMenu;
        awtOsxMenu._native.add(this._native);
        this.peerObj = AwtAccessor.getPeer(this._native);
    }

    @Override
    public void setImage(MenuItem object) {
        object = ((MenuItem)object).getImage();
        if (this.peerObj != null && object != null) {
            object = new ImageIcon(((File)object).getAbsolutePath()).getImage();
            SwingUtil.INSTANCE.invokeLater(() -> this.lambda$setImage$0((Image)object));
        }
    }

    @Override
    public void setEnabled(MenuItem menuItem) {
        SwingUtil.INSTANCE.invokeLater(() -> this._native.setEnabled(menuItem.getEnabled()));
    }

    @Override
    public void setText(MenuItem menuItem) {
        SwingUtil.INSTANCE.invokeLater(() -> this._native.setLabel(menuItem.getText()));
    }

    @Override
    public void setCallback(final MenuItem menuItem) {
        if (this.callback != null) {
            this._native.removeActionListener(this.callback);
        }
        this.callback = menuItem.getCallback();
        if (this.callback != null) {
            this.callback = new ActionListener(){
                final ActionListener cb;
                {
                    this.cb = menuItem.getCallback();
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    1 v0 = this;
                    EventDispatch.runLater(() -> {
                        try {
                            this.cb.actionPerformed(new ActionEvent(v0.menuItem, 1001, ""));
                            return;
                        }
                        catch (Throwable throwable) {
                            SystemTray.logger.error("Error calling menu entry {} click event.", (Object)v0.menuItem.getText(), (Object)throwable);
                            return;
                        }
                    });
                }
            };
            this._native.addActionListener(this.callback);
        }
    }

    @Override
    public void setShortcut(MenuItem menuItem) {
        int n = SwingUtil.INSTANCE.getVirtualKey(menuItem.getShortcut());
        SwingUtil.INSTANCE.invokeLater(() -> this._native.setShortcut(new MenuShortcut(n)));
    }

    @Override
    public void setTooltip(MenuItem object) {
        object = ((MenuItem)object).getTooltip();
        if (this.peerObj != null && object != null) {
            SwingUtil.INSTANCE.invokeLater(() -> this.lambda$setTooltip$4((String)object));
        }
    }

    @Override
    public void remove() {
        SwingUtil.INSTANCE.invokeLater(() -> {
            this._native.deleteShortcut();
            this._native.setEnabled(false);
            if (this.callback != null) {
                this._native.removeActionListener(this.callback);
                this.callback = null;
            }
            this.parent._native.remove(this._native);
            this._native.removeNotify();
        });
    }

    private /* synthetic */ void lambda$setTooltip$4(String string) {
        try {
            AwtAccessor.setToolTipText(this.peerObj, string);
            return;
        }
        catch (Exception exception) {
            SystemTray.logger.error("Unable to setTooltip for awt-osx menus.", (Throwable)exception);
            return;
        }
    }

    private /* synthetic */ void lambda$setImage$0(Image image) {
        try {
            AwtAccessor.setImage(this.peerObj, image);
            return;
        }
        catch (Exception exception) {
            SystemTray.logger.error("Unable to setImage for awt-osx menus.", (Throwable)exception);
            return;
        }
    }
}

