/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameListenerDecorator;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.TimeUnit;

final class Http2MaxRstFrameListener
extends Http2FrameListenerDecorator {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Http2MaxRstFrameListener.class);
    private static final Http2Exception RST_FRAME_RATE_EXCEEDED = Http2Exception.newStatic(Http2Error.ENHANCE_YOUR_CALM, "Maximum number of RST frames reached", Http2Exception.ShutdownHint.HARD_SHUTDOWN, Http2MaxRstFrameListener.class, "onRstStreamRead(..)");
    private final long nanosPerWindow;
    private final int maxRstFramesPerWindow;
    private long lastRstFrameNano = System.nanoTime();
    private int receivedRstInWindow;

    Http2MaxRstFrameListener(Http2FrameListener http2FrameListener, int n, int n2) {
        super(http2FrameListener);
        this.maxRstFramesPerWindow = n;
        this.nanosPerWindow = TimeUnit.SECONDS.toNanos(n2);
    }

    @Override
    public final void onRstStreamRead(ChannelHandlerContext channelHandlerContext, int n, long l) {
        long l2 = System.nanoTime();
        if (l2 - this.lastRstFrameNano >= this.nanosPerWindow) {
            this.lastRstFrameNano = l2;
            this.receivedRstInWindow = 1;
        } else {
            ++this.receivedRstInWindow;
            if (this.receivedRstInWindow > this.maxRstFramesPerWindow) {
                logger.debug("{} Maximum number {} of RST frames reached within {} seconds, closing connection with {} error", new Object[]{channelHandlerContext.channel(), this.maxRstFramesPerWindow, TimeUnit.NANOSECONDS.toSeconds(this.nanosPerWindow), RST_FRAME_RATE_EXCEEDED.error(), RST_FRAME_RATE_EXCEEDED});
                throw RST_FRAME_RATE_EXCEEDED;
            }
        }
        super.onRstStreamRead(channelHandlerContext, n, l);
    }
}

