/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;

final class MaxCapacityQueue<E>
implements Queue<E> {
    private final Queue<E> queue;
    private final int maxCapacity;

    MaxCapacityQueue(Queue<E> queue, int n) {
        this.queue = queue;
        this.maxCapacity = n;
    }

    @Override
    public final boolean add(E e) {
        if (this.offer(e)) {
            return true;
        }
        throw new IllegalStateException();
    }

    @Override
    public final boolean offer(E e) {
        if (this.maxCapacity <= this.queue.size()) {
            return false;
        }
        return this.queue.offer(e);
    }

    @Override
    public final E remove() {
        return this.queue.remove();
    }

    @Override
    public final E poll() {
        return this.queue.poll();
    }

    @Override
    public final E element() {
        return this.queue.element();
    }

    @Override
    public final E peek() {
        return this.queue.peek();
    }

    @Override
    public final int size() {
        return this.queue.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public final boolean contains(Object object) {
        return this.queue.contains(object);
    }

    @Override
    public final Iterator<E> iterator() {
        return this.queue.iterator();
    }

    @Override
    public final Object[] toArray() {
        return this.queue.toArray();
    }

    @Override
    public final <T> T[] toArray(T[] TArray) {
        return this.queue.toArray(TArray);
    }

    @Override
    public final boolean remove(Object object) {
        return this.queue.remove(object);
    }

    @Override
    public final boolean containsAll(Collection<?> collection) {
        return this.queue.containsAll(collection);
    }

    @Override
    public final boolean addAll(Collection<? extends E> collection) {
        if (this.maxCapacity >= this.size() + collection.size()) {
            return this.queue.addAll(collection);
        }
        throw new IllegalStateException();
    }

    @Override
    public final boolean removeAll(Collection<?> collection) {
        return this.queue.removeAll(collection);
    }

    @Override
    public final boolean retainAll(Collection<?> collection) {
        return this.queue.retainAll(collection);
    }

    @Override
    public final void clear() {
        this.queue.clear();
    }
}

