/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.collection;

import io.netty.util.collection.IntObjectMap;
import io.netty.util.internal.MathUtil;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class IntObjectHashMap<V>
implements IntObjectMap<V> {
    public static final int DEFAULT_CAPACITY = 8;
    public static final float DEFAULT_LOAD_FACTOR = 0.5f;
    private static final Object NULL_VALUE = new Object();
    private int maxSize;
    private final float loadFactor;
    private int[] keys;
    private V[] values;
    private int size;
    private int mask;
    private final Set<Integer> keySet = new KeySet();
    private final Set<Map.Entry<Integer, V>> entrySet = new EntrySet();
    private final Iterable<IntObjectMap.PrimitiveEntry<V>> entries = new Iterable<IntObjectMap.PrimitiveEntry<V>>(){

        @Override
        public Iterator<IntObjectMap.PrimitiveEntry<V>> iterator() {
            return new PrimitiveIterator();
        }
    };

    public IntObjectHashMap() {
        this(8, 0.5f);
    }

    public IntObjectHashMap(int n) {
        this(n, 0.5f);
    }

    public IntObjectHashMap(int n, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1");
        }
        this.loadFactor = f;
        n = MathUtil.safeFindNextPositivePowerOfTwo(n);
        this.mask = n - 1;
        this.keys = new int[n];
        Object[] objectArray = new Object[n];
        this.values = objectArray;
        this.maxSize = this.calcMaxSize(n);
    }

    private static <T> T toExternal(T t) {
        assert (t != null) : "null is not a legitimate internal value. Concurrent Modification?";
        if (t == NULL_VALUE) {
            return null;
        }
        return t;
    }

    private static <T> T toInternal(T t) {
        if (t == null) {
            return (T)NULL_VALUE;
        }
        return t;
    }

    @Override
    public V get(int n) {
        if ((n = this.indexOf(n)) == -1) {
            return null;
        }
        return IntObjectHashMap.toExternal(this.values[n]);
    }

    @Override
    public V put(int n, V v) {
        int n2;
        int n3 = n2 = this.hashIndex(n);
        do {
            if (this.values[n3] == null) {
                this.keys[n3] = n;
                this.values[n3] = IntObjectHashMap.toInternal(v);
                this.growSize();
                return null;
            }
            if (this.keys[n3] != n) continue;
            V v2 = this.values[n3];
            this.values[n3] = IntObjectHashMap.toInternal(v);
            return IntObjectHashMap.toExternal(v2);
        } while ((n3 = this.probeNext(n3)) != n2);
        throw new IllegalStateException("Unable to insert");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void putAll(Map<? extends Integer, ? extends V> object) {
        if (object instanceof IntObjectHashMap) {
            void entry;
            object = (IntObjectHashMap)((Object)object);
            boolean i = false;
            while (entry < ((IntObjectHashMap)((Object)object)).values.length) {
                V v = ((IntObjectHashMap)((Object)object)).values[entry];
                if (v != null) {
                    this.put(((IntObjectHashMap)((Object)object)).keys[entry], v);
                }
                ++entry;
            }
            return;
        }
        for (Map.Entry entry : object.entrySet()) {
            this.put((Integer)entry.getKey(), (V)entry.getValue());
        }
    }

    @Override
    public V remove(int n) {
        if ((n = this.indexOf(n)) == -1) {
            return null;
        }
        V v = this.values[n];
        this.removeAt(n);
        return IntObjectHashMap.toExternal(v);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, 0);
        Arrays.fill(this.values, null);
        this.size = 0;
    }

    @Override
    public boolean containsKey(int n) {
        return this.indexOf(n) >= 0;
    }

    @Override
    public boolean containsValue(Object object) {
        object = IntObjectHashMap.toInternal(object);
        V[] VArray = this.values;
        int n = this.values.length;
        for (int i = 0; i < n; ++i) {
            V v = VArray[i];
            if (v == null || !v.equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterable<IntObjectMap.PrimitiveEntry<V>> entries() {
        return this.entries;
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    final PrimitiveIterator iter;
                    {
                        this.iter = new PrimitiveIterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public V next() {
                        return this.iter.next().value();
                    }

                    @Override
                    public void remove() {
                        this.iter.remove();
                    }
                };
            }

            @Override
            public int size() {
                return IntObjectHashMap.this.size;
            }
        };
    }

    @Override
    public int hashCode() {
        int n = this.size;
        int[] nArray = this.keys;
        int n2 = this.keys.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[i];
            n ^= IntObjectHashMap.hashCode(n3);
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IntObjectMap)) {
            return false;
        }
        if (this.size != (object = (IntObjectMap)object).size()) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            V v = this.values[i];
            if (v == null) continue;
            int n = this.keys[i];
            Object v2 = object.get(n);
            if (!(v == NULL_VALUE ? v2 != null : !v.equals(v2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object object) {
        IntObjectHashMap intObjectHashMap = this;
        return intObjectHashMap.containsKey(intObjectHashMap.objectToKey(object));
    }

    @Override
    public V get(Object object) {
        IntObjectHashMap intObjectHashMap = this;
        return intObjectHashMap.get(intObjectHashMap.objectToKey(object));
    }

    @Override
    public V put(Integer n, V v) {
        IntObjectHashMap intObjectHashMap = this;
        return intObjectHashMap.put(intObjectHashMap.objectToKey(n), v);
    }

    @Override
    public V remove(Object object) {
        IntObjectHashMap intObjectHashMap = this;
        return intObjectHashMap.remove(intObjectHashMap.objectToKey(object));
    }

    @Override
    public Set<Integer> keySet() {
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<Integer, V>> entrySet() {
        return this.entrySet;
    }

    private int objectToKey(Object object) {
        return (Integer)object;
    }

    private int indexOf(int n) {
        int n2;
        int n3 = n2 = this.hashIndex(n);
        do {
            if (this.values[n3] == null) {
                return -1;
            }
            if (n != this.keys[n3]) continue;
            return n3;
        } while ((n3 = this.probeNext(n3)) != n2);
        return -1;
    }

    private int hashIndex(int n) {
        return IntObjectHashMap.hashCode(n) & this.mask;
    }

    private static int hashCode(int n) {
        return n;
    }

    private int probeNext(int n) {
        return n + 1 & this.mask;
    }

    private void growSize() {
        ++this.size;
        if (this.size > this.maxSize) {
            if (this.keys.length == Integer.MAX_VALUE) {
                throw new IllegalStateException("Max capacity reached at size=" + this.size);
            }
            IntObjectHashMap intObjectHashMap = this;
            intObjectHashMap.rehash(intObjectHashMap.keys.length << 1);
        }
    }

    private boolean removeAt(int n) {
        --this.size;
        this.keys[n] = 0;
        this.values[n] = null;
        int n2 = n;
        int n3 = this.probeNext(n);
        V v = this.values[n3];
        while (v != null) {
            int n4 = this.keys[n3];
            int n5 = this.hashIndex(n4);
            if (n3 < n5 && (n5 <= n2 || n2 <= n3) || n5 <= n2 && n2 <= n3) {
                this.keys[n2] = n4;
                this.values[n2] = v;
                this.keys[n3] = 0;
                this.values[n3] = null;
                n2 = n3;
            }
            n3 = this.probeNext(n3);
            v = this.values[n3];
        }
        return n2 != n;
    }

    private int calcMaxSize(int n) {
        int n2 = n - 1;
        return Math.min(n2, (int)((float)n * this.loadFactor));
    }

    private void rehash(int n) {
        int[] nArray = this.keys;
        V[] VArray = this.values;
        this.keys = new int[n];
        Object object = new Object[n];
        this.values = object;
        this.maxSize = this.calcMaxSize(n);
        this.mask = n - 1;
        block0: for (n = 0; n < VArray.length; ++n) {
            object = VArray[n];
            if (object == null) continue;
            int n2 = nArray[n];
            int n3 = this.hashIndex(n2);
            while (true) {
                if (this.values[n3] == null) {
                    this.keys[n3] = n2;
                    this.values[n3] = object;
                    continue block0;
                }
                n3 = this.probeNext(n3);
            }
        }
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(4 * this.size);
        stringBuilder.append('{');
        boolean bl = true;
        for (int i = 0; i < this.values.length; ++i) {
            V v = this.values[i];
            if (v == null) continue;
            if (!bl) {
                stringBuilder.append(", ");
            }
            IntObjectHashMap intObjectHashMap = this;
            stringBuilder.append(intObjectHashMap.keyToString(intObjectHashMap.keys[i])).append('=').append((Object)(v == this ? "(this Map)" : IntObjectHashMap.toExternal(v)));
            bl = false;
        }
        return stringBuilder.append('}').toString();
    }

    protected String keyToString(int n) {
        return Integer.toString(n);
    }

    final class MapEntry
    implements Map.Entry<Integer, V> {
        private final int entryIndex;

        MapEntry(int n) {
            this.entryIndex = n;
        }

        @Override
        public final Integer getKey() {
            this.verifyExists();
            return IntObjectHashMap.this.keys[this.entryIndex];
        }

        @Override
        public final V getValue() {
            this.verifyExists();
            return IntObjectHashMap.toExternal(IntObjectHashMap.this.values[this.entryIndex]);
        }

        @Override
        public final V setValue(V v) {
            this.verifyExists();
            Object object = IntObjectHashMap.toExternal(IntObjectHashMap.this.values[this.entryIndex]);
            ((IntObjectHashMap)IntObjectHashMap.this).values[this.entryIndex] = IntObjectHashMap.toInternal(v);
            return object;
        }

        private void verifyExists() {
            if (IntObjectHashMap.this.values[this.entryIndex] == null) {
                throw new IllegalStateException("The map entry has been removed");
            }
        }
    }

    private final class MapIterator
    implements Iterator<Map.Entry<Integer, V>> {
        private final PrimitiveIterator iter;

        private MapIterator() {
            this.iter = new PrimitiveIterator();
        }

        @Override
        public final boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public final Map.Entry<Integer, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.iter.next();
            return new MapEntry(this.iter.entryIndex);
        }

        @Override
        public final void remove() {
            this.iter.remove();
        }
    }

    private final class PrimitiveIterator
    implements IntObjectMap.PrimitiveEntry<V>,
    Iterator<IntObjectMap.PrimitiveEntry<V>> {
        private int prevIndex = -1;
        private int nextIndex = -1;
        private int entryIndex = -1;

        private PrimitiveIterator() {
        }

        private void scanNext() {
            while (++this.nextIndex != IntObjectHashMap.this.values.length && IntObjectHashMap.this.values[this.nextIndex] == null) {
            }
        }

        @Override
        public final boolean hasNext() {
            if (this.nextIndex == -1) {
                this.scanNext();
            }
            return this.nextIndex != IntObjectHashMap.this.values.length;
        }

        @Override
        public final IntObjectMap.PrimitiveEntry<V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.prevIndex = this.nextIndex;
            this.scanNext();
            this.entryIndex = this.prevIndex;
            return this;
        }

        @Override
        public final void remove() {
            if (this.prevIndex == -1) {
                throw new IllegalStateException("next must be called before each remove.");
            }
            if (IntObjectHashMap.this.removeAt(this.prevIndex)) {
                this.nextIndex = this.prevIndex;
            }
            this.prevIndex = -1;
        }

        @Override
        public final int key() {
            return IntObjectHashMap.this.keys[this.entryIndex];
        }

        @Override
        public final V value() {
            return IntObjectHashMap.toExternal(IntObjectHashMap.this.values[this.entryIndex]);
        }

        @Override
        public final void setValue(V v) {
            ((IntObjectHashMap)IntObjectHashMap.this).values[this.entryIndex] = IntObjectHashMap.toInternal(v);
        }
    }

    private final class KeySet
    extends AbstractSet<Integer> {
        private KeySet() {
        }

        @Override
        public final int size() {
            return IntObjectHashMap.this.size();
        }

        @Override
        public final boolean contains(Object object) {
            return IntObjectHashMap.this.containsKey(object);
        }

        @Override
        public final boolean remove(Object object) {
            return IntObjectHashMap.this.remove(object) != null;
        }

        @Override
        public final boolean retainAll(Collection<?> collection) {
            boolean bl = false;
            Iterator iterator = IntObjectHashMap.this.entries().iterator();
            while (iterator.hasNext()) {
                IntObjectMap.PrimitiveEntry primitiveEntry = iterator.next();
                if (collection.contains(primitiveEntry.key())) continue;
                bl = true;
                iterator.remove();
            }
            return bl;
        }

        @Override
        public final void clear() {
            IntObjectHashMap.this.clear();
        }

        @Override
        public final Iterator<Integer> iterator() {
            return new Iterator<Integer>(){
                private final Iterator<Map.Entry<Integer, V>> iter;
                {
                    this.iter = IntObjectHashMap.this.entrySet.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public Integer next() {
                    return this.iter.next().getKey();
                }

                @Override
                public void remove() {
                    this.iter.remove();
                }
            };
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<Integer, V>> {
        private EntrySet() {
        }

        @Override
        public final Iterator<Map.Entry<Integer, V>> iterator() {
            return new MapIterator();
        }

        @Override
        public final int size() {
            return IntObjectHashMap.this.size();
        }
    }
}

