/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.collection;

import io.netty.util.collection.LongObjectMap;
import io.netty.util.internal.MathUtil;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class LongObjectHashMap<V>
implements LongObjectMap<V> {
    public static final int DEFAULT_CAPACITY = 8;
    public static final float DEFAULT_LOAD_FACTOR = 0.5f;
    private static final Object NULL_VALUE = new Object();
    private int maxSize;
    private final float loadFactor;
    private long[] keys;
    private V[] values;
    private int size;
    private int mask;
    private final Set<Long> keySet = new KeySet();
    private final Set<Map.Entry<Long, V>> entrySet = new EntrySet();
    private final Iterable<LongObjectMap.PrimitiveEntry<V>> entries = new Iterable<LongObjectMap.PrimitiveEntry<V>>(){

        @Override
        public Iterator<LongObjectMap.PrimitiveEntry<V>> iterator() {
            return new PrimitiveIterator();
        }
    };

    public LongObjectHashMap() {
        this(8, 0.5f);
    }

    public LongObjectHashMap(int n) {
        this(n, 0.5f);
    }

    public LongObjectHashMap(int n, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1");
        }
        this.loadFactor = f;
        n = MathUtil.safeFindNextPositivePowerOfTwo(n);
        this.mask = n - 1;
        this.keys = new long[n];
        Object[] objectArray = new Object[n];
        this.values = objectArray;
        this.maxSize = this.calcMaxSize(n);
    }

    private static <T> T toExternal(T t) {
        assert (t != null) : "null is not a legitimate internal value. Concurrent Modification?";
        if (t == NULL_VALUE) {
            return null;
        }
        return t;
    }

    private static <T> T toInternal(T t) {
        if (t == null) {
            return (T)NULL_VALUE;
        }
        return t;
    }

    @Override
    public V get(long l) {
        int n = this.indexOf(l);
        if (n == -1) {
            return null;
        }
        return LongObjectHashMap.toExternal(this.values[n]);
    }

    @Override
    public V put(long l, V v) {
        int n;
        int n2 = n = this.hashIndex(l);
        do {
            if (this.values[n2] == null) {
                this.keys[n2] = l;
                this.values[n2] = LongObjectHashMap.toInternal(v);
                this.growSize();
                return null;
            }
            if (this.keys[n2] != l) continue;
            V v2 = this.values[n2];
            this.values[n2] = LongObjectHashMap.toInternal(v);
            return LongObjectHashMap.toExternal(v2);
        } while ((n2 = this.probeNext(n2)) != n);
        throw new IllegalStateException("Unable to insert");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void putAll(Map<? extends Long, ? extends V> object) {
        if (object instanceof LongObjectHashMap) {
            void entry;
            object = (LongObjectHashMap)((Object)object);
            boolean i = false;
            while (entry < ((LongObjectHashMap)((Object)object)).values.length) {
                V v = ((LongObjectHashMap)((Object)object)).values[entry];
                if (v != null) {
                    this.put(((LongObjectHashMap)((Object)object)).keys[entry], v);
                }
                ++entry;
            }
            return;
        }
        for (Map.Entry entry : object.entrySet()) {
            this.put((Long)entry.getKey(), (V)entry.getValue());
        }
    }

    @Override
    public V remove(long l) {
        int n = this.indexOf(l);
        if (n == -1) {
            return null;
        }
        V v = this.values[n];
        this.removeAt(n);
        return LongObjectHashMap.toExternal(v);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, 0L);
        Arrays.fill(this.values, null);
        this.size = 0;
    }

    @Override
    public boolean containsKey(long l) {
        return this.indexOf(l) >= 0;
    }

    @Override
    public boolean containsValue(Object object) {
        object = LongObjectHashMap.toInternal(object);
        V[] VArray = this.values;
        int n = this.values.length;
        for (int i = 0; i < n; ++i) {
            V v = VArray[i];
            if (v == null || !v.equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterable<LongObjectMap.PrimitiveEntry<V>> entries() {
        return this.entries;
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    final PrimitiveIterator iter;
                    {
                        this.iter = new PrimitiveIterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public V next() {
                        return this.iter.next().value();
                    }

                    @Override
                    public void remove() {
                        this.iter.remove();
                    }
                };
            }

            @Override
            public int size() {
                return LongObjectHashMap.this.size;
            }
        };
    }

    @Override
    public int hashCode() {
        int n = this.size;
        long[] lArray = this.keys;
        int n2 = this.keys.length;
        for (int i = 0; i < n2; ++i) {
            long l = lArray[i];
            n ^= LongObjectHashMap.hashCode(l);
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LongObjectMap)) {
            return false;
        }
        if (this.size != (object = (LongObjectMap)object).size()) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            V v = this.values[i];
            if (v == null) continue;
            long l = this.keys[i];
            Object v2 = object.get(l);
            if (!(v == NULL_VALUE ? v2 != null : !v.equals(v2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object object) {
        LongObjectHashMap longObjectHashMap = this;
        return longObjectHashMap.containsKey(longObjectHashMap.objectToKey(object));
    }

    @Override
    public V get(Object object) {
        LongObjectHashMap longObjectHashMap = this;
        return longObjectHashMap.get(longObjectHashMap.objectToKey(object));
    }

    @Override
    public V put(Long l, V v) {
        LongObjectHashMap longObjectHashMap = this;
        return longObjectHashMap.put(longObjectHashMap.objectToKey(l), v);
    }

    @Override
    public V remove(Object object) {
        LongObjectHashMap longObjectHashMap = this;
        return longObjectHashMap.remove(longObjectHashMap.objectToKey(object));
    }

    @Override
    public Set<Long> keySet() {
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<Long, V>> entrySet() {
        return this.entrySet;
    }

    private long objectToKey(Object object) {
        return (Long)object;
    }

    private int indexOf(long l) {
        int n;
        int n2 = n = this.hashIndex(l);
        do {
            if (this.values[n2] == null) {
                return -1;
            }
            if (l != this.keys[n2]) continue;
            return n2;
        } while ((n2 = this.probeNext(n2)) != n);
        return -1;
    }

    private int hashIndex(long l) {
        return LongObjectHashMap.hashCode(l) & this.mask;
    }

    private static int hashCode(long l) {
        long l2 = l;
        return (int)(l2 ^ l2 >>> 32);
    }

    private int probeNext(int n) {
        return n + 1 & this.mask;
    }

    private void growSize() {
        ++this.size;
        if (this.size > this.maxSize) {
            if (this.keys.length == Integer.MAX_VALUE) {
                throw new IllegalStateException("Max capacity reached at size=" + this.size);
            }
            LongObjectHashMap longObjectHashMap = this;
            longObjectHashMap.rehash(longObjectHashMap.keys.length << 1);
        }
    }

    private boolean removeAt(int n) {
        --this.size;
        this.keys[n] = 0L;
        this.values[n] = null;
        int n2 = n;
        int n3 = this.probeNext(n);
        V v = this.values[n3];
        while (v != null) {
            long l = this.keys[n3];
            int n4 = this.hashIndex(l);
            if (n3 < n4 && (n4 <= n2 || n2 <= n3) || n4 <= n2 && n2 <= n3) {
                this.keys[n2] = l;
                this.values[n2] = v;
                this.keys[n3] = 0L;
                this.values[n3] = null;
                n2 = n3;
            }
            n3 = this.probeNext(n3);
            v = this.values[n3];
        }
        return n2 != n;
    }

    private int calcMaxSize(int n) {
        int n2 = n - 1;
        return Math.min(n2, (int)((float)n * this.loadFactor));
    }

    private void rehash(int n) {
        long[] lArray = this.keys;
        V[] VArray = this.values;
        this.keys = new long[n];
        Object object = new Object[n];
        this.values = object;
        this.maxSize = this.calcMaxSize(n);
        this.mask = n - 1;
        block0: for (n = 0; n < VArray.length; ++n) {
            object = VArray[n];
            if (object == null) continue;
            long l = lArray[n];
            int n2 = this.hashIndex(l);
            while (true) {
                if (this.values[n2] == null) {
                    this.keys[n2] = l;
                    this.values[n2] = object;
                    continue block0;
                }
                n2 = this.probeNext(n2);
            }
        }
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(4 * this.size);
        stringBuilder.append('{');
        boolean bl = true;
        for (int i = 0; i < this.values.length; ++i) {
            V v = this.values[i];
            if (v == null) continue;
            if (!bl) {
                stringBuilder.append(", ");
            }
            LongObjectHashMap longObjectHashMap = this;
            stringBuilder.append(longObjectHashMap.keyToString(longObjectHashMap.keys[i])).append('=').append((Object)(v == this ? "(this Map)" : LongObjectHashMap.toExternal(v)));
            bl = false;
        }
        return stringBuilder.append('}').toString();
    }

    protected String keyToString(long l) {
        return Long.toString(l);
    }

    final class MapEntry
    implements Map.Entry<Long, V> {
        private final int entryIndex;

        MapEntry(int n) {
            this.entryIndex = n;
        }

        @Override
        public final Long getKey() {
            this.verifyExists();
            return LongObjectHashMap.this.keys[this.entryIndex];
        }

        @Override
        public final V getValue() {
            this.verifyExists();
            return LongObjectHashMap.toExternal(LongObjectHashMap.this.values[this.entryIndex]);
        }

        @Override
        public final V setValue(V v) {
            this.verifyExists();
            Object object = LongObjectHashMap.toExternal(LongObjectHashMap.this.values[this.entryIndex]);
            ((LongObjectHashMap)LongObjectHashMap.this).values[this.entryIndex] = LongObjectHashMap.toInternal(v);
            return object;
        }

        private void verifyExists() {
            if (LongObjectHashMap.this.values[this.entryIndex] == null) {
                throw new IllegalStateException("The map entry has been removed");
            }
        }
    }

    private final class MapIterator
    implements Iterator<Map.Entry<Long, V>> {
        private final PrimitiveIterator iter;

        private MapIterator() {
            this.iter = new PrimitiveIterator();
        }

        @Override
        public final boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public final Map.Entry<Long, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.iter.next();
            return new MapEntry(this.iter.entryIndex);
        }

        @Override
        public final void remove() {
            this.iter.remove();
        }
    }

    private final class PrimitiveIterator
    implements LongObjectMap.PrimitiveEntry<V>,
    Iterator<LongObjectMap.PrimitiveEntry<V>> {
        private int prevIndex = -1;
        private int nextIndex = -1;
        private int entryIndex = -1;

        private PrimitiveIterator() {
        }

        private void scanNext() {
            while (++this.nextIndex != LongObjectHashMap.this.values.length && LongObjectHashMap.this.values[this.nextIndex] == null) {
            }
        }

        @Override
        public final boolean hasNext() {
            if (this.nextIndex == -1) {
                this.scanNext();
            }
            return this.nextIndex != LongObjectHashMap.this.values.length;
        }

        @Override
        public final LongObjectMap.PrimitiveEntry<V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.prevIndex = this.nextIndex;
            this.scanNext();
            this.entryIndex = this.prevIndex;
            return this;
        }

        @Override
        public final void remove() {
            if (this.prevIndex == -1) {
                throw new IllegalStateException("next must be called before each remove.");
            }
            if (LongObjectHashMap.this.removeAt(this.prevIndex)) {
                this.nextIndex = this.prevIndex;
            }
            this.prevIndex = -1;
        }

        @Override
        public final long key() {
            return LongObjectHashMap.this.keys[this.entryIndex];
        }

        @Override
        public final V value() {
            return LongObjectHashMap.toExternal(LongObjectHashMap.this.values[this.entryIndex]);
        }

        @Override
        public final void setValue(V v) {
            ((LongObjectHashMap)LongObjectHashMap.this).values[this.entryIndex] = LongObjectHashMap.toInternal(v);
        }
    }

    private final class KeySet
    extends AbstractSet<Long> {
        private KeySet() {
        }

        @Override
        public final int size() {
            return LongObjectHashMap.this.size();
        }

        @Override
        public final boolean contains(Object object) {
            return LongObjectHashMap.this.containsKey(object);
        }

        @Override
        public final boolean remove(Object object) {
            return LongObjectHashMap.this.remove(object) != null;
        }

        @Override
        public final boolean retainAll(Collection<?> collection) {
            boolean bl = false;
            Iterator iterator = LongObjectHashMap.this.entries().iterator();
            while (iterator.hasNext()) {
                LongObjectMap.PrimitiveEntry primitiveEntry = iterator.next();
                if (collection.contains(primitiveEntry.key())) continue;
                bl = true;
                iterator.remove();
            }
            return bl;
        }

        @Override
        public final void clear() {
            LongObjectHashMap.this.clear();
        }

        @Override
        public final Iterator<Long> iterator() {
            return new Iterator<Long>(){
                private final Iterator<Map.Entry<Long, V>> iter;
                {
                    this.iter = LongObjectHashMap.this.entrySet.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public Long next() {
                    return this.iter.next().getKey();
                }

                @Override
                public void remove() {
                    this.iter.remove();
                }
            };
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<Long, V>> {
        private EntrySet() {
        }

        @Override
        public final Iterator<Map.Entry<Long, V>> iterator() {
            return new MapIterator();
        }

        @Override
        public final int size() {
            return LongObjectHashMap.this.size();
        }
    }
}

