/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.FastThreadLocalRunnable;
import io.netty.util.concurrent.FastThreadLocalThread;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.util.Locale;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultThreadFactory
implements ThreadFactory {
    private static final AtomicInteger poolId = new AtomicInteger();
    private final AtomicInteger nextId = new AtomicInteger();
    private final String prefix;
    private final boolean daemon;
    private final int priority;
    protected final ThreadGroup threadGroup;

    public DefaultThreadFactory(Class<?> clazz) {
        this(clazz, false, 5);
    }

    public DefaultThreadFactory(String string) {
        this(string, false, 5);
    }

    public DefaultThreadFactory(Class<?> clazz, boolean bl) {
        this(clazz, bl, 5);
    }

    public DefaultThreadFactory(String string, boolean bl) {
        this(string, bl, 5);
    }

    public DefaultThreadFactory(Class<?> clazz, int n) {
        this(clazz, false, n);
    }

    public DefaultThreadFactory(String string, int n) {
        this(string, false, n);
    }

    public DefaultThreadFactory(Class<?> clazz, boolean bl, int n) {
        this(DefaultThreadFactory.toPoolName(clazz), bl, n);
    }

    public static String toPoolName(Class<?> object) {
        ObjectUtil.checkNotNull(object, "poolType");
        object = StringUtil.simpleClassName(object);
        switch (((String)object).length()) {
            case 0: {
                return "unknown";
            }
            case 1: {
                return ((String)object).toLowerCase(Locale.US);
            }
        }
        if (Character.isUpperCase(((String)object).charAt(0)) && Character.isLowerCase(((String)object).charAt(1))) {
            return Character.toLowerCase(((String)object).charAt(0)) + ((String)object).substring(1);
        }
        return object;
    }

    public DefaultThreadFactory(String string, boolean bl, int n, ThreadGroup threadGroup) {
        ObjectUtil.checkNotNull(string, "poolName");
        if (n <= 0 || n > 10) {
            throw new IllegalArgumentException("priority: " + n + " (expected: Thread.MIN_PRIORITY <= priority <= Thread.MAX_PRIORITY)");
        }
        this.prefix = string + '-' + poolId.incrementAndGet() + '-';
        this.daemon = bl;
        this.priority = n;
        this.threadGroup = threadGroup;
    }

    public DefaultThreadFactory(String string, boolean bl, int n) {
        this(string, bl, n, null);
    }

    @Override
    public Thread newThread(Runnable runnable) {
        runnable = this.newThread(FastThreadLocalRunnable.wrap(runnable), this.prefix + this.nextId.incrementAndGet());
        try {
            if (((Thread)runnable).isDaemon() != this.daemon) {
                ((Thread)runnable).setDaemon(this.daemon);
            }
            if (((Thread)runnable).getPriority() != this.priority) {
                ((Thread)runnable).setPriority(this.priority);
            }
        }
        catch (Exception exception) {}
        return runnable;
    }

    protected Thread newThread(Runnable runnable, String string) {
        return new FastThreadLocalThread(this.threadGroup, runnable, string);
    }
}

