/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.NetUtil;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SocketUtils;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MacAddressUtil {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(MacAddressUtil.class);
    private static final int EUI64_MAC_ADDRESS_LENGTH = 8;
    private static final int EUI48_MAC_ADDRESS_LENGTH = 6;

    /*
     * WARNING - void declaration
     */
    public static byte[] bestAvailableMac() {
        InetAddress inetAddress;
        Object object = EmptyArrays.EMPTY_BYTES;
        InetAddress inetAddress2 = NetUtil.LOCALHOST4;
        Object object2 = new LinkedHashMap<NetworkInterface, InetAddress>();
        for (NetworkInterface networkInterface : NetUtil.NETWORK_INTERFACES) {
            Enumeration<InetAddress> enumeration = SocketUtils.addressesFromNetworkInterface(networkInterface);
            if (!enumeration.hasMoreElements() || (inetAddress = enumeration.nextElement()).isLoopbackAddress()) continue;
            object2.put(networkInterface, inetAddress);
        }
        for (Map.Entry entry : object2.entrySet()) {
            void var4_11;
            NetworkInterface networkInterface = (NetworkInterface)entry.getKey();
            inetAddress = (InetAddress)entry.getValue();
            if (networkInterface.isVirtual()) continue;
            try {
                object2 = SocketUtils.hardwareAddressFromNetworkInterface(networkInterface);
            }
            catch (SocketException socketException) {
                logger.debug("Failed to get the hardware address of a network interface: {}", (Object)networkInterface, (Object)socketException);
                continue;
            }
            boolean bl = false;
            int n = MacAddressUtil.compareAddresses(object, (byte[])object2);
            if (n < 0) {
                boolean bl2 = true;
            } else if (n == 0) {
                n = MacAddressUtil.compareAddresses(inetAddress2, inetAddress);
                if (n < 0) {
                    boolean bl3 = true;
                } else if (n == 0 && ((byte[])object).length < ((Object)object2).length) {
                    boolean bl4 = true;
                }
            }
            if (var4_11 == false) continue;
            object = object2;
            inetAddress2 = inetAddress;
        }
        if (object == EmptyArrays.EMPTY_BYTES) {
            return null;
        }
        if (((byte[])object).length == 6) {
            Object object3 = new byte[8];
            System.arraycopy(object, 0, object3, 0, 3);
            object3[3] = -1;
            object3[4] = -2;
            System.arraycopy(object, 3, object3, 5, 3);
            object = object3;
        } else {
            object = Arrays.copyOf(object, 8);
        }
        return object;
    }

    public static byte[] defaultMachineId() {
        byte[] byArray = MacAddressUtil.bestAvailableMac();
        if (byArray == null) {
            byArray = new byte[8];
            PlatformDependent.threadLocalRandom().nextBytes(byArray);
            logger.warn("Failed to find a usable hardware address from the network interfaces; using random bytes: {}", (Object)MacAddressUtil.formatAddress(byArray));
        }
        return byArray;
    }

    public static byte[] parseMAC(String string) {
        byte[] byArray;
        char c;
        switch (string.length()) {
            case 17: {
                c = string.charAt(2);
                MacAddressUtil.validateMacSeparator(c);
                byArray = new byte[6];
                break;
            }
            case 23: {
                c = string.charAt(2);
                MacAddressUtil.validateMacSeparator(c);
                byArray = new byte[8];
                break;
            }
            default: {
                throw new IllegalArgumentException("value is not supported [MAC-48, EUI-48, EUI-64]");
            }
        }
        int n = byArray.length - 1;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = n2 + 2;
            byArray[n3] = StringUtil.decodeHexByte(string, n2);
            if (string.charAt(n4) != c) {
                throw new IllegalArgumentException("expected separator '" + c + " but got '" + string.charAt(n4) + "' at index: " + n4);
            }
            ++n3;
            n2 += 3;
        }
        byArray[n] = StringUtil.decodeHexByte(string, n2);
        return byArray;
    }

    private static void validateMacSeparator(char c) {
        if (c != ':' && c != '-') {
            throw new IllegalArgumentException("unsupported separator: " + c + " (expected: [:-])");
        }
    }

    public static String formatAddress(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(24);
        for (byte by : byArray) {
            stringBuilder.append(String.format("%02x:", by & 0xFF));
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    static int compareAddresses(byte[] byArray, byte[] byArray2) {
        if (byArray2 == null || byArray2.length < 6) {
            return 1;
        }
        boolean bl = true;
        byte[] byArray3 = byArray2;
        int n = byArray2.length;
        for (int i = 0; i < n; ++i) {
            byte by = byArray3[i];
            if (by == 0 || by == 1) continue;
            bl = false;
            break;
        }
        if (bl) {
            return 1;
        }
        if ((byArray2[0] & 1) != 0) {
            return 1;
        }
        if ((byArray2[0] & 2) == 0) {
            if (byArray.length != 0 && (byArray[0] & 2) == 0) {
                return 0;
            }
            return -1;
        }
        if (byArray.length != 0 && (byArray[0] & 2) == 0) {
            return 1;
        }
        return 0;
    }

    private static int compareAddresses(InetAddress inetAddress, InetAddress inetAddress2) {
        return MacAddressUtil.scoreAddress(inetAddress) - MacAddressUtil.scoreAddress(inetAddress2);
    }

    private static int scoreAddress(InetAddress inetAddress) {
        if (inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress()) {
            return 0;
        }
        if (inetAddress.isMulticastAddress()) {
            return 1;
        }
        if (inetAddress.isLinkLocalAddress()) {
            return 2;
        }
        if (inetAddress.isSiteLocalAddress()) {
            return 3;
        }
        return 4;
    }

    private MacAddressUtil() {
    }
}

