/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues.atomic;

import io.netty.util.internal.shaded.org.jctools.queues.IndexedQueueSizeUtil;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import io.netty.util.internal.shaded.org.jctools.queues.QueueProgressIndicators;
import io.netty.util.internal.shaded.org.jctools.queues.SupportsIterator;
import io.netty.util.internal.shaded.org.jctools.queues.atomic.AtomicQueueUtil;
import io.netty.util.internal.shaded.org.jctools.util.Pow2;
import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReferenceArray;

public abstract class AtomicReferenceArrayQueue<E>
extends AbstractQueue<E>
implements IndexedQueueSizeUtil.IndexedQueue,
MessagePassingQueue<E>,
QueueProgressIndicators,
SupportsIterator {
    protected final AtomicReferenceArray<E> buffer;
    protected final int mask;

    public AtomicReferenceArrayQueue(int n) {
        n = Pow2.roundToPowerOfTwo(n);
        this.mask = n - 1;
        this.buffer = new AtomicReferenceArray(n);
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public void clear() {
        while (this.poll() != null) {
        }
    }

    @Override
    public final int capacity() {
        return this.mask + 1;
    }

    @Override
    public final int size() {
        return IndexedQueueSizeUtil.size(this, 1);
    }

    @Override
    public final boolean isEmpty() {
        return IndexedQueueSizeUtil.isEmpty(this);
    }

    @Override
    public final long currentProducerIndex() {
        return this.lvProducerIndex();
    }

    @Override
    public final long currentConsumerIndex() {
        return this.lvConsumerIndex();
    }

    @Override
    public final Iterator<E> iterator() {
        long l = this.lvConsumerIndex();
        long l2 = this.lvProducerIndex();
        return new WeakIterator<E>(l, l2, this.mask, this.buffer);
    }

    private static class WeakIterator<E>
    implements Iterator<E> {
        private final long pIndex;
        private final int mask;
        private final AtomicReferenceArray<E> buffer;
        private long nextIndex;
        private E nextElement;

        WeakIterator(long l, long l2, int n, AtomicReferenceArray<E> atomicReferenceArray) {
            this.nextIndex = l;
            this.pIndex = l2;
            this.mask = n;
            this.buffer = atomicReferenceArray;
            this.nextElement = this.getNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public boolean hasNext() {
            return this.nextElement != null;
        }

        @Override
        public E next() {
            E e = this.nextElement;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.nextElement = this.getNext();
            return e;
        }

        private E getNext() {
            int n = this.mask;
            AtomicReferenceArray<E> atomicReferenceArray = this.buffer;
            while (this.nextIndex < this.pIndex) {
                int n2;
                E e;
                if ((e = AtomicQueueUtil.lvRefElement(atomicReferenceArray, n2 = AtomicQueueUtil.calcCircularRefElementOffset(this.nextIndex++, n))) == null) continue;
                return e;
            }
            return null;
        }
    }
}

