/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf;

import com.formdev.flatlaf.util.SystemInfo;
import java.io.Serializable;
import java.util.function.BooleanSupplier;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.InputMapUIResource;

class FlatInputMaps {
    FlatInputMaps() {
    }

    static void initInputMaps(UIDefaults uIDefaults) {
        FlatInputMaps.initBasicInputMaps(uIDefaults);
        FlatInputMaps.initTextComponentInputMaps(uIDefaults);
        if (SystemInfo.isMacOS) {
            FlatInputMaps.initMacInputMaps(uIDefaults);
        }
    }

    private static void initBasicInputMaps(UIDefaults uIDefaults) {
        if (SystemInfo.isMacOS) {
            uIDefaults.put("Button.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"}));
        }
        FlatInputMaps.modifyInputMap(uIDefaults, "ComboBox.ancestorInputMap", "UP", FlatInputMaps.mac("selectPrevious2", "selectPrevious"), "DOWN", FlatInputMaps.mac("selectNext2", "selectNext"), "KP_UP", FlatInputMaps.mac("selectPrevious2", "selectPrevious"), "KP_DOWN", FlatInputMaps.mac("selectNext2", "selectNext"), FlatInputMaps.mac("alt UP", null), "togglePopup", FlatInputMaps.mac("alt DOWN", null), "togglePopup", FlatInputMaps.mac("alt KP_UP", null), "togglePopup", FlatInputMaps.mac("alt KP_DOWN", null), "togglePopup");
        if (!SystemInfo.isMacOS) {
            FlatInputMaps.modifyInputMap(uIDefaults, "FileChooser.ancestorInputMap", "F2", "editFileName", "BACK_SPACE", "Go Up");
        }
        Object[] objectArray = (Object[])uIDefaults.get("PopupMenu.selectedWindowInputMapBindings");
        Object[] objectArray2 = (Object[])uIDefaults.get("PopupMenu.selectedWindowInputMapBindings.RightToLeft");
        if (objectArray != null && objectArray2 != null) {
            Object[] objectArray3 = new Object[objectArray.length + objectArray2.length];
            System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
            System.arraycopy(objectArray2, 0, objectArray3, objectArray.length, objectArray2.length);
            uIDefaults.put("PopupMenu.selectedWindowInputMapBindings.RightToLeft", objectArray3);
        }
        FlatInputMaps.modifyInputMap(uIDefaults, "TabbedPane.ancestorInputMap", "ctrl TAB", "navigateNext", "shift ctrl TAB", "navigatePrevious");
        FlatInputMaps.modifyInputMap(() -> UIManager.getBoolean("Table.consistentHomeEndKeyBehavior"), uIDefaults, "Table.ancestorInputMap", "HOME", "selectFirstRow", "END", "selectLastRow", "shift HOME", "selectFirstRowExtendSelection", "shift END", "selectLastRowExtendSelection", FlatInputMaps.mac("ctrl HOME", null), "selectFirstColumn", FlatInputMaps.mac("ctrl END", null), "selectLastColumn", FlatInputMaps.mac("shift ctrl HOME", null), "selectFirstColumnExtendSelection", FlatInputMaps.mac("shift ctrl END", null), "selectLastColumnExtendSelection");
        if (!SystemInfo.isMacOS) {
            FlatInputMaps.modifyInputMap(uIDefaults, "Tree.focusInputMap", "ADD", "expand", "SUBTRACT", "collapse");
        }
    }

    private static void initTextComponentInputMaps(UIDefaults uIDefaults) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3;
        Object object = new Object[]{"LEFT", "caret-backward", "RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "shift LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_LEFT", "selection-backward", "shift KP_RIGHT", "selection-forward", FlatInputMaps.mac("ctrl LEFT", "alt LEFT"), "caret-previous-word", FlatInputMaps.mac("ctrl RIGHT", "alt RIGHT"), "caret-next-word", FlatInputMaps.mac("ctrl KP_LEFT", "alt KP_LEFT"), "caret-previous-word", FlatInputMaps.mac("ctrl KP_RIGHT", "alt KP_RIGHT"), "caret-next-word", FlatInputMaps.mac("ctrl shift LEFT", "shift alt LEFT"), "selection-previous-word", FlatInputMaps.mac("ctrl shift RIGHT", "shift alt RIGHT"), "selection-next-word", FlatInputMaps.mac("ctrl shift KP_LEFT", "shift alt KP_LEFT"), "selection-previous-word", FlatInputMaps.mac("ctrl shift KP_RIGHT", "shift alt KP_RIGHT"), "selection-next-word", FlatInputMaps.mac("HOME", "meta LEFT"), "caret-begin-line", FlatInputMaps.mac("END", "meta RIGHT"), "caret-end-line", FlatInputMaps.mac("shift HOME", "shift meta LEFT"), "selection-begin-line", FlatInputMaps.mac("shift END", "shift meta RIGHT"), "selection-end-line", FlatInputMaps.mac("ctrl A", "meta A"), "select-all", FlatInputMaps.mac("ctrl BACK_SLASH", "meta BACK_SLASH"), "unselect", "BACK_SPACE", "delete-previous", "shift BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", FlatInputMaps.mac("ctrl BACK_SPACE", "alt BACK_SPACE"), "delete-previous-word", FlatInputMaps.mac("ctrl DELETE", "alt DELETE"), "delete-next-word", FlatInputMaps.mac("ctrl X", "meta X"), "cut-to-clipboard", FlatInputMaps.mac("ctrl C", "meta C"), "copy-to-clipboard", FlatInputMaps.mac("ctrl V", "meta V"), "paste-from-clipboard", "CUT", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", FlatInputMaps.mac("shift DELETE", null), "cut-to-clipboard", FlatInputMaps.mac("control INSERT", null), "copy-to-clipboard", FlatInputMaps.mac("shift INSERT", null), "paste-from-clipboard", "control shift O", "toggle-componentOrientation"};
        if (SystemInfo.isMacOS) {
            Object[] objectArray4 = new Object[58];
            objectArray4[0] = "ctrl B";
            objectArray4[1] = "caret-backward";
            objectArray4[2] = "ctrl F";
            objectArray4[3] = "caret-forward";
            objectArray4[4] = "HOME";
            objectArray4[5] = "caret-begin";
            objectArray4[6] = "END";
            objectArray4[7] = "caret-end";
            objectArray4[8] = "meta UP";
            objectArray4[9] = "caret-begin";
            objectArray4[10] = "meta DOWN";
            objectArray4[11] = "caret-end";
            objectArray4[12] = "meta KP_UP";
            objectArray4[13] = "caret-begin";
            objectArray4[14] = "meta KP_DOWN";
            objectArray4[15] = "caret-end";
            objectArray4[16] = "ctrl P";
            objectArray4[17] = "caret-begin";
            objectArray4[18] = "ctrl N";
            objectArray4[19] = "caret-end";
            objectArray4[20] = "ctrl V";
            objectArray4[21] = "caret-end";
            objectArray4[22] = "meta KP_LEFT";
            objectArray4[23] = "caret-begin-line";
            objectArray4[24] = "meta KP_RIGHT";
            objectArray4[25] = "caret-end-line";
            objectArray4[26] = "ctrl A";
            objectArray4[27] = "caret-begin-line";
            objectArray4[28] = "ctrl E";
            objectArray4[29] = "caret-end-line";
            objectArray4[30] = "shift meta UP";
            objectArray4[31] = "selection-begin";
            objectArray4[32] = "shift meta DOWN";
            objectArray4[33] = "selection-end";
            objectArray4[34] = "shift meta KP_UP";
            objectArray4[35] = "selection-begin";
            objectArray4[36] = "shift meta KP_DOWN";
            objectArray4[37] = "selection-end";
            objectArray4[38] = "shift HOME";
            objectArray4[39] = "selection-begin";
            objectArray4[40] = "shift END";
            objectArray4[41] = "selection-end";
            objectArray4[42] = "shift meta KP_LEFT";
            objectArray4[43] = "selection-begin-line";
            objectArray4[44] = "shift meta KP_RIGHT";
            objectArray4[45] = "selection-end-line";
            objectArray4[46] = "shift UP";
            objectArray4[47] = "selection-begin-line";
            objectArray4[48] = "shift DOWN";
            objectArray4[49] = "selection-end-line";
            objectArray4[50] = "shift KP_UP";
            objectArray4[51] = "selection-begin-line";
            objectArray4[52] = "shift KP_DOWN";
            objectArray4[53] = "selection-end-line";
            objectArray4[54] = "ctrl W";
            objectArray4[55] = "delete-previous-word";
            objectArray4[56] = "ctrl D";
            objectArray3 = objectArray4;
            objectArray4[57] = "delete-next";
        } else {
            objectArray3 = null;
        }
        Object[] objectArray5 = objectArray3;
        Object[] objectArray6 = new Object[]{"ENTER", "notify-field-accept"};
        if (SystemInfo.isMacOS) {
            Object[] objectArray7 = new Object[8];
            objectArray7[0] = "UP";
            objectArray7[1] = "caret-begin-line";
            objectArray7[2] = "DOWN";
            objectArray7[3] = "caret-end-line";
            objectArray7[4] = "KP_UP";
            objectArray7[5] = "caret-begin-line";
            objectArray7[6] = "KP_DOWN";
            objectArray2 = objectArray7;
            objectArray7[7] = "caret-end-line";
        } else {
            objectArray2 = null;
        }
        Object[] objectArray8 = objectArray2;
        Object[] objectArray9 = new Object[]{"ESCAPE", "reset-field-edit", "UP", "increment", "DOWN", "decrement", "KP_UP", "increment", "KP_DOWN", "decrement"};
        Object[] objectArray10 = new Object[]{FlatInputMaps.mac("ctrl LEFT", "alt LEFT"), "caret-begin-line", FlatInputMaps.mac("ctrl RIGHT", "alt RIGHT"), "caret-end-line", FlatInputMaps.mac("ctrl KP_LEFT", "alt KP_LEFT"), "caret-begin-line", FlatInputMaps.mac("ctrl KP_RIGHT", "alt KP_RIGHT"), "caret-end-line", FlatInputMaps.mac("ctrl shift LEFT", "shift alt LEFT"), "selection-begin-line", FlatInputMaps.mac("ctrl shift RIGHT", "shift alt RIGHT"), "selection-end-line", FlatInputMaps.mac("ctrl shift KP_LEFT", "shift alt KP_LEFT"), "selection-begin-line", FlatInputMaps.mac("ctrl shift KP_RIGHT", "shift alt KP_RIGHT"), "selection-end-line", FlatInputMaps.mac("ctrl BACK_SPACE", "alt BACK_SPACE"), null, FlatInputMaps.mac("ctrl DELETE", "alt DELETE"), null};
        Object[] objectArray11 = new Object[]{"UP", "caret-up", "DOWN", "caret-down", "KP_UP", "caret-up", "KP_DOWN", "caret-down", "shift UP", "selection-up", "shift DOWN", "selection-down", "shift KP_UP", "selection-up", "shift KP_DOWN", "selection-down", "PAGE_UP", "page-up", "PAGE_DOWN", "page-down", "shift PAGE_UP", "selection-page-up", "shift PAGE_DOWN", "selection-page-down", FlatInputMaps.mac("ctrl shift PAGE_UP", "shift meta PAGE_UP"), "selection-page-left", FlatInputMaps.mac("ctrl shift PAGE_DOWN", "shift meta PAGE_DOWN"), "selection-page-right", FlatInputMaps.mac("ctrl HOME", "meta UP"), "caret-begin", FlatInputMaps.mac("ctrl END", "meta DOWN"), "caret-end", FlatInputMaps.mac("ctrl shift HOME", "shift meta UP"), "selection-begin", FlatInputMaps.mac("ctrl shift END", "shift meta DOWN"), "selection-end", "ENTER", "insert-break", "TAB", "insert-tab", FlatInputMaps.mac("ctrl T", "meta T"), "next-link-action", FlatInputMaps.mac("ctrl shift T", "shift meta T"), "previous-link-action", FlatInputMaps.mac("ctrl SPACE", "meta SPACE"), "activate-link-action"};
        if (SystemInfo.isMacOS) {
            Object[] objectArray12 = new Object[14];
            objectArray12[0] = "ctrl N";
            objectArray12[1] = "caret-down";
            objectArray12[2] = "ctrl P";
            objectArray12[3] = "caret-up";
            objectArray12[4] = "shift alt UP";
            objectArray12[5] = "selection-begin-paragraph";
            objectArray12[6] = "shift alt DOWN";
            objectArray12[7] = "selection-end-paragraph";
            objectArray12[8] = "shift alt KP_UP";
            objectArray12[9] = "selection-begin-paragraph";
            objectArray12[10] = "shift alt KP_DOWN";
            objectArray12[11] = "selection-end-paragraph";
            objectArray12[12] = "ctrl V";
            objectArray = objectArray12;
            objectArray12[13] = "page-down";
        } else {
            objectArray = null;
        }
        Object[] objectArray13 = objectArray;
        uIDefaults.put("TextField.focusInputMap", new LazyInputMapEx(new Object[][]{object, objectArray5, objectArray6, objectArray8}));
        uIDefaults.put("FormattedTextField.focusInputMap", new LazyInputMapEx(new Object[][]{object, objectArray5, objectArray6, objectArray8, objectArray9}));
        uIDefaults.put("PasswordField.focusInputMap", new LazyInputMapEx(new Object[][]{object, objectArray5, objectArray6, objectArray8, objectArray10}));
        object = new LazyInputMapEx(new Object[][]{object, objectArray5, objectArray11, objectArray13});
        uIDefaults.put("TextArea.focusInputMap", object);
        uIDefaults.put("TextPane.focusInputMap", object);
        uIDefaults.put("EditorPane.focusInputMap", object);
    }

    private static void initMacInputMaps(UIDefaults uIDefaults) {
        FlatInputMaps.modifyInputMap(uIDefaults, "List.focusInputMap", "meta A", "selectAll", "meta C", "copy", "meta V", "paste", "meta X", "cut", "HOME", null, "END", null, "PAGE_UP", null, "PAGE_DOWN", null, "ctrl A", null, "ctrl BACK_SLASH", null, "ctrl C", null, "ctrl DOWN", null, "ctrl END", null, "ctrl HOME", null, "ctrl INSERT", null, "ctrl KP_DOWN", null, "ctrl KP_LEFT", null, "ctrl KP_RIGHT", null, "ctrl KP_UP", null, "ctrl LEFT", null, "ctrl PAGE_DOWN", null, "ctrl PAGE_UP", null, "ctrl RIGHT", null, "ctrl SLASH", null, "ctrl SPACE", null, "ctrl UP", null, "ctrl V", null, "ctrl X", null, "SPACE", null, "shift ctrl DOWN", null, "shift ctrl END", null, "shift ctrl HOME", null, "shift ctrl KP_DOWN", null, "shift ctrl KP_LEFT", null, "shift ctrl KP_RIGHT", null, "shift ctrl KP_UP", null, "shift ctrl LEFT", null, "shift ctrl PAGE_DOWN", null, "shift ctrl PAGE_UP", null, "shift ctrl RIGHT", null, "shift ctrl SPACE", null, "shift ctrl UP", null, "shift DELETE", null, "shift INSERT", null, "shift SPACE", null);
        FlatInputMaps.modifyInputMap(uIDefaults, "List.focusInputMap.RightToLeft", "ctrl KP_LEFT", null, "ctrl KP_RIGHT", null, "ctrl LEFT", null, "ctrl RIGHT", null, "shift ctrl KP_LEFT", null, "shift ctrl KP_RIGHT", null, "shift ctrl LEFT", null, "shift ctrl RIGHT", null);
        FlatInputMaps.modifyInputMap(uIDefaults, "ScrollPane.ancestorInputMap", "END", "scrollEnd", "HOME", "scrollHome", "ctrl END", null, "ctrl HOME", null, "ctrl PAGE_DOWN", null, "ctrl PAGE_UP", null);
        FlatInputMaps.modifyInputMap(uIDefaults, "ScrollPane.ancestorInputMap.RightToLeft", "ctrl PAGE_DOWN", null, "ctrl PAGE_UP", null);
        FlatInputMaps.modifyInputMap(uIDefaults, "TabbedPane.ancestorInputMap", "ctrl UP", null, "ctrl KP_UP", null);
        FlatInputMaps.modifyInputMap(uIDefaults, "TabbedPane.focusInputMap", "ctrl DOWN", null, "ctrl KP_DOWN", null);
        FlatInputMaps.modifyInputMap(uIDefaults, "Table.ancestorInputMap", "alt TAB", "focusHeader", "shift alt TAB", "focusHeader", "meta A", "selectAll", "meta C", "copy", "meta V", "paste", "meta X", "cut", "HOME", null, "END", null, "PAGE_UP", null, "PAGE_DOWN", null, "ctrl A", null, "ctrl BACK_SLASH", null, "ctrl C", null, "ctrl DOWN", null, "ctrl END", null, "ctrl HOME", null, "ctrl INSERT", null, "ctrl KP_DOWN", null, "ctrl KP_LEFT", null, "ctrl KP_RIGHT", null, "ctrl KP_UP", null, "ctrl LEFT", null, "ctrl PAGE_DOWN", null, "ctrl PAGE_UP", null, "ctrl RIGHT", null, "ctrl SLASH", null, "ctrl SPACE", null, "ctrl UP", null, "ctrl V", null, "ctrl X", null, "F2", null, "F8", null, "SPACE", null, "shift ctrl DOWN", null, "shift ctrl END", null, "shift ctrl HOME", null, "shift ctrl KP_DOWN", null, "shift ctrl KP_LEFT", null, "shift ctrl KP_RIGHT", null, "shift ctrl KP_UP", null, "shift ctrl LEFT", null, "shift ctrl PAGE_DOWN", null, "shift ctrl PAGE_UP", null, "shift ctrl RIGHT", null, "shift ctrl SPACE", null, "shift ctrl UP", null, "shift DELETE", null, "shift INSERT", null, "shift SPACE", null);
        FlatInputMaps.modifyInputMap(uIDefaults, "Table.ancestorInputMap.RightToLeft", "ctrl KP_LEFT", null, "ctrl KP_RIGHT", null, "ctrl LEFT", null, "ctrl RIGHT", null, "shift ctrl KP_LEFT", null, "shift ctrl KP_RIGHT", null, "shift ctrl LEFT", null, "shift ctrl RIGHT", null);
        FlatInputMaps.modifyInputMap(uIDefaults, "Tree.focusInputMap", "LEFT", "selectParent", "RIGHT", "selectChild", "KP_LEFT", "selectParent", "KP_RIGHT", "selectChild", "shift LEFT", "selectParent", "shift RIGHT", "selectChild", "shift KP_LEFT", "selectParent", "shift KP_RIGHT", "selectChild", "alt LEFT", "selectParent", "alt RIGHT", "selectChild", "alt KP_LEFT", "selectParent", "alt KP_RIGHT", "selectChild", "shift HOME", "selectFirstExtendSelection", "shift END", "selectLastExtendSelection", "meta A", "selectAll", "meta C", "copy", "meta V", "paste", "meta X", "cut", "HOME", null, "END", null, "PAGE_UP", null, "PAGE_DOWN", null, "ctrl LEFT", null, "ctrl RIGHT", null, "ctrl KP_LEFT", null, "ctrl KP_RIGHT", null, "ctrl A", null, "ctrl BACK_SLASH", null, "ctrl C", null, "ctrl DOWN", null, "ctrl END", null, "ctrl HOME", null, "ctrl INSERT", null, "ctrl KP_DOWN", null, "ctrl KP_UP", null, "ctrl PAGE_DOWN", null, "ctrl PAGE_UP", null, "ctrl SLASH", null, "ctrl SPACE", null, "ctrl UP", null, "ctrl V", null, "ctrl X", null, "F2", null, "SPACE", null, "shift ctrl DOWN", null, "shift ctrl END", null, "shift ctrl HOME", null, "shift ctrl KP_DOWN", null, "shift ctrl KP_UP", null, "shift ctrl PAGE_DOWN", null, "shift ctrl PAGE_UP", null, "shift ctrl SPACE", null, "shift ctrl UP", null, "shift DELETE", null, "shift INSERT", null, "shift PAGE_DOWN", null, "shift PAGE_UP", null, "shift SPACE", null);
        uIDefaults.put("Tree.focusInputMap.RightToLeft", new UIDefaults.LazyInputMap(new Object[]{"LEFT", "selectChild", "RIGHT", "selectParent", "KP_LEFT", "selectChild", "KP_RIGHT", "selectParent", "shift LEFT", "selectChild", "shift RIGHT", "selectParent", "shift KP_LEFT", "selectChild", "shift KP_RIGHT", "selectParent", "alt LEFT", "selectChild", "alt RIGHT", "selectParent", "alt KP_LEFT", "selectChild", "alt KP_RIGHT", "selectParent"}));
    }

    private static void modifyInputMap(UIDefaults uIDefaults, String string, Object ... objectArray) {
        FlatInputMaps.modifyInputMap(null, uIDefaults, string, objectArray);
    }

    private static void modifyInputMap(BooleanSupplier booleanSupplier, UIDefaults uIDefaults, String string, Object ... objectArray) {
        uIDefaults.put(string, new LazyModifyInputMap(booleanSupplier, uIDefaults.remove(string), objectArray));
    }

    private static <T> T mac(T t, T t2) {
        if (SystemInfo.isMacOS) {
            return t2;
        }
        return t;
    }

    private static class LazyModifyInputMap
    implements UIDefaults.LazyValue {
        private final BooleanSupplier condition;
        private final Object baseInputMap;
        private final Object[] bindings;

        LazyModifyInputMap(BooleanSupplier booleanSupplier, Object object, Object[] objectArray) {
            this.condition = booleanSupplier;
            this.baseInputMap = object;
            this.bindings = objectArray;
        }

        @Override
        public Object createValue(UIDefaults serializable) {
            Serializable serializable2 = serializable = this.baseInputMap instanceof UIDefaults.LazyValue ? (InputMap)((UIDefaults.LazyValue)this.baseInputMap).createValue((UIDefaults)serializable) : (InputMap)this.baseInputMap;
            if (this.condition != null && !this.condition.getAsBoolean()) {
                return serializable;
            }
            for (int i = 0; i < this.bindings.length; i += 2) {
                KeyStroke keyStroke = KeyStroke.getKeyStroke((String)this.bindings[i]);
                if (this.bindings[i + 1] != null) {
                    ((InputMap)serializable).put(keyStroke, this.bindings[i + 1]);
                    continue;
                }
                ((InputMap)serializable).remove(keyStroke);
            }
            return serializable;
        }
    }

    private static class LazyInputMapEx
    implements UIDefaults.LazyValue {
        private final Object[][] bindingsArray;

        LazyInputMapEx(Object[] ... objectArray) {
            this.bindingsArray = objectArray;
        }

        @Override
        public Object createValue(UIDefaults serializable) {
            serializable = new InputMapUIResource();
            Object[][] objectArray = this.bindingsArray;
            int n = this.bindingsArray.length;
            for (int i = 0; i < n; ++i) {
                Object[] objectArray2 = objectArray[i];
                LookAndFeel.loadKeyBindings((InputMap)serializable, objectArray2);
            }
            return serializable;
        }
    }
}

