/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.icons.FlatCheckBoxIcon;
import com.formdev.flatlaf.ui.FlatButtonUI;
import com.formdev.flatlaf.ui.FlatLabelUI;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.MigLayoutVisualPadding;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicRadioButtonUI;

public class FlatRadioButtonUI
extends BasicRadioButtonUI
implements FlatStylingSupport.StyleableUI {
    protected int iconTextGap;
    @FlatStylingSupport.Styleable
    protected Color disabledText;
    private Color defaultBackground;
    private final boolean shared;
    private boolean iconShared = true;
    private boolean defaults_initialized = false;
    private Map<String, Object> oldStyleValues;
    private static final Insets tempInsets = new Insets(0, 0, 0, 0);

    public static ComponentUI createUI(JComponent jComponent) {
        if (FlatUIUtils.canUseSharedUI(jComponent) && !FlatUIUtils.needsLightAWTPeer(jComponent)) {
            return FlatUIUtils.createSharedUI(FlatRadioButtonUI.class, () -> new FlatRadioButtonUI(true));
        }
        return new FlatRadioButtonUI(false);
    }

    protected FlatRadioButtonUI(boolean bl) {
        this.shared = bl;
    }

    @Override
    public void installUI(JComponent jComponent) {
        if (FlatUIUtils.needsLightAWTPeer(jComponent)) {
            FlatUIUtils.runWithLightAWTPeerUIDefaults(() -> this.installUIImpl(jComponent));
            return;
        }
        this.installUIImpl(jComponent);
    }

    private void installUIImpl(JComponent jComponent) {
        super.installUI(jComponent);
        if (FlatUIUtils.isAWTPeer(jComponent)) {
            AWTPeerMouseExitedFix.install(jComponent);
        }
        this.installStyle((AbstractButton)jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        if (FlatUIUtils.isAWTPeer(jComponent)) {
            AWTPeerMouseExitedFix.uninstall(jComponent);
        }
    }

    @Override
    public void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        if (!this.defaults_initialized) {
            String string = this.getPropertyPrefix();
            this.iconTextGap = FlatUIUtils.getUIInt(string + "iconTextGap", 4);
            this.disabledText = UIManager.getColor(string + "disabledText");
            this.defaultBackground = UIManager.getColor(string + "background");
            this.iconShared = true;
            this.defaults_initialized = true;
        }
        LookAndFeel.installProperty(abstractButton, "opaque", Boolean.FALSE);
        LookAndFeel.installProperty(abstractButton, "iconTextGap", UIScale.scale(this.iconTextGap));
        MigLayoutVisualPadding.install(abstractButton, null);
    }

    @Override
    protected void uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
        this.oldStyleValues = null;
        MigLayoutVisualPadding.uninstall(abstractButton);
        this.defaults_initialized = false;
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton abstractButton) {
        return new FlatRadioButtonListener(abstractButton);
    }

    protected void propertyChange(AbstractButton abstractButton, PropertyChangeEvent object) {
        switch (((PropertyChangeEvent)object).getPropertyName()) {
            case "FlatLaf.style": 
            case "FlatLaf.styleClass": {
                if (this.shared && FlatStylingSupport.hasStyleProperty(abstractButton)) {
                    abstractButton.updateUI();
                } else {
                    this.installStyle(abstractButton);
                }
                abstractButton.revalidate();
                abstractButton.repaint();
            }
        }
    }

    protected void installStyle(AbstractButton abstractButton) {
        try {
            AbstractButton abstractButton2 = abstractButton;
            this.applyStyle(abstractButton2, FlatStylingSupport.getResolvedStyle(abstractButton2, this.getStyleType()));
            return;
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
            return;
        }
    }

    String getStyleType() {
        return "RadioButton";
    }

    protected void applyStyle(AbstractButton abstractButton, Object object2) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object2, (string, object) -> this.applyStyleProperty(abstractButton, (String)string, object));
    }

    protected Object applyStyleProperty(AbstractButton abstractButton, String string, Object object) {
        if (string.startsWith("icon.")) {
            if (!(this.icon instanceof FlatCheckBoxIcon)) {
                return new FlatStylingSupport.UnknownStyleException(string);
            }
            if (this.iconShared) {
                this.icon = FlatStylingSupport.cloneIcon(this.icon);
                this.iconShared = false;
            }
            string = string.substring(5);
            return ((FlatCheckBoxIcon)this.icon).applyStyleProperty(string, object);
        }
        if ("iconTextGap".equals(string) && object instanceof Integer) {
            object = UIScale.scale((Integer)object);
        }
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(this, abstractButton, string, object);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent object) {
        object = FlatStylingSupport.getAnnotatedStyleableInfos(this);
        if (this.icon instanceof FlatCheckBoxIcon) {
            for (Map.Entry<String, Class<?>> entry : ((FlatCheckBoxIcon)this.icon).getStyleableInfos().entrySet()) {
                object.put("icon.".concat(entry.getKey()), entry.getValue());
            }
        }
        return object;
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        if (string.startsWith("icon.")) {
            if (this.icon instanceof FlatCheckBoxIcon) {
                return ((FlatCheckBoxIcon)this.icon).getStyleableValue(string.substring(5));
            }
            return null;
        }
        return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
    }

    @Override
    public Dimension getPreferredSize(JComponent serializable) {
        Dimension dimension = super.getPreferredSize((JComponent)serializable);
        if (dimension == null) {
            return null;
        }
        int n = this.getIconFocusWidth((JComponent)serializable);
        if (n > 0) {
            serializable = serializable.getInsets(tempInsets);
            dimension.width += Math.max(n - ((Insets)serializable).left, 0) + Math.max(n - ((Insets)serializable).right, 0);
            dimension.height += Math.max(n - ((Insets)serializable).top, 0) + Math.max(n - ((Insets)serializable).bottom, 0);
        }
        return dimension;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        int n;
        if (!jComponent.isOpaque() && ((AbstractButton)jComponent).isContentAreaFilled() && !Objects.equals(jComponent.getBackground(), this.getDefaultBackground(jComponent))) {
            graphics.setColor(jComponent.getBackground());
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
        if ((n = this.getIconFocusWidth(jComponent)) > 0) {
            boolean bl = jComponent.getComponentOrientation().isLeftToRight();
            int n2 = ((AbstractButton)jComponent).getHorizontalAlignment();
            if (n2 == 10) {
                n2 = bl ? 2 : 4;
            } else if (n2 == 11) {
                n2 = bl ? 4 : 2;
            }
            Insets insets = jComponent.getInsets(tempInsets);
            if (!(n <= insets.left && n <= insets.right || n2 != 2 && n2 != 4)) {
                n = n2 == 2 ? Math.max(n - insets.left, 0) : -Math.max(n - insets.right, 0);
                graphics.translate(n, 0);
                super.paint(FlatLabelUI.createGraphicsHTMLTextYCorrection(graphics, jComponent), jComponent);
                graphics.translate(-n, 0);
                return;
            }
        }
        super.paint(FlatLabelUI.createGraphicsHTMLTextYCorrection(graphics, jComponent), jComponent);
    }

    @Override
    protected void paintText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string) {
        FlatButtonUI.paintText(graphics, abstractButton, rectangle, string, abstractButton.isEnabled() ? abstractButton.getForeground() : this.disabledText);
    }

    private Color getDefaultBackground(JComponent container) {
        if ((container = container.getParent()) instanceof CellRendererPane && container.getParent() != null) {
            return container.getParent().getBackground();
        }
        return this.defaultBackground;
    }

    private int getIconFocusWidth(JComponent object) {
        object = (AbstractButton)object;
        if ((object = ((AbstractButton)object).getIcon()) == null) {
            object = this.getDefaultIcon();
        }
        if (object instanceof FlatCheckBoxIcon) {
            return Math.round(UIScale.scale(((FlatCheckBoxIcon)object).getFocusWidth()));
        }
        return 0;
    }

    @Override
    public int getBaseline(JComponent jComponent, int n, int n2) {
        return FlatButtonUI.getBaselineImpl(jComponent, n, n2);
    }

    private static class AWTPeerMouseExitedFix
    extends MouseAdapter
    implements PropertyChangeListener {
        private final JComponent button;

        static void install(JComponent container) {
            AWTPeerMouseExitedFix aWTPeerMouseExitedFix = new AWTPeerMouseExitedFix((JComponent)container);
            container.addPropertyChangeListener("ancestor", aWTPeerMouseExitedFix);
            container = container.getParent();
            if (container != null) {
                container.addMouseListener(aWTPeerMouseExitedFix);
            }
        }

        static void uninstall(JComponent container) {
            for (PropertyChangeListener propertyChangeListener : container.getPropertyChangeListeners("ancestor")) {
                if (!(propertyChangeListener instanceof AWTPeerMouseExitedFix)) continue;
                container.removePropertyChangeListener("ancestor", propertyChangeListener);
                container = container.getParent();
                if (container == null) break;
                container.removeMouseListener((AWTPeerMouseExitedFix)propertyChangeListener);
                return;
            }
        }

        AWTPeerMouseExitedFix(JComponent jComponent) {
            this.button = jComponent;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getOldValue() instanceof Component) {
                ((Component)propertyChangeEvent.getOldValue()).removeMouseListener(this);
            }
            if (propertyChangeEvent.getNewValue() instanceof Component) {
                ((Component)propertyChangeEvent.getNewValue()).removeMouseListener(this);
                ((Component)propertyChangeEvent.getNewValue()).addMouseListener(this);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.button.dispatchEvent(SwingUtilities.convertMouseEvent(mouseEvent.getComponent(), mouseEvent, this.button));
        }
    }

    protected class FlatRadioButtonListener
    extends BasicButtonListener {
        private final AbstractButton b;

        protected FlatRadioButtonListener(AbstractButton abstractButton) {
            super(abstractButton);
            this.b = abstractButton;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            super.propertyChange(propertyChangeEvent);
            FlatRadioButtonUI.this.propertyChange(this.b, propertyChangeEvent);
        }
    }
}

