/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatLabelUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.StringUtils;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;

public class FlatToolTipUI
extends BasicToolTipUI
implements PropertyChangeListener {
    public static ComponentUI createUI(JComponent jComponent) {
        return FlatUIUtils.createSharedUI(FlatToolTipUI.class, FlatToolTipUI::new);
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        JComponent jComponent2 = jComponent;
        FlatLabelUI.updateHTMLRenderer(jComponent2, ((JToolTip)jComponent2).getTipText(), false);
    }

    @Override
    protected void installListeners(JComponent jComponent) {
        super.installListeners(jComponent);
        jComponent.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallListeners(JComponent jComponent) {
        super.uninstallListeners(jComponent);
        jComponent.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent serializable) {
        String string = ((PropertyChangeEvent)serializable).getPropertyName();
        if (string == "tiptext" || string == "font" || string == "foreground") {
            serializable = (JToolTip)((EventObject)serializable).getSource();
            FlatLabelUI.updateHTMLRenderer((JComponent)serializable, ((JToolTip)serializable).getTipText(), false);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent iterator) {
        Object object = ((JToolTip)((Object)iterator)).getTipText();
        if (object == null || ((String)object).isEmpty()) {
            return new Dimension();
        }
        if (this.isMultiLine((JComponent)((Object)iterator))) {
            JComponent jComponent = iterator;
            object = jComponent.getFontMetrics(jComponent.getFont());
            Insets insets = ((JComponent)((Object)iterator)).getInsets();
            iterator = StringUtils.split(((JToolTip)((Object)iterator)).getTipText(), '\n');
            int n = 0;
            int n2 = ((FontMetrics)object).getHeight() * Math.max(iterator.size(), 1);
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                n = Math.max(n, SwingUtilities.computeStringWidth((FontMetrics)object, string));
            }
            return new Dimension(insets.left + n + insets.right + 6, insets.top + n2 + insets.bottom);
        }
        return super.getPreferredSize((JComponent)((Object)iterator));
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        if (this.isMultiLine(jComponent)) {
            JComponent jComponent2 = jComponent;
            FontMetrics fontMetrics = jComponent2.getFontMetrics(jComponent2.getFont());
            Insets insets = jComponent.getInsets();
            graphics.setColor(jComponent.getForeground());
            Object object = StringUtils.split(((JToolTip)jComponent).getTipText(), '\n');
            int n = insets.left + 3;
            int n2 = jComponent.getWidth() - insets.right - 3;
            int n3 = insets.top - fontMetrics.getDescent();
            int n4 = fontMetrics.getHeight();
            JComponent jComponent3 = ((JToolTip)jComponent).getComponent();
            boolean bl = (jComponent3 != null ? jComponent3 : jComponent).getComponentOrientation().isLeftToRight();
            object = object.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                FlatUIUtils.drawString(jComponent, graphics, string, bl ? n : n2 - SwingUtilities.computeStringWidth(fontMetrics, string), n3 += n4);
            }
            return;
        }
        super.paint(HiDPIUtils.createGraphicsTextYCorrection((Graphics2D)graphics), jComponent);
    }

    private boolean isMultiLine(JComponent jComponent) {
        String string = ((JToolTip)jComponent).getTipText();
        return jComponent.getClientProperty("html") == null && string != null && string.indexOf(10) >= 0;
    }
}

