/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.executor;

import dorkbox.executor.DeferredProcessResult;
import dorkbox.executor.Executor;
import dorkbox.executor.JvmExecOptions;
import dorkbox.executor.LogHelper;
import dorkbox.executor.Params;
import dorkbox.executor.ProcessAttributes;
import dorkbox.executor.SshExecOptions;
import dorkbox.executor.exceptions.ProcessInitException;
import dorkbox.executor.listener.CompositeProcessListener;
import dorkbox.executor.listener.DestroyerListenerAdapter;
import dorkbox.executor.listener.ProcessDestroyer;
import dorkbox.executor.listener.ProcessListener;
import dorkbox.executor.listener.ShutdownHookProcessDestroyer;
import dorkbox.executor.processResults.ProcessResult;
import dorkbox.executor.processResults.SyncProcessResult;
import dorkbox.executor.stop.DestroyProcessStopper;
import dorkbox.executor.stop.NopProcessStopper;
import dorkbox.executor.stop.ProcessStopper;
import dorkbox.executor.stream.CallerLoggerUtil;
import dorkbox.executor.stream.IOStreamHandler;
import dorkbox.executor.stream.NopPumpStreamHandler;
import dorkbox.executor.stream.nopStreams.NopInputStream;
import dorkbox.executor.stream.nopStreams.NopOutputStream;
import dorkbox.executor.stream.slf4j.Slf4jStream;
import dorkbox.updates.Updates;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.G;
import kotlinx.coroutines.W;
import kotlinx.coroutines.g;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00e4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0016\u0018\u0000 \u0088\u00012\u00020\u0001:\u0002\u0088\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0015\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006B\u001b\b\u0016\u0012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0007\"\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u001f\u00102\u001a\u00020\u00002\u0012\u00103\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0007\"\u00020\u0005\u00a2\u0006\u0002\u00104J\u0014\u00102\u001a\u00020\u00002\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u000e\u00105\u001a\u00020\u00002\u0006\u00106\u001a\u000207J\u000e\u00108\u001a\u00020\u00002\u0006\u00109\u001a\u00020:J\u001f\u0010;\u001a\u00020\u00002\u0012\u0010<\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0007\"\u00020\u0005\u00a2\u0006\u0002\u00104J\u000e\u0010=\u001a\u00020$2\u0006\u0010>\u001a\u00020?J\u0014\u0010=\u001a\u00020$2\n\b\u0002\u0010>\u001a\u0004\u0018\u00010\u0005H\u0007J\u0006\u0010@\u001a\u00020-J\u000e\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020DJ\u0006\u0010E\u001a\u00020\u0000J\u0016\u0010\u0014\u001a\u00020\u00002\u0006\u0010F\u001a\u00020\u00152\u0006\u0010G\u001a\u00020\u0017J'\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020?2\u0012\u0010H\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0007\"\u00020\u0005\u00a2\u0006\u0002\u0010IJ\u001f\u0010\u0003\u001a\u00020\u00002\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0007\"\u00020\u0005\u00a2\u0006\u0002\u00104J\u0014\u0010\u0003\u001a\u00020\u00002\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u000e\u0010J\u001a\u00020\u00002\u0006\u0010K\u001a\u00020\u0005J\u0006\u0010L\u001a\u00020\u0000J\u0006\u0010M\u001a\u00020\u0000J\u0010\u00106\u001a\u00020\u00002\b\u00106\u001a\u0004\u0018\u000107J\u0006\u0010N\u001a\u00020\u0000J\u0018\u0010\u0018\u001a\u00020\u00002\u0006\u0010O\u001a\u00020\u00052\b\u0010P\u001a\u0004\u0018\u00010\u0005J\u001c\u0010\u0018\u001a\u00020\u00002\u0014\u0010Q\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050RJ\u000e\u0010S\u001a\u00020\u00002\u0006\u0010T\u001a\u00020?J\u000e\u0010S\u001a\u00020\u00002\u0006\u0010T\u001a\u00020\u0005J\u000e\u0010U\u001a\u00020\u00002\u0006\u0010U\u001a\u00020\u000bJ\u0006\u0010V\u001a\u00020\u0000J\u0006\u0010W\u001a\u00020\u0000J\u0012\u0010X\u001a\u00020\u00002\n\u0010X\u001a\u00020Y\"\u00020\u000bJ\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u00050[J\u000e\u0010\\\u001a\b\u0012\u0004\u0012\u00020\u00050[H\u0016J\u0006\u0010]\u001a\u00020\u0005J\u0006\u0010^\u001a\u00020\u0005J\b\u0010_\u001a\u0004\u0018\u00010?J\u0006\u0010!\u001a\u00020\u0000J\u0006\u0010\"\u001a\u00020\u0000J\u0010\u00109\u001a\u00020\u00002\b\u00109\u001a\u0004\u0018\u00010:J \u0010`\u001a\u00020a2\u0006\u0010F\u001a\u00020\u00152\u0006\u0010b\u001a\u00020\u00172\u0006\u0010c\u001a\u00020\u001dH\u0002J\u0010\u0010d\u001a\u00020\u00002\b\u0010e\u001a\u0004\u0018\u00010fJ\u000e\u0010g\u001a\u00020\u00002\u0006\u0010e\u001a\u00020fJ\u0006\u0010h\u001a\u00020\u0000J\u000e\u0010h\u001a\u00020\u00002\u0006\u0010i\u001a\u00020(J\u0006\u0010j\u001a\u00020\u0000J\u000e\u0010j\u001a\u00020\u00002\u0006\u0010i\u001a\u00020(J\u0006\u0010k\u001a\u00020\u0000J\u000e\u0010k\u001a\u00020\u00002\u0006\u0010i\u001a\u00020(J\u0006\u0010l\u001a\u00020\u0000J\u000e\u0010l\u001a\u00020\u00002\u0006\u0010i\u001a\u00020(J\u0006\u0010m\u001a\u00020\u0000J\u000e\u0010m\u001a\u00020\u00002\u0006\u0010i\u001a\u00020(J\u000e\u0010n\u001a\u00020\u00002\u0006\u0010n\u001a\u00020\u001dJ\u0010\u0010o\u001a\u00020\u00002\b\u0010p\u001a\u0004\u0018\u00010qJ\u0014\u0010r\u001a\u00020\u00002\n\b\u0002\u0010e\u001a\u0004\u0018\u00010fH\u0007J\u000e\u0010s\u001a\u00020\u00002\u0006\u0010e\u001a\u00020fJ\u0006\u0010t\u001a\u00020\u0000J\u000e\u0010t\u001a\u00020\u00002\u0006\u0010i\u001a\u00020(J\u0006\u0010u\u001a\u00020\u0000J\u000e\u0010u\u001a\u00020\u00002\u0006\u0010i\u001a\u00020(J\u0006\u0010v\u001a\u00020\u0000J\u000e\u0010v\u001a\u00020\u00002\u0006\u0010i\u001a\u00020(J\u0006\u0010w\u001a\u00020\u0000J\u000e\u0010w\u001a\u00020\u00002\u0006\u0010i\u001a\u00020(J\u0006\u0010x\u001a\u00020\u0000J\u000e\u0010x\u001a\u00020\u00002\u0006\u0010i\u001a\u00020(J\u000e\u0010y\u001a\u00020\u00002\u0006\u00109\u001a\u00020:J\u0016\u0010z\u001a\u00020\u00002\u000e\u0010{\u001a\n\u0012\u0006\b\u0001\u0012\u00020:0|J%\u0010}\u001a\u00020~2\b\b\u0002\u0010F\u001a\u00020\u00152\b\b\u0002\u0010b\u001a\u00020\u0017H\u0087@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u007fJ&\u0010\u0080\u0001\u001a\u00020~2\b\b\u0002\u0010F\u001a\u00020\u00152\b\b\u0002\u0010b\u001a\u00020\u0017H\u0087@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u007fJ\u001d\u0010\u0081\u0001\u001a\u00020a2\b\b\u0002\u0010F\u001a\u00020\u00152\b\b\u0002\u0010b\u001a\u00020\u0017H\u0007J\u001d\u0010\u0082\u0001\u001a\u00020~2\b\b\u0002\u0010F\u001a\u00020\u00152\b\b\u0002\u0010b\u001a\u00020\u0017H\u0007J\u001d\u0010\u0083\u0001\u001a\u00020a2\b\b\u0002\u0010F\u001a\u00020\u00152\b\b\u0002\u0010b\u001a\u00020\u0017H\u0007J\u001d\u0010\u0084\u0001\u001a\u00020~2\b\b\u0002\u0010F\u001a\u00020\u00152\b\b\u0002\u0010b\u001a\u00020\u0017H\u0007J\u0010\u0010.\u001a\u00020\u00002\b\u0010.\u001a\u0004\u0018\u00010/J\u0006\u00100\u001a\u000201J\u000e\u00100\u001a\u00020\u00002\u0006\u00100\u001a\u000201J\u0007\u0010\u0085\u0001\u001a\u00020\u0000J\u0012\u0010\u0086\u0001\u001a\u00020\u00002\t\u0010\u0087\u0001\u001a\u0004\u0018\u00010?J\u0012\u0010\u0086\u0001\u001a\u00020\u00002\t\u0010\u0087\u0001\u001a\u0004\u0018\u00010\u0005R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00050*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010,\u001a\u0004\u0018\u00010-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0089\u0001"}, d2={"Ldorkbox/executor/Executor;", "", "()V", "command", "", "", "(Ljava/lang/Iterable;)V", "", "([Ljava/lang/String;)V", "allowedExitValues", "", "", "attributes", "Ldorkbox/executor/ProcessAttributes;", "getAttributes", "()Ldorkbox/executor/ProcessAttributes;", "builder", "Ljava/lang/ProcessBuilder;", "getBuilder$Executor", "()Ljava/lang/ProcessBuilder;", "closeTimeout", "", "closeTimeoutUnit", "Ljava/util/concurrent/TimeUnit;", "environment", "", "getEnvironment", "()Ljava/util/Map;", "executeAsShell", "", "executingMessageParams", "getExecutingMessageParams", "()Ljava/lang/String;", "highPerformanceIO", "inheritIO", "jvmExecOptions", "Ldorkbox/executor/JvmExecOptions;", "listeners", "Ldorkbox/executor/listener/CompositeProcessListener;", "logger", "Lorg/slf4j/Logger;", "pathsToPrepend", "", "readOutput", "sshExecOptions", "Ldorkbox/executor/SshExecOptions;", "stopper", "Ldorkbox/executor/stop/ProcessStopper;", "streams", "Ldorkbox/executor/stream/IOStreamHandler;", "addArg", "arguments", "([Ljava/lang/String;)Ldorkbox/executor/Executor;", "addDestroyer", "destroyer", "Ldorkbox/executor/listener/ProcessDestroyer;", "addListener", "listener", "Ldorkbox/executor/listener/ProcessListener;", "addPath", "pathsToAdd", "asJvmProcess", "javaExecutable", "Ljava/io/File;", "asSshProcess", "checkExitValue", "", "result", "Ldorkbox/executor/processResults/ProcessResult;", "clearListeners", "timeout", "unit", "args", "(Ljava/io/File;[Ljava/lang/String;)Ldorkbox/executor/Executor;", "commandSplit", "commandWithArgs", "defaultLogger", "destroyOnExit", "enableRead", "name", "value", "env", "", "executable", "exe", "exitValue", "exitValueAny", "exitValueNormal", "exitValues", "", "getArgs", "", "getCommand", "getExecutable", "getSystemPath", "getWorkingDirectory", "prepareProcess", "Ldorkbox/executor/DeferredProcessResult;", "timeoutUnit", "asyncProcessStart", "redirectError", "output", "Ljava/io/OutputStream;", "redirectErrorAlsoTo", "redirectErrorAsDebug", "log", "redirectErrorAsError", "redirectErrorAsInfo", "redirectErrorAsTrace", "redirectErrorAsWarn", "redirectErrorStream", "redirectInput", "input", "Ljava/io/InputStream;", "redirectOutput", "redirectOutputAlsoTo", "redirectOutputAsDebug", "redirectOutputAsError", "redirectOutputAsInfo", "redirectOutputAsTrace", "redirectOutputAsWarn", "removeListener", "removeListeners", "listenerType", "Ljava/lang/Class;", "start", "Ldorkbox/executor/processResults/SyncProcessResult;", "(JLjava/util/concurrent/TimeUnit;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "startAsShell", "startAsShellAsync", "startAsShellBlocking", "startAsync", "startBlocking", "useSystemEnvironment", "workingDirectory", "directory", "Companion", "Executor"})
public class Executor {
    public static final Companion Companion = new Companion(null);
    private final ProcessBuilder builder;
    private final Map<String, String> environment;
    private JvmExecOptions jvmExecOptions;
    private SshExecOptions sshExecOptions;
    private boolean executeAsShell;
    private List<String> pathsToPrepend;
    private Set<Integer> allowedExitValues;
    private ProcessStopper stopper;
    private IOStreamHandler streams;
    private long closeTimeout;
    private TimeUnit closeTimeoutUnit;
    private boolean readOutput;
    private boolean inheritIO;
    private boolean highPerformanceIO;
    private final CompositeProcessListener listeners;
    private Logger logger;
    public static final String version = "3.14";
    private static final Logger log;
    private static final boolean IS_OS_WINDOWS;
    private static final boolean IS_OS_MAC;
    private static final int NORMAL_EXIT_VALUE = 0;
    public static final boolean DEFAULT_REDIRECT_ERROR_STREAM = true;
    private static final CoroutineScope IO_DISPATCH;
    private static final String LINE_SEPARATOR;
    private static final Regex EXTRA_SPACE_REGEX;
    private static String DEFAULT_SHELL;

    public final ProcessBuilder getBuilder$Executor() {
        return this.builder;
    }

    public final Map<String, String> getEnvironment() {
        return this.environment;
    }

    private final ProcessAttributes getAttributes() {
        Set<Integer> set = this.allowedExitValues;
        if (set != null) {
            return new ProcessAttributes(this.getCommand(), this.getWorkingDirectory(), (Map<String, String>)new LinkedHashMap<String, String>(this.environment), CollectionsKt.toSet((Iterable)set));
        }
        return new ProcessAttributes(this.getCommand(), this.getWorkingDirectory(), new LinkedHashMap<String, String>(this.environment), null, 8, null);
    }

    private final String getExecutingMessageParams() {
        List<String> list = this.builder.command();
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        String string2 = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        if (this.builder.directory() != null) {
            string2 = string2 + " in " + this.builder.directory();
        }
        if (!this.environment.isEmpty()) {
            string2 = string2 + " with environment " + this.environment;
        }
        return string2;
    }

    public Executor() {
        this.builder = new ProcessBuilder(new String[0]);
        this.environment = new LinkedHashMap();
        this.pathsToPrepend = new ArrayList();
        this.stopper = NopProcessStopper.Companion.getINSTANCE();
        this.streams = new NopPumpStreamHandler();
        this.closeTimeoutUnit = TimeUnit.SECONDS;
        this.listeners = new CompositeProcessListener();
        this.exitValueAny();
        this.stopper(DestroyProcessStopper.Companion.getINSTANCE());
        this.redirectOutput(null);
        this.redirectError(null);
        this.destroyer(null);
        this.redirectErrorStream(true);
    }

    public Executor(Iterable<String> iterable) {
        Intrinsics.checkNotNullParameter(iterable, (String)"");
        this.builder = new ProcessBuilder(new String[0]);
        this.environment = new LinkedHashMap();
        this.pathsToPrepend = new ArrayList();
        this.stopper = NopProcessStopper.Companion.getINSTANCE();
        this.streams = new NopPumpStreamHandler();
        this.closeTimeoutUnit = TimeUnit.SECONDS;
        this.listeners = new CompositeProcessListener();
        this.exitValueAny();
        this.stopper(DestroyProcessStopper.Companion.getINSTANCE());
        this.redirectOutput(null);
        this.redirectError(null);
        this.destroyer(null);
        this.redirectErrorStream(true);
        this.command(iterable);
    }

    public Executor(String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        this.builder = new ProcessBuilder(new String[0]);
        this.environment = new LinkedHashMap();
        this.pathsToPrepend = new ArrayList();
        this.stopper = NopProcessStopper.Companion.getINSTANCE();
        this.streams = new NopPumpStreamHandler();
        this.closeTimeoutUnit = TimeUnit.SECONDS;
        this.listeners = new CompositeProcessListener();
        this.exitValueAny();
        this.stopper(DestroyProcessStopper.Companion.getINSTANCE());
        this.redirectOutput(null);
        this.redirectError(null);
        this.destroyer(null);
        this.redirectErrorStream(true);
        this.command(Arrays.copyOf(stringArray, stringArray.length));
    }

    public List<String> getCommand() {
        return new ArrayList(this.builder.command());
    }

    public final Executor command(Iterable<String> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"");
        Object object = collection;
        collection = new ArrayList(CollectionsKt.collectionSizeOrDefault(collection, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            object2 = (String)object2;
            Collection collection2 = collection;
            collection2.add(object2);
        }
        collection = (List)collection;
        this.builder.command().addAll((Collection<String>)Companion.fixArguments$Executor(collection));
        return this;
    }

    public final Executor command(String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        this.builder.command().addAll((Collection<String>)Companion.fixArguments$Executor(CollectionsKt.listOf((Object[])Arrays.copyOf(stringArray, stringArray.length))));
        return this;
    }

    public final Executor command(File object, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)((File)object).getAbsolutePath());
        spreadBuilder.addSpread((Object)stringArray);
        SpreadBuilder spreadBuilder2 = spreadBuilder;
        object = CollectionsKt.listOf((Object[])spreadBuilder2.toArray((Object[])new String[spreadBuilder2.size()]));
        this.builder.command().addAll((Collection<String>)Companion.fixArguments$Executor((Iterable)object));
        return this;
    }

    public final Executor commandSplit(String charSequence) {
        Intrinsics.checkNotNullParameter((Object)charSequence, (String)"");
        charSequence = charSequence;
        Regex regex = EXTRA_SPACE_REGEX;
        this.builder.command().addAll(regex.split(charSequence, 0));
        return this;
    }

    public final Executor executable(String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        this.builder.command().add(0, string2);
        return this;
    }

    public final Executor executable(File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        this.builder.command().add(0, file.getAbsolutePath());
        return this;
    }

    public final String getExecutable() {
        List<String> list = this.builder.command();
        if (list.isEmpty()) {
            return "";
        }
        String string2 = list.get(0);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        return string2;
    }

    public final Executor addArg(String ... object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        object = Companion.fixArguments$Executor(CollectionsKt.listOf((Object[])Arrays.copyOf(object, ((String[])object).length)));
        this.builder.command().addAll((Collection)object);
        return this;
    }

    public final Executor addArg(Iterable<String> iterable) {
        Intrinsics.checkNotNullParameter(iterable, (String)"");
        iterable = Companion.fixArguments$Executor(iterable);
        this.builder.command().addAll((Collection)iterable);
        return this;
    }

    public final List<String> getArgs() {
        List<String> list = this.builder.command();
        if (list.size() <= 1) {
            return CollectionsKt.emptyList();
        }
        return list.subList(1, list.size());
    }

    public final File getWorkingDirectory() {
        return this.builder.directory();
    }

    public final Executor workingDirectory(File file) {
        this.builder.directory(file);
        return this;
    }

    public final Executor workingDirectory(String string2) {
        if (string2 != null) {
            this.builder.directory(new File(string2));
        } else {
            this.builder.directory((File)((Object)string2));
        }
        return this;
    }

    public final Executor environment(Map<String, String> map) {
        Intrinsics.checkNotNullParameter(map, (String)"");
        this.environment.putAll(map);
        return this;
    }

    public final Executor environment(String string2, String string3) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        this.environment.put(string2, string3);
        return this;
    }

    public final Executor useSystemEnvironment() {
        Map<String, String> map = System.getenv();
        Intrinsics.checkNotNullExpressionValue(map, (String)"");
        this.environment.putAll(map);
        return this;
    }

    public final Executor addPath(String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        CollectionsKt.addAll((Collection)this.pathsToPrepend, (Object[])stringArray);
        this.executeAsShell = true;
        return this;
    }

    public final String getSystemPath() {
        Map<String, String> map = System.getenv();
        String string2 = map.get("PATH");
        if (string2 == null && (string2 = map.get("Path")) == null && (string2 = map.get("path")) == null) {
            string2 = "";
        }
        return string2;
    }

    public final Executor redirectErrorStream(boolean bl) {
        this.builder.redirectErrorStream(bl);
        return this;
    }

    public final Executor exitValueAny() {
        this.allowedExitValues = null;
        return this;
    }

    public final Executor exitValueNormal() {
        int[] nArray = new int[1];
        int[] nArray2 = nArray;
        nArray[0] = 0;
        return this.exitValues(nArray2);
    }

    public final Executor exitValue(int n) {
        int[] nArray = new int[1];
        int[] nArray2 = nArray;
        nArray[0] = n;
        return this.exitValues(nArray2);
    }

    public final Executor exitValues(int ... nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"");
        this.allowedExitValues = ArraysKt.toSet((int[])nArray);
        return this;
    }

    public final Executor stopper(ProcessStopper processStopper) {
        this.stopper = processStopper == null ? NopProcessStopper.Companion.getINSTANCE() : processStopper;
        return this;
    }

    public final IOStreamHandler streams() {
        return this.streams;
    }

    public final Executor streams(IOStreamHandler iOStreamHandler) {
        Intrinsics.checkNotNullParameter((Object)iOStreamHandler, (String)"");
        this.streams = iOStreamHandler;
        return this;
    }

    public final Executor closeTimeout(long l, TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"");
        this.closeTimeout = l;
        this.closeTimeoutUnit = timeUnit;
        return this;
    }

    public final Executor enableRead() {
        this.readOutput = true;
        return this;
    }

    public final Executor inheritIO() {
        this.inheritIO = true;
        return this;
    }

    public final Executor redirectInput(InputStream inputStream) {
        inputStream = inputStream == null ? (InputStream)NopInputStream.Companion.getINPUT_STREAM() : inputStream;
        this.streams = this.streams.setInputStream(inputStream);
        return this;
    }

    public final Executor redirectOutput(OutputStream outputStream) {
        if (outputStream == null) {
            outputStream = NopOutputStream.Companion.getOUTPUT_STREAM();
        }
        this.streams = this.streams.setOutputStream(outputStream);
        return this;
    }

    public static /* synthetic */ Executor redirectOutput$default(Executor executor, OutputStream outputStream, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: redirectOutput");
        }
        if ((n & 1) != 0) {
            outputStream = null;
        }
        return executor.redirectOutput(outputStream);
    }

    public final Executor redirectError(OutputStream outputStream) {
        if (outputStream == null) {
            outputStream = NopOutputStream.Companion.getOUTPUT_STREAM();
        }
        this.streams = this.streams.setErrorStream(outputStream);
        this.redirectErrorStream(false);
        return this;
    }

    public final Executor redirectOutputAlsoTo(OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"");
        this.streams = this.streams.teeOutputStream(outputStream);
        return this;
    }

    public final Executor redirectErrorAlsoTo(OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"");
        this.streams = this.streams.teeErrorStream(outputStream);
        this.redirectErrorStream(false);
        return this;
    }

    public final Executor redirectOutputAsTrace() {
        Logger logger = LoggerFactory.getLogger((String)CallerLoggerUtil.INSTANCE.getName(null, 1));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"");
        return this.redirectOutput(Slf4jStream.INSTANCE.asDebug(logger));
    }

    public final Executor redirectOutputAsDebug() {
        Logger logger = LoggerFactory.getLogger((String)CallerLoggerUtil.INSTANCE.getName(null, 1));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"");
        return this.redirectOutput(Slf4jStream.INSTANCE.asDebug(logger));
    }

    public final Executor redirectOutputAsInfo() {
        Logger logger = LoggerFactory.getLogger((String)CallerLoggerUtil.INSTANCE.getName(null, 1));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"");
        return this.redirectOutput(Slf4jStream.INSTANCE.asInfo(logger));
    }

    public final Executor redirectOutputAsWarn() {
        Logger logger = LoggerFactory.getLogger((String)CallerLoggerUtil.INSTANCE.getName(null, 1));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"");
        return this.redirectOutput(Slf4jStream.INSTANCE.asWarn(logger));
    }

    public final Executor redirectOutputAsError() {
        Logger logger = LoggerFactory.getLogger((String)CallerLoggerUtil.INSTANCE.getName(null, 1));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"");
        return this.redirectOutput(Slf4jStream.INSTANCE.asDebug(logger));
    }

    public final Executor redirectOutputAsTrace(Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"");
        return this.redirectOutput(Slf4jStream.INSTANCE.asDebug(logger));
    }

    public final Executor redirectOutputAsDebug(Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"");
        return this.redirectOutput(Slf4jStream.INSTANCE.asDebug(logger));
    }

    public final Executor redirectOutputAsInfo(Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"");
        return this.redirectOutput(Slf4jStream.INSTANCE.asInfo(logger));
    }

    public final Executor redirectOutputAsWarn(Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"");
        return this.redirectOutput(Slf4jStream.INSTANCE.asWarn(logger));
    }

    public final Executor redirectOutputAsError(Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"");
        return this.redirectOutput(Slf4jStream.INSTANCE.asDebug(logger));
    }

    public final Executor redirectErrorAsTrace() {
        Logger logger = LoggerFactory.getLogger((String)CallerLoggerUtil.INSTANCE.getName(null, 1));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"");
        return this.redirectError(Slf4jStream.INSTANCE.asTrace(logger));
    }

    public final Executor redirectErrorAsDebug() {
        Logger logger = LoggerFactory.getLogger((String)CallerLoggerUtil.INSTANCE.getName(null, 1));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"");
        return this.redirectError(Slf4jStream.INSTANCE.asDebug(logger));
    }

    public final Executor redirectErrorAsInfo() {
        Logger logger = LoggerFactory.getLogger((String)CallerLoggerUtil.INSTANCE.getName(null, 1));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"");
        return this.redirectError(Slf4jStream.INSTANCE.asInfo(logger));
    }

    public final Executor redirectErrorAsWarn() {
        Logger logger = LoggerFactory.getLogger((String)CallerLoggerUtil.INSTANCE.getName(null, 1));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"");
        return this.redirectError(Slf4jStream.INSTANCE.asWarn(logger));
    }

    public final Executor redirectErrorAsError() {
        return this.redirectError(Slf4jStream.INSTANCE.asError(log));
    }

    public final Executor redirectErrorAsTrace(Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"");
        return this.redirectError(Slf4jStream.INSTANCE.asTrace(logger));
    }

    public final Executor redirectErrorAsDebug(Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"");
        return this.redirectError(Slf4jStream.INSTANCE.asDebug(logger));
    }

    public final Executor redirectErrorAsInfo(Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"");
        return this.redirectError(Slf4jStream.INSTANCE.asInfo(logger));
    }

    public final Executor redirectErrorAsWarn(Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"");
        return this.redirectError(Slf4jStream.INSTANCE.asWarn(logger));
    }

    public final Executor redirectErrorAsError(Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"");
        return this.redirectError(Slf4jStream.INSTANCE.asError(logger));
    }

    public final Executor addDestroyer(ProcessDestroyer processDestroyer) {
        Intrinsics.checkNotNullParameter((Object)processDestroyer, (String)"");
        return this.addListener(new DestroyerListenerAdapter(processDestroyer));
    }

    public final Executor destroyer(ProcessDestroyer processDestroyer) {
        this.removeListeners(DestroyerListenerAdapter.class);
        if (processDestroyer != null) {
            this.addListener(new DestroyerListenerAdapter(processDestroyer));
        }
        return this;
    }

    public final Executor destroyOnExit() {
        return this.destroyer(ShutdownHookProcessDestroyer.Companion.getINSTANCE());
    }

    public final Executor listener(ProcessListener processListener) {
        block0: {
            this.clearListeners();
            ProcessListener processListener2 = processListener;
            if (processListener2 == null) break block0;
            processListener = processListener2;
            this.addListener(processListener);
        }
        return this;
    }

    public final Executor addListener(ProcessListener processListener) {
        Intrinsics.checkNotNullParameter((Object)processListener, (String)"");
        this.listeners.add(processListener);
        return this;
    }

    public final Executor removeListener(ProcessListener processListener) {
        Intrinsics.checkNotNullParameter((Object)processListener, (String)"");
        this.listeners.remove(processListener);
        return this;
    }

    public final Executor removeListeners(Class<? extends ProcessListener> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        this.listeners.removeAll(clazz);
        return this;
    }

    public final Executor clearListeners() {
        this.listeners.clear();
        return this;
    }

    public final void checkExitValue(ProcessResult processResult) {
        Intrinsics.checkNotNullParameter((Object)processResult, (String)"");
        DeferredProcessResult.Companion.checkExit$Executor(this.getAttributes(), processResult);
    }

    public final Executor defaultLogger() {
        this.logger = log;
        return this;
    }

    public final Executor highPerformanceIO() {
        this.highPerformanceIO = true;
        return this;
    }

    public final JvmExecOptions asJvmProcess(String string2) {
        JvmExecOptions jvmExecOptions = this.jvmExecOptions = new JvmExecOptions(this, string2);
        Intrinsics.checkNotNull((Object)jvmExecOptions);
        return jvmExecOptions;
    }

    public static /* synthetic */ JvmExecOptions asJvmProcess$default(Executor executor, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: asJvmProcess");
        }
        if ((n & 1) != 0) {
            string2 = null;
        }
        return executor.asJvmProcess(string2);
    }

    public final JvmExecOptions asJvmProcess(File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        if (!file.canExecute()) {
            throw new IllegalArgumentException("The java executable if specified, must be exist and be executable. Error with: " + file);
        }
        JvmExecOptions jvmExecOptions = this.jvmExecOptions = new JvmExecOptions(this, file.getCanonicalFile().getPath());
        Intrinsics.checkNotNull((Object)jvmExecOptions);
        return jvmExecOptions;
    }

    public final SshExecOptions asSshProcess() {
        SshExecOptions sshExecOptions = this.sshExecOptions = new SshExecOptions(this);
        Intrinsics.checkNotNull((Object)sshExecOptions);
        return sshExecOptions;
    }

    public final DeferredProcessResult startAsShellAsync(long l, TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"");
        this.executeAsShell = true;
        return this.startAsync(l, timeUnit);
    }

    public static /* synthetic */ DeferredProcessResult startAsShellAsync$default(Executor executor, long l, TimeUnit timeUnit, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: startAsShellAsync");
        }
        if ((n & 1) != 0) {
            l = 0L;
        }
        if ((n & 2) != 0) {
            timeUnit = TimeUnit.SECONDS;
        }
        return executor.startAsShellAsync(l, timeUnit);
    }

    public final DeferredProcessResult startAsync(long l, TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"");
        return this.prepareProcess(l, timeUnit, true);
    }

    public static /* synthetic */ DeferredProcessResult startAsync$default(Executor executor, long l, TimeUnit timeUnit, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: startAsync");
        }
        if ((n & 1) != 0) {
            l = 0L;
        }
        if ((n & 2) != 0) {
            timeUnit = TimeUnit.SECONDS;
        }
        return executor.startAsync(l, timeUnit);
    }

    public final Object startAsShell(long l, TimeUnit timeUnit, Continuation<? super SyncProcessResult> continuation) {
        this.executeAsShell = true;
        return this.start(l, timeUnit, continuation);
    }

    public static /* synthetic */ Object startAsShell$default(Executor executor, long l, TimeUnit timeUnit, Continuation continuation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: startAsShell");
        }
        if ((n & 1) != 0) {
            l = 0L;
        }
        if ((n & 2) != 0) {
            timeUnit = TimeUnit.SECONDS;
        }
        return executor.startAsShell(l, timeUnit, (Continuation<? super SyncProcessResult>)continuation);
    }

    public final SyncProcessResult startAsShellBlocking(long l, TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"");
        return (SyncProcessResult)g.a(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super SyncProcessResult>, Object>(this, l, timeUnit, null){
            int label;
            final /* synthetic */ Executor this$0;
            final /* synthetic */ long $timeout;
            final /* synthetic */ TimeUnit $timeoutUnit;
            {
                this.this$0 = executor;
                this.$timeout = l;
                this.$timeoutUnit = timeUnit;
                super(2, continuation);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.startAsShell(this.$timeout, this.$timeoutUnit, (Continuation<? super SyncProcessResult>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)object);
                        Object object3 = object;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object object, Continuation<?> continuation) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope coroutineScope, Continuation<? super SyncProcessResult> continuation) {
                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public static /* synthetic */ SyncProcessResult startAsShellBlocking$default(Executor executor, long l, TimeUnit timeUnit, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: startAsShellBlocking");
        }
        if ((n & 1) != 0) {
            l = 0L;
        }
        if ((n & 2) != 0) {
            timeUnit = TimeUnit.SECONDS;
        }
        return executor.startAsShellBlocking(l, timeUnit);
    }

    public final Object start(long l, TimeUnit timeUnit, Continuation<? super SyncProcessResult> continuation) {
        return this.prepareProcess(l, timeUnit, false).await(l, timeUnit, continuation);
    }

    public static /* synthetic */ Object start$default(Executor executor, long l, TimeUnit timeUnit, Continuation continuation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: start");
        }
        if ((n & 1) != 0) {
            l = 0L;
        }
        if ((n & 2) != 0) {
            timeUnit = TimeUnit.SECONDS;
        }
        return executor.start(l, timeUnit, (Continuation<? super SyncProcessResult>)continuation);
    }

    public final SyncProcessResult startBlocking(long l, TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"");
        return (SyncProcessResult)g.a(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super SyncProcessResult>, Object>(this, l, timeUnit, null){
            int label;
            final /* synthetic */ Executor this$0;
            final /* synthetic */ long $timeout;
            final /* synthetic */ TimeUnit $timeoutUnit;
            {
                this.this$0 = executor;
                this.$timeout = l;
                this.$timeoutUnit = timeUnit;
                super(2, continuation);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.start(this.$timeout, this.$timeoutUnit, (Continuation<? super SyncProcessResult>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)object);
                        Object object3 = object;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object object, Continuation<?> continuation) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope coroutineScope, Continuation<? super SyncProcessResult> continuation) {
                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public static /* synthetic */ SyncProcessResult startBlocking$default(Executor executor, long l, TimeUnit timeUnit, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: startBlocking");
        }
        if ((n & 1) != 0) {
            l = 0L;
        }
        if ((n & 2) != 0) {
            timeUnit = TimeUnit.SECONDS;
        }
        return executor.startBlocking(l, timeUnit);
    }

    private final DeferredProcessResult prepareProcess(long l, TimeUnit timeUnit, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Map<String, String> map;
        Object[] objectArray;
        List<String> list;
        block57: {
            block59: {
                int n;
                block60: {
                    block58: {
                        Object[] objectArray2;
                        boolean bl2;
                        if (!(!this.inheritIO || !this.highPerformanceIO)) {
                            String string2 = "inheritIO & highPerformanceIO cannot be both set at the same time, they cancel each-other out";
                            throw new IllegalStateException(string2.toString());
                        }
                        ((ProcessListener)this.listeners).beforeStart(this);
                        list = this.builder.command();
                        if (this.jvmExecOptions == null) {
                            Intrinsics.checkNotNull(list);
                            if (!(!((Collection)list).isEmpty())) {
                                String string3 = "Command has not been set.";
                                throw new IllegalStateException(string3.toString());
                            }
                        }
                        if (bl2 = !((Collection)this.pathsToPrepend).isEmpty()) {
                            Iterable iterable = this.pathsToPrepend;
                            String string4 = File.pathSeparator;
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"");
                            objectArray2 = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string4, null, null, (int)0, null, null, (int)62, null);
                        } else {
                            objectArray2 = objectArray = "";
                        }
                        if (!this.environment.isEmpty() || bl2) {
                            map = System.getenv();
                            boolean bl3 = map.get("PATH") != null;
                            boolean bl4 = map.get("Path") != null;
                            int n2 = n = map.get("path") != null ? 1 : 0;
                            Object object7 = bl3 ? "PATH" : (object6 = bl4 ? "Path" : "path");
                            if (bl3 || bl4 || n != 0) {
                                Object object8;
                                Object object9;
                                Object object10 = this.environment.remove("PATH");
                                if (object10 == null) {
                                    object10 = object5 = "";
                                }
                                if ((object9 = this.environment.remove("Path")) == null) {
                                    object9 = object4 = "";
                                }
                                if ((object8 = this.environment.remove("path")) == null) {
                                    object8 = object3 = "";
                                }
                                if (((CharSequence)object5).length() > 0 || ((CharSequence)object4).length() > 0 || ((CharSequence)object3).length() > 0) {
                                    String string5 = "";
                                    if (((CharSequence)object5).length() > 0) {
                                        string5 = string5 + (String)object5;
                                    }
                                    if (((CharSequence)object4).length() > 0) {
                                        if (((CharSequence)string5).length() > 0) {
                                            string5 = string5 + File.pathSeparator;
                                        }
                                        string5 = string5 + (String)object4;
                                    }
                                    if (((CharSequence)object3).length() > 0) {
                                        if (((CharSequence)string5).length() > 0) {
                                            string5 = string5 + File.pathSeparator;
                                        }
                                        string5 = string5 + (String)object3;
                                    }
                                    if (bl2) {
                                        string5 = (String)objectArray + File.pathSeparator + string5;
                                    }
                                    this.environment.put((String)object6, string5);
                                } else {
                                    this.environment.put((String)object6, (String)objectArray);
                                }
                            } else if (bl2) {
                                this.environment.put((String)object6, (String)objectArray);
                            }
                            object5 = this.builder.environment();
                            object4 = this.environment;
                            object2 = object4.entrySet().iterator();
                            while (object2.hasNext()) {
                                Object object11 = (Map.Entry)object2.next();
                                Map.Entry entry = object11;
                                objectArray = (String)object11.getKey();
                                object11 = (String)entry.getValue();
                                if (object11 == null) {
                                    object5.remove(objectArray);
                                    continue;
                                }
                                Intrinsics.checkNotNull((Object)object5);
                                object5.put(objectArray, object11);
                            }
                        }
                        if (this.jvmExecOptions != null) {
                            JvmExecOptions jvmExecOptions = this.jvmExecOptions;
                            Intrinsics.checkNotNull((Object)jvmExecOptions);
                            map = jvmExecOptions;
                            jvmExecOptions.configure$Executor();
                        }
                        if (!this.executeAsShell) break block57;
                        Intrinsics.checkNotNull(list);
                        map = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
                        list.clear();
                        if (!IS_OS_WINDOWS) break block58;
                        String[] stringArray = new String[2];
                        object2 = stringArray;
                        stringArray[0] = "cmd";
                        object2[1] = "/c";
                        list.addAll(CollectionsKt.listOf((Object[])object2));
                        break block59;
                    }
                    if (DEFAULT_SHELL == null && (object2 = System.getenv().get("SHELL")) != null && new File((String)object2).canExecute()) {
                        DEFAULT_SHELL = object2;
                    }
                    if (DEFAULT_SHELL != null) break block60;
                    try {
                        String[] stringArray = new String[3];
                        Object object12 = stringArray;
                        stringArray[0] = "sh";
                        object12[1] = "-c";
                        object12[2] = "echo $SHELL";
                        object12 = Runtime.getRuntime().exec((String[])object12).getInputStream();
                        Throwable throwable = null;
                        try {
                            object6 = (InputStream)object12;
                            object4 = new Scanner((InputStream)object6).useDelimiter("\\A");
                            object3 = null;
                            try {
                                String string6;
                                object2 = (Scanner)object4;
                                if (((Scanner)object2).hasNext()) {
                                    String string7 = ((Scanner)object2).next();
                                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"");
                                    string6 = ((Object)StringsKt.trim((CharSequence)string7)).toString();
                                } else {
                                    string6 = null;
                                }
                                object2 = string6;
                            }
                            catch (Throwable throwable2) {
                                try {
                                    object2 = throwable2;
                                    object3 = throwable2;
                                    throw object2;
                                }
                                catch (Throwable throwable3) {
                                    CloseableKt.closeFinally((Closeable)object4, (Throwable)object3);
                                    throw throwable3;
                                }
                            }
                            CloseableKt.closeFinally((Closeable)object4, null);
                            object6 = object2;
                        }
                        catch (Throwable throwable4) {
                            try {
                                object6 = throwable4;
                                throwable = throwable4;
                                throw object6;
                            }
                            catch (Throwable throwable5) {
                                CloseableKt.closeFinally((Closeable)object12, (Throwable)throwable);
                                throw throwable5;
                            }
                        }
                        CloseableKt.closeFinally((Closeable)object12, null);
                        object2 = object6;
                        if (object2 != null && !StringsKt.isBlank((CharSequence)((CharSequence)object2)) && new File((String)object2).canExecute()) {
                            DEFAULT_SHELL = object2;
                        }
                    }
                    catch (IOException iOException) {}
                }
                if (DEFAULT_SHELL == null) {
                    String[] stringArray = new String[32];
                    object2 = stringArray;
                    stringArray[0] = "/bin/bash";
                    object2[1] = "/usr/bin/bash";
                    object2[2] = "/bin/pfbash";
                    object2[3] = "/usr/bin/pfbash";
                    object2[4] = "/bin/csh";
                    object2[5] = "/usr/bin/csh";
                    object2[6] = "/bin/pfcsh";
                    object2[7] = "/usr/bin/pfcsh";
                    object2[8] = "/bin/jsh";
                    object2[9] = "/usr/bin/jsh";
                    object2[10] = "/bin/ksh";
                    object2[11] = "/usr/bin/ksh";
                    object2[12] = "/bin/pfksh";
                    object2[13] = "/usr/bin/pfksh";
                    object2[14] = "/bin/ksh93";
                    object2[15] = "/usr/bin/ksh93";
                    object2[16] = "/bin/pfksh93";
                    object2[17] = "/usr/bin/pfksh93";
                    object2[18] = "/bin/pfsh";
                    object2[19] = "/usr/bin/pfsh";
                    object2[20] = "/bin/tcsh";
                    object2[21] = "/usr/bin/tcsh";
                    object2[22] = "/bin/pftcsh";
                    object2[23] = "/usr/bin/pftcsh";
                    object2[24] = "/usr/xpg4/bin/sh";
                    object2[25] = "/usr/xp4/bin/pfsh";
                    object2[26] = "/bin/zsh";
                    object2[27] = "/usr/bin/zsh";
                    object2[28] = "/bin/pfzsh";
                    object2[29] = "/usr/bin/pfzsh";
                    object2[30] = "/bin/sh";
                    object2[31] = "/usr/bin/sh";
                    int cfr_ignored_0 = ((Object)object2).length;
                    for (n = 0; n < 32; ++n) {
                        object5 = object2[n];
                        object4 = object5;
                        if (!new File((String)object4).canExecute()) continue;
                        DEFAULT_SHELL = object4;
                    }
                }
                if (DEFAULT_SHELL == null) {
                    throw new IllegalStateException("Unable to determine the default shell for the linux/unix environment.");
                }
                String[] stringArray = new String[2];
                object2 = stringArray;
                String string8 = DEFAULT_SHELL;
                Intrinsics.checkNotNull((Object)string8);
                stringArray[0] = string8;
                object2[1] = "-c";
                list.addAll(CollectionsKt.listOf((Object[])object2));
            }
            list.add((String)((Object)map));
            if (IS_OS_MAC && !this.environment.containsKey("SOFTWARE")) {
                this.environment.put("SOFTWARE", "");
            }
            if (!this.environment.containsKey("LANG")) {
                this.environment.put("LANG", "C");
            }
        }
        if (this.inheritIO) {
            this.builder.inheritIO();
        }
        map = this.getAttributes();
        object2 = this.listeners.clone();
        if (!this.readOutput && this.executeAsShell && this.streams.getOut$Executor() instanceof NopOutputStream) {
            if (IS_OS_WINDOWS) {
                list.add("2>&1>");
                list.add("nul");
            } else {
                list.add(">/dev/null");
                list.add("2>&1");
            }
        }
        try {
            Process process;
            object = l > 0L ? "(timeout: " + l + ' ' + (Object)((Object)timeUnit) + ") " : "";
            Object object13 = object6 = this.executeAsShell ? "Executing as shell " + (String)object : "Executing " + (String)object;
            if (this.sshExecOptions != null) {
                StringBuilder stringBuilder = new StringBuilder().append((String)object6).append(" on ");
                SshExecOptions sshExecOptions = this.sshExecOptions;
                Intrinsics.checkNotNull((Object)sshExecOptions);
                LogHelper.INSTANCE.logAtLowestLevel(this.logger, stringBuilder.append(sshExecOptions.info()).append(' ').append(this.getExecutingMessageParams()).toString(), new Object[0]);
                SshExecOptions sshExecOptions2 = this.sshExecOptions;
                Intrinsics.checkNotNull((Object)sshExecOptions2);
                process = sshExecOptions2.startProcess$Executor(l, timeUnit, this.logger);
            } else {
                LogHelper.INSTANCE.logAtLowestLevel(this.logger, (String)object6 + ' ' + this.getExecutingMessageParams(), new Object[0]);
                process = this.builder.start();
            }
            object = process;
        }
        catch (Exception exception) {
            String string9;
            if (this.sshExecOptions != null) {
                StringBuilder stringBuilder = new StringBuilder("Could not execute on ");
                SshExecOptions sshExecOptions = this.sshExecOptions;
                Intrinsics.checkNotNull((Object)sshExecOptions);
                string9 = stringBuilder.append(sshExecOptions.info()).append(' ').append(this.getExecutingMessageParams()).toString();
            } else {
                string9 = "Could not execute " + this.getExecutingMessageParams();
            }
            object5 = string9;
            ProcessInitException processInitException = ProcessInitException.Companion.newInstance((String)object5, exception);
            throw processInitException != null ? (Throwable)processInitException : (Throwable)new IOException((String)object5, exception);
        }
        Object object14 = object;
        if (!this.readOutput) {
            object = this.streams;
            object6 = prepareProcess.5.INSTANCE;
            object5 = (Function1)new Function1<StringBuilder, Unit>((ProcessAttributes)((Object)map)){
                final /* synthetic */ ProcessAttributes $attributes;
                {
                    this.$attributes = processAttributes;
                    super(1);
                }

                public final void invoke(StringBuilder stringBuilder) {
                    Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"");
                    DeferredProcessResult.Companion.addExceptionMessageSuffix$Executor(this.$attributes, stringBuilder, "");
                }
            };
        } else {
            object = this.streams;
            if (bl) {
                object = ((IOStreamHandler)object).asyncMode();
            }
            object4 = new ByteArrayOutputStream();
            object = ((IOStreamHandler)object).teeOutputStream((OutputStream)object4);
            object6 = (Function2)new Function2<Long, Integer, SyncProcessResult>((ByteArrayOutputStream)object4){
                final /* synthetic */ ByteArrayOutputStream $out;
                {
                    this.$out = byteArrayOutputStream;
                    super(2);
                }

                public final SyncProcessResult invoke(long l, int n) {
                    byte[] byArray = this.$out.toByteArray();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"");
                    return new SyncProcessResult(l, n, byArray);
                }

                public final /* synthetic */ Object invoke(Object object, Object object2) {
                    return this.invoke(((Number)object).longValue(), ((Number)object2).intValue());
                }
            };
            object5 = (Function1)new Function1<StringBuilder, Unit>((ByteArrayOutputStream)object4, (ProcessAttributes)((Object)map)){
                final /* synthetic */ ByteArrayOutputStream $out;
                final /* synthetic */ ProcessAttributes $attributes;
                {
                    this.$out = byteArrayOutputStream;
                    this.$attributes = processAttributes;
                    super(1);
                }

                public final void invoke(StringBuilder stringBuilder) {
                    Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"");
                    byte[] byArray = this.$out.toByteArray();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"");
                    SyncProcessResult syncProcessResult = new SyncProcessResult(0L, 0, byArray);
                    DeferredProcessResult.Companion.addExceptionMessageSuffix$Executor(this.$attributes, stringBuilder, syncProcessResult.getOutput().string());
                }
            };
        }
        boolean bl5 = !this.builder.redirectErrorStream();
        Intrinsics.checkNotNull((Object)object14);
        ((IOStreamHandler)object).start((Process)object14, bl5, this.highPerformanceIO);
        ((ProcessListener)object2).afterStart((Process)object14, this);
        object3 = this.logger;
        object2 = new Params((ProcessAttributes)((Object)map), this.stopper, (ProcessListener)object2, (IOStreamHandler)object, (Logger)object3, (Function1<? super StringBuilder, Unit>)object5, this.closeTimeout, this.closeTimeoutUnit, bl);
        DeferredProcessResult deferredProcessResult = new DeferredProcessResult((Process)object14, (Params)object2, (Function2<? super Long, ? super Integer, ? extends SyncProcessResult>)object6);
        long l2 = deferredProcessResult.getPid();
        if (l2 == -1L) {
            LogHelper.INSTANCE.logAtLowestLevel((Logger)object3, "Started process", new Object[0]);
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = l2;
            LogHelper.INSTANCE.logAtLowestLevel((Logger)object3, "Started process [pid={}]", objectArray);
        }
        deferredProcessResult.start();
        return deferredProcessResult;
    }

    public final Executor redirectOutput() {
        return Executor.redirectOutput$default(this, null, 1, null);
    }

    public final JvmExecOptions asJvmProcess() {
        return Executor.asJvmProcess$default(this, null, 1, null);
    }

    public final DeferredProcessResult startAsShellAsync(long l) {
        return Executor.startAsShellAsync$default(this, l, null, 2, null);
    }

    public final DeferredProcessResult startAsShellAsync() {
        return Executor.startAsShellAsync$default(this, 0L, null, 3, null);
    }

    public final DeferredProcessResult startAsync(long l) {
        return Executor.startAsync$default(this, l, null, 2, null);
    }

    public final DeferredProcessResult startAsync() {
        return Executor.startAsync$default(this, 0L, null, 3, null);
    }

    public final Object startAsShell(long l, Continuation<? super SyncProcessResult> continuation) {
        return Executor.startAsShell$default(this, l, null, continuation, 2, null);
    }

    public final Object startAsShell(Continuation<? super SyncProcessResult> continuation) {
        return Executor.startAsShell$default(this, 0L, null, continuation, 3, null);
    }

    public final SyncProcessResult startAsShellBlocking(long l) {
        return Executor.startAsShellBlocking$default(this, l, null, 2, null);
    }

    public final SyncProcessResult startAsShellBlocking() {
        return Executor.startAsShellBlocking$default(this, 0L, null, 3, null);
    }

    public final Object start(long l, Continuation<? super SyncProcessResult> continuation) {
        return Executor.start$default(this, l, null, continuation, 2, null);
    }

    public final Object start(Continuation<? super SyncProcessResult> continuation) {
        return Executor.start$default(this, 0L, null, continuation, 3, null);
    }

    public final SyncProcessResult startBlocking(long l) {
        return Executor.startBlocking$default(this, l, null, 2, null);
    }

    public final SyncProcessResult startBlocking() {
        return Executor.startBlocking$default(this, 0L, null, 3, null);
    }

    static {
        Logger logger = LoggerFactory.getLogger(Executor.class);
        Intrinsics.checkNotNull((Object)logger);
        log = logger;
        IO_DISPATCH = G.a((CoroutineContext)((CoroutineContext)W.d()));
        LINE_SEPARATOR = System.getProperty("line.separator");
        EXTRA_SPACE_REGEX = new Regex("\\s+");
        String string2 = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        String string3 = string2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
        String string4 = string3;
        IS_OS_WINDOWS = StringsKt.startsWith$default((String)string3, (String)"win", (boolean)false, (int)2, null);
        IS_OS_MAC = StringsKt.startsWith$default((String)string4, (String)"mac", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)string4, (String)"darwin", (boolean)false, (int)2, null);
        Updates.INSTANCE.add(Executor.class, "03fcf3762a2b4f68b5e968aaf79f3a72", version);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ'\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 2\u0012\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\"\"\u00020\u0006\u00a2\u0006\u0002\u0010#J\u001c\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00060\u001cJ\u001f\u0010\u001e\u001a\u00020\u00062\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\"\"\u00020\u0006\u00a2\u0006\u0002\u0010$J\u0014\u0010\u001e\u001a\u00020\u00062\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u001cR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0016\u0010\u0012\u001a\n \u0013*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Ldorkbox/executor/Executor$Companion;", "", "()V", "DEFAULT_REDIRECT_ERROR_STREAM", "", "DEFAULT_SHELL", "", "EXTRA_SPACE_REGEX", "Lkotlin/text/Regex;", "IO_DISPATCH", "Lkotlinx/coroutines/CoroutineScope;", "getIO_DISPATCH$Executor", "()Lkotlinx/coroutines/CoroutineScope;", "IS_OS_MAC", "getIS_OS_MAC", "()Z", "IS_OS_WINDOWS", "getIS_OS_WINDOWS", "LINE_SEPARATOR", "kotlin.jvm.PlatformType", "NORMAL_EXIT_VALUE", "", "log", "Lorg/slf4j/Logger;", "version", "fixArguments", "", "command", "", "fixArguments$Executor", "run", "executable", "Ljava/io/File;", "args", "", "(Ljava/io/File;[Ljava/lang/String;)Ljava/lang/String;", "([Ljava/lang/String;)Ljava/lang/String;", "Executor"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getIS_OS_WINDOWS() {
            return IS_OS_WINDOWS;
        }

        public final boolean getIS_OS_MAC() {
            return IS_OS_MAC;
        }

        public final CoroutineScope getIO_DISPATCH$Executor() {
            return IO_DISPATCH;
        }

        public final List<String> fixArguments$Executor(Iterable<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"");
            if (!this.getIS_OS_WINDOWS()) {
                return CollectionsKt.toMutableList(list);
            }
            Object object = new ArrayList();
            List list2 = object;
            CollectionsKt.addAll((Collection)((Collection)object), list);
            list = object;
            object = list.listIterator();
            while (object.hasNext()) {
                if (!Intrinsics.areEqual((Object)"", object.next())) continue;
                object.set("\"\"");
            }
            return list;
        }

        public final String run(Iterable<String> iterable) {
            Intrinsics.checkNotNullParameter(iterable, (String)"");
            return Executor.startBlocking$default(new Executor().command(iterable).enableRead(), 0L, null, 3, null).getOutput().utf8();
        }

        public final String run(File file, Iterable<String> iterable) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"");
            Intrinsics.checkNotNullParameter(iterable, (String)"");
            return Executor.startBlocking$default(new Executor().executable(file).command(iterable).enableRead(), 0L, null, 3, null).getOutput().utf8();
        }

        public final String run(String ... stringArray) {
            Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
            return Executor.startBlocking$default(new Executor().command(CollectionsKt.listOf((Object[])Arrays.copyOf(stringArray, stringArray.length))).enableRead(), 0L, null, 3, null).getOutput().utf8();
        }

        public final String run(File file, String ... stringArray) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"");
            Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
            return Executor.startBlocking$default(new Executor().executable(file).command(CollectionsKt.listOf((Object[])Arrays.copyOf(stringArray, stringArray.length))).enableRead(), 0L, null, 3, null).getOutput().utf8();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

