/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;

public class DefaultByteBufHolder
implements ByteBufHolder {
    private final ByteBuf data;

    public DefaultByteBufHolder(ByteBuf byteBuf) {
        this.data = (ByteBuf)ObjectUtil.checkNotNull((Object)byteBuf, (String)"data");
    }

    @Override
    public ByteBuf content() {
        return ByteBufUtil.ensureAccessible(this.data);
    }

    @Override
    public ByteBufHolder copy() {
        DefaultByteBufHolder defaultByteBufHolder = this;
        return defaultByteBufHolder.replace(defaultByteBufHolder.data.copy());
    }

    @Override
    public ByteBufHolder duplicate() {
        DefaultByteBufHolder defaultByteBufHolder = this;
        return defaultByteBufHolder.replace(defaultByteBufHolder.data.duplicate());
    }

    @Override
    public ByteBufHolder retainedDuplicate() {
        DefaultByteBufHolder defaultByteBufHolder = this;
        return defaultByteBufHolder.replace(defaultByteBufHolder.data.retainedDuplicate());
    }

    @Override
    public ByteBufHolder replace(ByteBuf byteBuf) {
        return new DefaultByteBufHolder(byteBuf);
    }

    public int refCnt() {
        return this.data.refCnt();
    }

    @Override
    public ByteBufHolder retain() {
        this.data.retain();
        return this;
    }

    @Override
    public ByteBufHolder retain(int n) {
        this.data.retain(n);
        return this;
    }

    @Override
    public ByteBufHolder touch() {
        this.data.touch();
        return this;
    }

    @Override
    public ByteBufHolder touch(Object object) {
        this.data.touch(object);
        return this;
    }

    public boolean release() {
        return this.data.release();
    }

    public boolean release(int n) {
        return this.data.release(n);
    }

    protected final String contentToString() {
        return this.data.toString();
    }

    public String toString() {
        return StringUtil.simpleClassName((Object)this) + '(' + this.contentToString() + ')';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            return this.data.equals(((DefaultByteBufHolder)object).data);
        }
        return false;
    }

    public int hashCode() {
        return this.data.hashCode();
    }
}

