/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledHeapByteBuf;
import io.netty.buffer.SwappedByteBuf;
import io.netty.buffer.UnsafeByteBufUtil;
import io.netty.buffer.UnsafeHeapSwappedByteBuf;
import io.netty.util.internal.ObjectPool;
import io.netty.util.internal.PlatformDependent;

final class PooledUnsafeHeapByteBuf
extends PooledHeapByteBuf {
    private static final ObjectPool<PooledUnsafeHeapByteBuf> RECYCLER = ObjectPool.newPool((ObjectPool.ObjectCreator)new ObjectPool.ObjectCreator<PooledUnsafeHeapByteBuf>(){

        public final PooledUnsafeHeapByteBuf newObject(ObjectPool.Handle<PooledUnsafeHeapByteBuf> handle) {
            return new PooledUnsafeHeapByteBuf(handle, 0);
        }
    });

    static PooledUnsafeHeapByteBuf newUnsafeInstance(int n) {
        PooledUnsafeHeapByteBuf pooledUnsafeHeapByteBuf = (PooledUnsafeHeapByteBuf)RECYCLER.get();
        pooledUnsafeHeapByteBuf.reuse(n);
        return pooledUnsafeHeapByteBuf;
    }

    private PooledUnsafeHeapByteBuf(ObjectPool.Handle<PooledUnsafeHeapByteBuf> handle, int n) {
        super((ObjectPool.Handle<? extends PooledHeapByteBuf>)handle, n);
    }

    @Override
    protected final byte _getByte(int n) {
        return UnsafeByteBufUtil.getByte((byte[])this.memory, this.idx(n));
    }

    @Override
    protected final short _getShort(int n) {
        return UnsafeByteBufUtil.getShort((byte[])this.memory, this.idx(n));
    }

    @Override
    protected final short _getShortLE(int n) {
        return UnsafeByteBufUtil.getShortLE((byte[])this.memory, this.idx(n));
    }

    @Override
    protected final int _getUnsignedMedium(int n) {
        return UnsafeByteBufUtil.getUnsignedMedium((byte[])this.memory, this.idx(n));
    }

    @Override
    protected final int _getUnsignedMediumLE(int n) {
        return UnsafeByteBufUtil.getUnsignedMediumLE((byte[])this.memory, this.idx(n));
    }

    @Override
    protected final int _getInt(int n) {
        return UnsafeByteBufUtil.getInt((byte[])this.memory, this.idx(n));
    }

    @Override
    protected final int _getIntLE(int n) {
        return UnsafeByteBufUtil.getIntLE((byte[])this.memory, this.idx(n));
    }

    @Override
    protected final long _getLong(int n) {
        return UnsafeByteBufUtil.getLong((byte[])this.memory, this.idx(n));
    }

    @Override
    protected final long _getLongLE(int n) {
        return UnsafeByteBufUtil.getLongLE((byte[])this.memory, this.idx(n));
    }

    @Override
    protected final void _setByte(int n, int n2) {
        UnsafeByteBufUtil.setByte((byte[])this.memory, this.idx(n), n2);
    }

    @Override
    protected final void _setShort(int n, int n2) {
        UnsafeByteBufUtil.setShort((byte[])this.memory, this.idx(n), n2);
    }

    @Override
    protected final void _setShortLE(int n, int n2) {
        UnsafeByteBufUtil.setShortLE((byte[])this.memory, this.idx(n), n2);
    }

    @Override
    protected final void _setMedium(int n, int n2) {
        UnsafeByteBufUtil.setMedium((byte[])this.memory, this.idx(n), n2);
    }

    @Override
    protected final void _setMediumLE(int n, int n2) {
        UnsafeByteBufUtil.setMediumLE((byte[])this.memory, this.idx(n), n2);
    }

    @Override
    protected final void _setInt(int n, int n2) {
        UnsafeByteBufUtil.setInt((byte[])this.memory, this.idx(n), n2);
    }

    @Override
    protected final void _setIntLE(int n, int n2) {
        UnsafeByteBufUtil.setIntLE((byte[])this.memory, this.idx(n), n2);
    }

    @Override
    protected final void _setLong(int n, long l) {
        UnsafeByteBufUtil.setLong((byte[])this.memory, this.idx(n), l);
    }

    @Override
    protected final void _setLongLE(int n, long l) {
        UnsafeByteBufUtil.setLongLE((byte[])this.memory, this.idx(n), l);
    }

    @Override
    public final ByteBuf setZero(int n, int n2) {
        if (PlatformDependent.javaVersion() >= 7) {
            this.checkIndex(n, n2);
            UnsafeByteBufUtil.setZero((byte[])this.memory, this.idx(n), n2);
            return this;
        }
        return super.setZero(n, n2);
    }

    @Override
    public final ByteBuf writeZero(int n) {
        if (PlatformDependent.javaVersion() >= 7) {
            ((ByteBuf)this).ensureWritable(n);
            int n2 = this.writerIndex;
            UnsafeByteBufUtil.setZero((byte[])this.memory, this.idx(n2), n);
            this.writerIndex = n2 + n;
            return this;
        }
        return super.writeZero(n);
    }

    @Override
    @Deprecated
    protected final SwappedByteBuf newSwappedByteBuf() {
        if (PlatformDependent.isUnaligned()) {
            return new UnsafeHeapSwappedByteBuf(this);
        }
        return super.newSwappedByteBuf();
    }
}

