/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors;

import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorVisitor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.Variance;

final class CapturedTypeParameterDescriptor
implements TypeParameterDescriptor {
    private final TypeParameterDescriptor originalDescriptor;
    private final DeclarationDescriptor declarationDescriptor;
    private final int declaredTypeParametersCount;

    public CapturedTypeParameterDescriptor(TypeParameterDescriptor typeParameterDescriptor, DeclarationDescriptor declarationDescriptor, int n) {
        Intrinsics.checkNotNullParameter((Object)typeParameterDescriptor, (String)"");
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        this.originalDescriptor = typeParameterDescriptor;
        this.declarationDescriptor = declarationDescriptor;
        this.declaredTypeParametersCount = n;
    }

    @Override
    public final boolean isCapturedFromOuterDeclaration() {
        return true;
    }

    @Override
    public final TypeParameterDescriptor getOriginal() {
        TypeParameterDescriptor typeParameterDescriptor = this.originalDescriptor.getOriginal();
        Intrinsics.checkNotNullExpressionValue((Object)typeParameterDescriptor, (String)"");
        return typeParameterDescriptor;
    }

    @Override
    public final DeclarationDescriptor getContainingDeclaration() {
        return this.declarationDescriptor;
    }

    @Override
    public final int getIndex() {
        return this.declaredTypeParametersCount + this.originalDescriptor.getIndex();
    }

    public final String toString() {
        return this.originalDescriptor + "[inner-copy]";
    }

    @Override
    public final boolean isReified() {
        return this.originalDescriptor.isReified();
    }

    @Override
    public final Variance getVariance() {
        Variance variance = this.originalDescriptor.getVariance();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)variance), (String)"");
        return variance;
    }

    @Override
    public final List<KotlinType> getUpperBounds() {
        List<KotlinType> list = this.originalDescriptor.getUpperBounds();
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        return list;
    }

    @Override
    public final TypeConstructor getTypeConstructor() {
        TypeConstructor typeConstructor2 = this.originalDescriptor.getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue((Object)typeConstructor2, (String)"");
        return typeConstructor2;
    }

    @Override
    public final StorageManager getStorageManager() {
        StorageManager storageManager = this.originalDescriptor.getStorageManager();
        Intrinsics.checkNotNullExpressionValue((Object)storageManager, (String)"");
        return storageManager;
    }

    @Override
    public final SimpleType getDefaultType() {
        SimpleType simpleType = this.originalDescriptor.getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"");
        return simpleType;
    }

    @Override
    public final SourceElement getSource() {
        SourceElement sourceElement = this.originalDescriptor.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"");
        return sourceElement;
    }

    @Override
    public final <R, D> R accept(DeclarationDescriptorVisitor<R, D> declarationDescriptorVisitor, D d) {
        return this.originalDescriptor.accept(declarationDescriptorVisitor, d);
    }

    @Override
    public final Annotations getAnnotations() {
        return this.originalDescriptor.getAnnotations();
    }

    @Override
    public final Name getName() {
        Name name = this.originalDescriptor.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
        return name;
    }
}

